/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.events.CatalogEvent;
import org.apache.ignite.internal.catalog.events.CreateIndexEventParameters;
import org.apache.ignite.internal.catalog.events.IndexEventParameters;
import org.apache.ignite.internal.catalog.events.MakeIndexAvailableEventParameters;
import org.apache.ignite.internal.catalog.events.RemoveIndexEventParameters;
import org.apache.ignite.internal.catalog.events.RenameTableEventParameters;
import org.apache.ignite.internal.catalog.events.StartBuildingIndexEventParameters;
import org.apache.ignite.internal.catalog.events.StoppingIndexEventParameters;
import org.apache.ignite.internal.catalog.events.TableEventParameters;
import org.apache.ignite.internal.event.Event;
import org.apache.ignite.internal.event.EventListener;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.ByteArray;
import org.apache.ignite.internal.lowwatermark.LowWatermark;
import org.apache.ignite.internal.lowwatermark.event.ChangeLowWatermarkEventParameters;
import org.apache.ignite.internal.lowwatermark.event.LowWatermarkEvent;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.metastorage.Entry;
import org.apache.ignite.internal.metastorage.MetaStorageManager;
import org.apache.ignite.internal.metastorage.Revisions;
import org.apache.ignite.internal.metastorage.dsl.Condition;
import org.apache.ignite.internal.metastorage.dsl.Conditions;
import org.apache.ignite.internal.metastorage.dsl.Operation;
import org.apache.ignite.internal.metastorage.dsl.Operations;
import org.apache.ignite.internal.table.distributed.index.IndexMeta;
import org.apache.ignite.internal.table.distributed.index.IndexMetaSerializer;
import org.apache.ignite.internal.table.distributed.index.MetaIndexStatus;
import org.apache.ignite.internal.util.ByteUtils;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.internal.versioned.VersionedSerialization;
import org.apache.ignite.internal.versioned.VersionedSerializer;
import org.jetbrains.annotations.Nullable;

public class IndexMetaStorage
implements IgniteComponent {
    private static final String INDEX_META_VERSION_KEY_PREFIX = "index.meta.version.";
    private static final String INDEX_META_VALUE_KEY_PREFIX = "index.meta.value.";
    private final CatalogService catalogService;
    private final LowWatermark lowWatermark;
    private final MetaStorageManager metaStorageManager;
    private final Map<Integer, IndexMeta> indexMetaByIndexId = new ConcurrentHashMap<Integer, IndexMeta>();
    private final EventListener<CreateIndexEventParameters> onCatalogIndexCreateEventListener;
    private final EventListener<RemoveIndexEventParameters> onCatalogIndexRemovedEventListener;
    private final EventListener<StartBuildingIndexEventParameters> onCatalogIndexBuildingEventListener;
    private final EventListener<MakeIndexAvailableEventParameters> onCatalogIndexAvailableEventListener;
    private final EventListener<StoppingIndexEventParameters> onCatalogIndexStoppingEventListener;
    private final EventListener<TableEventParameters> onCatalogTableAlterEventListener;
    private final EventListener<ChangeLowWatermarkEventParameters> onLwmChangedListener;

    public IndexMetaStorage(CatalogService catalogService, LowWatermark lowWatermark, MetaStorageManager metaStorageManager) {
        this.catalogService = catalogService;
        this.lowWatermark = lowWatermark;
        this.metaStorageManager = metaStorageManager;
        this.onCatalogIndexCreateEventListener = EventListener.fromFunction(this::onCatalogIndexCreateEvent);
        this.onCatalogIndexRemovedEventListener = EventListener.fromFunction(this::onCatalogIndexRemovedEvent);
        this.onCatalogIndexBuildingEventListener = EventListener.fromFunction(this::onCatalogIndexBuildingEvent);
        this.onCatalogIndexAvailableEventListener = EventListener.fromFunction(this::onCatalogIndexAvailableEvent);
        this.onCatalogIndexStoppingEventListener = EventListener.fromFunction(this::onCatalogIndexStoppingEvent);
        this.onCatalogTableAlterEventListener = EventListener.fromFunction(this::onCatalogTableAlterEvent);
        this.onLwmChangedListener = EventListener.fromFunction(this::onLwmChanged);
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        try {
            this.catalogService.listen((Event)CatalogEvent.INDEX_CREATE, this.onCatalogIndexCreateEventListener);
            this.catalogService.listen((Event)CatalogEvent.INDEX_REMOVED, this.onCatalogIndexRemovedEventListener);
            this.catalogService.listen((Event)CatalogEvent.INDEX_BUILDING, this.onCatalogIndexBuildingEventListener);
            this.catalogService.listen((Event)CatalogEvent.INDEX_AVAILABLE, this.onCatalogIndexAvailableEventListener);
            this.catalogService.listen((Event)CatalogEvent.INDEX_STOPPING, this.onCatalogIndexStoppingEventListener);
            this.catalogService.listen((Event)CatalogEvent.TABLE_ALTER, this.onCatalogTableAlterEventListener);
            this.lowWatermark.listen((Event)LowWatermarkEvent.LOW_WATERMARK_CHANGED, this.onLwmChangedListener);
            return this.recoverIndexMetas();
        }
        catch (Throwable t) {
            return CompletableFuture.failedFuture(t);
        }
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        this.catalogService.removeListener((Event)CatalogEvent.INDEX_CREATE, this.onCatalogIndexCreateEventListener);
        this.catalogService.removeListener((Event)CatalogEvent.INDEX_REMOVED, this.onCatalogIndexRemovedEventListener);
        this.catalogService.removeListener((Event)CatalogEvent.INDEX_BUILDING, this.onCatalogIndexBuildingEventListener);
        this.catalogService.removeListener((Event)CatalogEvent.INDEX_AVAILABLE, this.onCatalogIndexAvailableEventListener);
        this.catalogService.removeListener((Event)CatalogEvent.INDEX_STOPPING, this.onCatalogIndexStoppingEventListener);
        this.catalogService.removeListener((Event)CatalogEvent.TABLE_ALTER, this.onCatalogTableAlterEventListener);
        this.lowWatermark.removeListener((Event)LowWatermarkEvent.LOW_WATERMARK_CHANGED, this.onLwmChangedListener);
        this.indexMetaByIndexId.clear();
        return CompletableFutures.nullCompletedFuture();
    }

    @Nullable
    public IndexMeta indexMeta(int indexId) {
        return this.indexMetaByIndexId.get(indexId);
    }

    public Collection<IndexMeta> indexMetas() {
        return Collections.unmodifiableCollection(this.indexMetaByIndexId.values());
    }

    private CompletableFuture<Boolean> onCatalogIndexCreateEvent(CreateIndexEventParameters parameters) {
        int indexId = parameters.indexDescriptor().id();
        Catalog catalog = this.catalog(parameters.catalogVersion());
        return this.createAndSaveIndexMetaToMetastore(indexId, indexMeta -> {
            assert (indexMeta == null) : "indexId=" + indexId + "catalogVersion=" + catalog.version();
            return IndexMeta.of(indexId, catalog);
        }).thenApply(unused -> false);
    }

    private CompletableFuture<Boolean> onCatalogIndexRemovedEvent(RemoveIndexEventParameters parameters) {
        int indexId = parameters.indexId();
        int eventCatalogVersion = parameters.catalogVersion();
        Catalog catalog = this.catalog(eventCatalogVersion);
        CompletableFuture[] futureContainer = new CompletableFuture[1];
        this.lowWatermark.getLowWatermarkSafe(lwm -> {
            int lwmCatalogVersion = this.lwmCatalogVersion((HybridTimestamp)lwm);
            if (eventCatalogVersion <= lwmCatalogVersion) {
                IndexMeta removed = this.indexMetaByIndexId.remove(indexId);
                assert (removed != null) : "indexId=" + indexId + ", catalogVersion=" + catalog.version();
                futureContainer[0] = this.removeFromMetastore(removed);
            } else {
                futureContainer[0] = this.updateAndSaveIndexMetaToMetastore(indexId, indexMeta -> {
                    assert (indexMeta != null) : "indexId=" + indexId + ", catalogVersion=" + catalog.version();
                    return IndexMetaStorage.setNewStatus(indexMeta, MetaIndexStatus.statusOnRemoveIndex(indexMeta.status()), catalog);
                });
            }
        });
        CompletableFuture future = futureContainer[0];
        assert (future != null) : "indexId=" + indexId + ", catalogVersion=" + catalog.version();
        return future.thenApply(unused -> false);
    }

    private CompletableFuture<Boolean> onCatalogIndexBuildingEvent(StartBuildingIndexEventParameters parameters) {
        return this.updateIndexStatus((IndexEventParameters)parameters);
    }

    private CompletableFuture<Boolean> onCatalogIndexAvailableEvent(MakeIndexAvailableEventParameters parameters) {
        if (this.relatedToNonPrimaryKeyIndex(parameters)) {
            return this.updateIndexStatus((IndexEventParameters)parameters);
        }
        return CompletableFutures.falseCompletedFuture();
    }

    private boolean relatedToNonPrimaryKeyIndex(MakeIndexAvailableEventParameters parameters) {
        CatalogIndexDescriptor catalogIndexDescriptor;
        Catalog catalog;
        CatalogTableDescriptor catalogTableDescriptor;
        int catalogVersion = parameters.catalogVersion();
        int indexId = parameters.indexId();
        return indexId != (catalogTableDescriptor = (catalog = this.catalog(catalogVersion)).table((catalogIndexDescriptor = catalog.index(indexId)).tableId())).primaryKeyIndexId();
    }

    private CompletableFuture<Boolean> onCatalogIndexStoppingEvent(StoppingIndexEventParameters parameters) {
        return this.updateIndexStatus((IndexEventParameters)parameters);
    }

    private CompletableFuture<Boolean> updateIndexStatus(IndexEventParameters parameters) {
        Catalog catalog = this.catalog(parameters.catalogVersion());
        CatalogIndexDescriptor catalogIndexDescriptor = catalog.index(parameters.indexId());
        return this.updateAndSaveIndexMetaToMetastore(catalogIndexDescriptor.id(), indexMeta -> {
            assert (indexMeta != null) : "indexId=" + catalogIndexDescriptor.id() + ", catalogVersion=" + catalog.version();
            return IndexMetaStorage.setNewStatus(indexMeta, MetaIndexStatus.convert(catalogIndexDescriptor.status()), catalog);
        }).thenApply(unused -> false);
    }

    private CompletableFuture<Boolean> onCatalogTableAlterEvent(TableEventParameters parameters) {
        if (parameters instanceof RenameTableEventParameters) {
            int catalogVersion = parameters.catalogVersion();
            Catalog catalog = this.catalog(parameters.catalogVersion());
            CatalogTableDescriptor catalogTableDescriptor = catalog.table(parameters.tableId());
            int indexId = catalogTableDescriptor.primaryKeyIndexId();
            CatalogIndexDescriptor primaryKeyIndexDescriptor = catalog.index(indexId);
            return this.updateAndSaveIndexMetaToMetastore(indexId, indexMeta -> {
                assert (indexMeta != null) : "indexId=" + indexId + ", catalogVersion=" + catalogVersion;
                return indexMeta.indexName(parameters.catalogVersion(), primaryKeyIndexDescriptor.name());
            }).thenApply(unused -> false);
        }
        return CompletableFutures.falseCompletedFuture();
    }

    private CompletableFuture<Boolean> onLwmChanged(ChangeLowWatermarkEventParameters parameters) {
        int lwmCatalogVersion = this.lwmCatalogVersion(parameters.newLowWatermark());
        return this.removeIndexMetasFromMetastore(lwmCatalogVersion).thenApply(unused -> false);
    }

    private CompletableFuture<Void> recoverIndexMetas() {
        int lwmCatalogVersion = this.lwmCatalogVersion(this.lowWatermark.getLowWatermark());
        int latestCatalogVersion = this.catalogService.latestCatalogVersion();
        int startCatalogVersion = Math.max(lwmCatalogVersion, this.catalogService.earliestCatalogVersion());
        this.indexMetaByIndexId.putAll(this.readAllFromMetastoreOnRecovery());
        ArrayList futures = new ArrayList();
        Set<Integer> previousCatalogVersionIndexIds = IndexMetaStorage.indexIdsForCatalogVersion(this.indexMetaByIndexId.values(), startCatalogVersion - 1);
        for (int catalogVersion = startCatalogVersion; catalogVersion <= latestCatalogVersion; ++catalogVersion) {
            IndexMeta fromMetastore;
            Catalog catalog = this.catalog(catalogVersion);
            HashSet<Integer> indexIds = new HashSet<Integer>();
            for (CatalogIndexDescriptor catalogIndexDescriptor : catalog.indexes()) {
                int indexId = catalogIndexDescriptor.id();
                indexIds.add(indexId);
                fromMetastore = this.indexMetaByIndexId.get(indexId);
                if (fromMetastore == null) {
                    futures.add(this.createAndSaveIndexMetaToMetastore(indexId, indexMeta -> IndexMeta.of(indexId, catalog)));
                    continue;
                }
                if (fromMetastore.catalogVersion() >= catalog.version()) continue;
                if (!catalogIndexDescriptor.name().equals(fromMetastore.indexName())) {
                    futures.add(this.updateAndSaveIndexMetaToMetastore(indexId, indexMeta -> indexMeta.indexName(catalog.version(), catalogIndexDescriptor.name())));
                    continue;
                }
                if (MetaIndexStatus.convert(catalogIndexDescriptor.status()) == fromMetastore.status()) continue;
                futures.add(this.updateAndSaveIndexMetaToMetastore(indexId, indexMeta -> IndexMetaStorage.setNewStatus(fromMetastore, MetaIndexStatus.convert(catalogIndexDescriptor.status()), catalog)));
            }
            HashSet<Integer> knownRemovedIndexIds = new HashSet<Integer>();
            for (Integer removedIndexId : CollectionUtils.difference(previousCatalogVersionIndexIds, indexIds)) {
                fromMetastore = this.indexMetaByIndexId.get(removedIndexId);
                if (fromMetastore.catalogVersion() >= catalog.version()) continue;
                if (fromMetastore.isRemovedFromCatalog()) {
                    knownRemovedIndexIds.add(removedIndexId);
                    continue;
                }
                futures.add(this.updateAndSaveIndexMetaToMetastore(removedIndexId, indexMeta -> IndexMetaStorage.setNewStatus(fromMetastore, MetaIndexStatus.statusOnRemoveIndex(fromMetastore.status()), catalog)));
            }
            previousCatalogVersionIndexIds = indexIds;
            previousCatalogVersionIndexIds.addAll(knownRemovedIndexIds);
        }
        futures.add(this.removeIndexMetasFromMetastore(lwmCatalogVersion));
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    private Catalog catalog(int catalogVersion) {
        Catalog catalog = this.catalogService.catalog(catalogVersion);
        assert (catalog != null) : catalogVersion;
        return catalog;
    }

    private Map<Integer, IndexMeta> readAllFromMetastoreOnRecovery() {
        CompletableFuture recoveryFinishedFuture = this.metaStorageManager.recoveryFinishedFuture();
        assert (recoveryFinishedFuture.isDone());
        long recoveryRevision = ((Revisions)recoveryFinishedFuture.join()).revision();
        try (Cursor cursor = this.metaStorageManager.prefixLocally(ByteArray.fromString((String)INDEX_META_VALUE_KEY_PREFIX), recoveryRevision);){
            Map<Integer, IndexMeta> map = cursor.stream().map(Entry::value).filter(Objects::nonNull).map(entryBytes -> (IndexMeta)VersionedSerialization.fromBytes((byte[])entryBytes, (VersionedSerializer)IndexMetaSerializer.INSTANCE)).collect(Collectors.toMap(IndexMeta::indexId, Function.identity()));
            return map;
        }
    }

    private static IndexMeta setNewStatus(IndexMeta indexMeta, MetaIndexStatus newStatus, Catalog catalog) {
        return indexMeta.status(newStatus, catalog.version(), catalog.time());
    }

    private static boolean shouldBeRemoved(IndexMeta indexMeta, int lwmCatalogVersion) {
        MetaIndexStatus status = indexMeta.status();
        return (status == MetaIndexStatus.READ_ONLY || status == MetaIndexStatus.REMOVED) && indexMeta.statusChanges().get((Object)status).catalogVersion() <= lwmCatalogVersion;
    }

    private static ByteArray indexMetaVersionKey(IndexMeta indexMeta) {
        return ByteArray.fromString((String)(INDEX_META_VERSION_KEY_PREFIX + indexMeta.indexId()));
    }

    private static ByteArray indexMetaValueKey(IndexMeta indexMeta) {
        return ByteArray.fromString((String)(INDEX_META_VALUE_KEY_PREFIX + indexMeta.indexId()));
    }

    private CompletableFuture<?> createInMetastore(IndexMeta indexMeta) {
        return this.metaStorageManager.invoke((Condition)Conditions.notExists((ByteArray)IndexMetaStorage.indexMetaVersionKey(indexMeta)), IndexMetaStorage.saveIndexMetaOperations(indexMeta), List.of(Operations.noop()));
    }

    private CompletableFuture<?> updateInMetastore(IndexMeta indexMeta) {
        ByteArray versionKey = IndexMetaStorage.indexMetaVersionKey(indexMeta);
        byte[] versionValue = ByteUtils.intToBytesKeepingOrder((int)indexMeta.catalogVersion());
        return this.metaStorageManager.invoke((Condition)Conditions.and((Condition)Conditions.exists((ByteArray)versionKey), (Condition)Conditions.value((ByteArray)versionKey).lt(versionValue)), IndexMetaStorage.saveIndexMetaOperations(indexMeta), List.of(Operations.noop()));
    }

    private CompletableFuture<?> removeFromMetastore(IndexMeta indexMeta) {
        ByteArray versionKey = IndexMetaStorage.indexMetaVersionKey(indexMeta);
        return this.metaStorageManager.invoke((Condition)Conditions.exists((ByteArray)versionKey), List.of(Operations.remove((ByteArray)versionKey), Operations.remove((ByteArray)IndexMetaStorage.indexMetaValueKey(indexMeta))), List.of(Operations.noop()));
    }

    private static List<Operation> saveIndexMetaOperations(IndexMeta indexMeta) {
        byte[] versionValue = ByteUtils.intToBytesKeepingOrder((int)indexMeta.catalogVersion());
        return List.of(Operations.put((ByteArray)IndexMetaStorage.indexMetaVersionKey(indexMeta), (byte[])versionValue), Operations.put((ByteArray)IndexMetaStorage.indexMetaValueKey(indexMeta), (byte[])VersionedSerialization.toBytes((Object)indexMeta, (VersionedSerializer)IndexMetaSerializer.INSTANCE)));
    }

    private CompletableFuture<?> createAndSaveIndexMetaToMetastore(int indexId, Function<@Nullable IndexMeta, IndexMeta> updateFunction) {
        IndexMeta newMeta = this.indexMetaByIndexId.compute(indexId, (id, indexMeta) -> (IndexMeta)updateFunction.apply((IndexMeta)indexMeta));
        return this.createInMetastore(newMeta);
    }

    private CompletableFuture<?> updateAndSaveIndexMetaToMetastore(int indexId, Function<@Nullable IndexMeta, IndexMeta> updateFunction) {
        IndexMeta newMeta = this.indexMetaByIndexId.compute(indexId, (id, indexMeta) -> (IndexMeta)updateFunction.apply((IndexMeta)indexMeta));
        return this.updateInMetastore(newMeta);
    }

    private int lwmCatalogVersion(@Nullable HybridTimestamp lwm) {
        return lwm == null ? this.catalogService.earliestCatalogVersion() : this.catalogService.activeCatalogVersion(lwm.longValue());
    }

    private static Set<Integer> indexIdsForCatalogVersion(Collection<IndexMeta> indexMetas, int catalogVersion) {
        return indexMetas.stream().filter(indexMeta -> indexMeta.catalogVersion() <= catalogVersion).map(IndexMeta::indexId).collect(Collectors.toSet());
    }

    private CompletableFuture<Void> removeIndexMetasFromMetastore(int lwmCatalogVersion) {
        Iterator<IndexMeta> it = this.indexMetaByIndexId.values().iterator();
        ArrayList futures = new ArrayList();
        while (it.hasNext()) {
            IndexMeta indexMeta = it.next();
            if (!IndexMetaStorage.shouldBeRemoved(indexMeta, lwmCatalogVersion)) continue;
            it.remove();
            futures.add(this.removeFromMetastore(indexMeta));
        }
        return futures.isEmpty() ? CompletableFutures.nullCompletedFuture() : CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }
}

