/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.io.entity;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.io.entity.FileEntity;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestFileEntity {
    TestFileEntity() {
    }

    @Test
    void testBasics() throws Exception {
        File tmpfile = File.createTempFile("testfile", ".txt");
        tmpfile.deleteOnExit();
        try (FileEntity httpentity = new FileEntity(tmpfile, ContentType.TEXT_PLAIN);){
            Assertions.assertEquals((long)tmpfile.length(), (long)httpentity.getContentLength());
            try (InputStream content = httpentity.getContent();){
                Assertions.assertNotNull((Object)content);
            }
            Assertions.assertTrue((boolean)httpentity.isRepeatable());
            Assertions.assertFalse((boolean)httpentity.isStreaming());
            Assertions.assertTrue((boolean)tmpfile.delete(), (String)("Failed to delete " + tmpfile));
        }
    }

    @Test
    void testNullConstructor() {
        Assertions.assertThrows(NullPointerException.class, () -> new FileEntity(null, ContentType.TEXT_PLAIN));
    }

    @Test
    void testWriteTo() throws Exception {
        File tmpfile = File.createTempFile("testfile", ".txt");
        tmpfile.deleteOnExit();
        try (FileOutputStream outStream = new FileOutputStream(tmpfile);){
            outStream.write(0);
            outStream.write(1);
            outStream.write(2);
            outStream.write(3);
        }
        var3_3 = null;
        try (FileEntity httpentity = new FileEntity(tmpfile, ContentType.TEXT_PLAIN);){
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            httpentity.writeTo((OutputStream)out);
            byte[] bytes = out.toByteArray();
            Assertions.assertNotNull((Object)bytes);
            Assertions.assertEquals((long)tmpfile.length(), (long)bytes.length);
            for (int i = 0; i < 4; ++i) {
                Assertions.assertEquals((int)i, (int)bytes[i]);
            }
            Assertions.assertTrue((boolean)tmpfile.delete(), (String)("Failed to delete: " + tmpfile));
            Assertions.assertThrows(NullPointerException.class, () -> httpentity.writeTo(null));
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }
}

