/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.runtime.operator;

import org.apache.flink.agents.api.Event;
import org.apache.flink.agents.plan.JavaFunction;
import org.apache.flink.agents.plan.actions.Action;
import org.apache.flink.agents.runtime.operator.ActionTask;
import org.apache.flink.util.Preconditions;

public class JavaActionTask
extends ActionTask {
    private final ClassLoader userCodeClassLoader;

    public JavaActionTask(Object key, Event event, Action action, ClassLoader userCodeClassLoader) {
        super(key, event, action);
        Preconditions.checkState((boolean)(action.getExec() instanceof JavaFunction));
        this.userCodeClassLoader = userCodeClassLoader;
    }

    @Override
    public ActionTask.ActionTaskResult invoke() throws Exception {
        LOG.debug("Try execute java action {} for event {} with key {}.", this.action.getName(), this.event, this.key);
        this.runnerContext.checkNoPendingEvents();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.userCodeClassLoader);
            this.action.getExec().call(this.event, this.runnerContext);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
        return new ActionTask.ActionTaskResult(true, this.runnerContext.drainEvents(this.event.getSourceTimestamp()), null);
    }
}

