/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.upgradeTests;

import java.io.File;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derby.shared.common.info.JVMInfo;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.UpgradeChange;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Changes10_10
extends UpgradeChange {
    private static final String SYNTAX_ERROR = "42X01";
    private static final String HARD_UPGRADE_REQUIRED = "XCL47";
    private static final String NEEDS_JAVA_STYLE = "42ZCA";
    private static final String DB_README_FILE_NAME = "README_DO_NOT_TOUCH_FILES.txt";
    static final float[] beyondDB2Real = new float[]{Float.MIN_VALUE, Float.MAX_VALUE, 1.174E-37f, -1.174E-37f, Float.MIN_NORMAL, -1.1754944E-38f};
    static final double[] beyondDB2Double = new double[]{Double.MIN_VALUE, Double.MAX_VALUE, 2.224E-307, -2.224E-307, Double.MIN_NORMAL, -2.2250738585072014E-308};

    public Changes10_10(String string) {
        super(string);
    }

    public static Test suite(int n) {
        BaseTestSuite baseTestSuite = new BaseTestSuite("Upgrade test for 10.9");
        baseTestSuite.addTestSuite(Changes10_10.class);
        return new SupportFilesSetup((Test)baseTestSuite);
    }

    public void testProcsNewTo10_10() throws Exception {
        Statement statement = this.createStatement();
        String string = "call syscs_util.SYSCS_INVALIDATE_STORED_STATEMENTS()";
        String string2 = "call syscs_util.syscs_register_tool( 'foo', true )";
        String string3 = "X0Y88";
        String string4 = SYNTAX_ERROR;
        boolean bl = JDBC.vmSupportsJDBC3();
        boolean bl2 = this.oldAtLeast(10, 7);
        switch (this.getPhase()) {
            case 0: 
            case 1: 
            case 2: {
                this.vetProcs(statement, string, false, null);
                if (!bl) break;
                this.vetProcs(statement, string2, false, bl2 || this.getPhase() == 1 ? null : string4);
                break;
            }
            case 3: {
                this.vetProcs(statement, string, true, null);
                if (!bl) break;
                this.vetProcs(statement, string2, true, string3);
            }
        }
        statement.close();
    }

    private void vetProcs(Statement statement, String string, boolean bl, String string2) throws Exception {
        try {
            statement.execute(string);
            if (!bl) {
                Changes10_10.fail((String)"Procedure should not exist!");
            }
            if (string2 != null) {
                Changes10_10.fail((String)("Expected to fail with SQLState " + string2));
            }
        }
        catch (SQLException sQLException) {
            if (string2 == null) {
                string2 = "42Y03";
            }
            Changes10_10.assertSQLState(string2, sQLException);
        }
    }

    public void testUDAs() throws Exception {
        Statement statement = this.createStatement();
        String string = "create derby aggregate mode for int external name 'foo.bar.Wibble'";
        String string2 = "drop derby aggregate mode restrict";
        switch (this.getPhase()) {
            case 0: 
            case 2: {
                Changes10_10.assertStatementError(SYNTAX_ERROR, statement, string);
                Changes10_10.assertStatementError(SYNTAX_ERROR, statement, string2);
                break;
            }
            case 1: {
                Changes10_10.assertStatementError(HARD_UPGRADE_REQUIRED, statement, string);
                Changes10_10.assertStatementError(HARD_UPGRADE_REQUIRED, statement, string2);
                break;
            }
            case 3: {
                statement.execute(string);
                statement.execute(string2);
            }
        }
        statement.close();
    }

    public void testVarargss() throws Exception {
        Statement statement = this.createStatement();
        String string = "create procedure vds ( a int ... ) language java parameter style derby no sql external name 'Foo.foo'";
        String string2 = "create function vds ( a int ... ) returns integer language java parameter style derby no sql external name 'Foo.foo'";
        String string3 = "create function vtf ( a int ... ) returns table ( b int ) language java parameter style derby_jdbc_result_set no sql external name 'Foo.foo'";
        String string4 = "create procedure nvds ( a int ) language java parameter style derby no sql external name 'Foo.foo'";
        String string5 = "create function nvds ( a int ) returns integer language java parameter style derby no sql external name 'Foo.foo'";
        boolean bl = this.oldAtLeast(10, 4);
        switch (this.getPhase()) {
            case 0: 
            case 2: {
                Changes10_10.assertStatementError(SYNTAX_ERROR, statement, string);
                Changes10_10.assertStatementError(SYNTAX_ERROR, statement, string2);
                if (bl) {
                    Changes10_10.assertStatementError(SYNTAX_ERROR, statement, string3);
                }
                Changes10_10.assertStatementError(SYNTAX_ERROR, statement, string4);
                Changes10_10.assertStatementError(SYNTAX_ERROR, statement, string5);
                break;
            }
            case 1: {
                Changes10_10.assertStatementError(HARD_UPGRADE_REQUIRED, statement, string);
                Changes10_10.assertStatementError(HARD_UPGRADE_REQUIRED, statement, string2);
                if (bl) {
                    Changes10_10.assertStatementError(HARD_UPGRADE_REQUIRED, statement, string3);
                }
                Changes10_10.assertStatementError(HARD_UPGRADE_REQUIRED, statement, string4);
                Changes10_10.assertStatementError(HARD_UPGRADE_REQUIRED, statement, string5);
                break;
            }
            case 3: {
                statement.execute(string);
                statement.execute(string2);
                statement.execute(string3);
                Changes10_10.assertStatementError(NEEDS_JAVA_STYLE, statement, string4);
                Changes10_10.assertStatementError(NEEDS_JAVA_STYLE, statement, string5);
            }
        }
        statement.close();
    }

    public void testReadMeFiles() throws SQLException, IOException {
        Statement statement = this.createStatement();
        statement.close();
        TestConfiguration testConfiguration = TestConfiguration.getCurrent();
        String string = testConfiguration.getDatabasePath(testConfiguration.getDefaultDatabaseName());
        switch (this.getPhase()) {
            case 0: 
            case 1: 
            case 2: {
                this.lookForReadmeFile(string, false);
                this.lookForReadmeFile(string + File.separator + "seg0", false);
                this.lookForReadmeFile(string + File.separator + "log", false);
                break;
            }
            case 3: 
            case 4: {
                this.lookForReadmeFile(string, true);
                this.lookForReadmeFile(string + File.separator + "seg0", true);
                this.lookForReadmeFile(string + File.separator + "log", true);
            }
        }
    }

    private void lookForReadmeFile(String string, boolean bl) throws IOException {
        File file = new File(string, DB_README_FILE_NAME);
        if (bl) {
            Changes10_10.assertTrue((String)(file + "doesn't exist"), (boolean)PrivilegedFileOpsForTests.exists(file));
        } else {
            Changes10_10.assertFalse((String)(file + "exists"), (boolean)PrivilegedFileOpsForTests.exists(file));
        }
    }

    public void testFloatLimits() throws Exception {
        if (JVMInfo.isModuleAware()) {
            return;
        }
        Statement statement = this.createStatement();
        statement.execute("create table d3398(r real, d double)");
        PreparedStatement preparedStatement = this.prepareStatement("insert into d3398(r) values (?)");
        PreparedStatement preparedStatement2 = this.prepareStatement("insert into d3398(d) values (?)");
        PreparedStatement preparedStatement3 = this.prepareStatement("select * from d3398", 1003, 1008);
        statement.execute("insert into d3398 values (0.0, 0.0)");
        switch (this.getPhase()) {
            case 0: {
                this.verifyDB2Behavior(preparedStatement3, preparedStatement, preparedStatement2, false);
                break;
            }
            case 2: {
                this.verifyDB2Behavior(preparedStatement3, preparedStatement, preparedStatement2, false);
                break;
            }
            case 1: {
                this.verifyDB2Behavior(preparedStatement3, preparedStatement, preparedStatement2, true);
                break;
            }
            case 3: {
                ResultSet resultSet;
                int n;
                for (n = 0; n < beyondDB2Real.length; ++n) {
                    preparedStatement.setFloat(1, beyondDB2Real[n]);
                    preparedStatement.execute();
                    resultSet = preparedStatement3.executeQuery();
                    resultSet.next();
                    resultSet.updateFloat(1, beyondDB2Real[n]);
                    resultSet.updateRow();
                    resultSet.close();
                }
                for (n = 0; n < beyondDB2Double.length; ++n) {
                    preparedStatement2.setDouble(1, beyondDB2Double[n]);
                    preparedStatement2.execute();
                    resultSet = preparedStatement3.executeQuery();
                    resultSet.next();
                    resultSet.updateDouble(2, beyondDB2Double[n]);
                    resultSet.updateRow();
                    resultSet.close();
                }
                break;
            }
        }
        statement.executeUpdate("drop table d3398");
        statement.close();
    }

    private void assertSetError(PreparedStatement preparedStatement, float f, boolean bl) throws SQLException {
        try {
            preparedStatement.setFloat(1, f);
            if (!bl) {
                Changes10_10.fail();
            }
            preparedStatement.executeUpdate();
            Changes10_10.fail();
        }
        catch (SQLException sQLException) {
            Changes10_10.assertSQLState("22003", sQLException);
        }
    }

    private void assertSetError(PreparedStatement preparedStatement, double d, boolean bl) throws SQLException {
        try {
            preparedStatement.setDouble(1, d);
            if (!bl) {
                Changes10_10.fail();
            }
            preparedStatement.executeUpdate();
            Changes10_10.fail();
        }
        catch (SQLException sQLException) {
            Changes10_10.assertSQLState("22003", sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertUpdateError(PreparedStatement preparedStatement, float f, boolean bl) throws SQLException {
        boolean bl2 = this.oldAtLeast(10, 2);
        if (!bl2) {
            return;
        }
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        try {
            resultSet.updateFloat(1, f);
            if (!bl) {
                Changes10_10.fail();
            }
            resultSet.updateRow();
            Changes10_10.fail();
        }
        catch (SQLException sQLException) {
            Changes10_10.assertSQLState("22003", sQLException);
        }
        finally {
            resultSet.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertUpdateError(PreparedStatement preparedStatement, double d, boolean bl) throws SQLException {
        boolean bl2 = this.oldAtLeast(10, 2);
        if (!bl2) {
            return;
        }
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        try {
            resultSet.updateDouble(1, d);
            if (!bl) {
                Changes10_10.fail();
            }
            resultSet.updateRow();
            Changes10_10.fail();
        }
        catch (SQLException sQLException) {
            Changes10_10.assertSQLState("22003", sQLException);
        }
        finally {
            resultSet.close();
        }
    }

    private void verifyDB2Behavior(PreparedStatement preparedStatement, PreparedStatement preparedStatement2, PreparedStatement preparedStatement3, boolean bl) throws SQLException {
        int n;
        for (n = 0; n < beyondDB2Real.length; ++n) {
            this.assertSetError(preparedStatement2, beyondDB2Real[n], bl);
            this.assertUpdateError(preparedStatement, beyondDB2Real[n], bl);
        }
        for (n = 0; n < beyondDB2Double.length; ++n) {
            this.assertSetError(preparedStatement3, beyondDB2Double[n], bl);
            this.assertUpdateError(preparedStatement, beyondDB2Double[n], bl);
        }
    }
}

