/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class TriggerBeforeTrigTest
extends BaseJDBCTestCase {
    public static final String LANG_COL_NOT_FOUND = "42X04";
    public static final String LANG_TRIGGER_BAD_REF_MISMATCH = "42Y92";
    public static final String LANG_TRIGGER_BAD_REF_CLAUSE_DUPS = "42Y93";
    public static final String LANG_UNSUPPORTED_TRIGGER_STMT = "42Z9D";
    public static final String LANG_SYNTAX_ERROR = "42X01";

    public TriggerBeforeTrigTest(String string) {
        super(string);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(TriggerBeforeTrigTest.class);
    }

    public void testBeforeTriggers() throws Exception {
        Statement statement = this.createStatement();
        try {
            statement.executeUpdate("create table x (x int, constraint ck check (x > 0))");
            statement.executeUpdate("create table unrelated (x int, constraint ckunrelated check (x > 0))");
            statement.executeUpdate("create index x on x(x)");
            TriggerBeforeTrigTest.assertStatementError(LANG_SYNTAX_ERROR, statement, "create trigger tbad NO CASCADE before insert on x for each statement drop table x");
            TriggerBeforeTrigTest.assertStatementError(LANG_SYNTAX_ERROR, statement, "create trigger tbad NO CASCADE before insert on x for each statement drop index x");
            TriggerBeforeTrigTest.assertStatementError(LANG_SYNTAX_ERROR, statement, "create trigger tbad NO CASCADE before insert on x for each statement alter table x add column y int");
            TriggerBeforeTrigTest.assertStatementError(LANG_SYNTAX_ERROR, statement, "create trigger tbad NO CASCADE before insert on x for each statement alter table x add constraint ck2 check(x > 0)");
            TriggerBeforeTrigTest.assertStatementError(LANG_SYNTAX_ERROR, statement, "create trigger tbad NO CASCADE before insert on x for each statement alter table x drop constraint ck");
            TriggerBeforeTrigTest.assertStatementError(LANG_SYNTAX_ERROR, statement, "create trigger tbad NO CASCADE before insert on x for each statement create index x2 on x (x)");
            TriggerBeforeTrigTest.assertStatementError(LANG_SYNTAX_ERROR, statement, "create trigger tbad NO CASCADE before insert on x for each statement create index xunrelated on unrelated(x)");
            TriggerBeforeTrigTest.assertStatementError(LANG_SYNTAX_ERROR, statement, "create trigger tbad NO CASCADE before insert on x for each statement drop index xunrelated");
            TriggerBeforeTrigTest.assertStatementError(LANG_SYNTAX_ERROR, statement, "create trigger tbad NO CASCADE before insert on x for each statement drop trigger tbad");
            TriggerBeforeTrigTest.assertStatementError(LANG_SYNTAX_ERROR, statement, "create trigger tbad NO CASCADE before insert on x for each statement \tcreate trigger tbad2 NO CASCADE before insert on x for each statement values 1");
            statement.executeUpdate("create trigger tokv1 NO CASCADE before insert on x for each statement values 1");
            statement.executeUpdate("insert into x values 1");
            ResultSet resultSet = statement.executeQuery("select * from x");
            JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1"}}, true);
            statement.executeUpdate("drop trigger tokv1");
            TriggerBeforeTrigTest.assertStatementError(LANG_SYNTAX_ERROR, statement, "create trigger tbad NO CASCADE before insert on x for each statement set isolation to rr");
            TriggerBeforeTrigTest.assertStatementError(LANG_SYNTAX_ERROR, statement, "create trigger tbad NO CASCADE before insert on x for each statement lock table x in share mode");
            TriggerBeforeTrigTest.assertStatementError(LANG_UNSUPPORTED_TRIGGER_STMT, statement, "create trigger tbadX NO CASCADE before insert on x for each statement insert into x values 1");
            TriggerBeforeTrigTest.assertStatementError(LANG_UNSUPPORTED_TRIGGER_STMT, statement, "create trigger tbadX NO CASCADE before insert on x for each statement delete from x");
            TriggerBeforeTrigTest.assertStatementError(LANG_UNSUPPORTED_TRIGGER_STMT, statement, "create trigger tbadX NO CASCADE before insert on x for each statement update x set x = x");
            TriggerBeforeTrigTest.assertStatementError(LANG_SYNTAX_ERROR, statement, "create trigger t1 NO CASCADE before update on x referencing badtoken as oldtable for each row values 1");
            TriggerBeforeTrigTest.assertStatementError(LANG_SYNTAX_ERROR, statement, "create trigger t1 NO CASCADE before update on x referencing old as oldrow new for each row values 1");
            TriggerBeforeTrigTest.assertStatementError(LANG_TRIGGER_BAD_REF_CLAUSE_DUPS, statement, "create trigger t1 NO CASCADE before update on x referencing old as oldrow new as newrow old as oldrow2 \tfor each row values 1");
            TriggerBeforeTrigTest.assertStatementError(LANG_TRIGGER_BAD_REF_CLAUSE_DUPS, statement, "create trigger t1 NO CASCADE before update on x referencing new as newrow new as newrow2 old as oldrow2 \tfor each row values 1");
            TriggerBeforeTrigTest.assertStatementError(LANG_TRIGGER_BAD_REF_MISMATCH, statement, "create trigger t1 NO CASCADE before update on x referencing new_table as newtab for each row values 1");
            TriggerBeforeTrigTest.assertStatementError(LANG_TRIGGER_BAD_REF_MISMATCH, statement, "create trigger t1 NO CASCADE before update on x referencing new as newrow for each statement values 1");
            TriggerBeforeTrigTest.assertStatementError(LANG_TRIGGER_BAD_REF_MISMATCH, statement, "create trigger t1 NO CASCADE before update on x referencing old_table as old for each row select * from old");
            TriggerBeforeTrigTest.assertStatementError(LANG_TRIGGER_BAD_REF_MISMATCH, statement, "create trigger t1 NO CASCADE before update on x referencing old_table as old for each statement values old.x");
            TriggerBeforeTrigTest.assertStatementError(LANG_TRIGGER_BAD_REF_MISMATCH, statement, "create trigger t1 NO CASCADE before update on x referencing old_table as oldtable for each statement select * from old");
            TriggerBeforeTrigTest.assertStatementError(LANG_COL_NOT_FOUND, statement, "create trigger t1 NO CASCADE before update on x referencing old as oldtable for each row values old.x");
            statement.executeUpdate("create table y (x int)");
            TriggerBeforeTrigTest.assertStatementError(LANG_UNSUPPORTED_TRIGGER_STMT, statement, "create trigger t1 NO CASCADE before insert on x referencing new_table as newrowtab for each statement insert into y select x from newrowtab");
        }
        finally {
            this.dontThrow(statement, "drop table x");
            this.dontThrow(statement, "drop table y");
            this.dontThrow(statement, "drop table unrelated");
            this.commit();
        }
    }

    private void dontThrow(Statement statement, String string) {
        try {
            statement.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            TriggerBeforeTrigTest.println("\"" + string + "\" failed");
        }
    }
}

