/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.SQLException;
import java.util.Arrays;
import org.apache.derby.vti.RestrictedVTI;
import org.apache.derby.vti.Restriction;
import org.apache.derbyTesting.functionTests.tests.lang.StringArrayVTI;

public class IntegerArrayVTI
extends StringArrayVTI
implements RestrictedVTI {
    private static String[] _lastProjection;
    private static Restriction _lastRestriction;
    private static int _lastQualifedRowCount;

    public IntegerArrayVTI(String[] stringArray, int[][] nArray) {
        super(stringArray, IntegerArrayVTI.stringify(nArray));
    }

    public IntegerArrayVTI(String[] stringArray, Integer[][] integerArray) {
        super(stringArray, IntegerArrayVTI.stringify(integerArray));
    }

    private static String[][] stringify(int[][] nArray) {
        int n = nArray.length;
        String[][] stringArray = new String[n][];
        for (int i = 0; i < n; ++i) {
            int[] nArray2 = nArray[i];
            int n2 = nArray2.length;
            String[] stringArray2 = new String[n2];
            stringArray[i] = stringArray2;
            for (int j = 0; j < n2; ++j) {
                stringArray2[j] = Integer.toString(nArray2[j]);
            }
        }
        return stringArray;
    }

    private static String[][] stringify(Integer[][] integerArray) {
        int n = integerArray.length;
        String[][] stringArray = new String[n][];
        for (int i = 0; i < n; ++i) {
            Integer[] integerArray2 = integerArray[i];
            int n2 = integerArray2.length;
            String[] stringArray2 = new String[n2];
            stringArray[i] = stringArray2;
            for (int j = 0; j < n2; ++j) {
                String string;
                Integer n3 = integerArray2[j];
                stringArray2[j] = string = n3 == null ? null : n3.toString();
            }
        }
        return stringArray;
    }

    @Override
    public boolean next() throws SQLException {
        do {
            boolean bl;
            if (bl = super.next()) continue;
            return false;
        } while (!this.qualifyCurrentRow());
        ++_lastQualifedRowCount;
        return true;
    }

    public void initScan(String[] stringArray, Restriction restriction) throws SQLException {
        _lastProjection = stringArray;
        _lastRestriction = restriction;
        _lastQualifedRowCount = 0;
    }

    private boolean qualifyCurrentRow() throws SQLException {
        if (_lastRestriction == null) {
            return true;
        }
        return this.qualifyCurrentRow(_lastRestriction);
    }

    private boolean qualifyCurrentRow(Restriction restriction) throws SQLException {
        if (restriction instanceof Restriction.AND) {
            Restriction.AND aND = (Restriction.AND)restriction;
            return this.qualifyCurrentRow(aND.getLeftChild()) && this.qualifyCurrentRow(aND.getRightChild());
        }
        if (restriction instanceof Restriction.OR) {
            Restriction.OR oR = (Restriction.OR)restriction;
            return this.qualifyCurrentRow(oR.getLeftChild()) || this.qualifyCurrentRow(oR.getRightChild());
        }
        if (restriction instanceof Restriction.ColumnQualifier) {
            return this.applyColumnQualifier((Restriction.ColumnQualifier)restriction);
        }
        throw new SQLException("Unknown type of Restriction: " + restriction.getClass().getName());
    }

    private boolean applyColumnQualifier(Restriction.ColumnQualifier columnQualifier) throws SQLException {
        int n = columnQualifier.getComparisonOperator();
        int n2 = this.getInt(columnQualifier.getColumnName());
        boolean bl = this.wasNull();
        if (bl) {
            if (n == 5) {
                return true;
            }
            if (n == 6) {
                return false;
            }
            return false;
        }
        if (n == 5) {
            return false;
        }
        if (n == 6) {
            return true;
        }
        int n3 = (Integer)columnQualifier.getConstantOperand();
        switch (n) {
            case 1: {
                return n2 == n3;
            }
            case 4: {
                return n2 >= n3;
            }
            case 3: {
                return n2 > n3;
            }
            case 2: {
                return n2 <= n3;
            }
            case 0: {
                return n2 < n3;
            }
        }
        throw new SQLException("Unknown comparison operator: " + n);
    }

    public static String getLastProjection() {
        return _lastProjection == null ? null : Arrays.asList(_lastProjection).toString();
    }

    public static String getLastRestriction() {
        return _lastRestriction == null ? null : _lastRestriction.toSQL();
    }

    public static int getLastQualifiedRowCount() {
        return _lastQualifedRowCount;
    }
}

