/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class DateTimeTest
extends BaseJDBCTestCase {
    public DateTimeTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("DateTimeTest");
        baseTestSuite.addTest(DateTimeTest.baseSuite("DateTimeTest:Embedded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(DateTimeTest.baseSuite("DateTimeTest:Client")));
        return baseTestSuite;
    }

    protected static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        baseTestSuite.addTestSuite(DateTimeTest.class);
        return new CleanDatabaseTestSetup((Test)baseTestSuite){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                DateTimeTest.createTableForArithmeticTest(statement);
                DateTimeTest.createTableForSyntaxTest(statement);
                DateTimeTest.createTableForConversionTest(statement);
                DateTimeTest.createTableForISOFormatTest(statement);
            }
        };
    }

    private static void createTableForISOFormatTest(Statement statement) throws SQLException {
        statement.executeUpdate(" create table ts (ts1 timestamp, ts2 timestamp)");
    }

    private static void createTableForConversionTest(Statement statement) throws SQLException {
        statement.executeUpdate(" create table convtest(d date, t time, ts timestamp)");
        statement.executeUpdate(" insert into convtest values(date('1932-03-21'),  time('23:49:52'), timestamp('1832-09-24 10:11:43.32'))");
        statement.executeUpdate(" insert into convtest values(date('0001-03-21'),  time('5:22:59'), timestamp('9999-12-31 23:59:59.999999'))");
        statement.executeUpdate(" insert into convtest values(null, null, null)");
    }

    private static void createTableForSyntaxTest(Statement statement) throws SQLException {
        statement.executeUpdate("create table source (i int, s smallint, c char(10), v varchar(50), d double precision, r real, e date, t time, p timestamp)");
        statement.executeUpdate(" create table target (e date not null, t time not null, p timestamp not null)");
    }

    private static void createTableForArithmeticTest(Statement statement) throws SQLException {
        statement.executeUpdate("create table t (i int, s smallint, c char(10), v varchar(50), d double precision, r real, e date, t time, p timestamp)");
        statement.executeUpdate(" insert into t values (null, null, null, null, null, null, null, null, null)");
        statement.executeUpdate(" insert into t values (0, 100, 'hello', 'everyone is here', 200.0e0, 300.0e0, date('1992-01-01'), time('12:30:30'), timestamp('1992-01-01 12:30:30'))");
        statement.executeUpdate(" insert into t values (-1, -100, 'goodbye', 'everyone is there', -200.0e0, -300.0e0, date('1992-01-01'), time('12:30:30'), timestamp('1992-01-01 12:30:45'))");
    }

    public void testArithOpers_math() throws SQLException {
        Statement statement = this.createStatement();
        DateTimeTest.assertStatementError("42Y95", statement, "select e + e from t");
        DateTimeTest.assertStatementError("42Y95", statement, " select i + e from t");
        DateTimeTest.assertStatementError("42Y95", statement, " select p / p from t");
        DateTimeTest.assertStatementError("42Y95", statement, " select p * s from t");
        DateTimeTest.assertStatementError("42Y95", statement, " select t - t from t");
        DateTimeTest.assertStatementError("42X37", statement, " select -t from t");
        DateTimeTest.assertStatementError("42X37", statement, " select +e from t");
        statement.close();
    }

    public void testArithOpers_Comarision() throws SQLException {
        ResultSet resultSet = null;
        Statement statement = this.createStatement();
        resultSet = statement.executeQuery("select e from t where e = date('1992-01-01')");
        JDBC.assertColumnNames(resultSet, "E");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1992-01-01"}, {"1992-01-01"}}, true);
        resultSet = statement.executeQuery(" select e from t where date('1992-01-01') = e");
        JDBC.assertColumnNames(resultSet, "E");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1992-01-01"}, {"1992-01-01"}}, true);
        resultSet = statement.executeQuery(" select t from t where t > time('09:30:15')");
        JDBC.assertColumnNames(resultSet, "T");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"12:30:30"}, {"12:30:30"}}, true);
        resultSet = statement.executeQuery(" select t from t where time('09:30:15') < t");
        JDBC.assertColumnNames(resultSet, "T");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"12:30:30"}, {"12:30:30"}}, true);
        resultSet = statement.executeQuery("select p from t where p < timestamp('1997-06-30 01:01:01')");
        JDBC.assertColumnNames(resultSet, "P");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1992-01-01 12:30:30.0"}, {"1992-01-01 12:30:45.0"}}, true);
        resultSet = statement.executeQuery("select p from t where timestamp('1997-06-30 01:01:01' )> p");
        JDBC.assertColumnNames(resultSet, "P");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1992-01-01 12:30:30.0"}, {"1992-01-01 12:30:45.0"}}, true);
        resultSet = statement.executeQuery("select e from t where e >= date('1990-01-01')");
        JDBC.assertColumnNames(resultSet, "E");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1992-01-01"}, {"1992-01-01"}}, true);
        resultSet = statement.executeQuery(" select e from t where date('1990-01-01')<= e");
        JDBC.assertColumnNames(resultSet, "E");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1992-01-01"}, {"1992-01-01"}}, true);
        resultSet = statement.executeQuery(" select t from t where t <= time('09:30:15')");
        JDBC.assertColumnNames(resultSet, "T");
        JDBC.assertDrainResults(resultSet, 0);
        resultSet = statement.executeQuery(" select t from t where time('09:30:15') >= t");
        JDBC.assertColumnNames(resultSet, "T");
        JDBC.assertDrainResults(resultSet, 0);
        resultSet = statement.executeQuery("select p from t where p <> timestamp('1997-06-30 01:01:01')");
        JDBC.assertColumnNames(resultSet, "P");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1992-01-01 12:30:30.0"}, {"1992-01-01 12:30:45.0"}}, true);
        resultSet = statement.executeQuery("select p from t where timestamp('1997-06-30 01:01:01' )<> p");
        JDBC.assertColumnNames(resultSet, "P");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1992-01-01 12:30:30.0"}, {"1992-01-01 12:30:45.0"}}, true);
        statement.close();
    }

    public void testArithOpers_CompraionOnMixedTypes() throws SQLException {
        Statement statement = this.createStatement();
        DateTimeTest.assertStatementError("42818", statement, "select e from t where e <= i");
        DateTimeTest.assertStatementError("42818", statement, " select e from t where t < s");
        DateTimeTest.assertStatementError("42818", statement, " select e from t where p > d");
        DateTimeTest.assertStatementError("42818", statement, " select e from t where e >= t");
        DateTimeTest.assertStatementError("42818", statement, " select e from t where t <> p");
        DateTimeTest.assertStatementError("42818", statement, " select e from t where p = e");
        statement.close();
    }

    public void testArithOpers_CompraionOnNotExistingValue() throws SQLException {
        ResultSet resultSet = null;
        Statement statement = this.createStatement();
        resultSet = statement.executeQuery("select e from t where e <> date('1992-01-01')");
        JDBC.assertColumnNames(resultSet, "E");
        JDBC.assertDrainResults(resultSet, 0);
        resultSet = statement.executeQuery("select e from t where date('1992-01-01') <> e");
        JDBC.assertColumnNames(resultSet, "E");
        JDBC.assertDrainResults(resultSet, 0);
        statement.close();
    }

    public void testArithOpers_ComparisonOnGarbage() throws SQLException {
        Statement statement = this.createStatement();
        DateTimeTest.assertStatementError("22008", statement, "select date( 'xxxx') from t where p is null");
        DateTimeTest.assertStatementError("22007", statement, " select time( '') from t where p is null");
        DateTimeTest.assertStatementError("22008", statement, " select timestamp( 'is there anything here?' )from t where p is null");
        DateTimeTest.assertStatementError("22008", statement, " select timestamp( '1992-01- there anything here?')from t where p is null");
        DateTimeTest.assertStatementError("22008", statement, " select timestamp( '--::' )from t where p is null");
        DateTimeTest.assertStatementError("22007", statement, " select time('::::') from t where p is null");
        statement.close();
    }

    public void testArithOpers_ComparisonOnLimits() throws SQLException {
        ResultSet resultSet = null;
        Statement statement = this.createStatement();
        resultSet = statement.executeQuery("values( date('0001-1-1'), date('9999-12-31'), date('2/29/2000'), date('29.2.2004'))");
        JDBC.assertColumnNames(resultSet, "1", "2", "3", "4");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"0001-01-01", "9999-12-31", "2000-02-29", "2004-02-29"}}, true);
        resultSet = statement.executeQuery(" values( time('00:00:00'), time('23:59:59'))");
        JDBC.assertColumnNames(resultSet, "1", "2");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"00:00:00", "23:59:59"}}, true);
        resultSet = statement.executeQuery(" values( time('00 AM'), time( '12:59 AM'), time('1 PM'), time('12:59 PM'))");
        JDBC.assertColumnNames(resultSet, "1", "2", "3", "4");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"00:00:00", "00:59:00", "13:00:00", "12:59:00"}}, true);
        resultSet = statement.executeQuery(" values( time('00.00.00'), time('23.59.59'), time('24.00.00'))");
        JDBC.assertColumnNames(resultSet, "1", "2", "3");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"00:00:00", "23:59:59", "00:00:00"}}, true);
        resultSet = statement.executeQuery(" values( timestamp('0001-1-1 00:00:00'), timestamp('9999-12-31 23:59:59.999999'))");
        JDBC.assertColumnNames(resultSet, "1", "2");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"0001-01-01 00:00:00.0", "9999-12-31 23:59:59.999999"}}, true);
        statement.close();
    }

    public void testArithOpers_ComparisonOnBeyondLimits() throws SQLException {
        Statement statement = this.createStatement();
        DateTimeTest.assertStatementError("22008", statement, "values( date('0000-01-01'))");
        DateTimeTest.assertStatementError("22008", statement, " values( date('2000-00-01'))");
        DateTimeTest.assertStatementError("22008", statement, " values( date('2000-01-00'))");
        DateTimeTest.assertStatementError("22008", statement, " values( date('10000-01-01'))");
        DateTimeTest.assertStatementError("22008", statement, " values( date('2000-13-01'))");
        DateTimeTest.assertStatementError("22008", statement, " values( date('2000-01-32'))");
        DateTimeTest.assertStatementError("22008", statement, " values( date('1900-02-29'))");
        DateTimeTest.assertStatementError("22008", statement, " values( date('2001-02-29'))");
        DateTimeTest.assertStatementError("22007", statement, " values( time('25.00.00'))");
        DateTimeTest.assertStatementError("22007", statement, " values( time('24.00.01'))");
        DateTimeTest.assertStatementError("22007", statement, " values( time('0:60:00'))");
        DateTimeTest.assertStatementError("22007", statement, " values( time('00:00:60'))");
        statement.close();
    }

    public void testArithOpers_ComparisonOnNullAndNonNull() throws SQLException {
        ResultSet resultSet = null;
        Statement statement = this.createStatement();
        resultSet = statement.executeQuery("select e, t, p from t where e = e or t = t or p = p");
        JDBC.assertColumnNames(resultSet, "E", "T", "P");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1992-01-01", "12:30:30", "1992-01-01 12:30:30.0"}, {"1992-01-01", "12:30:30", "1992-01-01 12:30:45.0"}}, true);
        resultSet = statement.executeQuery("select * from t where e is not null and t is not null and p is not null");
        JDBC.assertColumnNames(resultSet, "I", "S", "C", "V", "D", "R", "E", "T", "P");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"0", "100", "hello", "everyone is here", "200.0", "300.0", "1992-01-01", "12:30:30", "1992-01-01 12:30:30.0"}, {"-1", "-100", "goodbye", "everyone is there", "-200.0", "-300.0", "1992-01-01", "12:30:30", "1992-01-01 12:30:45.0"}}, true);
        statement.close();
    }

    public void testArithOpers_ComparisonOnEqualSQ() throws SQLException {
        ResultSet resultSet = null;
        Statement statement = this.createStatement();
        DateTimeTest.assertStatementError("21000", statement, "select 'fail' from t where e = (select e from t)");
        resultSet = statement.executeQuery("select 'pass' from t where e = (select e from t where d=200)");
        JDBC.assertColumnNames(resultSet, "1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"pass"}, {"pass"}}, true);
        DateTimeTest.assertStatementError("21000", statement, "select 'fail' from t where t = (select t from t)");
        resultSet = statement.executeQuery("select 'pass' from t where t = (select t from t where d=200)");
        JDBC.assertColumnNames(resultSet, "1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"pass"}, {"pass"}}, true);
        DateTimeTest.assertStatementError("21000", statement, "select 'fail' from t where p = (select p from t)");
        resultSet = statement.executeQuery("select 'pass' from t where p = (select p from t where d=200)");
        JDBC.assertColumnNames(resultSet, "1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"pass"}}, true);
        statement.close();
    }

    public void testSyntax_SpecifiedPrecision() throws SQLException {
        Statement statement = this.createStatement();
        DateTimeTest.assertStatementError("42X01", statement, "create table wrong (t time(-100))");
        DateTimeTest.assertStatementError("42X01", statement, " create table wrong (t time(0))");
        DateTimeTest.assertStatementError("42X01", statement, " create table wrong (t time(23))");
        DateTimeTest.assertStatementError("42X01", statement, " create table wrong (t timestamp(-100))");
        DateTimeTest.assertStatementError("42X01", statement, " create table wrong (t timestamp(0))");
        DateTimeTest.assertStatementError("42X01", statement, " create table wrong (t timestamp(6))");
        DateTimeTest.assertStatementError("42X01", statement, " create table wrong (t timestamp(9))");
        DateTimeTest.assertStatementError("42X01", statement, " create table wrong (t timestamp(23))");
        statement.close();
    }

    public void testSyntax_Insert() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("insert into source values (1, 2, '3', '4', 5, 6, date('1997-07-07'), time('08:08:08'),timestamp('1999-09-09 09:09:09'))");
        statement.executeUpdate("insert into target select e,t,p from source");
        DateTimeTest.assertStatementError("42821", statement, "insert into target select p,e,t from source");
        DateTimeTest.assertStatementError("42821", statement, " insert into target select i,s,d from source");
        DateTimeTest.assertStatementError("42821", statement, " insert into target (t,p) select c,r from source");
        DateTimeTest.assertUpdateCount(statement, 1, " delete from source");
        statement.executeUpdate(" insert into source values (null, null, null, null, null, null, null, null, null)");
        DateTimeTest.assertStatementError("23502", statement, "insert into target values(null, null, null)");
        DateTimeTest.assertStatementError("23502", statement, " insert into target select e,t,p from source");
        DateTimeTest.assertStatementError("42821", statement, "insert into target select p,e,t from source");
        DateTimeTest.assertStatementError("42821", statement, " insert into target select i,s,d from source");
        DateTimeTest.assertStatementError("42821", statement, " insert into target (t,p)select c,r from source");
        ResultSet resultSet = statement.executeQuery("select * from target");
        JDBC.assertColumnNames(resultSet, "E", "T", "P");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1997-07-07", "08:08:08", "1999-09-09 09:09:09.0"}}, true);
        statement.close();
    }

    public void testSyntax_Update() throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from target");
        JDBC.assertColumnNames(resultSet, "E", "T", "P");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1997-07-07", "08:08:08", "1999-09-09 09:09:09.0"}}, true);
        DateTimeTest.assertUpdateCount(statement, 1, "update target set e = e, t = t, p = p");
        resultSet = statement.executeQuery(" select * from target");
        JDBC.assertColumnNames(resultSet, "E", "T", "P");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1997-07-07", "08:08:08", "1999-09-09 09:09:09.0"}}, true);
        DateTimeTest.assertUpdateCount(statement, 1, "update target set e = date('1990-01-01')");
        resultSet = statement.executeQuery(" select * from target");
        JDBC.assertColumnNames(resultSet, "E", "T", "P");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1990-01-01", "08:08:08", "1999-09-09 09:09:09.0"}}, true);
        DateTimeTest.assertStatementError("23502", statement, "update target set e = null");
        resultSet = statement.executeQuery(" select * from target");
        JDBC.assertColumnNames(resultSet, "E", "T", "P");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1990-01-01", "08:08:08", "1999-09-09 09:09:09.0"}}, true);
        DateTimeTest.assertUpdateCount(statement, 1, "update source set e = date('1492-10-01')");
        resultSet = statement.executeQuery(" select e from source");
        JDBC.assertColumnNames(resultSet, "E");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1492-10-01"}}, true);
        DateTimeTest.assertUpdateCount(statement, 1, " update source set e = null");
        resultSet = statement.executeQuery(" select e from source");
        JDBC.assertColumnNames(resultSet, "E");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{null}}, true);
        DateTimeTest.assertStatementError("42821", statement, "update target set e = 1");
        DateTimeTest.assertStatementError("42821", statement, " update source set p = 1.4e10");
        DateTimeTest.assertStatementError("42821", statement, " update source set i = date('1001-01-01')");
        statement.close();
    }

    public void testSyntax_CurrentFunctions() throws SQLException {
        ResultSet resultSet = null;
        Statement statement = this.createStatement();
        DateTimeTest.assertUpdateCount(statement, 1, "delete from source");
        DateTimeTest.assertUpdateCount(statement, 1, " delete from target");
        statement.executeUpdate(" insert into source values (1, 2, '3', '4', 5, 6, date('1997-06-07'), time('08:08:08'), timestamp('9999-09-09 09:09:09'))");
        resultSet = statement.executeQuery("select 'pass' from source where current_date = current_date and current_time = current_time and current_timestamp = current_timestamp");
        JDBC.assertColumnNames(resultSet, "1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"pass"}}, true);
        resultSet = statement.executeQuery(" select 'pass' from source where current_date > date('1996-12-31') and current_time <= time(        '23:59:59') -- may oopsie on leap second days and current_timestamp <> timestamp( -- this comment is just more whitespace '1996-12-31 00:00:00')");
        JDBC.assertColumnNames(resultSet, "1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"pass"}}, true);
        resultSet = statement.executeQuery("select 'pass' from source where current date = current date and current time = current time and current timestamp = current timestamp");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"pass"}}, true);
        resultSet = statement.executeQuery(" select 'pass' from source where current date > date('1996-12-31') and current time <= time(        '23:59:59') -- may oopsie on leap second days and current timestamp <> timestamp( -- this comment is just more whitespace '1996-12-31 00:00:00')");
        JDBC.assertColumnNames(resultSet, "1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"pass"}}, true);
    }

    public void testSyntax_EscapedFunctions() throws SQLException {
        ResultSet resultSet = null;
        Statement statement = this.createStatement();
        DateTimeTest.assertStatementError("42X01", statement, "select 'pass' from source where current_date = {fn current_date()} and current_time = {fn current_time()} and current_timestamp = current_timestamp");
        resultSet = statement.executeQuery(" select 'pass' from source where current_date = {fn curdate()} and current_time = {fn curtime()} and current_timestamp = current_timestamp");
        JDBC.assertColumnNames(resultSet, "1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"pass"}}, true);
        DateTimeTest.assertStatementError("42Y03", statement, "values curdate()");
        DateTimeTest.assertStatementError("42Y03", statement, " values curtime()");
        DateTimeTest.assertStatementError("42X01", statement, " values current_date()");
        DateTimeTest.assertStatementError("42X01", statement, " values current_time()");
        DateTimeTest.assertStatementError("42X01", statement, " values {fn current_date()}");
        DateTimeTest.assertStatementError("42X01", statement, " values {fn current_time()}");
        resultSet = statement.executeQuery("select 'pass' from source where hour(current_time) = {fn hour(current_time)} and minute(current_time) = {fn minute(current_time)} and second(current_time) = {fn second(current_time)} and year(current_date)   = {fn year(current_date)}");
        JDBC.assertColumnNames(resultSet, "1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"pass"}}, true);
        resultSet = statement.executeQuery("values {fn hour('23:38:10')}");
        JDBC.assertColumnNames(resultSet, "1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"23"}}, true);
        resultSet = statement.executeQuery(" values {fn minute('23:38:10')}");
        JDBC.assertColumnNames(resultSet, "1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"38"}}, true);
        resultSet = statement.executeQuery(" values {fn second('23:38:10')}");
        JDBC.assertColumnNames(resultSet, "1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"10"}}, true);
        resultSet = statement.executeQuery(" values {fn year('2004-03-22')}");
        JDBC.assertColumnNames(resultSet, "1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"2004"}}, true);
        DateTimeTest.assertStatementError("42821", statement, "insert into source values (0, 0, '0', '0', 0, 0, current_time, current_time, current_timestamp)");
        DateTimeTest.assertStatementError("42821", statement, " insert into source values (0, 0, '0', '0', 0, 0, current_date, current_timestamp, current_timestamp)");
        DateTimeTest.assertStatementError("42821", statement, " insert into source values (0, 0, '0', '0', 0, 0, current_date, current_time, current_date)");
        statement.executeUpdate("insert into source values (0, 0, '0', '0', 0, 0, current_date, current_time, current_timestamp)");
        statement.executeUpdate("insert into source values (0, 0, '0', '0', 0, 0, current date, current time, current timestamp)");
        resultSet = statement.executeQuery("select * from source where e <> current_date and p <> current_timestamp");
        JDBC.assertColumnNames(resultSet, "I", "S", "C", "V", "D", "R", "E", "T", "P");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1", "2", "3", "4", "5.0", "6.0", "1997-06-07", "08:08:08", "9999-09-09 09:09:09.0"}}, true);
        resultSet = statement.executeQuery("select * from source where e <> current date and p <> current timestamp");
        JDBC.assertColumnNames(resultSet, "I", "S", "C", "V", "D", "R", "E", "T", "P");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1", "2", "3", "4", "5.0", "6.0", "1997-06-07", "08:08:08", "9999-09-09 09:09:09.0"}}, true);
        resultSet = statement.executeQuery(" select 'pass' from source where e <= current_date and p <= current_timestamp");
        JDBC.assertColumnNames(resultSet, "1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"pass"}, {"pass"}}, true);
        DateTimeTest.assertUpdateCount(statement, 2, "delete from source where i=0");
        statement.close();
    }

    public void testSyntax_Extract() throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select year( e), month( e), day( date( '1997-01-15')), hour( t), minute( t), second( time( '01:01:42')), year( p), month( p), day( p), hour( timestamp( '1992-01-01 14:11:23')), minute( p), second( p) from source");
        JDBC.assertColumnNames(resultSet, "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1997", "6", "15", "8", "8", "42", "9999", "9", "9", "14", "9", "9.0"}}, true);
        DateTimeTest.assertStatementError("42X25", statement, "select month( i) from source");
        DateTimeTest.assertStatementError("42X25", statement, " select hour( d) from source");
        DateTimeTest.assertStatementError("42X25", statement, "select month( t) from source");
        DateTimeTest.assertStatementError("42X25", statement, " select day( t) from source");
        DateTimeTest.assertStatementError("42X25", statement, " select year( t) from source");
        DateTimeTest.assertStatementError("42X25", statement, " select hour( e) from source");
        DateTimeTest.assertStatementError("42X25", statement, " select minute( e) from source");
        DateTimeTest.assertStatementError("42X25", statement, " select second( e) from source");
        DateTimeTest.assertUpdateCount(statement, 1, " update source set i=month( e), s=minute( t), d=second( p)");
        resultSet = statement.executeQuery("select i,e as \"month\",s,t as \"minute\",d,p as \"second\" from source where (i = month(e)) and (s = minute(t)) and (d = second(p))");
        JDBC.assertColumnNames(resultSet, "I", "month", "S", "minute", "D", "second");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"6", "1997-06-07", "8", "08:08:08", "9.0", "9999-09-09 09:09:09.0"}}, true);
        resultSet = statement.executeQuery("select p, year( p) as \"year\", month( p) as \"month\", day( p) as \"day\", hour( p) as \"hour\", minute( p) as \"minute\", second( p) as \"second\" from source");
        JDBC.assertColumnNames(resultSet, "P", "year", "month", "day", "hour", "minute", "second");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"9999-09-09 09:09:09.0", "9999", "9", "9", "9", "9", "9.0"}}, true);
        resultSet = statement.executeQuery("values ({d '1999-01-12'}, {t '11:26:35'}, {ts '1999-01-12 11:26:51'})");
        JDBC.assertColumnNames(resultSet, "1", "2", "3");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1999-01-12", "11:26:35", "1999-01-12 11:26:51.0"}}, true);
        resultSet = statement.executeQuery(" values year( {d '1999-01-12'})");
        JDBC.assertColumnNames(resultSet, "1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1999"}}, true);
        resultSet = statement.executeQuery(" values hour( {t '11:28:10'})");
        JDBC.assertColumnNames(resultSet, "1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"11"}}, true);
        resultSet = statement.executeQuery(" values day( {ts '1999-01-12 11:28:23'})");
        JDBC.assertColumnNames(resultSet, "1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"12"}}, true);
        statement.close();
    }

    public void testRandom() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table sertest(d date, s Date, o Date)");
        statement.executeUpdate(" insert into sertest values (date('1992-01-03'), null, null)");
        ResultSet resultSet = statement.executeQuery(" select * from sertest");
        JDBC.assertColumnNames(resultSet, "D", "S", "O");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1992-01-03", null, null}}, true);
        DateTimeTest.assertUpdateCount(statement, 1, " update sertest set s=d");
        DateTimeTest.assertUpdateCount(statement, 1, " update sertest set o=d");
        statement.executeUpdate(" insert into sertest values (date( '3245-09-09'), date( '1001-06-07'), date( '1999-01-05'))");
        resultSet = statement.executeQuery(" select * from sertest");
        JDBC.assertColumnNames(resultSet, "D", "S", "O");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1992-01-03", "1992-01-03", "1992-01-03"}, {"3245-09-09", "1001-06-07", "1999-01-05"}}, true);
        resultSet = statement.executeQuery(" select * from sertest where d > s");
        JDBC.assertColumnNames(resultSet, "D", "S", "O");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"3245-09-09", "1001-06-07", "1999-01-05"}}, true);
        DateTimeTest.assertUpdateCount(statement, 2, " update sertest set d=s");
        DateTimeTest.assertStatementError("42821", statement, "insert into sertest values (date('3245-09-09'), time('09:30:25'), null)");
        DateTimeTest.assertStatementError("42821", statement, " insert into sertest values (null, null, time('09:30:25'))");
        DateTimeTest.assertStatementError("42821", statement, " insert into sertest values (null, null, timestamp('1745-01-01 09:30:25'))");
        DateTimeTest.assertUpdateCount(statement, 2, "update sertest set d=o");
        resultSet = statement.executeQuery(" select * from sertest where s is null and o is not null");
        JDBC.assertColumnNames(resultSet, "D", "S", "O");
        JDBC.assertDrainResults(resultSet, 0);
        resultSet = statement.executeQuery("select month(s) from sertest where s is not null");
        JDBC.assertColumnNames(resultSet, "1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1"}, {"6"}}, true);
        resultSet = statement.executeQuery(" select day(o) from sertest");
        JDBC.assertColumnNames(resultSet, "1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"3"}, {"5"}}, true);
        this.dropTable("sertest");
    }

    public void testConvertFromString() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table convstrtest(d varchar(30), t char(30), ts long varchar)");
        statement.executeUpdate(" insert into convstrtest values('1932-03-21',  '23:49:52', '1832-09-24 10:11:43.32')");
        statement.executeUpdate(" insert into convstrtest values(null, null, null)");
        DateTimeTest.assertStatementError("22007", statement, "select CAST (d AS time) from convstrtest");
        DateTimeTest.assertStatementError("22007", statement, " select CAST (t AS date) from convstrtest");
        DateTimeTest.assertStatementError("42846", statement, " select CAST (ts AS time) from convstrtest");
        DateTimeTest.assertStatementError("42846", statement, " select CAST (ts AS date) from convstrtest");
        ResultSet resultSet = statement.executeQuery("select CAST (t AS time) from convstrtest");
        JDBC.assertColumnNames(resultSet, "1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"23:49:52"}, {null}}, true);
        resultSet = statement.executeQuery(" select CAST (d AS date) from convstrtest");
        JDBC.assertColumnNames(resultSet, "1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1932-03-21"}, {null}}, true);
        DateTimeTest.assertStatementError("42846", statement, "select CAST(CAST (ts AS timestamp) AS date), CAST(CAST (ts AS timestamp) AS time) from convstrtest");
        this.dropTable("convstrtest");
        statement.close();
    }

    public void testConvertToStringWithCalendar() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("values cast(? as varchar(29))");
        Timestamp timestamp = new Timestamp(1283373100000L);
        timestamp.setNanos(123456789);
        String[][] stringArrayArray = new String[][]{{"GMT", "2010-09-01 20:31:40.123456789"}, {"Europe/Oslo", "2010-09-01 22:31:40.123456789"}};
        for (int i = 0; i < stringArrayArray.length; ++i) {
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(stringArrayArray[i][0]));
            preparedStatement.setTimestamp(1, timestamp, calendar);
            JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), stringArrayArray[i][1]);
        }
    }

    public void testConversionToString() throws SQLException {
        String string = "2010-04-20 15:17:36.0";
        String string2 = "15:17:36";
        String string3 = "2010-04-20";
        Timestamp timestamp = Timestamp.valueOf(string);
        Time time = Time.valueOf(string2);
        Date date = Date.valueOf(string3);
        PreparedStatement preparedStatement = this.prepareStatement("VALUES CAST(? AS VARCHAR(40))");
        preparedStatement.setTimestamp(1, timestamp);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), string);
        preparedStatement.setTimestamp(1, timestamp, Calendar.getInstance());
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), string);
        preparedStatement.setTime(1, time);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), string2);
        preparedStatement.setTime(1, time, Calendar.getInstance());
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), string2);
        preparedStatement.setDate(1, date);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), string3);
        preparedStatement.setDate(1, date, Calendar.getInstance());
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), string3);
    }

    public void testTrailingZeros() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("values cast(? as varchar(29))");
        String[] stringArray = new String[]{"2010-09-22 14:40:33.000000000", "2010-09-22 14:40:33.012000000", "2010-09-22 14:40:33.123456000", "2010-09-22 14:40:33.139990900", "2010-09-22 14:40:33.139990983"};
        for (int i = 0; i < stringArray.length; ++i) {
            Timestamp timestamp = Timestamp.valueOf(stringArray[i]);
            String string = timestamp.toString();
            preparedStatement.setTimestamp(1, timestamp);
            JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), string);
            preparedStatement.setTimestamp(1, timestamp, Calendar.getInstance());
            JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), string);
        }
    }

    public void testConversion_Aggregates() throws SQLException {
        Statement statement = this.createStatement();
        DateTimeTest.assertStatementError("42Y22", statement, "select sum(d) from convtest");
        DateTimeTest.assertStatementError("42Y22", statement, " select sum(t) from convtest");
        DateTimeTest.assertStatementError("42Y22", statement, " select sum(ts) from convtest");
        ResultSet resultSet = statement.executeQuery("select count(d) from convtest");
        JDBC.assertColumnNames(resultSet, "1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"2"}}, true);
        resultSet = statement.executeQuery(" select count(t) from convtest");
        JDBC.assertColumnNames(resultSet, "1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"2"}}, true);
        resultSet = statement.executeQuery(" select count(ts) from convtest");
        JDBC.assertColumnNames(resultSet, "1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"2"}}, true);
        statement.executeUpdate(" insert into convtest values(date('0001-03-21'),  time('5:22:59'), timestamp('9999-12-31 23:59:59.999999'))");
        resultSet = statement.executeQuery("select count(distinct d) from convtest");
        JDBC.assertColumnNames(resultSet, "1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"2"}}, true);
        resultSet = statement.executeQuery(" select count(distinct t) from convtest");
        JDBC.assertColumnNames(resultSet, "1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"2"}}, true);
        resultSet = statement.executeQuery(" select count(distinct ts) from convtest");
        JDBC.assertColumnNames(resultSet, "1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"2"}}, true);
        resultSet = statement.executeQuery("select min(d) from convtest");
        JDBC.assertColumnNames(resultSet, "1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"0001-03-21"}}, true);
        resultSet = statement.executeQuery(" select min(t) from convtest");
        JDBC.assertColumnNames(resultSet, "1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"05:22:59"}}, true);
        resultSet = statement.executeQuery("select CAST(CAST (min(ts) AS timestamp) AS date), CAST(CAST (min(ts) AS timestamp) AS time) from convtest");
        JDBC.assertColumnNames(resultSet, "1", "2");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1832-09-24", "10:11:43"}}, true);
        resultSet = statement.executeQuery(" select max(d) from convtest");
        JDBC.assertColumnNames(resultSet, "1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1932-03-21"}}, true);
        resultSet = statement.executeQuery(" select max(t) from convtest");
        JDBC.assertColumnNames(resultSet, "1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"23:49:52"}}, true);
        resultSet = statement.executeQuery("select CAST(CAST (max(ts) AS timestamp) AS date), CAST(CAST (max(ts) AS timestamp) AS time) from convtest");
        JDBC.assertColumnNames(resultSet, "1", "2");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"9999-12-31", "23:59:59"}}, true);
        this.dropTable("convtest");
        DateTimeTest.createTableForConversionTest(statement);
        statement.close();
    }

    public void testConversion() throws SQLException {
        Statement statement = this.createStatement();
        DateTimeTest.assertStatementError("42846", statement, "select CAST (d AS time) from convtest");
        DateTimeTest.assertStatementError("42846", statement, " select CAST (t AS date) from convtest");
        ResultSet resultSet = statement.executeQuery("select CAST (t AS time) from convtest");
        JDBC.assertColumnNames(resultSet, "1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"23:49:52"}, {"05:22:59"}, {null}}, true);
        resultSet = statement.executeQuery(" select CAST (d AS date) from convtest");
        JDBC.assertColumnNames(resultSet, "1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1932-03-21"}, {"0001-03-21"}, {null}}, true);
        resultSet = statement.executeQuery(" select CAST (ts AS time) from convtest");
        JDBC.assertColumnNames(resultSet, "1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"10:11:43"}, {"23:59:59"}, {null}}, true);
        resultSet = statement.executeQuery(" select CAST (ts AS date) from convtest");
        JDBC.assertColumnNames(resultSet, "1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1832-09-24"}, {"9999-12-31"}, {null}}, true);
        resultSet = statement.executeQuery("select CAST(CAST (ts AS timestamp) AS date), CAST(CAST (ts AS timestamp) AS time) from convtest");
        JDBC.assertColumnNames(resultSet, "1", "2");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1832-09-24", "10:11:43"}, {"9999-12-31", "23:59:59"}, {null, null}}, true);
        DateTimeTest.assertStatementError("42846", statement, "select 'pass', CAST (CAST(t AS timestamp) AS time) from convtest where CAST(CAST(t AS timestamp) AS date)=current_date");
        DateTimeTest.assertStatementError("42846", statement, "select CAST (CAST (d AS timestamp) AS date), CAST(CAST(d AS timestamp) AS time) from convtest");
        statement.close();
    }

    public void testISOFormat_OmitLeadingZero() throws SQLException {
        Statement statement = this.createStatement();
        DateTimeTest.assertEquals((int)1, (int)statement.executeUpdate("insert into ts values ('2003-03-05-17.05.43.111111', '2003-03-05 17:05:43.111111')"));
        DateTimeTest.assertEquals((int)1, (int)statement.executeUpdate(" insert into ts values ('2003-3-03-17.05.43.111111', '2003-3-03 17:05:43.111111')"));
        DateTimeTest.assertEquals((int)1, (int)statement.executeUpdate(" insert into ts values ('2003-3-2-17.05.43.111111', '2003-3-2 17:05:43.111111')"));
        DateTimeTest.assertEquals((int)1, (int)statement.executeUpdate(" insert into ts values ('2003-03-2-17.05.43.111111', '2003-03-2 17:05:43.111111')"));
        DateTimeTest.assertEquals((int)1, (int)statement.executeUpdate(" insert into ts values ('2003-3-1-17.05.43.1', '2003-3-1 17:05:43.1')"));
        DateTimeTest.assertEquals((int)1, (int)statement.executeUpdate(" insert into ts values ('2003-3-1-17.05.43.12', '2003-3-1 17:05:43.12')"));
        DateTimeTest.assertEquals((int)1, (int)statement.executeUpdate(" insert into ts values ('2003-3-1-17.05.43.123', '2003-3-1 17:05:43.123')"));
        DateTimeTest.assertEquals((int)1, (int)statement.executeUpdate(" insert into ts values ('2003-3-1-17.05.43.1234', '2003-3-1 17:05:43.1234')"));
        DateTimeTest.assertEquals((int)1, (int)statement.executeUpdate(" insert into ts values ('2003-3-1-17.05.43.12345', '2003-3-1 17:05:43.12345')"));
        DateTimeTest.assertEquals((int)1, (int)statement.executeUpdate(" insert into ts values ('2003-3-1-17.05.43.123456', '2003-3-1 17:05:43.123456')"));
        DateTimeTest.assertEquals((int)1, (int)statement.executeUpdate(" insert into ts values ('2003-3-1-17.05.43', '2003-3-1 17:05:43')"));
        statement.close();
    }

    public void testISOFormat_TrailingBlanks() throws SQLException {
        Statement statement = this.createStatement();
        DateTimeTest.assertEquals((int)1, (int)statement.executeUpdate("insert into ts values ('2002-03-05-17.05.43.111111  ', '2002-03-05 17:05:43.111111   ')"));
        DateTimeTest.assertEquals((int)1, (int)statement.executeUpdate(" insert into ts values ('2002-03-05-17.05.43.1   ', '2002-03-05 17:05:43.1   ')"));
        DateTimeTest.assertEquals((int)1, (int)statement.executeUpdate(" insert into ts values ('2002-03-05-17.05.43    ', '2002-03-05 17:05:43    ')"));
        statement.close();
    }

    public void testISOFormat_TrailingZero() throws SQLException {
        Statement statement = this.createStatement();
        DateTimeTest.assertEquals((int)1, (int)statement.executeUpdate("insert into ts values ('2003-3-1-17.05.43.', '2003-3-1 17:05:43')"));
        DateTimeTest.assertEquals((int)1, (int)statement.executeUpdate(" insert into ts values ('2003-3-1-17.05.43.0', '2003-3-1 17:05:43.0')"));
        DateTimeTest.assertEquals((int)1, (int)statement.executeUpdate(" insert into ts values ('0003-03-05-17.05.43.111111', '0003-03-05 17:05:43.111111')"));
        ResultSet resultSet = statement.executeQuery(" select count(*) from ts where ts1=ts2");
        resultSet.next();
        int n = resultSet.getInt(1);
        resultSet = statement.executeQuery(" select count(*) from ts ");
        resultSet.next();
        DateTimeTest.assertEquals((int)n, (int)resultSet.getInt(1));
        statement.executeUpdate(" delete from ts");
        statement.close();
    }

    public void testISOFormat_LeadingZero() throws SQLException {
        Statement statement = this.createStatement();
        DateTimeTest.assertStatementError("22007", statement, "insert into ts (ts1) values ('03-03-05-17.05.43.111111')");
        DateTimeTest.assertStatementError("22007", statement, " insert into ts (ts1) values ('103-03-05-17.05.43.111111')");
        DateTimeTest.assertStatementError("22007", statement, " insert into ts (ts1) values ('3-03-05-17.05.43.111111')");
        statement.close();
    }

    public void testISOFormat_WrongTimestampFormat() throws SQLException {
        Statement statement = this.createStatement();
        DateTimeTest.assertStatementError("22007", statement, "insert into ts (ts1) values ('2003-3-24-13.1.02.566999')");
        DateTimeTest.assertStatementError("22007", statement, " insert into ts (ts1) values ('2003-3-24-13.1.1.569')");
        DateTimeTest.assertStatementError("22007", statement, " insert into ts (ts1) values ('2003-3-24-1.1.1.56')");
        DateTimeTest.assertStatementError("22007", statement, " insert into ts (ts1) values ('2003-3-24-1.1.1')");
        DateTimeTest.assertStatementError("22007", statement, " insert into ts (ts1) values ('2003-3-1-17.05.4.')");
        DateTimeTest.assertEquals((int)1, (int)statement.executeUpdate(" insert into ts (ts1) values ('2003-03-05-7.05.43.111111')"));
        DateTimeTest.assertStatementError("22007", statement, "insert into ts (ts1) values ('2003-3-1 17.05.43.123456')");
        statement.close();
    }

    public void testISOFormat_MoreThanNanoseconds() throws SQLException {
        Statement statement = this.createStatement();
        DateTimeTest.assertStatementError("22007", statement, "insert into ts (ts1) values ('2003-03-05-17.05.43.999999999999')");
        DateTimeTest.assertStatementError("22007", statement, " insert into ts (ts1) values ('2003-03-05-17.05.43.999999999000')");
        statement.close();
    }

    public void testTimeStampFunction() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table tt (datecol date, dateStr varchar(16), timecol time, timeStr varchar(16), expected timestamp)");
        statement.executeUpdate(" insert into tt ( dateStr, timeStr) values( '2004-03-04', '12:01:02')");
        statement.executeUpdate(" insert into tt ( dateStr, timeStr) values( null, '12:01:03')");
        statement.executeUpdate(" insert into tt ( dateStr, timeStr) values( '2004-03-05', null)");
        DateTimeTest.assertUpdateCount(statement, 3, " update tt  set datecol = date( dateStr), timecol = time( timeStr)");
        DateTimeTest.assertUpdateCount(statement, 1, " update tt  set expected = timestamp( dateStr || ' ' || timeStr) where dateStr is not null and timeStr is not null");
        ResultSet resultSet = statement.executeQuery(" select dateStr, timeStr from tt where (expected is not null and (expected <> timestamp( dateCol, timeCol) or timestamp( dateCol, timeCol) is null)) or (expected is null and timestamp( dateCol, timeCol) is not null)");
        JDBC.assertColumnNames(resultSet, "DATESTR", "TIMESTR");
        JDBC.assertDrainResults(resultSet, 0);
        resultSet = statement.executeQuery(" select dateStr, timeStr from tt where (expected is not null and (expected <> timestamp( dateStr, timeStr) or timestamp( dateStr, timeStr) is null)) or (expected is null and timestamp( dateStr, timeStr) is not null)");
        JDBC.assertColumnNames(resultSet, "DATESTR", "TIMESTR");
        JDBC.assertDrainResults(resultSet, 0);
        resultSet = statement.executeQuery(" select dateStr, timeStr from tt where (expected is not null and timestamp( dateStr, timeStr) <> timestamp( dateCol, timeCol)) or (expected is null and timestamp( dateStr, timeStr) is not null)");
        JDBC.assertColumnNames(resultSet, "DATESTR", "TIMESTR");
        JDBC.assertDrainResults(resultSet, 0);
        resultSet = statement.executeQuery(" select dateStr, timeStr from tt where expected is not null and date( timestamp( dateCol, timeCol)) <> dateCol");
        JDBC.assertColumnNames(resultSet, "DATESTR", "TIMESTR");
        JDBC.assertDrainResults(resultSet, 0);
        resultSet = statement.executeQuery(" select dateStr, timeStr from tt where expected is not null and time( timestamp( dateCol, timeCol)) <> timeCol");
        JDBC.assertColumnNames(resultSet, "DATESTR", "TIMESTR");
        JDBC.assertDrainResults(resultSet, 0);
        DateTimeTest.assertStatementError("42Y95", statement, "select timestamp( dateCol, dateCol) from tt where dateCol is not null");
        DateTimeTest.assertStatementError("42Y95", statement, " select timestamp( timeCol, timeCol) from tt where timeCol is not null");
        DateTimeTest.assertStatementError("22007", statement, "values timestamp( 'xyz', '12:01:02')");
        DateTimeTest.assertStatementError("22007", statement, " values timestamp( '2004-03-04', 'xyz')");
        this.dropTable("tt");
        statement.close();
    }

    public void testFormat() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate(" create table t_format (t time)");
        DateTimeTest.assertEquals((int)1, (int)statement.executeUpdate("insert into t_format values ('17.05.44')"));
        DateTimeTest.assertEquals((int)1, (int)statement.executeUpdate(" insert into t_format values ('17.05.00')"));
        DateTimeTest.assertEquals((int)1, (int)statement.executeUpdate(" insert into t_format values ('00.05.43')"));
        DateTimeTest.assertEquals((int)1, (int)statement.executeUpdate(" insert into t_format values ('00.00.00')"));
        DateTimeTest.assertEquals((int)1, (int)statement.executeUpdate("insert into t_format values ('24.00.00')"));
        DateTimeTest.assertEquals((int)1, (int)statement.executeUpdate("insert into t_format values ('17.05.11  ')"));
        DateTimeTest.assertEquals((int)1, (int)statement.executeUpdate(" insert into t_format values ('17:05:11  ')"));
        DateTimeTest.assertEquals((int)1, (int)statement.executeUpdate("insert into t_format values ('1:01')"));
        DateTimeTest.assertEquals((int)1, (int)statement.executeUpdate(" insert into t_format values ('1:02 ')"));
        DateTimeTest.assertEquals((int)1, (int)statement.executeUpdate(" insert into t_format values ('2.01')"));
        DateTimeTest.assertEquals((int)1, (int)statement.executeUpdate(" insert into t_format values ('2.02 ')"));
        ResultSet resultSet = statement.executeQuery("select * from t_format");
        JDBC.assertColumnNames(resultSet, "T");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"17:05:44"}, {"17:05:00"}, {"00:05:43"}, {"00:00:00"}, {"00:00:00"}, {"17:05:11"}, {"17:05:11"}, {"01:01:00"}, {"01:02:00"}, {"02:01:00"}, {"02:02:00"}}, true);
        DateTimeTest.assertUpdateCount(statement, 11, " delete from t_format");
        DateTimeTest.assertStatementError("22007", statement, "insert into t_format values ('24.60.60')");
        DateTimeTest.assertStatementError("22007", statement, " insert into t_format values ('04.00.60')");
        DateTimeTest.assertStatementError("22007", statement, " insert into t_format values ('03.60.00')");
        DateTimeTest.assertStatementError("22007", statement, "insert into t_format values ('07.5.44')");
        DateTimeTest.assertStatementError("22007", statement, " insert into t_format values ('07.05.4')");
        DateTimeTest.assertStatementError("22007", statement, " insert into t_format values ('7.5.44')");
        DateTimeTest.assertStatementError("22007", statement, " insert into t_format values ('7.5.4')");
        DateTimeTest.assertStatementError("22007", statement, " insert into t_format values ('7.5.0')");
        DateTimeTest.assertStatementError("22007", statement, " insert into t_format values ('-4.00.00')");
        DateTimeTest.assertStatementError("22007", statement, " insert into t_format values ('A4.00.00')");
        DateTimeTest.assertStatementError("22007", statement, " insert into t_format values ('7.5.999')");
        DateTimeTest.assertStatementError("22007", statement, " insert into t_format values ('07.05.111')");
        DateTimeTest.assertStatementError("22007", statement, " insert into t_format values ('111.05.11')");
        DateTimeTest.assertStatementError("22007", statement, " insert into t_format values ('11.115.00')");
        resultSet = statement.executeQuery("select * from t_format");
        JDBC.assertColumnNames(resultSet, "T");
        JDBC.assertDrainResults(resultSet, 0);
        this.dropTable("t_format");
        statement.close();
    }

    public void testFormat_Additional() throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("values time('2004-04-15 16:15:32.387')");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"16:15:32"}}, true);
        resultSet = statement.executeQuery(" values time('2004-04-15-16.15.32.387')");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"16:15:32"}}, true);
        DateTimeTest.assertStatementError("22007", statement, " values time('2004-04-15-16.15.32.387 zz')");
        DateTimeTest.assertStatementError("22007", statement, " values time('x-04-15-16.15.32.387')");
        resultSet = statement.executeQuery(" values date('2004-04-15 16:15:32.387')");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"2004-04-15"}}, true);
        resultSet = statement.executeQuery(" values date('2004-04-15-16.15.32.387')");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"2004-04-15"}}, true);
        DateTimeTest.assertStatementError("22008", statement, " values date('2004-04-15-16.15.32.387 zz')");
        DateTimeTest.assertStatementError("22008", statement, " values date('2004-04-15-16.15.32.y')");
        resultSet = statement.executeQuery(" values time('13:59')");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"13:59:00"}}, true);
        resultSet = statement.executeQuery(" values time('1:00')");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"01:00:00"}}, true);
        statement.close();
    }

    public void test_DateAndDatetimeFunctionsMore() throws Exception {
        int n;
        ResultSet resultSet = null;
        Statement statement = this.createStatement();
        this.setAutoCommit(false);
        statement.executeUpdate("create table t_func( i int, d date)");
        this.commit();
        statement.executeUpdate(" insert into t_func values( 1, date(1)),(10, date(10.1)),(365,date(365.1e0)),(366,date(366)),(789,date(789)),(790,date(790)),(791,date(791))");
        DateTimeTest.assertStatementError("22008", statement, "insert into t_func values( 0, date(0))");
        DateTimeTest.assertStatementError("22008", statement, " insert into t_func values( -1, date(-1))");
        DateTimeTest.assertStatementError("22008", statement, " insert into t_func values( 3652060, date( 3652060))");
        resultSet = statement.executeQuery(" select i,d,date(i),date(d) from t_func order by i");
        JDBC.assertColumnNames(resultSet, "I", "D", "3", "4");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1", "1970-01-01", "1970-01-01", "1970-01-01"}, {"10", "1970-01-10", "1970-01-10", "1970-01-10"}, {"365", "1970-12-31", "1970-12-31", "1970-12-31"}, {"366", "1971-01-01", "1971-01-01", "1971-01-01"}, {"789", "1972-02-28", "1972-02-28", "1972-02-28"}, {"790", "1972-02-29", "1972-02-29", "1972-02-29"}, {"791", "1972-03-01", "1972-03-01", "1972-03-01"}}, true);
        this.rollback();
        DateTimeTest.assertEquals((int)1, (int)statement.executeUpdate(" insert into t_func(i) values( 0)"));
        DateTimeTest.assertStatementError("22008", statement, " select date(i) from t_func");
        this.rollback();
        statement.executeUpdate(" insert into t_func(i) values( -1)");
        DateTimeTest.assertStatementError("22008", statement, " select date(i) from t_func");
        this.rollback();
        statement.executeUpdate(" insert into t_func(i) values( 3652060)");
        DateTimeTest.assertStatementError("22008", statement, " select date(i) from t_func");
        this.rollback();
        statement.executeUpdate(" drop table t_func");
        statement.executeUpdate(" create table t_func( s varchar(32), d date)");
        this.commit();
        DateTimeTest.assertEquals((int)6, (int)statement.executeUpdate(" insert into t_func values('1900060', date('1900060')), ('1904060', date('1904060')), ('1904366', date('1904366')), ('2000060', date('2000060')), ('2001060', date('2001060')), ('2001365', date('2001365'))"));
        resultSet = statement.executeQuery(" select s,d,date(s) from t_func order by s");
        JDBC.assertColumnNames(resultSet, "S", "D", "3");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1900060", "1900-03-01", "1900-03-01"}, {"1904060", "1904-02-29", "1904-02-29"}, {"1904366", "1904-12-31", "1904-12-31"}, {"2000060", "2000-02-29", "2000-02-29"}, {"2001060", "2001-03-01", "2001-03-01"}, {"2001365", "2001-12-31", "2001-12-31"}}, true);
        this.rollback();
        DateTimeTest.assertStatementError("22008", statement, "values( date('2001000'))");
        DateTimeTest.assertStatementError("22008", statement, " values( date('2001366'))");
        DateTimeTest.assertStatementError("22008", statement, " values( date('2000367'))");
        DateTimeTest.assertStatementError("22008", statement, " values( date('xxxxxxx'))");
        statement.executeUpdate(" insert into t_func(s) values( '2001000')");
        DateTimeTest.assertStatementError("22008", statement, "select date(s) from t_func");
        this.rollback();
        statement.executeUpdate(" insert into t_func(s) values( '2001366')");
        DateTimeTest.assertStatementError("22008", statement, "select date(s) from t_func");
        this.rollback();
        statement.executeUpdate(" insert into t_func(s) values( '2000367')");
        DateTimeTest.assertStatementError("22008", statement, "select date(s) from t_func");
        this.rollback();
        statement.executeUpdate(" insert into t_func(s) values( 'xxxxxxx')");
        DateTimeTest.assertStatementError("22008", statement, "select date(s) from t_func");
        this.rollback();
        PreparedStatement preparedStatement = this.prepareStatement("values( date(cast(? as integer)),timestamp(cast(? as varchar(32))))");
        resultSet = statement.executeQuery("values(cast(1 as integer), '2003-03-05-17.05.43.111111')");
        resultSet.next();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        for (n = 1; n <= resultSetMetaData.getColumnCount(); ++n) {
            preparedStatement.setObject(n, resultSet.getObject(n));
        }
        resultSet = preparedStatement.executeQuery();
        JDBC.assertColumnNames(resultSet, "1", "2");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1970-01-01", "2003-03-05 17:05:43.111111"}}, true);
        resultSet = statement.executeQuery("values(2, '20030422190200')");
        resultSet.next();
        resultSetMetaData = resultSet.getMetaData();
        for (n = 1; n <= resultSetMetaData.getColumnCount(); ++n) {
            preparedStatement.setObject(n, resultSet.getObject(n));
        }
        resultSet = preparedStatement.executeQuery();
        JDBC.assertColumnNames(resultSet, "1", "2");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1970-01-02", "2003-04-22 19:02:00.0"}}, true);
        resultSet = statement.executeQuery(" values( date(date(1)), date(timestamp('2003-03-05-17.05.43.111111')))");
        JDBC.assertColumnNames(resultSet, "1", "2");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1970-01-01", "2003-03-05"}}, true);
        statement.executeUpdate(" drop table t_func");
        statement.executeUpdate(" create table t_func( s varchar(32), ts timestamp, expected timestamp)");
        this.commit();
        statement.executeUpdate(" insert into t_func(ts) values( timestamp('2003-03-05-17.05.43.111111'))");
        resultSet = statement.executeQuery(" select date(ts) from t_func");
        String[] stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"2003-03-05"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        this.rollback();
        statement.executeUpdate("insert into t_func values('20000228235959', timestamp('20000228235959'), '2000-02-28-23.59.59'), ('20000229000000', timestamp('20000229000000'), '2000-02-29-00.00.00')");
        resultSet = statement.executeQuery(" select s from t_func where ts <> expected or timestamp(s) <> expected or timestamp(ts) <> expected");
        JDBC.assertColumnNames(resultSet, "S");
        JDBC.assertDrainResults(resultSet, 0);
        this.rollback();
        DateTimeTest.assertStatementError("22008", statement, "values( timestamp('2000 1 1 0 0 0'))");
        DateTimeTest.assertStatementError("22008", statement, " values( timestamp('aaaaaaaaaaaaaa'))");
        DateTimeTest.assertEquals((int)1, (int)statement.executeUpdate(" insert into t_func(s) values('2000 1 1 0 0 0')"));
        DateTimeTest.assertStatementError("22008", statement, " select timestamp(s) from t_func");
        this.rollback();
        DateTimeTest.assertEquals((int)1, (int)statement.executeUpdate(" insert into t_func(s) values('aaaaaaaaaaaaaa')"));
        DateTimeTest.assertStatementError("22008", statement, " select timestamp(s) from t_func");
        this.rollback();
        this.commit();
        this.getConnection().rollback();
        statement.close();
    }

    public void testNulls() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table nulls (t time, d date, ts timestamp)");
        statement.executeUpdate(" insert into nulls values (null,null,null)");
        this.commit();
        DateTimeTest.assertStatementError("42X25", statement, " select year(t) from nulls");
        DateTimeTest.assertStatementError("42X25", statement, " select month(t) from nulls");
        DateTimeTest.assertStatementError("42X25", statement, " select day(t) from nulls");
        ResultSet resultSet = statement.executeQuery(" select hour(t) from nulls");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{null}}, true);
        resultSet = statement.executeQuery(" select minute(t) from nulls");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{null}}, true);
        resultSet = statement.executeQuery(" select second(t) from nulls");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{null}}, true);
        resultSet = statement.executeQuery(" select year(d) from nulls");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{null}}, true);
        resultSet = statement.executeQuery(" select month(d) from nulls");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{null}}, true);
        resultSet = statement.executeQuery(" select day(d) from nulls");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{null}}, true);
        DateTimeTest.assertStatementError("42X25", statement, " select hour(d) from nulls");
        DateTimeTest.assertStatementError("42X25", statement, " select minute(d) from nulls");
        DateTimeTest.assertStatementError("42X25", statement, " select second(d) from nulls");
        resultSet = statement.executeQuery(" select year(ts) from nulls");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{null}}, true);
        resultSet = statement.executeQuery(" select month(ts) from nulls");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{null}}, true);
        resultSet = statement.executeQuery(" select day(ts) from nulls");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{null}}, true);
        resultSet = statement.executeQuery(" select hour(ts) from nulls");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{null}}, true);
        resultSet = statement.executeQuery(" select minute(ts) from nulls");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{null}}, true);
        resultSet = statement.executeQuery(" select second(ts) from nulls");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{null}}, true);
        statement.executeUpdate(" drop table nulls");
        statement.close();
    }

    public void testDerby3856() throws SQLException {
        this.assertSingleValue("values timestamp('2003-03-05-17.05.43.111111')", "2003-03-05 17:05:43.111111");
        this.assertSingleValue("values timestamp(cast('2003-03-05-17.05.43.111111' as varchar(32)))", "2003-03-05 17:05:43.111111");
        this.assertSingleValue("values date('10/07/2008')", "2008-10-07");
        this.assertSingleValue("values date(cast('10/07/2008' as varchar(10)))", "2008-10-07");
        this.assertSingleValue("values time('10.00.00')", "10:00:00");
        this.assertSingleValue("values time(cast('10.00.00' as varchar(10)))", "10:00:00");
    }

    public void testNanosecondResolution() throws SQLException {
        this.assertSingleValue("values timestamp('2010-04-21 12:00:00.123456789')", "2010-04-21 12:00:00.123456789");
    }

    private void assertSingleValue(String string, String string2) throws SQLException {
        JDBC.assertSingleValueResultSet(this.createStatement().executeQuery(string), string2);
    }
}

