/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.SecurityCheck;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.derbyTesting.junit.Utilities;

public class ResultSetMiscTest
extends BaseJDBCTestCase {
    private final Object nogc = SecurityCheck.class;

    public ResultSetMiscTest(String string) {
        super(string);
    }

    public void testResultSetMetaData() throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select i, s, r, d, dt, t, ts, c, v, dc, bi, cbd, vbd, lvbd, cl, bl from t");
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        resultSet = statement.executeQuery("select i, s, r, d, dt, t, ts, c, v, dc, bi, cbd, vbd, lvbd, cl, bl from t");
        resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        ResultSetMiscTest.assertEquals((int)16, (int)n);
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isAutoIncrement(1));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isCaseSensitive(1));
        ResultSetMiscTest.assertTrue((boolean)resultSetMetaData.isSearchable(1));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isCurrency(1));
        ResultSetMiscTest.assertEquals((int)1, (int)resultSetMetaData.isNullable(1));
        ResultSetMiscTest.assertTrue((boolean)resultSetMetaData.isSigned(1));
        ResultSetMiscTest.assertEquals((int)11, (int)resultSetMetaData.getColumnDisplaySize(1));
        ResultSetMiscTest.assertEquals((String)"I", (String)resultSetMetaData.getColumnLabel(1));
        ResultSetMiscTest.assertEquals((String)"I", (String)resultSetMetaData.getColumnName(1));
        ResultSetMiscTest.assertEquals((String)"T", (String)resultSetMetaData.getTableName(1));
        ResultSetMiscTest.assertEquals((String)"APP", (String)resultSetMetaData.getSchemaName(1));
        ResultSetMiscTest.assertEquals((String)"", (String)resultSetMetaData.getCatalogName(1));
        ResultSetMiscTest.assertEquals((int)4, (int)resultSetMetaData.getColumnType(1));
        ResultSetMiscTest.assertEquals((int)10, (int)resultSetMetaData.getPrecision(1));
        ResultSetMiscTest.assertEquals((int)0, (int)resultSetMetaData.getScale(1));
        ResultSetMiscTest.assertEquals((String)"INTEGER", (String)resultSetMetaData.getColumnTypeName(1));
        if (ResultSetMiscTest.usingEmbedded()) {
            ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isReadOnly(1));
        }
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isWritable(1));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isDefinitelyWritable(1));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isAutoIncrement(2));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isCaseSensitive(2));
        ResultSetMiscTest.assertTrue((boolean)resultSetMetaData.isSearchable(2));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isCurrency(2));
        ResultSetMiscTest.assertEquals((int)1, (int)resultSetMetaData.isNullable(2));
        ResultSetMiscTest.assertTrue((boolean)resultSetMetaData.isSigned(2));
        ResultSetMiscTest.assertEquals((int)6, (int)resultSetMetaData.getColumnDisplaySize(2));
        ResultSetMiscTest.assertEquals((String)"S", (String)resultSetMetaData.getColumnLabel(2));
        ResultSetMiscTest.assertEquals((String)"S", (String)resultSetMetaData.getColumnName(2));
        ResultSetMiscTest.assertEquals((String)"T", (String)resultSetMetaData.getTableName(2));
        ResultSetMiscTest.assertEquals((String)"APP", (String)resultSetMetaData.getSchemaName(2));
        ResultSetMiscTest.assertEquals((String)"", (String)resultSetMetaData.getCatalogName(2));
        ResultSetMiscTest.assertEquals((int)5, (int)resultSetMetaData.getColumnType(2));
        ResultSetMiscTest.assertEquals((int)5, (int)resultSetMetaData.getPrecision(2));
        ResultSetMiscTest.assertEquals((int)0, (int)resultSetMetaData.getScale(2));
        ResultSetMiscTest.assertEquals((String)"SMALLINT", (String)resultSetMetaData.getColumnTypeName(2));
        if (ResultSetMiscTest.usingEmbedded()) {
            ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isReadOnly(2));
        }
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isWritable(2));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isDefinitelyWritable(2));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isAutoIncrement(3));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isCaseSensitive(3));
        ResultSetMiscTest.assertTrue((boolean)resultSetMetaData.isSearchable(3));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isCurrency(3));
        ResultSetMiscTest.assertEquals((int)1, (int)resultSetMetaData.isNullable(3));
        ResultSetMiscTest.assertTrue((boolean)resultSetMetaData.isSigned(3));
        ResultSetMiscTest.assertEquals((int)15, (int)resultSetMetaData.getColumnDisplaySize(3));
        ResultSetMiscTest.assertEquals((String)"R", (String)resultSetMetaData.getColumnLabel(3));
        ResultSetMiscTest.assertEquals((String)"R", (String)resultSetMetaData.getColumnName(3));
        ResultSetMiscTest.assertEquals((String)"T", (String)resultSetMetaData.getTableName(3));
        ResultSetMiscTest.assertEquals((String)"APP", (String)resultSetMetaData.getSchemaName(3));
        ResultSetMiscTest.assertEquals((String)"", (String)resultSetMetaData.getCatalogName(3));
        ResultSetMiscTest.assertEquals((int)7, (int)resultSetMetaData.getColumnType(3));
        ResultSetMiscTest.assertEquals((int)7, (int)resultSetMetaData.getPrecision(3));
        ResultSetMiscTest.assertEquals((int)0, (int)resultSetMetaData.getScale(3));
        ResultSetMiscTest.assertEquals((String)"REAL", (String)resultSetMetaData.getColumnTypeName(3));
        if (ResultSetMiscTest.usingEmbedded()) {
            ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isReadOnly(3));
        }
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isWritable(3));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isDefinitelyWritable(3));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isAutoIncrement(4));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isCaseSensitive(4));
        ResultSetMiscTest.assertTrue((boolean)resultSetMetaData.isSearchable(4));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isCurrency(4));
        ResultSetMiscTest.assertEquals((int)1, (int)resultSetMetaData.isNullable(4));
        ResultSetMiscTest.assertTrue((boolean)resultSetMetaData.isSigned(4));
        ResultSetMiscTest.assertEquals((int)24, (int)resultSetMetaData.getColumnDisplaySize(4));
        ResultSetMiscTest.assertEquals((String)"D", (String)resultSetMetaData.getColumnLabel(4));
        ResultSetMiscTest.assertEquals((String)"D", (String)resultSetMetaData.getColumnName(4));
        ResultSetMiscTest.assertEquals((String)"T", (String)resultSetMetaData.getTableName(4));
        ResultSetMiscTest.assertEquals((String)"APP", (String)resultSetMetaData.getSchemaName(4));
        ResultSetMiscTest.assertEquals((String)"", (String)resultSetMetaData.getCatalogName(4));
        ResultSetMiscTest.assertEquals((int)8, (int)resultSetMetaData.getColumnType(4));
        ResultSetMiscTest.assertEquals((int)15, (int)resultSetMetaData.getPrecision(4));
        ResultSetMiscTest.assertEquals((int)0, (int)resultSetMetaData.getScale(4));
        ResultSetMiscTest.assertEquals((String)"DOUBLE", (String)resultSetMetaData.getColumnTypeName(4));
        if (ResultSetMiscTest.usingEmbedded()) {
            ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isReadOnly(4));
        }
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isWritable(4));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isDefinitelyWritable(4));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isAutoIncrement(5));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isCaseSensitive(5));
        ResultSetMiscTest.assertTrue((boolean)resultSetMetaData.isSearchable(5));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isCurrency(5));
        ResultSetMiscTest.assertEquals((int)1, (int)resultSetMetaData.isNullable(5));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isSigned(5));
        ResultSetMiscTest.assertEquals((int)10, (int)resultSetMetaData.getColumnDisplaySize(5));
        ResultSetMiscTest.assertEquals((String)"DT", (String)resultSetMetaData.getColumnLabel(5));
        ResultSetMiscTest.assertEquals((String)"DT", (String)resultSetMetaData.getColumnName(5));
        ResultSetMiscTest.assertEquals((String)"T", (String)resultSetMetaData.getTableName(5));
        ResultSetMiscTest.assertEquals((String)"APP", (String)resultSetMetaData.getSchemaName(5));
        ResultSetMiscTest.assertEquals((String)"", (String)resultSetMetaData.getCatalogName(5));
        ResultSetMiscTest.assertEquals((int)91, (int)resultSetMetaData.getColumnType(5));
        ResultSetMiscTest.assertEquals((int)10, (int)resultSetMetaData.getPrecision(5));
        ResultSetMiscTest.assertEquals((int)0, (int)resultSetMetaData.getScale(5));
        ResultSetMiscTest.assertEquals((String)"DATE", (String)resultSetMetaData.getColumnTypeName(5));
        if (ResultSetMiscTest.usingEmbedded()) {
            ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isReadOnly(1));
        }
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isWritable(1));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isDefinitelyWritable(1));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isAutoIncrement(7));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isCaseSensitive(7));
        ResultSetMiscTest.assertTrue((boolean)resultSetMetaData.isSearchable(7));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isCurrency(7));
        ResultSetMiscTest.assertEquals((int)1, (int)resultSetMetaData.isNullable(7));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isSigned(7));
        ResultSetMiscTest.assertEquals((int)29, (int)resultSetMetaData.getColumnDisplaySize(7));
        ResultSetMiscTest.assertEquals((String)"TS", (String)resultSetMetaData.getColumnLabel(7));
        ResultSetMiscTest.assertEquals((String)"TS", (String)resultSetMetaData.getColumnName(7));
        ResultSetMiscTest.assertEquals((String)"T", (String)resultSetMetaData.getTableName(7));
        ResultSetMiscTest.assertEquals((String)"APP", (String)resultSetMetaData.getSchemaName(7));
        ResultSetMiscTest.assertEquals((String)"", (String)resultSetMetaData.getCatalogName(7));
        ResultSetMiscTest.assertEquals((int)93, (int)resultSetMetaData.getColumnType(7));
        ResultSetMiscTest.assertEquals((int)29, (int)resultSetMetaData.getPrecision(7));
        ResultSetMiscTest.assertEquals((int)9, (int)resultSetMetaData.getScale(7));
        ResultSetMiscTest.assertEquals((String)"TIMESTAMP", (String)resultSetMetaData.getColumnTypeName(7));
        if (ResultSetMiscTest.usingEmbedded()) {
            ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isReadOnly(7));
        }
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isWritable(7));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isDefinitelyWritable(7));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isAutoIncrement(8));
        ResultSetMiscTest.assertTrue((boolean)resultSetMetaData.isCaseSensitive(8));
        ResultSetMiscTest.assertTrue((boolean)resultSetMetaData.isSearchable(8));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isCurrency(8));
        ResultSetMiscTest.assertEquals((int)1, (int)resultSetMetaData.isNullable(8));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isSigned(8));
        ResultSetMiscTest.assertEquals((int)10, (int)resultSetMetaData.getColumnDisplaySize(8));
        ResultSetMiscTest.assertEquals((String)"C", (String)resultSetMetaData.getColumnLabel(8));
        ResultSetMiscTest.assertEquals((String)"C", (String)resultSetMetaData.getColumnName(8));
        ResultSetMiscTest.assertEquals((String)"T", (String)resultSetMetaData.getTableName(8));
        ResultSetMiscTest.assertEquals((String)"APP", (String)resultSetMetaData.getSchemaName(8));
        ResultSetMiscTest.assertEquals((String)"", (String)resultSetMetaData.getCatalogName(8));
        ResultSetMiscTest.assertEquals((int)1, (int)resultSetMetaData.getColumnType(8));
        ResultSetMiscTest.assertEquals((int)10, (int)resultSetMetaData.getPrecision(8));
        ResultSetMiscTest.assertEquals((int)0, (int)resultSetMetaData.getScale(8));
        ResultSetMiscTest.assertEquals((String)"CHAR", (String)resultSetMetaData.getColumnTypeName(8));
        if (ResultSetMiscTest.usingEmbedded()) {
            ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isReadOnly(8));
        }
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isWritable(8));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isDefinitelyWritable(8));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isAutoIncrement(9));
        ResultSetMiscTest.assertTrue((boolean)resultSetMetaData.isCaseSensitive(9));
        ResultSetMiscTest.assertTrue((boolean)resultSetMetaData.isSearchable(9));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isCurrency(9));
        ResultSetMiscTest.assertEquals((int)0, (int)resultSetMetaData.isNullable(9));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isSigned(9));
        ResultSetMiscTest.assertEquals((int)40, (int)resultSetMetaData.getColumnDisplaySize(9));
        ResultSetMiscTest.assertEquals((String)"V", (String)resultSetMetaData.getColumnLabel(9));
        ResultSetMiscTest.assertEquals((String)"V", (String)resultSetMetaData.getColumnName(9));
        ResultSetMiscTest.assertEquals((String)"T", (String)resultSetMetaData.getTableName(9));
        ResultSetMiscTest.assertEquals((String)"APP", (String)resultSetMetaData.getSchemaName(9));
        ResultSetMiscTest.assertEquals((String)"", (String)resultSetMetaData.getCatalogName(9));
        ResultSetMiscTest.assertEquals((int)12, (int)resultSetMetaData.getColumnType(9));
        ResultSetMiscTest.assertEquals((int)40, (int)resultSetMetaData.getPrecision(9));
        ResultSetMiscTest.assertEquals((int)0, (int)resultSetMetaData.getScale(9));
        ResultSetMiscTest.assertEquals((String)"VARCHAR", (String)resultSetMetaData.getColumnTypeName(9));
        if (ResultSetMiscTest.usingEmbedded()) {
            ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isReadOnly(9));
        }
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isWritable(9));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isDefinitelyWritable(9));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isAutoIncrement(10));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isCaseSensitive(10));
        ResultSetMiscTest.assertTrue((boolean)resultSetMetaData.isSearchable(10));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isCurrency(10));
        ResultSetMiscTest.assertEquals((int)1, (int)resultSetMetaData.isNullable(10));
        ResultSetMiscTest.assertTrue((boolean)resultSetMetaData.isSigned(10));
        ResultSetMiscTest.assertEquals((int)12, (int)resultSetMetaData.getColumnDisplaySize(10));
        ResultSetMiscTest.assertEquals((String)"DC", (String)resultSetMetaData.getColumnLabel(10));
        ResultSetMiscTest.assertEquals((String)"DC", (String)resultSetMetaData.getColumnName(10));
        ResultSetMiscTest.assertEquals((String)"T", (String)resultSetMetaData.getTableName(10));
        ResultSetMiscTest.assertEquals((String)"APP", (String)resultSetMetaData.getSchemaName(10));
        ResultSetMiscTest.assertEquals((String)"", (String)resultSetMetaData.getCatalogName(10));
        ResultSetMiscTest.assertEquals((int)3, (int)resultSetMetaData.getColumnType(10));
        ResultSetMiscTest.assertEquals((int)10, (int)resultSetMetaData.getPrecision(10));
        ResultSetMiscTest.assertEquals((int)2, (int)resultSetMetaData.getScale(10));
        ResultSetMiscTest.assertEquals((String)"DECIMAL", (String)resultSetMetaData.getColumnTypeName(10));
        if (ResultSetMiscTest.usingEmbedded()) {
            ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isReadOnly(10));
        }
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isWritable(10));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isDefinitelyWritable(10));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isAutoIncrement(11));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isCaseSensitive(11));
        ResultSetMiscTest.assertTrue((boolean)resultSetMetaData.isSearchable(11));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isCurrency(11));
        ResultSetMiscTest.assertEquals((int)1, (int)resultSetMetaData.isNullable(11));
        ResultSetMiscTest.assertTrue((boolean)resultSetMetaData.isSigned(11));
        ResultSetMiscTest.assertEquals((int)20, (int)resultSetMetaData.getColumnDisplaySize(11));
        ResultSetMiscTest.assertEquals((String)"BI", (String)resultSetMetaData.getColumnLabel(11));
        ResultSetMiscTest.assertEquals((String)"BI", (String)resultSetMetaData.getColumnName(11));
        ResultSetMiscTest.assertEquals((String)"T", (String)resultSetMetaData.getTableName(11));
        ResultSetMiscTest.assertEquals((String)"APP", (String)resultSetMetaData.getSchemaName(11));
        ResultSetMiscTest.assertEquals((String)"", (String)resultSetMetaData.getCatalogName(11));
        ResultSetMiscTest.assertEquals((int)-5, (int)resultSetMetaData.getColumnType(11));
        ResultSetMiscTest.assertEquals((int)19, (int)resultSetMetaData.getPrecision(11));
        ResultSetMiscTest.assertEquals((int)0, (int)resultSetMetaData.getScale(11));
        ResultSetMiscTest.assertEquals((String)"BIGINT", (String)resultSetMetaData.getColumnTypeName(11));
        if (ResultSetMiscTest.usingEmbedded()) {
            ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isReadOnly(11));
        }
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isWritable(11));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isDefinitelyWritable(11));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isAutoIncrement(12));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isCaseSensitive(12));
        ResultSetMiscTest.assertTrue((boolean)resultSetMetaData.isSearchable(12));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isCurrency(12));
        ResultSetMiscTest.assertEquals((int)1, (int)resultSetMetaData.isNullable(12));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isSigned(12));
        ResultSetMiscTest.assertEquals((int)20, (int)resultSetMetaData.getColumnDisplaySize(12));
        ResultSetMiscTest.assertEquals((String)"CBD", (String)resultSetMetaData.getColumnLabel(12));
        ResultSetMiscTest.assertEquals((String)"CBD", (String)resultSetMetaData.getColumnName(12));
        ResultSetMiscTest.assertEquals((String)"T", (String)resultSetMetaData.getTableName(12));
        ResultSetMiscTest.assertEquals((String)"APP", (String)resultSetMetaData.getSchemaName(12));
        ResultSetMiscTest.assertEquals((String)"", (String)resultSetMetaData.getCatalogName(12));
        ResultSetMiscTest.assertEquals((int)-2, (int)resultSetMetaData.getColumnType(12));
        ResultSetMiscTest.assertEquals((int)10, (int)resultSetMetaData.getPrecision(12));
        ResultSetMiscTest.assertEquals((int)0, (int)resultSetMetaData.getScale(12));
        if (ResultSetMiscTest.usingEmbedded()) {
            ResultSetMiscTest.assertEquals((String)"CHAR () FOR BIT DATA", (String)resultSetMetaData.getColumnTypeName(12));
        } else {
            ResultSetMiscTest.assertEquals((String)"CHAR FOR BIT DATA", (String)resultSetMetaData.getColumnTypeName(12));
        }
        if (ResultSetMiscTest.usingEmbedded()) {
            ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isReadOnly(12));
        }
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isWritable(12));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isDefinitelyWritable(12));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isAutoIncrement(13));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isCaseSensitive(13));
        ResultSetMiscTest.assertTrue((boolean)resultSetMetaData.isSearchable(13));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isCurrency(13));
        ResultSetMiscTest.assertEquals((int)1, (int)resultSetMetaData.isNullable(13));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isSigned(13));
        ResultSetMiscTest.assertEquals((int)20, (int)resultSetMetaData.getColumnDisplaySize(13));
        ResultSetMiscTest.assertEquals((String)"VBD", (String)resultSetMetaData.getColumnLabel(13));
        ResultSetMiscTest.assertEquals((String)"VBD", (String)resultSetMetaData.getColumnName(13));
        ResultSetMiscTest.assertEquals((String)"T", (String)resultSetMetaData.getTableName(13));
        ResultSetMiscTest.assertEquals((String)"APP", (String)resultSetMetaData.getSchemaName(13));
        ResultSetMiscTest.assertEquals((String)"", (String)resultSetMetaData.getCatalogName(13));
        ResultSetMiscTest.assertEquals((int)-3, (int)resultSetMetaData.getColumnType(13));
        ResultSetMiscTest.assertEquals((int)10, (int)resultSetMetaData.getPrecision(13));
        ResultSetMiscTest.assertEquals((int)0, (int)resultSetMetaData.getScale(13));
        if (ResultSetMiscTest.usingEmbedded()) {
            ResultSetMiscTest.assertEquals((String)"VARCHAR () FOR BIT DATA", (String)resultSetMetaData.getColumnTypeName(13));
        } else {
            ResultSetMiscTest.assertEquals((String)"VARCHAR FOR BIT DATA", (String)resultSetMetaData.getColumnTypeName(13));
        }
        if (ResultSetMiscTest.usingEmbedded()) {
            ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isReadOnly(13));
        }
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isWritable(13));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isDefinitelyWritable(13));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isAutoIncrement(14));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isCaseSensitive(14));
        ResultSetMiscTest.assertTrue((boolean)resultSetMetaData.isSearchable(14));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isCurrency(14));
        ResultSetMiscTest.assertEquals((int)1, (int)resultSetMetaData.isNullable(14));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isSigned(14));
        ResultSetMiscTest.assertEquals((int)65400, (int)resultSetMetaData.getColumnDisplaySize(14));
        ResultSetMiscTest.assertEquals((String)"LVBD", (String)resultSetMetaData.getColumnLabel(14));
        ResultSetMiscTest.assertEquals((String)"LVBD", (String)resultSetMetaData.getColumnName(14));
        ResultSetMiscTest.assertEquals((String)"T", (String)resultSetMetaData.getTableName(14));
        ResultSetMiscTest.assertEquals((String)"APP", (String)resultSetMetaData.getSchemaName(14));
        ResultSetMiscTest.assertEquals((String)"", (String)resultSetMetaData.getCatalogName(14));
        ResultSetMiscTest.assertEquals((int)-4, (int)resultSetMetaData.getColumnType(14));
        ResultSetMiscTest.assertEquals((int)32700, (int)resultSetMetaData.getPrecision(14));
        ResultSetMiscTest.assertEquals((int)0, (int)resultSetMetaData.getScale(14));
        ResultSetMiscTest.assertEquals((String)"LONG VARCHAR FOR BIT DATA", (String)resultSetMetaData.getColumnTypeName(14));
        if (ResultSetMiscTest.usingEmbedded()) {
            ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isReadOnly(14));
        }
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isWritable(14));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isDefinitelyWritable(14));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isAutoIncrement(15));
        ResultSetMiscTest.assertTrue((boolean)resultSetMetaData.isCaseSensitive(15));
        ResultSetMiscTest.assertTrue((boolean)resultSetMetaData.isSearchable(15));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isCurrency(15));
        ResultSetMiscTest.assertEquals((int)1, (int)resultSetMetaData.isNullable(15));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isSigned(15));
        ResultSetMiscTest.assertEquals((int)Integer.MAX_VALUE, (int)resultSetMetaData.getColumnDisplaySize(15));
        ResultSetMiscTest.assertEquals((String)"CL", (String)resultSetMetaData.getColumnLabel(15));
        ResultSetMiscTest.assertEquals((String)"CL", (String)resultSetMetaData.getColumnName(15));
        ResultSetMiscTest.assertEquals((String)"T", (String)resultSetMetaData.getTableName(15));
        ResultSetMiscTest.assertEquals((String)"APP", (String)resultSetMetaData.getSchemaName(15));
        ResultSetMiscTest.assertEquals((String)"", (String)resultSetMetaData.getCatalogName(15));
        ResultSetMiscTest.assertEquals((int)2005, (int)resultSetMetaData.getColumnType(15));
        ResultSetMiscTest.assertEquals((int)Integer.MAX_VALUE, (int)resultSetMetaData.getPrecision(15));
        ResultSetMiscTest.assertEquals((int)0, (int)resultSetMetaData.getScale(15));
        ResultSetMiscTest.assertEquals((String)"CLOB", (String)resultSetMetaData.getColumnTypeName(15));
        if (ResultSetMiscTest.usingEmbedded()) {
            ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isReadOnly(15));
        }
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isWritable(15));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isDefinitelyWritable(15));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isAutoIncrement(16));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isCaseSensitive(16));
        ResultSetMiscTest.assertTrue((boolean)resultSetMetaData.isSearchable(16));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isCurrency(16));
        ResultSetMiscTest.assertEquals((int)1, (int)resultSetMetaData.isNullable(16));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isSigned(16));
        ResultSetMiscTest.assertEquals((int)Integer.MAX_VALUE, (int)resultSetMetaData.getColumnDisplaySize(16));
        ResultSetMiscTest.assertEquals((String)"BL", (String)resultSetMetaData.getColumnLabel(16));
        ResultSetMiscTest.assertEquals((String)"BL", (String)resultSetMetaData.getColumnName(16));
        ResultSetMiscTest.assertEquals((String)"T", (String)resultSetMetaData.getTableName(16));
        ResultSetMiscTest.assertEquals((String)"APP", (String)resultSetMetaData.getSchemaName(16));
        ResultSetMiscTest.assertEquals((String)"", (String)resultSetMetaData.getCatalogName(16));
        ResultSetMiscTest.assertEquals((int)2004, (int)resultSetMetaData.getColumnType(16));
        ResultSetMiscTest.assertEquals((int)0x40000000, (int)resultSetMetaData.getPrecision(16));
        ResultSetMiscTest.assertEquals((int)0, (int)resultSetMetaData.getScale(16));
        ResultSetMiscTest.assertEquals((String)"BLOB", (String)resultSetMetaData.getColumnTypeName(16));
        if (ResultSetMiscTest.usingEmbedded()) {
            ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isReadOnly(16));
        }
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isWritable(16));
        ResultSetMiscTest.assertFalse((boolean)resultSetMetaData.isDefinitelyWritable(16));
    }

    public void testBug4810() throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table bug4810(i int, b int)");
        statement.executeUpdate("insert into bug4810 values (1,1), (1,2), (1,3), (1,4)");
        statement.executeUpdate("insert into bug4810 values (1,1), (1,2), (1,3), (1,4)");
        connection.commit();
        connection.setAutoCommit(true);
        connection.setTransactionIsolation(4);
        this.checkLocksForAutoCommitSelect(connection, statement, 0);
        this.checkLocksForAutoCommitSelect(connection, statement, 1);
        this.checkLocksForAutoCommitSelect(connection, statement, 2);
        statement.execute("drop table bug4810");
        connection.commit();
        statement.close();
    }

    public void testDerby853() throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table derby853(d1 decimal(10,2), d2 double)");
        ResultSet resultSet = statement.executeQuery("select d1 - d2 from derby853");
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        ResultSetMiscTest.assertEquals((int)0, (int)resultSetMetaData.getScale(1));
        ResultSetMiscTest.assertEquals((int)15, (int)resultSetMetaData.getPrecision(1));
        resultSet = statement.executeQuery("select d2 - d1 from derby853");
        resultSetMetaData = resultSet.getMetaData();
        ResultSetMiscTest.assertEquals((int)0, (int)resultSetMetaData.getScale(1));
        ResultSetMiscTest.assertEquals((int)15, (int)resultSetMetaData.getPrecision(1));
        statement.execute("drop table derby853");
        statement.close();
    }

    public void testAutoCommit() throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table AutoCommitTable (num int)");
        statement.executeUpdate("insert into AutoCommitTable values (1)");
        statement.executeUpdate("insert into AutoCommitTable values (2)");
        int n = connection.getTransactionIsolation();
        connection.setTransactionIsolation(8);
        this.checkSingleRSAutoCommit(connection);
        this.checkSingleRSCloseCursorsAtCommit(connection);
        connection.setTransactionIsolation(n);
        statement.executeUpdate("drop table AutoCommitTable");
        statement.close();
    }

    public void testCorrelationNamesAndMetaDataCalls() throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table s (a int, b int, c int, d int, e int, f int)");
        statement.executeUpdate("insert into s values (0,1,2,3,4,5)");
        statement.executeUpdate("insert into s values (10,11,12,13,14,15)");
        ResultSet resultSet = statement.executeQuery("select * from s ss (f, e, d, c, b, a) where f = 0");
        resultSet.next();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        ResultSetMiscTest.assertEquals((String)"S", (String)resultSetMetaData.getTableName(1));
        ResultSetMiscTest.assertEquals((String)"APP", (String)resultSetMetaData.getSchemaName(1));
        resultSet = statement.executeQuery("select * from (select * from s) a");
        resultSet.next();
        resultSetMetaData = resultSet.getMetaData();
        ResultSetMiscTest.assertEquals((String)"S", (String)resultSetMetaData.getTableName(1));
        ResultSetMiscTest.assertEquals((String)"APP", (String)resultSetMetaData.getSchemaName(1));
        statement.executeUpdate("create schema s1");
        statement.executeUpdate("create table s1.t1 (c11 int, c12 int)");
        statement.executeUpdate("insert into s1.t1 values (11, 12), (21, 22)");
        resultSet = statement.executeQuery("select * from s1.t1 as abc");
        resultSetMetaData = resultSet.getMetaData();
        ResultSetMiscTest.assertEquals((String)"T1", (String)resultSetMetaData.getTableName(1));
        ResultSetMiscTest.assertEquals((String)"S1", (String)resultSetMetaData.getSchemaName(1));
        ResultSetMiscTest.assertEquals((String)"T1", (String)resultSetMetaData.getTableName(2));
        ResultSetMiscTest.assertEquals((String)"S1", (String)resultSetMetaData.getSchemaName(2));
        resultSet = statement.executeQuery("select abc.c11 from s1.t1 as abc");
        resultSetMetaData = resultSet.getMetaData();
        ResultSetMiscTest.assertEquals((String)"T1", (String)resultSetMetaData.getTableName(1));
        ResultSetMiscTest.assertEquals((String)"S1", (String)resultSetMetaData.getSchemaName(1));
        resultSet = statement.executeQuery("select bcd.a, abc.c11 from s1.t1 as abc, s as bcd");
        resultSetMetaData = resultSet.getMetaData();
        ResultSetMiscTest.assertEquals((String)"S", (String)resultSetMetaData.getTableName(1));
        ResultSetMiscTest.assertEquals((String)"APP", (String)resultSetMetaData.getSchemaName(1));
        ResultSetMiscTest.assertEquals((String)"T1", (String)resultSetMetaData.getTableName(2));
        ResultSetMiscTest.assertEquals((String)"S1", (String)resultSetMetaData.getSchemaName(2));
        statement.executeUpdate("create schema app1");
        statement.executeUpdate("create table app1.t1 (c11 int, c12 int)");
        statement.executeUpdate("insert into app1.t1 values (11, 12), (21, 22)");
        statement.executeUpdate("create schema app2");
        statement.executeUpdate("create table app2.t1 (c11 int, c12 int)");
        statement.executeUpdate("insert into app2.t1 values (11, 12), (21, 22)");
        resultSet = statement.executeQuery("select app1.t1.c11, app2.t1.c11 from app1.t1, app2.t1");
        resultSetMetaData = resultSet.getMetaData();
        ResultSetMiscTest.assertEquals((String)"T1", (String)resultSetMetaData.getTableName(1));
        ResultSetMiscTest.assertEquals((String)"APP1", (String)resultSetMetaData.getSchemaName(1));
        ResultSetMiscTest.assertEquals((String)"T1", (String)resultSetMetaData.getTableName(2));
        ResultSetMiscTest.assertEquals((String)"APP2", (String)resultSetMetaData.getSchemaName(2));
        statement.execute("drop table s");
        statement.execute("drop table s1.t1");
        statement.execute("drop schema s1 restrict");
        statement.execute("drop table app1.t1");
        statement.execute("drop table app2.t1");
        statement.execute("drop schema app2 restrict");
        statement.execute("drop schema app1 restrict");
    }

    public void testFloatMAX_VALUE(Connection connection) throws SQLException {
        Statement statement = this.createStatement();
        try {
            statement.execute("drop table jira1136");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        statement.execute("create table jira1136 (f float)");
        statement.execute("insert into jira1136 values (3.4028235E38)");
        PreparedStatement preparedStatement = connection.prepareStatement("select * from jira1136");
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            ResultSetMiscTest.assertEquals((double)3.4028235E38, (double)resultSet.getFloat(1), (double)1.0E-5);
        }
    }

    private void checkSingleRSAutoCommit(Connection connection) throws SQLException {
        connection.setHoldability(1);
        Statement statement = connection.createStatement(1003, 1007);
        ResultSet resultSet = statement.executeQuery("select * from AutoCommitTable");
        while (resultSet.next()) {
        }
        ResultSetMiscTest.assertFalse((String)"Fail Auto-commit unsuccessful", (boolean)this.locksHeld());
        ResultSetMiscTest.assertFalse((String)"Final call of rs.next() should return false", (boolean)resultSet.next());
        resultSet.close();
        try {
            resultSet.next();
            ResultSetMiscTest.fail((String)"FAIL Error should have occured with rs.next() on a closed ResultSet");
        }
        catch (SQLException sQLException) {
            ResultSetMiscTest.assertEquals((String)"XCL16", (String)sQLException.getSQLState());
            ResultSetMiscTest.assertTrue((sQLException.getMessage().indexOf("next") > 0 ? 1 : 0) != 0);
        }
    }

    private void checkSingleRSCloseCursorsAtCommit(Connection connection) throws SQLException {
        connection.setHoldability(2);
        connection.setTransactionIsolation(8);
        Statement statement = connection.createStatement(1003, 1007);
        ResultSet resultSet = statement.executeQuery("select * from AutoCommitTable");
        while (resultSet.next()) {
        }
        ResultSetMiscTest.assertFalse((String)"Fail Auto-commit unsuccessful", (boolean)this.locksHeld());
        try {
            resultSet.next();
            ResultSetMiscTest.fail((String)"FAIL. ResultSet not closed implicitly");
        }
        catch (SQLException sQLException) {
            ResultSetMiscTest.assertEquals((String)"XCL16", (String)sQLException.getSQLState());
        }
    }

    private void checkLocksForAutoCommitSelect(Connection connection, Statement statement, int n) throws SQLException {
        ResultSet resultSet = statement.executeQuery("select i,b from bug4810");
        resultSet.next();
        ResultSetMiscTest.assertEquals((int)1, (int)resultSet.getInt(1));
        ResultSetMiscTest.assertEquals((int)1, (int)resultSet.getInt(2));
        resultSet.next();
        ResultSetMiscTest.assertEquals((int)1, (int)resultSet.getInt(1));
        ResultSetMiscTest.assertEquals((int)2, (int)resultSet.getInt(2));
        if (n == 1) {
            connection.commit();
            ResultSetMiscTest.assertFalse((String)"Should not hold locks after commit", (boolean)this.locksHeld());
        } else if (n == 2) {
            connection.rollback();
            ResultSetMiscTest.assertFalse((String)"Should not hold locks after rollback", (boolean)this.locksHeld());
        } else if (n == 0) {
            ResultSetMiscTest.assertTrue((String)"Locks should be held with autocommit only", (boolean)this.locksHeld());
            try {
                resultSet.next();
                ResultSetMiscTest.assertEquals((int)1, (int)resultSet.getInt(1));
                ResultSetMiscTest.assertEquals((int)3, (int)resultSet.getInt(2));
            }
            catch (SQLException sQLException) {
                ResultSetMiscTest.fail((String)("Unexpected exception" + sQLException.getSQLState() + ":" + sQLException.getMessage()));
            }
        }
        resultSet.close();
    }

    private boolean locksHeld() throws SQLException {
        Connection connection = this.openDefaultConnection();
        Statement statement = connection.createStatement();
        statement.execute("CALL WAIT_FOR_POST_COMMIT()");
        ResultSet resultSet = statement.executeQuery("SELECT 1 FROM SYSCS_DIAG.LOCK_TABLE");
        boolean bl = resultSet.next();
        resultSet.close();
        statement.close();
        connection.close();
        return bl;
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("ResultSetTest2");
        baseTestSuite.addTest(ResultSetMiscTest.baseSuite("ResultSetTest2:embedded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(ResultSetMiscTest.baseSuite("ResultSetTest2:client")));
        return baseTestSuite;
    }

    public static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        baseTestSuite.addTestSuite(ResultSetMiscTest.class);
        Test test = DatabasePropertyTestSetup.setLockTimeouts((Test)baseTestSuite, 1, 3);
        return new CleanDatabaseTestSetup(test){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.execute("create table t (i int, s smallint, r real, d double precision, dt date, t time, ts timestamp, c char(10), v varchar(40) not null, dc dec(10,2),bi bigint, cbd char(10) for bit data,vbd varchar(10) for bit data,lvbd long varchar for bit data,cl clob(2G), bl blob(1G) )");
                statement.execute("insert into t values(1,2,3.3,4.4,date('1990-05-05'),time('12:06:06'),timestamp('1990-07-07 07:07:07.000007'),'eight','nine', 10.1, 11," + Utilities.stringToHexLiteral("twelv") + "," + Utilities.stringToHexLiteral("3teen") + "," + Utilities.stringToHexLiteral("4teen") + ", null, null)");
                statement.execute("CREATE PROCEDURE WAIT_FOR_POST_COMMIT() LANGUAGE JAVA EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.T_Access.waitForPostCommitToFinish' PARAMETER STYLE JAVA");
            }
        };
    }
}

