/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.store;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.Storable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.ScanInfo;
import org.apache.derby.iapi.store.access.SortCostController;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.StoreCostController;
import org.apache.derby.iapi.store.access.StoreCostResult;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.i18n.MessageService;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.harness.T_Generic;
import org.apache.derbyTesting.unitTests.store.T_AccessRow;
import org.apache.derbyTesting.unitTests.store.T_StoreCostResult;
import org.apache.derbyTesting.unitTests.store.T_Util;

public class T_AccessFactory
extends T_Generic {
    private static final String testService = "accessTest";
    AccessFactory store = null;

    @Override
    public String getModuleToTestProtocolName() {
        return "org.apache.derby.iapi.store.access.AccessFactory";
    }

    @Override
    protected void runTests() throws T_Fail {
        TransactionController transactionController = null;
        boolean bl = false;
        if (this.startParams == null) {
            this.startParams = new Properties();
        }
        this.startParams.put("derby.database.noAutoBoot", Boolean.TRUE.toString());
        this.startParams.put("derby.__deleteOnCreate", Boolean.TRUE.toString());
        this.startParams = T_Util.setEncryptionParam(this.startParams);
        try {
            this.store = (AccessFactory)T_AccessFactory.createPersistentService(this.getModuleToTestProtocolName(), testService, this.startParams);
        }
        catch (StandardException standardException) {
            throw T_Fail.exceptionFail(standardException);
        }
        if (this.store == null) {
            throw T_Fail.testFailMsg(this.getModuleToTestProtocolName() + " service not started.");
        }
        this.REPORT("(unitTestMain) Testing accessTest");
        try {
            ContextManager contextManager = T_AccessFactory.getContextService().getCurrentContextManager();
            transactionController = this.store.getAndNameTransaction(contextManager, "UserTransaction");
            if (this.dropTest(transactionController) && this.holdCursor(transactionController) && this.readUncommitted(transactionController) && this.updatelocks(transactionController) && this.nestedUserTransaction(transactionController) && this.positionAtRowLocation(transactionController) && this.sortCost(transactionController) && this.storeCost(transactionController) && this.partialScan(transactionController) && this.scanInfo(transactionController) && this.insertAndUpdateExample(transactionController) && this.insertAndFetchExample(transactionController) && this.scanExample(transactionController) && this.alterTable(transactionController, false) && this.alterTable(transactionController, true) && this.tempTest(transactionController) && this.getTableProperties(transactionController) && this.insert_bench(transactionController) && this.transactionalProperties(transactionController) && this.commitTest(transactionController)) {
                bl = true;
            }
            transactionController.commitNoSync(1);
            transactionController.destroy();
            if (!bl) {
                throw T_Fail.testFailMsg("test failed");
            }
        }
        catch (StandardException standardException) {
            String string = standardException.getMessage();
            if (string == null) {
                string = ((Object)((Object)standardException)).getClass().getName();
            }
            this.REPORT(string);
            standardException.printStackTrace();
            throw T_Fail.exceptionFail(standardException);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void flush_cache() throws StandardException {
        RawStoreFactory rawStoreFactory = (RawStoreFactory)T_AccessFactory.findServiceModule(this.store, "org.apache.derby.iapi.store.raw.RawStoreFactory");
        rawStoreFactory.checkpoint();
    }

    protected boolean insertAndFetchExample(TransactionController transactionController) throws StandardException, T_Fail {
        this.REPORT("(insertAndFetchExample)");
        try {
            long l = transactionController.createConglomerate("heap", null, null, null, null, 0);
            throw T_Fail.testFailMsg("Allowed heap create without template.");
        }
        catch (Throwable throwable) {
            T_AccessRow t_AccessRow = new T_AccessRow(1);
            long l = transactionController.createConglomerate("heap", t_AccessRow.getRowArray(), null, null, null, 0);
            return this.insertAndFetch(transactionController, l, 33) && this.insertAndFetch(transactionController, l, -1) && this.insertAndFetch(transactionController, l, -1000000000);
        }
    }

    protected boolean insertAndFetch(TransactionController transactionController, long l, int n) throws StandardException, T_Fail {
        StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo = transactionController.getStaticCompiledConglomInfo(l);
        DynamicCompiledOpenConglomInfo dynamicCompiledOpenConglomInfo = transactionController.getDynamicCompiledConglomInfo(l);
        String string = transactionController.getTransactionIdString();
        this.REPORT("(insertAndFetch) xact id = " + string);
        ConglomerateController conglomerateController = transactionController.openCompiledConglomerate(false, 4, 6, 5, staticCompiledOpenConglomInfo, dynamicCompiledOpenConglomInfo);
        T_AccessRow t_AccessRow = new T_AccessRow(1);
        SQLInteger sQLInteger = new SQLInteger(n);
        t_AccessRow.setCol(0, (DataValueDescriptor)sQLInteger);
        RowLocation rowLocation = conglomerateController.newRowLocationTemplate();
        conglomerateController.insertAndFetchLocation(t_AccessRow.getRowArray(), rowLocation);
        Hashtable<RowLocation, RowLocation> hashtable = new Hashtable<RowLocation, RowLocation>();
        hashtable.put(rowLocation, rowLocation);
        RowLocation rowLocation2 = (RowLocation)hashtable.get(rowLocation);
        if (!rowLocation2.equals(rowLocation)) {
            throw T_Fail.testFailMsg("(insertAndFetch) bad hash lookup 1");
        }
        rowLocation2 = (RowLocation)hashtable.remove(rowLocation);
        if (!rowLocation2.equals(rowLocation)) {
            throw T_Fail.testFailMsg("(insertAndFetch) bad hash lookup 2");
        }
        rowLocation2 = (RowLocation)hashtable.remove(rowLocation);
        if (rowLocation2 != null) {
            throw T_Fail.testFailMsg("(insertAndFetch) bad hash lookup 3");
        }
        T_AccessRow t_AccessRow2 = new T_AccessRow(1);
        SQLInteger sQLInteger2 = new SQLInteger(0);
        t_AccessRow2.setCol(0, (DataValueDescriptor)sQLInteger2);
        if (!conglomerateController.fetch(rowLocation, t_AccessRow2.getRowArray(), (FormatableBitSet)null)) {
            throw T_Fail.testFailMsg("(insertAndFetch) fetch found no row.");
        }
        SQLInteger sQLInteger3 = new SQLInteger(0);
        FormatableBitSet formatableBitSet = new FormatableBitSet(1);
        formatableBitSet.set(0);
        DataValueDescriptor[] dataValueDescriptorArray = new DataValueDescriptor[]{sQLInteger3};
        if (!conglomerateController.fetch(rowLocation, dataValueDescriptorArray, formatableBitSet)) {
            throw T_Fail.testFailMsg("(insertAndFetch) fetch found no row.");
        }
        conglomerateController.close();
        if (sQLInteger2.getInt() != n) {
            throw T_Fail.testFailMsg("(insertAndFetch) Fetched value != inserted value.");
        }
        if (sQLInteger3.getInt() != n) {
            throw T_Fail.testFailMsg("(insertAndFetch) Fetched value != inserted value.");
        }
        return true;
    }

    protected boolean insertAndUpdateExample(TransactionController transactionController) throws StandardException, T_Fail {
        long l = transactionController.createConglomerate("heap", new T_AccessRow(1).getRowArray(), null, null, null, 0);
        this.REPORT("(insertAndUpdateExample)");
        return this.insertAndUpdate(transactionController, l, -1, -1003152) && this.insertAndUpdate(transactionController, l, 0, 2000000000) && this.deletetest(transactionController, l, 1, 2);
    }

    protected boolean deletetest(TransactionController transactionController, long l, int n, int n2) throws StandardException, T_Fail {
        ConglomerateController conglomerateController = transactionController.openConglomerate(l, false, 4, 6, 5);
        T_AccessRow t_AccessRow = new T_AccessRow(1);
        t_AccessRow.setCol(0, (DataValueDescriptor)new SQLInteger(n));
        RowLocation rowLocation = conglomerateController.newRowLocationTemplate();
        conglomerateController.insertAndFetchLocation(t_AccessRow.getRowArray(), rowLocation);
        if (!conglomerateController.delete(rowLocation)) {
            throw T_Fail.testFailMsg("(deleteTest) delete of row failed");
        }
        DataValueDescriptor[] dataValueDescriptorArray = new DataValueDescriptor[1];
        FormatableBitSet formatableBitSet = new FormatableBitSet(1);
        formatableBitSet.set(0);
        if (conglomerateController.replace(rowLocation, dataValueDescriptorArray, formatableBitSet)) {
            throw T_Fail.testFailMsg("(deleteTest) partial column row replace returned true on del row");
        }
        if (conglomerateController.replace(rowLocation, t_AccessRow.getRowArray(), (FormatableBitSet)null)) {
            throw T_Fail.testFailMsg("(deleteTest) update returned true on del row");
        }
        if (conglomerateController.delete(rowLocation)) {
            throw T_Fail.testFailMsg("(deleteTest) delete returned true on del row");
        }
        conglomerateController.close();
        return true;
    }

    protected boolean insertAndUpdate(TransactionController transactionController, long l, int n, int n2) throws StandardException, T_Fail {
        ConglomerateController conglomerateController = transactionController.openConglomerate(l, false, 4, 6, 5);
        T_AccessRow t_AccessRow = new T_AccessRow(1);
        t_AccessRow.setCol(0, (DataValueDescriptor)new SQLInteger(n));
        RowLocation rowLocation = conglomerateController.newRowLocationTemplate();
        conglomerateController.insertAndFetchLocation(t_AccessRow.getRowArray(), rowLocation);
        DataValueDescriptor[] dataValueDescriptorArray = new DataValueDescriptor[]{new SQLInteger(n2)};
        FormatableBitSet formatableBitSet = new FormatableBitSet(1);
        formatableBitSet.set(0);
        conglomerateController.replace(rowLocation, dataValueDescriptorArray, formatableBitSet);
        T_AccessRow t_AccessRow2 = new T_AccessRow(1);
        SQLInteger sQLInteger = new SQLInteger(0);
        t_AccessRow2.setCol(0, (DataValueDescriptor)sQLInteger);
        if (!conglomerateController.fetch(rowLocation, t_AccessRow2.getRowArray(), (FormatableBitSet)null)) {
            throw T_Fail.testFailMsg("(insertAndUpdate) Fetch val not there.");
        }
        conglomerateController.close();
        if (sQLInteger.getInt() != n2) {
            throw T_Fail.testFailMsg("(insertAndUpdate) Fetch value != updated value.");
        }
        return true;
    }

    protected boolean scanExample(TransactionController transactionController) throws StandardException, T_Fail {
        FormatableBitSet formatableBitSet;
        ScanController scanController;
        int n;
        transactionController.commit();
        if (!transactionController.isPristine() || !transactionController.isIdle() || transactionController.isGlobal()) {
            throw T_Fail.testFailMsg("(scanExample) bad xact state after commit.");
        }
        if (transactionController.countOpens(5) > 0 || transactionController.countOpens(1) > 0 || transactionController.countOpens(2) > 0 || transactionController.countOpens(3) > 0 || transactionController.countOpens(4) > 0) {
            System.out.println("OPENED 0:\n" + transactionController.debugOpened());
            return this.FAIL("unexpected open count.");
        }
        long l = transactionController.createConglomerate("heap", new T_AccessRow(1).getRowArray(), null, null, null, 0);
        this.REPORT("(scanExample) starting");
        ConglomerateController conglomerateController = transactionController.openConglomerate(l, false, 4, 6, 5);
        int[] nArray = new int[]{11, 22, 33, 44, 55, 66};
        T_AccessRow t_AccessRow = new T_AccessRow(1);
        for (n = 0; n < nArray.length; ++n) {
            t_AccessRow.setCol(0, (DataValueDescriptor)new SQLInteger(nArray[n]));
            if (conglomerateController.insert(t_AccessRow.getRowArray()) == 0) continue;
            throw T_Fail.testFailMsg("(scanExample after insert) insert failed ");
        }
        this.REPORT("(scanExample) debug output testing: " + transactionController.debugOpened());
        conglomerateController.close();
        if (transactionController.countOpens(5) > 0 || transactionController.countOpens(1) > 0 || transactionController.countOpens(2) > 0 || transactionController.countOpens(3) > 0 || transactionController.countOpens(4) > 0) {
            System.out.println("OPENED 1:\n" + transactionController.debugOpened());
            return this.FAIL("unexpected open count.");
        }
        this.REPORT("(scanExample) rows inserted");
        n = 0;
        SQLInteger sQLInteger = new SQLInteger(0);
        t_AccessRow.setCol(0, (DataValueDescriptor)sQLInteger);
        this.flush_cache();
        StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo = transactionController.getStaticCompiledConglomInfo(l);
        ScanController scanController2 = transactionController.openCompiledScan(false, 0, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0, staticCompiledOpenConglomInfo, transactionController.getDynamicCompiledConglomInfo(l));
        if (scanController2.getEstimatedRowCount() != 6L) {
            throw T_Fail.testFailMsg("(scanExample) estimated row count not 6:" + scanController2.getEstimatedRowCount());
        }
        scanController2.setEstimatedRowCount(5L);
        if (scanController2.getEstimatedRowCount() != 5L) {
            throw T_Fail.testFailMsg("(scanExample) estimated row count not 5");
        }
        while (scanController2.next()) {
            scanController2.fetch(t_AccessRow.getRowArray());
            if (sQLInteger.getInt() != nArray[n]) {
                throw T_Fail.testFailMsg("(scanExample after insert) Row " + n + " should have been " + nArray[n] + ", was " + sQLInteger.getInt());
            }
            ++n;
        }
        if (scanController2.next()) {
            throw T_Fail.testFailMsg("(scanExample after insert) should continue to return false after reaching end of scan");
        }
        scanController2.reopenScan(null, 0, null, null, 0);
        scanController2.next();
        scanController2.next();
        scanController2.next();
        RowLocation rowLocation = scanController2.newRowLocationTemplate();
        scanController2.fetchLocation(rowLocation);
        scanController2.reopenScanByRowLocation(rowLocation, null);
        n = 2;
        while (scanController2.next()) {
            scanController2.fetch(t_AccessRow.getRowArray());
            if (sQLInteger.getInt() != nArray[n]) {
                throw T_Fail.testFailMsg("(scanExample after insert) Row " + n + " should have been " + nArray[n] + ", was " + sQLInteger.getInt());
            }
            ++n;
        }
        scanController2.close();
        if (n != nArray.length) {
            throw T_Fail.testFailMsg("(scanExample after insert) Expected " + nArray.length + "rows, got " + n);
        }
        this.REPORT("(scanExample) rows present and accounted for");
        ScanController scanController3 = transactionController.openScan(l, false, 4, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
        int[] nArray2 = new int[]{22, 33, 444, 55, 6666};
        block9: while (scanController3.next()) {
            scanController3.fetch(t_AccessRow.getRowArray());
            switch (((SQLInteger)t_AccessRow.getCol(0)).getInt()) {
                case 11: {
                    if (scanController3.delete()) continue block9;
                    throw T_Fail.testFailMsg("(scanExample) delete failed.");
                }
                case 22: 
                case 33: 
                case 55: {
                    continue block9;
                }
                case 44: {
                    scanController = new ScanController[]{new SQLInteger(444)};
                    formatableBitSet = new FormatableBitSet(1);
                    formatableBitSet.set(0);
                    if (scanController3.replace((DataValueDescriptor[])scanController, formatableBitSet)) continue block9;
                    throw T_Fail.testFailMsg("(scanExample) partial column row replace failed.");
                }
                case 66: {
                    t_AccessRow.setCol(0, (DataValueDescriptor)new SQLInteger(6666));
                    if (scanController3.replace(t_AccessRow.getRowArray(), (FormatableBitSet)null)) continue block9;
                    throw T_Fail.testFailMsg("(scanExample) replace failed.");
                }
            }
            throw T_Fail.testFailMsg("(scanExample) Read unexpected value.");
        }
        scanController3.close();
        this.REPORT("(scanExample) rows fiddled with");
        scanController = transactionController.openScan(l, false, 0, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
        n = 0;
        t_AccessRow.setCol(0, (DataValueDescriptor)sQLInteger);
        while (scanController.next()) {
            scanController.fetch(t_AccessRow.getRowArray());
            this.REPORT("(scanExample) scan3 fetched " + sQLInteger.getInt());
            if (sQLInteger.getInt() != nArray2[n]) {
                throw T_Fail.testFailMsg("(scanExample after changes) Row " + n + " should have been " + nArray2[n] + ", was " + sQLInteger.getInt());
            }
            ++n;
        }
        scanController.close();
        scanController = transactionController.openScan(l, false, 0, 6, 1, (FormatableBitSet)null, null, 0, null, null, 0);
        n = 0;
        t_AccessRow.setCol(0, (DataValueDescriptor)sQLInteger);
        while (scanController.next()) {
            scanController.fetch(t_AccessRow.getRowArray());
            this.REPORT("(scanExample) scan3 fetched " + sQLInteger.getInt());
            if (sQLInteger.getInt() != nArray2[n]) {
                throw T_Fail.testFailMsg("(scanExample after changes) Row " + n + " should have been " + nArray2[n] + ", was " + sQLInteger.getInt());
            }
            ++n;
        }
        scanController.close();
        if (n != nArray2.length) {
            throw T_Fail.testFailMsg("(scanExample after changes) Expected " + nArray2.length + "rows, got " + n);
        }
        this.REPORT("(scanExample) fiddled rows present and accounted for");
        this.REPORT("(scanExample) testing expected delete errors");
        formatableBitSet = transactionController.openScan(l, false, 4, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
        while (formatableBitSet.next()) {
            formatableBitSet.fetch(t_AccessRow.getRowArray());
            if (!formatableBitSet.doesCurrentPositionQualify()) {
                throw T_Fail.testFailMsg("(scanExample doesCurrentPositionQualify() errors) Expected requalify of current row to succeed");
            }
            if (((SQLInteger)t_AccessRow.getCol(0)).getInt() != 22) continue;
            if (formatableBitSet.delete()) break;
            throw T_Fail.testFailMsg("(scanExample delete errors) Delete failed.");
        }
        if (formatableBitSet.doesCurrentPositionQualify()) {
            throw T_Fail.testFailMsg("(scanExample doesCurrentPositionQualify() errors) Expected qualify of deleted row to FAIL");
        }
        DataValueDescriptor[] dataValueDescriptorArray = new DataValueDescriptor[1];
        FormatableBitSet formatableBitSet2 = new FormatableBitSet(1);
        formatableBitSet2.set(0);
        if (formatableBitSet.replace(dataValueDescriptorArray, formatableBitSet2)) {
            throw T_Fail.testFailMsg("(scanExample delete errors) Expected partial column replace to FAIL");
        }
        if (formatableBitSet.replace(t_AccessRow.getRowArray(), (FormatableBitSet)null)) {
            throw T_Fail.testFailMsg("(scanExample after changes) Expected replace to FAIL");
        }
        if (formatableBitSet.delete()) {
            throw T_Fail.testFailMsg("(scanExample after changes) Expected delete to FAIL");
        }
        formatableBitSet.close();
        if (transactionController.countOpens(5) > 0 || transactionController.countOpens(1) > 0 || transactionController.countOpens(2) > 0 || transactionController.countOpens(3) > 0 || transactionController.countOpens(4) > 0) {
            System.out.println("OPENED:\n" + transactionController.debugOpened());
            return this.FAIL("unexpected open count.");
        }
        this.REPORT("(scanExample) completed");
        return true;
    }

    protected boolean dropTest(TransactionController transactionController) throws StandardException, T_Fail {
        this.REPORT("(dropTest) starting");
        long l = transactionController.createConglomerate("heap", new T_AccessRow(1).getRowArray(), null, null, null, 0);
        transactionController.commit();
        transactionController.dropConglomerate(l);
        try {
            ConglomerateController conglomerateController = transactionController.openConglomerate(l, false, 4, 6, 5);
            throw T_Fail.testFailMsg("Open conglom on deleted conglom worked.");
        }
        catch (StandardException standardException) {
            if (!standardException.getMessageId().equals("XSAI2.S")) {
                throw standardException;
            }
            try {
                ConglomerateController conglomerateController = transactionController.openConglomerate(42424242L, false, 4, 6, 5);
                throw T_Fail.testFailMsg("Open conglom on deleted conglom worked.");
            }
            catch (StandardException standardException2) {
                if (!standardException2.getMessageId().equals("XSAI2.S")) {
                    throw standardException2;
                }
                try {
                    transactionController.dropConglomerate(l);
                    throw T_Fail.testFailMsg("Delete conglom on deleted conglom worked.");
                }
                catch (StandardException standardException3) {
                    long l2 = transactionController.createConglomerate("heap", new T_AccessRow(1).getRowArray(), null, null, null, 0);
                    ConglomerateController conglomerateController = transactionController.openConglomerate(l2, false, 4, 6, 5);
                    transactionController.abort();
                    conglomerateController = transactionController.openConglomerate(l, false, 4, 6, 5);
                    conglomerateController.close();
                    return true;
                }
            }
        }
    }

    protected boolean getTableProperties(TransactionController transactionController) throws StandardException, T_Fail {
        Properties properties = new Properties();
        properties.put("derby.storage.pageSize", "8192");
        properties.put("derby.storage.pageReservedSpace", "99");
        properties.put("derby.storage.minimumRecordSize", "42");
        properties.put("derby.storage.initialPages", "22");
        T_AccessRow t_AccessRow = new T_AccessRow(1);
        long l = transactionController.createConglomerate("heap", t_AccessRow.getRowArray(), null, null, properties, 0);
        ConglomerateController conglomerateController = transactionController.openConglomerate(l, false, 4, 6, 5);
        Properties properties2 = transactionController.getUserCreateConglomPropList();
        conglomerateController.getTableProperties(properties2);
        if (properties2.getProperty("derby.storage.pageSize").compareTo("8192") != 0 || properties2.getProperty("derby.storage.pageReservedSpace").compareTo("99") != 0 || properties2.getProperty("derby.storage.minimumRecordSize").compareTo("42") != 0 || properties2.getProperty("derby.storage.initialPages").compareTo("22") != 0) {
            throw T_Fail.testFailMsg("(getTableProperties) Did not get expected table propertes(1).\nGot pageSize = " + properties2.getProperty("derby.storage.pageSize") + "\nGot reserved = " + properties2.getProperty("derby.storage.pageReservedSpace") + "\nGot minimum record size = " + properties2.getProperty("derby.storage.minimumRecordSize") + "\nGot initial pages = " + properties2.getProperty("derby.storage.initialPages"));
        }
        properties2 = conglomerateController.getInternalTablePropertySet(null);
        if (properties2.getProperty("derby.storage.pageSize").compareTo("8192") != 0 || properties2.getProperty("derby.storage.pageReservedSpace").compareTo("99") != 0 || properties2.getProperty("derby.storage.minimumRecordSize").compareTo("42") != 0 || properties2.getProperty("derby.storage.initialPages").compareTo("22") != 0) {
            throw T_Fail.testFailMsg("(getTableProperties) Did not get expected table propertes(2).\nGot pageSize = " + properties2.getProperty("derby.storage.pageSize") + "\nGot reserved = " + properties2.getProperty("derby.storage.pageReservedSpace") + "\nGot minimum record size = " + properties2.getProperty("derby.storage.minimumRecordSize") + "\nGot initial pages = " + properties2.getProperty("derby.storage.initialPages"));
        }
        properties2 = new Properties();
        if ((properties2 = conglomerateController.getInternalTablePropertySet(properties2)).getProperty("derby.storage.pageSize").compareTo("8192") != 0 || properties2.getProperty("derby.storage.pageReservedSpace").compareTo("99") != 0 || properties2.getProperty("derby.storage.minimumRecordSize").compareTo("42") != 0 || properties2.getProperty("derby.storage.initialPages").compareTo("22") != 0) {
            throw T_Fail.testFailMsg("(getTableProperties) Did not get expected table propertes(3).\nGot pageSize = " + properties2.getProperty("derby.storage.pageSize") + "\nGot reserved = " + properties2.getProperty("derby.storage.pageReservedSpace") + "\nGot minimum record size = " + properties2.getProperty("derby.storage.minimumRecordSize") + "\nGot initial pages = " + properties2.getProperty("derby.storage.initialPages"));
        }
        return true;
    }

    private boolean alterTable(TransactionController transactionController, boolean bl) throws StandardException, T_Fail {
        int n;
        this.REPORT("(alterTable) starting");
        T_AccessRow t_AccessRow = new T_AccessRow(1);
        int n2 = bl ? 1 : 0;
        long l = transactionController.createConglomerate("heap", t_AccessRow.getRowArray(), null, null, null, n2);
        ConglomerateController conglomerateController = transactionController.openConglomerate(l, false, 4, 6, 5);
        T_AccessRow t_AccessRow2 = new T_AccessRow(1);
        SQLInteger sQLInteger = new SQLInteger(1);
        t_AccessRow2.setCol(0, (DataValueDescriptor)sQLInteger);
        RowLocation rowLocation = conglomerateController.newRowLocationTemplate();
        conglomerateController.insertAndFetchLocation(t_AccessRow2.getRowArray(), rowLocation);
        t_AccessRow2.setCol(0, (DataValueDescriptor)new SQLInteger(2));
        RowLocation rowLocation2 = conglomerateController.newRowLocationTemplate();
        conglomerateController.insertAndFetchLocation(t_AccessRow2.getRowArray(), rowLocation2);
        transactionController.commitNoSync(1);
        transactionController.addColumnToConglomerate(l, 1, (Storable)sQLInteger, 0);
        conglomerateController = transactionController.openConglomerate(l, false, 4, 6, 5);
        T_AccessRow t_AccessRow3 = new T_AccessRow(2);
        SQLInteger sQLInteger2 = new SQLInteger(3);
        SQLInteger sQLInteger3 = new SQLInteger(3);
        if (!conglomerateController.fetch(rowLocation, t_AccessRow3.getRowArray(), (FormatableBitSet)null)) {
            throw T_Fail.testFailMsg("(alterTable) Row not there.");
        }
        if (((SQLInteger)t_AccessRow3.getCol(0)).getInt() != 1 || !t_AccessRow3.getCol(1).isNull()) {
            throw T_Fail.testFailMsg("(alterTable) Bad column value after alter.");
        }
        if (!conglomerateController.fetch(rowLocation2, t_AccessRow3.getRowArray(), (FormatableBitSet)null)) {
            throw T_Fail.testFailMsg("(alterTable) Row not there.");
        }
        if (((SQLInteger)t_AccessRow3.getCol(0)).getInt() != 2 || !t_AccessRow3.getCol(1).isNull()) {
            throw T_Fail.testFailMsg("(alterTable) Bad column value after alter.");
        }
        t_AccessRow3 = new T_AccessRow(2);
        t_AccessRow3.setCol(0, (DataValueDescriptor)new SQLInteger(3));
        t_AccessRow3.setCol(1, (DataValueDescriptor)new SQLInteger(300));
        conglomerateController.insert(t_AccessRow3.getRowArray());
        ScanController scanController = transactionController.openScan(l, false, 4, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
        block8: while (scanController.next()) {
            scanController.fetch(t_AccessRow3.getRowArray());
            n = ((SQLInteger)t_AccessRow3.getCol(0)).getInt();
            switch (n) {
                case 1: {
                    if (!t_AccessRow3.getCol(1).isNull()) {
                        throw T_Fail.testFailMsg("(alterTable) Bad column value after alter.");
                    }
                    t_AccessRow3.setCol(1, (DataValueDescriptor)new SQLInteger(100));
                    scanController.replace(t_AccessRow3.getRowArray(), (FormatableBitSet)null);
                    continue block8;
                }
                case 2: {
                    if (!t_AccessRow3.getCol(1).isNull()) {
                        throw T_Fail.testFailMsg("(alterTable) Bad column value after alter.");
                    }
                    t_AccessRow3.setCol(1, (DataValueDescriptor)new SQLInteger(200));
                    scanController.replace(t_AccessRow3.getRowArray(), (FormatableBitSet)null);
                    continue block8;
                }
                case 3: {
                    continue block8;
                }
            }
            throw T_Fail.testFailMsg("(alterTable) bad row value found in table.");
        }
        scanController.reopenScan(null, 0, null, null, 0);
        block9: while (scanController.next()) {
            scanController.fetch(t_AccessRow3.getRowArray());
            n = ((SQLInteger)t_AccessRow3.getCol(0)).getInt();
            switch (n) {
                case 1: 
                case 2: 
                case 3: {
                    int n3 = ((SQLInteger)t_AccessRow3.getCol(1)).getInt();
                    if (n3 == n * 100) continue block9;
                    throw T_Fail.testFailMsg("(alterTable) Bad column value after alter.expected: (" + n + ", " + n * 100 + ")\ngot     : (" + n + ", " + n3 + ")\n");
                }
            }
            throw T_Fail.testFailMsg("(alterTable) bad row value found in table.");
        }
        scanController.close();
        transactionController.commit();
        this.REPORT("(alterTable) completed");
        return true;
    }

    protected boolean scanInfo(TransactionController transactionController) throws StandardException, T_Fail {
        this.REPORT("(scanInfo) starting");
        T_AccessRow t_AccessRow = new T_AccessRow(2);
        long l = transactionController.createConglomerate("heap", t_AccessRow.getRowArray(), null, null, null, 0);
        ConglomerateController conglomerateController = transactionController.openConglomerate(l, false, 4, 6, 5);
        T_AccessRow t_AccessRow2 = new T_AccessRow(2);
        SQLInteger sQLInteger = new SQLInteger(1);
        SQLInteger sQLInteger2 = new SQLInteger(100);
        t_AccessRow2.setCol(0, (DataValueDescriptor)sQLInteger);
        t_AccessRow2.setCol(1, (DataValueDescriptor)sQLInteger2);
        RowLocation rowLocation = conglomerateController.newRowLocationTemplate();
        conglomerateController.insertAndFetchLocation(t_AccessRow2.getRowArray(), rowLocation);
        t_AccessRow2.setCol(0, (DataValueDescriptor)new SQLInteger(2));
        t_AccessRow2.setCol(1, (DataValueDescriptor)new SQLInteger(200));
        RowLocation rowLocation2 = conglomerateController.newRowLocationTemplate();
        conglomerateController.insertAndFetchLocation(t_AccessRow2.getRowArray(), rowLocation2);
        conglomerateController.delete(rowLocation2);
        if (transactionController.isPristine() || transactionController.isIdle()) {
            throw T_Fail.testFailMsg("(scanInfo) bad xact state after update xact.");
        }
        transactionController.commit();
        ScanController scanController = transactionController.openScan(l, false, 0, 7, 5, (FormatableBitSet)null, null, 0, null, null, 0);
        if (!scanController.isTableLocked()) {
            throw T_Fail.testFailMsg("(scanInfo) table should be table locked.");
        }
        while (scanController.next()) {
            scanController.fetch(t_AccessRow2.getRowArray());
        }
        ScanInfo scanInfo = scanController.getScanInfo();
        Properties properties = scanInfo.getAllScanInfo(null);
        if (!transactionController.isPristine() || transactionController.isIdle()) {
            throw T_Fail.testFailMsg("(scanInfo) bad xact state after update xact.");
        }
        this.REPORT("return from full row scan heap.getScanInfo() = " + properties);
        if (Integer.parseInt(properties.getProperty(MessageService.getTextMessage((String)"XSAJ1.U", (Object[])new Object[0]))) != 1) {
            throw T_Fail.testFailMsg("(scanInfo) wrong numPagesVisited.  Expected 1, got " + Integer.parseInt(properties.getProperty(MessageService.getTextMessage((String)"XSAJ1.U", (Object[])new Object[0]))));
        }
        if (Integer.parseInt(properties.getProperty(MessageService.getTextMessage((String)"XSAJ2.U", (Object[])new Object[0]))) != 2) {
            throw T_Fail.testFailMsg("(scanInfo) wrong numRowsVisited. Expected 2, got " + Integer.parseInt(properties.getProperty(MessageService.getTextMessage((String)"XSAJ2.U", (Object[])new Object[0]))));
        }
        if (Integer.parseInt(properties.getProperty(MessageService.getTextMessage((String)"XSAJ4.U", (Object[])new Object[0]))) != 1) {
            throw T_Fail.testFailMsg("(scanInfo) wrong numRowsQualified. Expected 1, got " + Integer.parseInt(properties.getProperty(MessageService.getTextMessage((String)"XSAJ4.U", (Object[])new Object[0]))));
        }
        FormatableBitSet formatableBitSet = new FormatableBitSet(3);
        formatableBitSet.set(1);
        scanController = transactionController.openScan(l, false, 4, 6, 5, formatableBitSet, null, 0, null, null, 0);
        if (scanController.isTableLocked()) {
            throw T_Fail.testFailMsg("(scanInfo) table should be row locked.");
        }
        scanInfo = scanController.getScanInfo();
        properties = scanInfo.getAllScanInfo(null);
        this.REPORT("return from partial scan heap.getScanInfo() = " + properties);
        this.REPORT("(scanInfo) finishing");
        return true;
    }

    protected boolean partialScan(TransactionController transactionController) throws StandardException, T_Fail {
        this.REPORT("(partialScan) starting");
        T_AccessRow t_AccessRow = new T_AccessRow(2);
        long l = transactionController.createConglomerate("heap", t_AccessRow.getRowArray(), null, null, null, 0);
        ConglomerateController conglomerateController = transactionController.openConglomerate(l, false, 4, 6, 5);
        T_AccessRow t_AccessRow2 = new T_AccessRow(2);
        SQLInteger sQLInteger = new SQLInteger(1);
        SQLInteger sQLInteger2 = new SQLInteger(100);
        t_AccessRow2.setCol(0, (DataValueDescriptor)sQLInteger);
        t_AccessRow2.setCol(1, (DataValueDescriptor)sQLInteger2);
        RowLocation rowLocation = conglomerateController.newRowLocationTemplate();
        conglomerateController.insertAndFetchLocation(t_AccessRow2.getRowArray(), rowLocation);
        t_AccessRow2.setCol(0, (DataValueDescriptor)new SQLInteger(2));
        t_AccessRow2.setCol(1, (DataValueDescriptor)new SQLInteger(200));
        RowLocation rowLocation2 = conglomerateController.newRowLocationTemplate();
        conglomerateController.insertAndFetchLocation(t_AccessRow2.getRowArray(), rowLocation2);
        conglomerateController.delete(rowLocation2);
        transactionController.commit();
        FormatableBitSet formatableBitSet = new FormatableBitSet();
        ScanController scanController = transactionController.openScan(l, false, 4, 6, 5, formatableBitSet, null, 0, null, null, 0);
        if (!scanController.next()) {
            throw T_Fail.testFailMsg("(partialScan) did not see first row.");
        }
        if (scanController.next()) {
            throw T_Fail.testFailMsg("(partialScan) saw more than one row.");
        }
        this.REPORT("(partialScan) finishing");
        return true;
    }

    protected boolean insert_bench(TransactionController transactionController) throws StandardException, T_Fail {
        ConglomerateController conglomerateController = null;
        ScanController scanController = null;
        long l = -1L;
        T_AccessRow t_AccessRow = new T_AccessRow(1);
        long l2 = 100L;
        for (int i = 1; i < 101; i *= 10) {
            int n;
            l = transactionController.createConglomerate("heap", new T_AccessRow(i).getRowArray(), null, null, null, 0);
            transactionController.commit();
            conglomerateController = transactionController.openConglomerate(l, false, 4, 6, 5);
            for (n = 0; n < i; ++n) {
                t_AccessRow.setCol(n, (DataValueDescriptor)new SQLInteger(i));
            }
            long l3 = System.currentTimeMillis();
            n = 0;
            while ((long)n < l2) {
                if (conglomerateController.insert(t_AccessRow.getRowArray()) != 0) {
                    throw T_Fail.testFailMsg("(insert_bench) insert failed ");
                }
                ++n;
            }
            long l4 = System.currentTimeMillis();
            this.REPORT("insert " + l2 + " rows of " + i + " integer cols = " + (l4 - l3) + " milliseconds.\n");
            l3 = System.currentTimeMillis();
            n = 0;
            while ((long)n < l2) {
                if (conglomerateController.insert(t_AccessRow.getRowArray()) != 0) {
                    throw T_Fail.testFailMsg("(insert_bench) insert failed ");
                }
                ++n;
            }
            l4 = System.currentTimeMillis();
            this.REPORT("second insert " + l2 + " rows of " + i + " integer cols = " + (l4 - l3) + " milliseconds.\n");
            l3 = System.currentTimeMillis();
            scanController = transactionController.openScan(l, false, 0, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
            l3 = System.currentTimeMillis();
            while (scanController.next()) {
                scanController.fetch(t_AccessRow.getRowArray());
            }
            l4 = System.currentTimeMillis();
            this.REPORT("scan " + 2L * l2 + " rows of " + i + " integer cols = " + (l4 - l3) + " milliseconds.\n");
            conglomerateController.close();
            transactionController.commit();
        }
        return true;
    }

    protected boolean sortCost(TransactionController transactionController) throws StandardException, T_Fail {
        this.REPORT("(sortCost) starting");
        T_AccessRow t_AccessRow = new T_AccessRow(2);
        long l = transactionController.createConglomerate("heap", t_AccessRow.getRowArray(), null, null, null, 0);
        ConglomerateController conglomerateController = transactionController.openConglomerate(l, false, 4, 6, 5);
        T_AccessRow t_AccessRow2 = new T_AccessRow(2);
        SQLInteger sQLInteger = new SQLInteger(1);
        SQLInteger sQLInteger2 = new SQLInteger(100);
        t_AccessRow2.setCol(0, (DataValueDescriptor)sQLInteger);
        t_AccessRow2.setCol(1, (DataValueDescriptor)sQLInteger2);
        RowLocation rowLocation = conglomerateController.newRowLocationTemplate();
        conglomerateController.insertAndFetchLocation(t_AccessRow2.getRowArray(), rowLocation);
        conglomerateController.close();
        transactionController.commit();
        this.flush_cache();
        SortCostController sortCostController = transactionController.openSortCostController();
        double d = sortCostController.getSortCost(t_AccessRow.getRowArray(), null, false, 10000L, 100L, 100);
        if (d <= 0.0) {
            throw T_Fail.testFailMsg("(storeCost) estimated sort cost :" + d);
        }
        this.REPORT("(sortCost) finishing");
        return true;
    }

    protected boolean storeCost(TransactionController transactionController) throws StandardException, T_Fail {
        this.REPORT("(storeCost) starting");
        T_AccessRow t_AccessRow = new T_AccessRow(2);
        long l = transactionController.createConglomerate("heap", t_AccessRow.getRowArray(), null, null, null, 0);
        ConglomerateController conglomerateController = transactionController.openConglomerate(l, false, 4, 6, 5);
        T_AccessRow t_AccessRow2 = new T_AccessRow(2);
        SQLInteger sQLInteger = new SQLInteger(1);
        SQLInteger sQLInteger2 = new SQLInteger(100);
        t_AccessRow2.setCol(0, (DataValueDescriptor)sQLInteger);
        t_AccessRow2.setCol(1, (DataValueDescriptor)sQLInteger2);
        RowLocation rowLocation = conglomerateController.newRowLocationTemplate();
        conglomerateController.insertAndFetchLocation(t_AccessRow2.getRowArray(), rowLocation);
        conglomerateController.close();
        transactionController.commit();
        this.flush_cache();
        StoreCostController storeCostController = transactionController.openStoreCost(l);
        if (storeCostController.getEstimatedRowCount() != 1L) {
            throw T_Fail.testFailMsg("(storeCost) estimated row count not 1:" + storeCostController.getEstimatedRowCount());
        }
        storeCostController.setEstimatedRowCount(5L);
        if (storeCostController.getEstimatedRowCount() != 5L) {
            throw T_Fail.testFailMsg("(storeCost) estimated row count not 5");
        }
        storeCostController.setEstimatedRowCount(1L);
        double d = storeCostController.getFetchFromRowLocationCost((FormatableBitSet)null, 0);
        d = storeCostController.getFetchFromRowLocationCost(new FormatableBitSet(0), 0);
        this.REPORT("fetch cost (full row) of row loc = " + d);
        d = storeCostController.getFetchFromRowLocationCost(new FormatableBitSet(1), 0);
        FormatableBitSet formatableBitSet = new FormatableBitSet(2);
        this.REPORT("fetch cost (no cols) of row loc = " + d);
        formatableBitSet.set(1);
        d = storeCostController.getFetchFromRowLocationCost(new FormatableBitSet(1), 0);
        this.REPORT("fetch cost (1 col) of row loc = " + d);
        T_StoreCostResult t_StoreCostResult = new T_StoreCostResult();
        storeCostController.getScanCost(2, -1L, 1, false, (FormatableBitSet)null, new T_AccessRow(2).getRowArray(), null, 0, null, 0, false, 0, (StoreCostResult)t_StoreCostResult);
        this.REPORT("fetch scan cost (full row) of row loc = " + t_StoreCostResult);
        storeCostController.getScanCost(2, -1L, 1, false, new FormatableBitSet(0), new T_AccessRow(2).getRowArray(), null, 0, null, 0, false, 0, (StoreCostResult)t_StoreCostResult);
        this.REPORT("fetch scan cost (no cols) of row loc = " + t_StoreCostResult);
        storeCostController.getScanCost(2, -1L, 1, false, new FormatableBitSet(1), new T_AccessRow(2).getRowArray(), null, 0, null, 0, false, 0, (StoreCostResult)t_StoreCostResult);
        this.REPORT("fetch scan cost (no cols) of row loc = " + t_StoreCostResult);
        formatableBitSet = new FormatableBitSet(2);
        formatableBitSet.set(1);
        storeCostController.getScanCost(2, -1L, 1, false, formatableBitSet, new T_AccessRow(2).getRowArray(), null, 0, null, 0, false, 0, (StoreCostResult)t_StoreCostResult);
        this.REPORT("fetch scan cost (1 cols) of row loc = " + t_StoreCostResult);
        rowLocation = storeCostController.newRowLocationTemplate();
        this.REPORT("(storeCost) finishing");
        return true;
    }

    protected boolean transactionalProperties(TransactionController transactionController) throws StandardException, T_Fail {
        this.REPORT("start transactionalProperties");
        transactionController.setProperty("T_Key_Frog", (Serializable)new SQLLongint(479L), false);
        transactionController.setProperty("T_Key_Tiger", (Serializable)((Object)"Roar, ROAR"), false);
        long l = ((SQLLongint)transactionController.getProperty("T_Key_Frog")).getLong();
        if (l != 479L) {
            throw T_Fail.testFailMsg("setProperty() - expected 479 - got " + l);
        }
        String string = (String)((Object)transactionController.getProperty("T_Key_Tiger"));
        if (!string.equals("Roar, ROAR")) {
            throw T_Fail.testFailMsg("setProperty() - expected 'Roar, ROAR' - got " + string);
        }
        transactionController.commit();
        l = ((SQLLongint)transactionController.getProperty("T_Key_Frog")).getLong();
        if (l != 479L) {
            throw T_Fail.testFailMsg("setProperty() - expected 479 - got " + l);
        }
        string = (String)((Object)transactionController.getProperty("T_Key_Tiger"));
        if (!string.equals("Roar, ROAR")) {
            throw T_Fail.testFailMsg("setProperty() - expected 'Roar, ROAR' - got " + string);
        }
        transactionController.commit();
        transactionController.setProperty("T_Key_Tiger", (Serializable)((Object)"mieow, mieow"), false);
        string = (String)((Object)transactionController.getProperty("T_Key_Tiger"));
        if (!string.equals("mieow, mieow")) {
            throw T_Fail.testFailMsg("setProperty() - expected 'mieow, mieow' - got " + string);
        }
        transactionController.commit();
        string = (String)((Object)transactionController.getProperty("T_Key_Tiger"));
        if (!string.equals("mieow, mieow")) {
            throw T_Fail.testFailMsg("setProperty() - expected 'mieow, mieow' - got " + string);
        }
        transactionController.setProperty("T_Key_Tiger", (Serializable)new SQLLongint(570L), false);
        l = ((SQLLongint)transactionController.getProperty("T_Key_Tiger")).getLong();
        if (l != 570L) {
            throw T_Fail.testFailMsg("setProperty() - expected 570 - got " + l);
        }
        transactionController.commit();
        l = ((SQLLongint)transactionController.getProperty("T_Key_Tiger")).getLong();
        if (l != 570L) {
            throw T_Fail.testFailMsg("setProperty() - expected 570 - got " + l);
        }
        transactionController.commit();
        transactionController.setProperty("T_Key_Frog", (Serializable)null, false);
        if (transactionController.getProperty("T_Key_Frog") != null) {
            throw T_Fail.testFailMsg("setProperty() - delete failed");
        }
        transactionController.commit();
        if (transactionController.getProperty("T_Key_Frog") != null) {
            throw T_Fail.testFailMsg("setProperty() - delete failed");
        }
        transactionController.commit();
        transactionController.setProperty("T_Key_Tiger", (Serializable)new SQLLongint(457L), false);
        transactionController.abort();
        l = ((SQLLongint)transactionController.getProperty("T_Key_Tiger")).getLong();
        if (l != 570L) {
            throw T_Fail.testFailMsg("setProperty() - expected 570 - got " + l);
        }
        transactionController.commit();
        this.PASS("transactionalProperties");
        return true;
    }

    protected boolean tempTest(TransactionController transactionController) throws StandardException, T_Fail {
        this.REPORT("(tempTest) starting");
        long l = this.createAConglom(transactionController, 5252, true);
        long l2 = this.createAConglom(transactionController, 87, true);
        long l3 = this.createAConglom(transactionController, 999, false);
        long l4 = this.createAConglom(transactionController, 3, true);
        long l5 = this.createBtree(transactionController, l, true);
        long l6 = this.createBtree(transactionController, l3, false);
        int n = this.checkAConglom(transactionController, null, l, 5252);
        if (n != 1) {
            throw T_Fail.testFailMsg("(tempTest) after create checkAConglom(cid5252t) == " + n);
        }
        n = this.checkAConglom(transactionController, this.getBtreeTemplate(transactionController, l), l5, 5252);
        if (n != 1) {
            throw T_Fail.testFailMsg("(tempTest) after create checkAConglom(cid5252ti) == " + n);
        }
        n = this.checkAConglom(transactionController, null, l3, 999);
        if (n != 1) {
            throw T_Fail.testFailMsg("(tempTest) after create checkAConglom(cid999p) == " + n);
        }
        n = this.checkAConglom(transactionController, this.getBtreeTemplate(transactionController, l3), l6, 999);
        if (n != 1) {
            throw T_Fail.testFailMsg("(tempTest) after create checkAConglom(cid999pi) == " + n);
        }
        n = this.checkAConglom(transactionController, null, l4, 3);
        if (n != 1) {
            throw T_Fail.testFailMsg("(tempTest) after create checkAConglom(cid3t) == " + n);
        }
        n = this.checkAConglom(transactionController, null, l2, 87);
        if (n != 1) {
            throw T_Fail.testFailMsg("(tempTest) after create checkAConglom(cid87t) == " + n);
        }
        transactionController.dropConglomerate(l6);
        transactionController.dropConglomerate(l3);
        transactionController.dropConglomerate(l2);
        try {
            transactionController.dropConglomerate(l3);
            throw T_Fail.testFailMsg("(tempTest) drop of dropped cid999p succeeded");
        }
        catch (StandardException standardException) {
            try {
                transactionController.dropConglomerate(l6);
                throw T_Fail.testFailMsg("(tempTest) drop of dropped cid999pi succeeded");
            }
            catch (StandardException standardException2) {
                try {
                    transactionController.dropConglomerate(l2);
                    throw T_Fail.testFailMsg("(tempTest) drop of dropped cid87t succeeded");
                }
                catch (StandardException standardException3) {
                    n = this.checkAConglom(transactionController, null, l, 5252);
                    if (n != 1) {
                        throw T_Fail.testFailMsg("(tempTest) after drop checkAConglom(cid5252t) == " + n);
                    }
                    n = this.checkAConglom(transactionController, this.getBtreeTemplate(transactionController, l), l5, 5252);
                    if (n != 1) {
                        throw T_Fail.testFailMsg("(tempTest) after drop checkAConglom(cid5252ti) == " + n);
                    }
                    n = this.checkAConglom(transactionController, null, l4, 3);
                    if (n != 1) {
                        throw T_Fail.testFailMsg("(tempTest) after drop checkAConglom(cid3t) == " + n);
                    }
                    transactionController.commitNoSync(1);
                    n = this.checkAConglom(transactionController, null, l, 5252);
                    if (n != 1) {
                        throw T_Fail.testFailMsg("(tempTest) after commit checkAConglom(cid5252t) == " + n);
                    }
                    n = this.checkAConglom(transactionController, this.getBtreeTemplate(transactionController, l), l5, 5252);
                    if (n != 1) {
                        throw T_Fail.testFailMsg("(tempTest) after commit checkAConglom(cid5252ti) == " + n);
                    }
                    n = this.checkAConglom(transactionController, null, l4, 3);
                    if (n != 1) {
                        throw T_Fail.testFailMsg("(tempTest) after commit checkAConglom(cid3t) == " + n);
                    }
                    ScanController scanController = transactionController.openScan(l4, false, 4, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
                    scanController.close();
                    transactionController.abort();
                    n = this.checkAConglom(transactionController, null, l, 5252);
                    if (n != 1) {
                        throw T_Fail.testFailMsg("(tempTest) after abort checkAConglom(cid5252t) == " + n);
                    }
                    n = this.checkAConglom(transactionController, null, l4, 3);
                    if (n != 1) {
                        throw T_Fail.testFailMsg("(tempTest) after abort checkAConglom(cid3t) == " + n);
                    }
                    transactionController.dropConglomerate(l5);
                    if (transactionController.conglomerateExists(l5)) {
                        throw T_Fail.testFailMsg("(tempTest) after drop cid5252ti still exists");
                    }
                    transactionController.dropConglomerate(l);
                    if (transactionController.conglomerateExists(l)) {
                        throw T_Fail.testFailMsg("(tempTest) after drop cid5252t still exists");
                    }
                    this.REPORT("(tempTest) succeeded");
                    return true;
                }
            }
        }
    }

    private long createAConglom(TransactionController transactionController, int n, boolean bl) throws StandardException {
        long l = transactionController.createConglomerate("heap", new T_AccessRow(1).getRowArray(), null, null, null, bl ? 1 : 0);
        ConglomerateController conglomerateController = transactionController.openConglomerate(l, false, 4, 6, 5);
        T_AccessRow t_AccessRow = new T_AccessRow(1);
        SQLLongint sQLLongint = new SQLLongint((long)n);
        t_AccessRow.setCol(0, (DataValueDescriptor)sQLLongint);
        conglomerateController.insert(t_AccessRow.getRowArray());
        conglomerateController.close();
        return l;
    }

    private DataValueDescriptor[] getBtreeTemplate(TransactionController transactionController, long l) throws StandardException {
        FormatableBitSet formatableBitSet = new FormatableBitSet(1);
        formatableBitSet.set(0);
        ScanController scanController = transactionController.openScan(l, false, 0, 6, 5, formatableBitSet, null, 0, null, null, 0);
        T_AccessRow t_AccessRow = new T_AccessRow(2);
        SQLLongint sQLLongint = new SQLLongint(0L);
        RowLocation rowLocation = scanController.newRowLocationTemplate();
        t_AccessRow.setCol(0, (DataValueDescriptor)sQLLongint);
        t_AccessRow.setCol(1, (DataValueDescriptor)rowLocation);
        scanController.close();
        return t_AccessRow.getRowArray();
    }

    private long createBtree(TransactionController transactionController, long l, boolean bl) throws StandardException {
        Properties properties = new Properties();
        properties.put("baseConglomerateId", Long.toString(l));
        properties.put("nUniqueColumns", "1");
        properties.put("rowLocationColumn", "1");
        properties.put("nKeyFields", "2");
        FormatableBitSet formatableBitSet = new FormatableBitSet(1);
        formatableBitSet.set(0);
        ScanController scanController = transactionController.openScan(l, false, 0, 6, 5, formatableBitSet, null, 0, null, null, 0);
        T_AccessRow t_AccessRow = new T_AccessRow(2);
        SQLLongint sQLLongint = new SQLLongint(0L);
        RowLocation rowLocation = scanController.newRowLocationTemplate();
        t_AccessRow.setCol(0, (DataValueDescriptor)sQLLongint);
        t_AccessRow.setCol(1, (DataValueDescriptor)rowLocation);
        DataValueDescriptor[] dataValueDescriptorArray = new DataValueDescriptor[]{sQLLongint};
        long l2 = transactionController.createConglomerate("BTREE", t_AccessRow.getRowArray(), null, null, properties, bl ? 1 : 0);
        ConglomerateController conglomerateController = transactionController.openConglomerate(l2, false, 4, 6, 5);
        while (scanController.next()) {
            scanController.fetch(dataValueDescriptorArray);
            scanController.fetchLocation(rowLocation);
            conglomerateController.insert(t_AccessRow.getRowArray());
        }
        conglomerateController.close();
        return l2;
    }

    private int checkAConglom(TransactionController transactionController, DataValueDescriptor[] dataValueDescriptorArray, long l, int n) throws StandardException {
        if (!transactionController.conglomerateExists(l)) {
            return -1;
        }
        ScanController scanController = transactionController.openScan(l, false, 0, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
        T_AccessRow t_AccessRow = new T_AccessRow(1);
        SQLLongint sQLLongint = new SQLLongint(0L);
        t_AccessRow.setCol(0, (DataValueDescriptor)sQLLongint);
        int n2 = 0;
        while (scanController.next()) {
            scanController.fetch(t_AccessRow.getRowArray());
            if (((SQLLongint)t_AccessRow.getCol(0)).getLong() != (long)n) {
                return -2;
            }
            ++n2;
        }
        scanController.close();
        return n2;
    }

    protected boolean updatelocks(TransactionController transactionController) throws StandardException, T_Fail {
        this.REPORT("(updatelocks starting.)");
        this.updatelocks_0(transactionController, 5);
        this.updatelocks_0(transactionController, 2);
        this.REPORT("(updatelocks ending.)");
        return true;
    }

    protected boolean updatelocks_0(TransactionController transactionController, int n) throws StandardException, T_Fail {
        T_AccessRow t_AccessRow;
        int n2;
        T_AccessRow t_AccessRow2 = new T_AccessRow(2);
        SQLInteger sQLInteger = new SQLInteger(1);
        SQLInteger sQLInteger2 = new SQLInteger(100);
        t_AccessRow2.setCol(0, (DataValueDescriptor)sQLInteger);
        t_AccessRow2.setCol(1, (DataValueDescriptor)sQLInteger2);
        long l = transactionController.createConglomerate("heap", t_AccessRow2.getRowArray(), null, null, null, 0);
        ConglomerateController conglomerateController = transactionController.openConglomerate(l, false, 4, 6, 5);
        t_AccessRow2.setCol(0, (DataValueDescriptor)new SQLInteger(1));
        t_AccessRow2.setCol(1, (DataValueDescriptor)new SQLInteger(100));
        conglomerateController.insert(t_AccessRow2.getRowArray());
        t_AccessRow2.setCol(0, (DataValueDescriptor)new SQLInteger(2));
        t_AccessRow2.setCol(1, (DataValueDescriptor)new SQLInteger(200));
        conglomerateController.insert(t_AccessRow2.getRowArray());
        t_AccessRow2.setCol(0, (DataValueDescriptor)new SQLInteger(3));
        t_AccessRow2.setCol(1, (DataValueDescriptor)new SQLInteger(300));
        conglomerateController.insert(t_AccessRow2.getRowArray());
        conglomerateController.close();
        transactionController.commit();
        this.REPORT("(updatelocks ending.)");
        ScanController scanController = transactionController.openScan(l, false, 4100, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
        boolean bl = false;
        block13: while (scanController.next()) {
            scanController.fetch(t_AccessRow2.getRowArray());
            n2 = ((SQLInteger)t_AccessRow2.getCol(0)).getInt();
            switch (n2) {
                case 1: {
                    scanController.delete();
                    continue block13;
                }
                case 2: {
                    bl = true;
                    continue block13;
                }
                case 3: {
                    t_AccessRow = new T_AccessRow(2);
                    t_AccessRow2.setCol(0, (DataValueDescriptor)new SQLInteger(30));
                    t_AccessRow2.setCol(1, (DataValueDescriptor)new SQLInteger(3000));
                    scanController.replace(t_AccessRow2.getRowArray(), null);
                    continue block13;
                }
            }
            throw T_Fail.testFailMsg("(updatelock) bad row value found in table.");
        }
        if (!bl) {
            throw T_Fail.testFailMsg("(updatelock) did not find row in first scan.");
        }
        scanController.reopenScan(null, 0, null, null, 0);
        bl = false;
        block14: while (scanController.next()) {
            scanController.fetch(t_AccessRow2.getRowArray());
            n2 = ((SQLInteger)t_AccessRow2.getCol(0)).getInt();
            switch (n2) {
                case 2: {
                    bl = true;
                    continue block14;
                }
                case 30: {
                    t_AccessRow = new T_AccessRow(2);
                    t_AccessRow2.setCol(0, (DataValueDescriptor)new SQLInteger(40));
                    t_AccessRow2.setCol(1, (DataValueDescriptor)new SQLInteger(4000));
                    scanController.replace(t_AccessRow2.getRowArray(), null);
                    continue block14;
                }
            }
            throw T_Fail.testFailMsg("(updatelock) bad row value found in table.");
        }
        if (!bl) {
            throw T_Fail.testFailMsg("(updatelock) did not find row in second scan.");
        }
        scanController.close();
        transactionController.commit();
        scanController = transactionController.openScan(l, false, 4100, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
        bl = false;
        block15: while (scanController.next()) {
            scanController.fetch(t_AccessRow2.getRowArray());
            n2 = ((SQLInteger)t_AccessRow2.getCol(0)).getInt();
            switch (n2) {
                case 2: {
                    bl = true;
                    continue block15;
                }
                case 40: {
                    t_AccessRow = new T_AccessRow(2);
                    t_AccessRow2.setCol(0, (DataValueDescriptor)new SQLInteger(30));
                    t_AccessRow2.setCol(1, (DataValueDescriptor)new SQLInteger(3000));
                    scanController.replace(t_AccessRow2.getRowArray(), null);
                    continue block15;
                }
            }
            throw T_Fail.testFailMsg("(updatelock) bad row value found in table.");
        }
        if (!bl) {
            throw T_Fail.testFailMsg("(updatelock) did not find row in first scan.");
        }
        return true;
    }

    protected boolean nestedUserTransaction(TransactionController transactionController) throws StandardException, T_Fail {
        this.REPORT("(nestedUserTransaction) starting");
        long l = transactionController.createConglomerate("heap", new T_AccessRow(1).getRowArray(), null, null, null, 0);
        long l2 = transactionController.createConglomerate("heap", new T_AccessRow(1).getRowArray(), null, null, null, 1);
        TransactionController transactionController2 = this.store.getTransaction(T_AccessFactory.getContextService().getCurrentContextManager());
        TransactionController transactionController3 = transactionController.startNestedUserTransaction(true, true);
        TransactionController transactionController4 = this.store.getTransaction(T_AccessFactory.getContextService().getCurrentContextManager());
        if (transactionController4 != transactionController2) {
            throw T_Fail.testFailMsg("(nestedUserTransaction) getTransaction() return changed after startNestedUserTransaction().current_xact = " + transactionController2 + ";current_xact_after_nest = " + transactionController4);
        }
        T_Fail.T_ASSERT(transactionController.getLockSpace() == transactionController3.getLockSpace(), "getLockSpace() returned different object for child.");
        ConglomerateController conglomerateController = transactionController3.openConglomerate(l, false, 4, 6, 5);
        ConglomerateController conglomerateController2 = transactionController3.openConglomerate(l2, false, 4, 6, 5);
        conglomerateController.close();
        conglomerateController2.close();
        transactionController3.commit();
        transactionController3.destroy();
        transactionController.dropConglomerate(l);
        transactionController3 = transactionController.startNestedUserTransaction(true, true);
        try {
            transactionController3.startNestedUserTransaction(true, true);
            throw T_Fail.testFailMsg("(nestedUserTransaction) double nest xact not allowed.");
        }
        catch (StandardException standardException) {
            transactionController3.commit();
            transactionController3.destroy();
            Object object = new String("0123456789012345");
            for (int i = 0; i < 7; ++i) {
                object = (String)object + (String)object;
            }
            T_AccessRow t_AccessRow = new T_AccessRow(2);
            t_AccessRow.setCol(1, (DataValueDescriptor)new SQLChar((String)object));
            l = transactionController.createConglomerate("heap", t_AccessRow.getRowArray(), null, null, null, 0);
            transactionController3 = transactionController.startNestedUserTransaction(true, true);
            conglomerateController = transactionController3.openConglomerate(l, false, 4, 6, 5);
            transactionController3.abort();
            transactionController3.destroy();
            try {
                conglomerateController = transactionController.openConglomerate(l, false, 4, 6, 5);
                throw T_Fail.testFailMsg("(nestedUserTransaction) conglom should have been aborted.");
            }
            catch (StandardException standardException2) {
                transactionController.commit();
                l = transactionController.createConglomerate("heap", t_AccessRow.getRowArray(), null, null, null, 0);
                transactionController.commit();
                transactionController3 = transactionController.startNestedUserTransaction(true, true);
                conglomerateController = transactionController3.openConglomerate(l, false, 4, 6, 5);
                transactionController3.abort();
                transactionController3.destroy();
                try {
                    conglomerateController = transactionController.openConglomerate(l, false, 4, 6, 5);
                    conglomerateController.close();
                }
                catch (StandardException standardException3) {
                    throw T_Fail.testFailMsg("(nestedUserTransaction) conglom should have not be aborted.");
                }
                transactionController3 = transactionController.startNestedUserTransaction(true, true);
                ConglomerateController conglomerateController3 = transactionController3.openConglomerate(l, false, 4, 6, 5);
                try {
                    t_AccessRow.setCol(0, (DataValueDescriptor)new SQLInteger(1042));
                    conglomerateController3.insert(t_AccessRow.getRowArray());
                    throw T_Fail.testFailMsg("(nestedUserTransaction) read only xact does not allow upd.");
                }
                catch (StandardException standardException4) {
                    transactionController3.commit();
                    transactionController3.destroy();
                    transactionController.commit();
                    transactionController3 = transactionController.startNestedUserTransaction(false, true);
                    conglomerateController3 = transactionController3.openConglomerate(l, false, 4, 6, 5);
                    try {
                        t_AccessRow.setCol(0, (DataValueDescriptor)new SQLInteger(1043));
                        conglomerateController3.insert(t_AccessRow.getRowArray());
                    }
                    catch (StandardException standardException5) {
                        throw T_Fail.testFailMsg("(nestedUserTransaction) read only xact does not allow upd.");
                    }
                    transactionController3.commit();
                    transactionController3.destroy();
                    transactionController.commit();
                    conglomerateController = transactionController.openConglomerate(l, false, 4, 7, 5);
                    transactionController3 = transactionController.startNestedUserTransaction(false, true);
                    try {
                        conglomerateController3 = transactionController3.openConglomerate(l, false, 4, 6, 5);
                        throw T_Fail.testFailMsg("(nestedUserTransaction) lock should have timed out.");
                    }
                    catch (StandardException standardException6) {
                        transactionController3.commit();
                        transactionController3.destroy();
                        transactionController.commit();
                        this.REPORT("(nestedUserTransaction) finishing");
                        return true;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean commitTest(TransactionController transactionController) throws StandardException, T_Fail {
        this.REPORT("(commitTest)");
        T_AccessRow t_AccessRow = new T_AccessRow(1);
        long l = transactionController.createConglomerate("heap", t_AccessRow.getRowArray(), null, null, null, 0);
        transactionController.commit();
        ConglomerateController conglomerateController = transactionController.openConglomerate(l, false, 4, 6, 5);
        T_AccessRow t_AccessRow2 = new T_AccessRow(1);
        SQLInteger sQLInteger = new SQLInteger(0);
        t_AccessRow2.setCol(0, (DataValueDescriptor)sQLInteger);
        RowLocation rowLocation = conglomerateController.newRowLocationTemplate();
        conglomerateController.insertAndFetchLocation(t_AccessRow2.getRowArray(), rowLocation);
        transactionController.commitNoSync(2);
        try {
            conglomerateController.newRowLocationTemplate();
            throw T_Fail.testFailMsg("conglomerate controller is not closed after commit");
        }
        catch (StandardException standardException) {
            ContextManager contextManager = T_AccessFactory.getContextService().newContextManager();
            T_AccessFactory.getContextService().setCurrentContextManager(contextManager);
            TransactionController transactionController2 = null;
            ConglomerateController conglomerateController2 = null;
            try {
                try {
                    transactionController2 = this.store.getTransaction(contextManager);
                    conglomerateController2 = transactionController2.openConglomerate(l, false, 4, 6, 5);
                    conglomerateController2.delete(rowLocation);
                    throw T_Fail.testFailMsg("expected time out did not happen");
                }
                catch (StandardException standardException2) {
                    if (!standardException2.getMessageId().equals("40XL1")) {
                        throw standardException2;
                    }
                    T_AccessFactory.getContextService().resetCurrentContextManager(contextManager);
                }
            }
            catch (Throwable throwable) {
                T_AccessFactory.getContextService().resetCurrentContextManager(contextManager);
                throw throwable;
            }
            if (transactionController.anyoneBlocked()) {
                throw T_Fail.testFailMsg("No transactions should be blocked");
            }
            transactionController.commit();
            T_AccessFactory.getContextService().setCurrentContextManager(contextManager);
            try {
                conglomerateController2.fetch(rowLocation, t_AccessRow2.getRowArray(), (FormatableBitSet)null);
                transactionController2.commitNoSync(1);
                transactionController2.destroy();
            }
            finally {
                T_AccessFactory.getContextService().resetCurrentContextManager(contextManager);
            }
            this.REPORT("(commitTest) succeeded");
            return true;
        }
    }

    private void testOpsBeforeFirstNext(ScanController scanController, DataValueDescriptor[] dataValueDescriptorArray) throws StandardException, T_Fail {
        try {
            scanController.delete();
            throw T_Fail.testFailMsg("(holdCursor) delete() does not work until next() is called.");
        }
        catch (StandardException standardException) {
            try {
                scanController.doesCurrentPositionQualify();
                throw T_Fail.testFailMsg("(holdCursor) doesCurrentPositionQualify() does not work until next() is called.");
            }
            catch (StandardException standardException2) {
                try {
                    scanController.fetch(dataValueDescriptorArray);
                    throw T_Fail.testFailMsg("(holdCursor) fetch() does not work until next() is called.");
                }
                catch (StandardException standardException3) {
                    try {
                        scanController.fetchLocation(null);
                        throw T_Fail.testFailMsg("(holdCursor) fetchLocation() does not work until next() is called.");
                    }
                    catch (StandardException standardException4) {
                        try {
                            scanController.isCurrentPositionDeleted();
                            throw T_Fail.testFailMsg("(holdCursor) isCurrentPositionDeleted() does not work until next() is called.");
                        }
                        catch (StandardException standardException5) {
                            try {
                                scanController.replace(dataValueDescriptorArray, null);
                                throw T_Fail.testFailMsg("(holdCursor) isCurrentPositionDeleted() does not work until next() is called.");
                            }
                            catch (StandardException standardException6) {
                                return;
                            }
                        }
                    }
                }
            }
        }
    }

    protected boolean holdCursor(TransactionController transactionController) throws StandardException, T_Fail {
        this.REPORT("(holdCursor)");
        long l = this.createAConglom(transactionController, 0, false);
        ConglomerateController conglomerateController = transactionController.openConglomerate(l, false, 4, 6, 5);
        T_AccessRow t_AccessRow = null;
        SQLLongint sQLLongint = null;
        for (int i = 1; i < 5; ++i) {
            t_AccessRow = new T_AccessRow(1);
            sQLLongint = new SQLLongint((long)i);
            t_AccessRow.setCol(0, (DataValueDescriptor)sQLLongint);
            RowLocation rowLocation = conglomerateController.newRowLocationTemplate();
            conglomerateController.insertAndFetchLocation(t_AccessRow.getRowArray(), rowLocation);
        }
        long l2 = this.createBtree(transactionController, l, false);
        transactionController.commit();
        conglomerateController.close();
        transactionController.commit();
        ScanController scanController = transactionController.openScan(l, false, 4, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
        ScanController scanController2 = transactionController.openScan(l2, false, 4, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
        this.testOpsBeforeFirstNext(scanController, t_AccessRow.getRowArray());
        this.testOpsBeforeFirstNext(scanController2, t_AccessRow.getRowArray());
        scanController.next();
        scanController2.next();
        scanController.next();
        scanController2.next();
        scanController.next();
        scanController2.next();
        scanController.next();
        scanController2.next();
        scanController.next();
        scanController2.next();
        scanController.next();
        scanController2.next();
        scanController.next();
        scanController2.next();
        long l3 = scanController.getEstimatedRowCount();
        scanController.setEstimatedRowCount(10L);
        l3 = scanController.getEstimatedRowCount();
        l3 = scanController2.getEstimatedRowCount();
        scanController2.setEstimatedRowCount(10L);
        l3 = scanController2.getEstimatedRowCount();
        if (l3 != 10L) {
            throw T_Fail.testFailMsg("(holdCursor) some problem with get/set row count.");
        }
        transactionController.commit();
        this.testOpsBeforeFirstNext(scanController, t_AccessRow.getRowArray());
        this.testOpsBeforeFirstNext(scanController2, t_AccessRow.getRowArray());
        if (scanController.next()) {
            throw T_Fail.testFailMsg("(holdCursor) next() should return false, commit should close base_scan.");
        }
        if (scanController2.next()) {
            throw T_Fail.testFailMsg("(holdCursor) next() should return false, commit should close base_scan.");
        }
        transactionController.commit();
        scanController = transactionController.openScan(l, true, 4, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
        scanController2 = transactionController.openScan(l2, true, 4, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
        transactionController.commit();
        this.testOpsBeforeFirstNext(scanController, t_AccessRow.getRowArray());
        this.testOpsBeforeFirstNext(scanController2, t_AccessRow.getRowArray());
        if (!scanController.next()) {
            throw T_Fail.testFailMsg("(holdCursor) next() should not fail, commit should close hold scan.");
        }
        if (!scanController2.next()) {
            throw T_Fail.testFailMsg("(holdCursor) next() should not fail, commit should close hold scan.");
        }
        scanController.fetch(t_AccessRow.getRowArray());
        long l4 = ((SQLLongint)t_AccessRow.getCol(0)).getLong();
        if (l4 != 0L) {
            throw T_Fail.testFailMsg("(holdCursor) 1st row is not 0.");
        }
        scanController2.fetch(t_AccessRow.getRowArray());
        l4 = ((SQLLongint)t_AccessRow.getCol(0)).getLong();
        if (l4 != 0L) {
            throw T_Fail.testFailMsg("(holdCursor) 1st row is not 0.");
        }
        scanController.next();
        scanController2.next();
        transactionController.commit();
        this.testOpsBeforeFirstNext(scanController, t_AccessRow.getRowArray());
        this.testOpsBeforeFirstNext(scanController2, t_AccessRow.getRowArray());
        l3 = scanController.getEstimatedRowCount();
        scanController.setEstimatedRowCount(5L);
        l3 = scanController.getEstimatedRowCount();
        l3 = scanController2.getEstimatedRowCount();
        scanController2.setEstimatedRowCount(5L);
        l3 = scanController2.getEstimatedRowCount();
        if (l3 != 5L) {
            throw T_Fail.testFailMsg("(holdCursor) some problem with get/set row count.");
        }
        if (!scanController.next()) {
            throw T_Fail.testFailMsg("(holdCursor) next() should not fail, commit should close hold base_scan.");
        }
        if (!scanController2.next()) {
            throw T_Fail.testFailMsg("(holdCursor) next() should not fail, commit should close hold base_scan.");
        }
        scanController.fetch(t_AccessRow.getRowArray());
        l4 = ((SQLLongint)t_AccessRow.getCol(0)).getLong();
        if (l4 != 2L) {
            throw T_Fail.testFailMsg("(holdCursor) 1st row is not 0.");
        }
        scanController2.fetch(t_AccessRow.getRowArray());
        l4 = ((SQLLongint)t_AccessRow.getCol(0)).getLong();
        if (l4 != 2L) {
            throw T_Fail.testFailMsg("(holdCursor) 1st row is not 0.");
        }
        scanController.next();
        scanController.delete();
        scanController2.next();
        scanController2.delete();
        scanController.next();
        scanController2.next();
        scanController.next();
        scanController2.next();
        transactionController.commit();
        l3 = scanController.getEstimatedRowCount();
        scanController.setEstimatedRowCount(15L);
        l3 = scanController.getEstimatedRowCount();
        if (l3 != 15L) {
            throw T_Fail.testFailMsg("(holdCursor) some problem with get/set row count.");
        }
        l3 = scanController2.getEstimatedRowCount();
        scanController2.setEstimatedRowCount(15L);
        l3 = scanController2.getEstimatedRowCount();
        if (l3 != 15L) {
            throw T_Fail.testFailMsg("(holdCursor) some problem with get/set row count.");
        }
        this.testOpsBeforeFirstNext(scanController, t_AccessRow.getRowArray());
        this.testOpsBeforeFirstNext(scanController2, t_AccessRow.getRowArray());
        if (scanController.next()) {
            throw T_Fail.testFailMsg("(holdCursor) next() should fail, the base_scan has been closed by progressing to end.");
        }
        if (scanController2.next()) {
            throw T_Fail.testFailMsg("(holdCursor) next() should fail, the base_scan has been closed by progressing to end.");
        }
        transactionController.commit();
        scanController.close();
        scanController2.close();
        this.REPORT("(holdCursor) succeeded");
        return true;
    }

    protected boolean positionAtRowLocation(TransactionController transactionController) throws StandardException, T_Fail {
        SQLLongint sQLLongint;
        this.REPORT("(positionAtRowLocation)");
        long l = this.createAConglom(transactionController, 0, false);
        ConglomerateController conglomerateController = transactionController.openConglomerate(l, false, 4, 6, 5);
        T_AccessRow t_AccessRow = null;
        for (int i = 1; i < 5; ++i) {
            t_AccessRow = new T_AccessRow(1);
            sQLLongint = new SQLLongint((long)i);
            t_AccessRow.setCol(0, (DataValueDescriptor)sQLLongint);
            conglomerateController.insert(t_AccessRow.getRowArray());
        }
        transactionController.commit();
        conglomerateController.close();
        ScanController scanController = transactionController.openScan(l, true, 4, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
        scanController.next();
        sQLLongint = scanController.newRowLocationTemplate();
        scanController.fetchLocation((RowLocation)sQLLongint);
        scanController.fetch(t_AccessRow.getRowArray());
        long l2 = ((SQLLongint)t_AccessRow.getCol(0)).getLong();
        if (l2 != 0L) {
            throw T_Fail.testFailMsg("(positionAtRowLocation_err_1) 1st row is not 0 it is:" + l2);
        }
        scanController.next();
        scanController.fetch(t_AccessRow.getRowArray());
        l2 = ((SQLLongint)t_AccessRow.getCol(0)).getLong();
        if (l2 != 1L) {
            throw T_Fail.testFailMsg("(positionAtRowLocation_err_2) 2nd row is not 1 it is:" + l2);
        }
        scanController.next();
        scanController.fetch(t_AccessRow.getRowArray());
        l2 = ((SQLLongint)t_AccessRow.getCol(0)).getLong();
        if (l2 != 2L) {
            throw T_Fail.testFailMsg("(positionAtRowLocation_err_3) 3d row is not 2 it is:" + l2);
        }
        if (!scanController.positionAtRowLocation((RowLocation)sQLLongint)) {
            throw T_Fail.testFailMsg("(positionAtRowLocation_err_4) Failed to position at RowLocation");
        }
        scanController.fetch(t_AccessRow.getRowArray());
        l2 = ((SQLLongint)t_AccessRow.getCol(0)).getLong();
        if (l2 != 0L) {
            throw T_Fail.testFailMsg("(positionAtRowLocation_err_5) 1st row is not 0 it is:" + l2);
        }
        transactionController.commit();
        scanController.next();
        scanController.fetch(t_AccessRow.getRowArray());
        l2 = ((SQLLongint)t_AccessRow.getCol(0)).getLong();
        if (l2 != 1L) {
            throw T_Fail.testFailMsg("(positionAtRowLocation_err_6) 2nd row is not 1 it is:" + l2);
        }
        scanController.next();
        scanController.fetch(t_AccessRow.getRowArray());
        l2 = ((SQLLongint)t_AccessRow.getCol(0)).getLong();
        if (l2 != 2L) {
            throw T_Fail.testFailMsg("(positionAtRowLocation_err_7) 3d row is not 2 it is:" + l2);
        }
        if (!scanController.positionAtRowLocation((RowLocation)sQLLongint)) {
            throw T_Fail.testFailMsg("(positionAtRowLocation_err_8) Failed to position at RowLocation after commit");
        }
        scanController.fetch(t_AccessRow.getRowArray());
        l2 = ((SQLLongint)t_AccessRow.getCol(0)).getLong();
        if (l2 != 0L) {
            throw T_Fail.testFailMsg("(positionAtRowLocation_err_9) 1st row is not 0 it is:" + l2);
        }
        scanController.next();
        scanController.fetch(t_AccessRow.getRowArray());
        l2 = ((SQLLongint)t_AccessRow.getCol(0)).getLong();
        if (l2 != 1L) {
            throw T_Fail.testFailMsg("(positionAtRowLocation_err_10) 2nd row is not 1 it is:" + l2);
        }
        scanController.next();
        scanController.fetch(t_AccessRow.getRowArray());
        l2 = ((SQLLongint)t_AccessRow.getCol(0)).getLong();
        if (l2 != 2L) {
            throw T_Fail.testFailMsg("(positionAtRowLocation_err_10) 3d row is not 2 it is:" + l2);
        }
        scanController.reopenScanByRowLocation((RowLocation)sQLLongint, null);
        scanController.next();
        scanController.fetch(t_AccessRow.getRowArray());
        l2 = ((SQLLongint)t_AccessRow.getCol(0)).getLong();
        if (l2 != 0L) {
            throw T_Fail.testFailMsg("(positionAtRowLocation_err_11) 1st row is not 0 it is:" + l2);
        }
        transactionController.commit();
        transactionController.compressConglomerate(l);
        transactionController.commit();
        scanController.next();
        scanController.fetch(t_AccessRow.getRowArray());
        l2 = ((SQLLongint)t_AccessRow.getCol(0)).getLong();
        if (l2 != 1L) {
            throw T_Fail.testFailMsg("(positionAtRowLocation_err_12) 2nd row is not 1 it is:" + l2);
        }
        if (scanController.positionAtRowLocation((RowLocation)sQLLongint)) {
            throw T_Fail.testFailMsg("(positionAtRowLocation_err_12) Unexpectedly succeeded at positioning at RowLocation after compress");
        }
        scanController.close();
        this.REPORT("(positionAtRowLocation) succeeded");
        return true;
    }

    protected boolean readUncommitted(TransactionController transactionController) throws StandardException, T_Fail {
        int n;
        this.REPORT("(readUncommitted)");
        Object object = new String("0123456789012345");
        for (int i = 0; i < 7; ++i) {
            object = (String)object + (String)object;
        }
        T_AccessRow t_AccessRow = new T_AccessRow(2);
        t_AccessRow.setCol(1, (DataValueDescriptor)new SQLChar((String)object));
        long l = transactionController.createConglomerate("heap", t_AccessRow.getRowArray(), null, null, null, 0);
        ConglomerateController conglomerateController = transactionController.openConglomerate(l, false, 4, 6, 1);
        for (int i = 0; i < 10; ++i) {
            t_AccessRow.setCol(0, (DataValueDescriptor)new SQLInteger(i));
            conglomerateController.insert(t_AccessRow.getRowArray());
        }
        conglomerateController.close();
        ScanController scanController = transactionController.openScan(l, true, 4, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
        RowLocation rowLocation = scanController.newRowLocationTemplate();
        for (int i = 0; i < 10; ++i) {
            scanController.next();
            scanController.fetchLocation(rowLocation);
            scanController.delete();
            transactionController.commit();
        }
        scanController.close();
        transactionController.commit();
        conglomerateController = transactionController.openConglomerate(l, false, 0, 6, 1);
        if (conglomerateController.fetch(rowLocation, t_AccessRow.getRowArray(), null)) {
            throw T_Fail.testFailMsg("(readUncommitted) fetch should ret false for reclaimed page.");
        }
        FormatableBitSet formatableBitSet = new FormatableBitSet(1);
        if (conglomerateController.replace(rowLocation, t_AccessRow.getRowArray(), formatableBitSet)) {
            throw T_Fail.testFailMsg("(readUncommitted) delete should ret false for reclaimed page.");
        }
        if (conglomerateController.fetch(rowLocation, t_AccessRow.getRowArray(), null, true)) {
            throw T_Fail.testFailMsg("(readUncommitted) fetch should ret false for reclaimed page.");
        }
        if (conglomerateController.delete(rowLocation)) {
            throw T_Fail.testFailMsg("(readUncommitted) delete should ret false for reclaimed page.");
        }
        conglomerateController.close();
        SQLChar sQLChar = new SQLChar();
        sQLChar.setValue(T_AccessFactory.repeatString("012345678901234", 100));
        t_AccessRow.setCol(1, (DataValueDescriptor)sQLChar);
        l = transactionController.createConglomerate("heap", t_AccessRow.getRowArray(), null, null, null, 0);
        conglomerateController = transactionController.openConglomerate(l, false, 4, 6, 1);
        for (int i = 0; i < 3; ++i) {
            t_AccessRow.setCol(0, (DataValueDescriptor)new SQLInteger(i));
            conglomerateController.insert(t_AccessRow.getRowArray());
        }
        scanController = transactionController.openScan(l, true, 4, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
        RowLocation rowLocation2 = scanController.newRowLocationTemplate();
        for (n = 0; n < 3; ++n) {
            scanController.next();
            scanController.fetchLocation(rowLocation2);
            scanController.delete();
        }
        conglomerateController.insert(t_AccessRow.getRowArray());
        conglomerateController.close();
        scanController.close();
        transactionController.commit();
        conglomerateController = transactionController.openConglomerate(l, false, 0, 6, 1);
        if (conglomerateController.fetch(rowLocation2, t_AccessRow.getRowArray(), null)) {
            throw T_Fail.testFailMsg("(readUncommitted) fetch should ret false for reclaimed row.");
        }
        if (conglomerateController.replace(rowLocation, t_AccessRow.getRowArray(), formatableBitSet)) {
            throw T_Fail.testFailMsg("(readUncommitted) delete should ret false for reclaimed page.");
        }
        if (conglomerateController.fetch(rowLocation, t_AccessRow.getRowArray(), null, true)) {
            throw T_Fail.testFailMsg("(readUncommitted) fetch should ret false for reclaimed page.");
        }
        if (conglomerateController.delete(rowLocation)) {
            throw T_Fail.testFailMsg("(readUncommitted) delete should ret false for reclaimed page.");
        }
        conglomerateController.close();
        t_AccessRow = new T_AccessRow(2);
        t_AccessRow.setCol(1, (DataValueDescriptor)new SQLChar((String)object));
        l = transactionController.createConglomerate("heap", t_AccessRow.getRowArray(), null, null, null, 0);
        conglomerateController = transactionController.openConglomerate(l, false, 4, 6, 1);
        for (n = 0; n < 10; ++n) {
            t_AccessRow.setCol(0, (DataValueDescriptor)new SQLInteger(n));
            conglomerateController.insert(t_AccessRow.getRowArray());
        }
        conglomerateController.close();
        scanController = transactionController.openScan(l, true, 0, 6, 1, (FormatableBitSet)null, null, 0, null, null, 0);
        scanController.next();
        scanController.next();
        scanController.next();
        if (!scanController.doesCurrentPositionQualify()) {
            throw T_Fail.testFailMsg("(readUncommitted) doesCurrentPositionQualify() failed.");
        }
        scanController.fetch(t_AccessRow.getRowArray());
        scanController.fetchLocation(rowLocation2);
        if (scanController.isCurrentPositionDeleted()) {
            throw T_Fail.testFailMsg("(readUncommitted) isCurrentPositionDeleted() failed.");
        }
        ScanController scanController2 = transactionController.openScan(l, true, 4, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
        for (int i = 0; i < 10; ++i) {
            scanController2.next();
            scanController2.fetchLocation(rowLocation);
            scanController2.delete();
        }
        scanController2.close();
        if (scanController.doesCurrentPositionQualify()) {
            throw T_Fail.testFailMsg("(readUncommitted) doesCurrentPositionQualify() failed.");
        }
        try {
            scanController.fetch(t_AccessRow.getRowArray());
            throw T_Fail.testFailMsg("(readUncommitted) fetch of deleted row should throw exception.");
        }
        catch (StandardException standardException) {
            if (!standardException.getMessageId().equals("XSAM6.S")) {
                throw T_Fail.testFailMsg("(readUncommitted) fetch of deleted row should throw SQLState.AM_RECORD_NOT_FOUND.");
            }
            scanController.fetchLocation(rowLocation2);
            if (!scanController.isCurrentPositionDeleted()) {
                throw T_Fail.testFailMsg("(readUncommitted) isCurrentPositionDeleted() failed.");
            }
            scanController.close();
            transactionController.commit();
            this.REPORT("(readUncommitted) succeeded");
            return true;
        }
    }

    public static String repeatString(String string, int n) {
        Object object = string;
        for (int i = 1; i < n; ++i) {
            object = (String)object + string;
        }
        return object;
    }

    private static ContextService getContextService() {
        return ContextService.getFactory();
    }

    private static Object findServiceModule(Object object, String string) throws StandardException {
        return Monitor.findServiceModule((Object)object, (String)string);
    }

    private static Object createPersistentService(String string, String string2, Properties properties) throws StandardException {
        return Monitor.createPersistentService((String)string, (String)string2, (Properties)properties);
    }
}

