/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import org.apache.derby.tools.JDBCDisplayUtil;
import org.apache.derby.tools.ij;
import org.apache.derbyTesting.functionTests.util.Formatters;

public class concateTests {
    private static String[] concatenatedSQLTypesNames = new String[]{"CHAR", "VARCHAR", "LONG VARCHAR", "CLOB", "CHAR () FOR BIT DATA", "VARCHAR () FOR BIT DATA", "LONG VARCHAR FOR BIT DATA", "BLOB"};

    public static void main(String[] stringArray) throws Throwable {
        ij.getPropertyArg((String[])stringArray);
        Connection connection = ij.startJBMS();
        concateTests.testCharConcatenation(connection);
        concateTests.testCharForBitDataConcatenation(connection);
    }

    public static void testCharConcatenation(Connection connection) throws Throwable {
        try {
            System.out.println("Test1 - CHAR, VARCHAR, LONGVARCHAR and CLOB concatenation tests");
            String string = Formatters.repeatChar("a", 40);
            String string2 = "z";
            String string3 = Formatters.repeatChar("b", 32698);
            StringBuffer stringBuffer = new StringBuffer();
            Statement statement = connection.createStatement();
            try {
                statement.executeUpdate("drop table t1");
            }
            catch (Exception exception) {
                // empty catch block
            }
            statement.executeUpdate("create table t1 (c1 char(254), c2 char(40), vc1 varchar(264), vc2 varchar(4000), vc3 varchar(1), lvc1 long varchar, lvc2 long varchar)");
            PreparedStatement preparedStatement = connection.prepareStatement("insert into t1(c2, vc3) values(?, ?)");
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            preparedStatement.executeUpdate();
            preparedStatement = connection.prepareStatement("update t1 set lvc2 = ?");
            preparedStatement.setString(1, string3);
            preparedStatement.executeUpdate();
            System.out.println("Test1a - CHAR concatenations will give result type of CHAR when concatenated string < 255");
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select c2 || c2 || c2 || c2 || c2 || c2 || '12345678901234' from t1)"), concatenatedSQLTypesNames[0]);
            stringBuffer = new StringBuffer(string);
            stringBuffer.append(string).append(string).append(string).append(string).append(string);
            stringBuffer.append("12345678901234");
            String string4 = stringBuffer.toString();
            concateTests.verifyStringData(statement.executeQuery("values(select c2 || c2 || c2 || c2 || c2 || c2 || '12345678901234' from t1)"), string4);
            statement.executeUpdate("update t1 set c1 = c2 || c2 || c2 || c2 || c2 || c2 || '12345678901234'");
            concateTests.verifyStringData(statement.executeQuery("select c1 from t1"), string4);
            System.out.println("Test1b boundary test - CHAR concatenations will give result type of VARCHAR when concatenated string = 255");
            Object object = string4 + "1";
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select c1 || '1' from t1)"), concatenatedSQLTypesNames[1]);
            concateTests.verifyStringData(statement.executeQuery("values(select c1 || '1' from t1)"), (String)object);
            statement.executeUpdate("update t1 set vc1 = c1 || '1'");
            concateTests.verifyStringData(statement.executeQuery("select vc1 from t1"), (String)object);
            System.out.println("Test1b - CHAR concatenations will give result type of VARCHAR when concatenated string > 254");
            object = string4 + "1234567890";
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select c1 || '1234567890' from t1)"), concatenatedSQLTypesNames[1]);
            concateTests.verifyStringData(statement.executeQuery("values(select c1 || '1234567890' from t1)"), (String)object);
            statement.executeUpdate("update t1 set vc1 = c1 || '1234567890'");
            concateTests.verifyStringData(statement.executeQuery("select vc1 from t1"), (String)object);
            System.out.println("Test1c - CHAR and VARCHAR concatenations will give result type of VARCHAR when concatenated string < 4001");
            stringBuffer = new StringBuffer(string);
            stringBuffer.append((String)object).append((String)object).append((String)object).append((String)object).append((String)object);
            stringBuffer.append((String)object).append((String)object).append((String)object).append((String)object).append((String)object);
            stringBuffer.append((String)object).append((String)object).append((String)object).append((String)object).append((String)object);
            String string5 = stringBuffer.toString();
            Object object2 = stringBuffer.toString();
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select c2||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1 from t1)"), concatenatedSQLTypesNames[1]);
            concateTests.verifyStringData(statement.executeQuery("values(select c2||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1 from t1)"), string5);
            statement.executeUpdate("update t1 set vc2 = c2||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1");
            concateTests.verifyStringData(statement.executeQuery("select vc2 from t1"), string5);
            statement.executeUpdate("update t1 set lvc1 = c2||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1");
            concateTests.verifyStringData(statement.executeQuery("select lvc1 from t1"), (String)object2);
            System.out.println("Test1d - VARCHAR and CHAR concatenations will give result type of VARCHAR when concatenated string < 4001");
            stringBuffer = new StringBuffer();
            stringBuffer.append((String)object).append((String)object).append((String)object).append((String)object).append((String)object);
            stringBuffer.append((String)object).append((String)object).append((String)object).append((String)object).append((String)object);
            stringBuffer.append((String)object).append((String)object).append((String)object).append((String)object).append((String)object);
            stringBuffer.append(string);
            string5 = stringBuffer.toString();
            object2 = stringBuffer.toString();
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||c2 from t1)"), concatenatedSQLTypesNames[1]);
            concateTests.verifyStringData(statement.executeQuery("values(select vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||c2 from t1)"), string5);
            statement.executeUpdate("update t1 set vc2 = vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||c2");
            concateTests.verifyStringData(statement.executeQuery("select vc2 from t1"), string5);
            statement.executeUpdate("update t1 set lvc1 = vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||vc1||c2");
            concateTests.verifyStringData(statement.executeQuery("select lvc1 from t1"), (String)object2);
            System.out.println("Test1e boundary test - CHAR and VARCHAR concatenations will give result type of LONG VARCHAR when concatenated string = 4001");
            object2 = "a" + string5;
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select 'a'||vc2 from t1)"), concatenatedSQLTypesNames[2]);
            concateTests.verifyStringData(statement.executeQuery("values(select 'a'||vc2 from t1)"), (String)object2);
            statement.executeUpdate("update t1 set lvc1 = 'a'||vc2");
            concateTests.verifyStringData(statement.executeQuery("select lvc1 from t1"), (String)object2);
            System.out.println("Test1f boundary test - VARCHAR and CHAR concatenations will give result type of LONG VARCHAR when concatenated string = 4001");
            object2 = string5 + "a";
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select vc2 || 'a' from t1)"), concatenatedSQLTypesNames[2]);
            concateTests.verifyStringData(statement.executeQuery("values(select vc2 || 'a' from t1)"), (String)object2);
            statement.executeUpdate("update t1 set lvc1 = vc2 || 'a'");
            concateTests.verifyStringData(statement.executeQuery("select lvc1 from t1"), (String)object2);
            System.out.println("Test1g - CHAR and LONG VARCHAR concatenations will give result type of LONG VARCHAR");
            object2 = "a" + (String)object2;
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select 'a' || lvc1 from t1)"), concatenatedSQLTypesNames[2]);
            concateTests.verifyStringData(statement.executeQuery("values(select 'a' || lvc1 from t1)"), (String)object2);
            statement.executeUpdate("update t1 set lvc1 = 'a' || lvc1");
            concateTests.verifyStringData(statement.executeQuery("select lvc1 from t1"), (String)object2);
            System.out.println("Test1h - VARCHAR and LONG VARCHAR concatenations will give result type of LONG VARCHAR");
            object2 = (String)object + (String)object2;
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select vc1 || lvc1 from t1)"), concatenatedSQLTypesNames[2]);
            concateTests.verifyStringData(statement.executeQuery("values(select vc1 || lvc1 from t1)"), (String)object2);
            statement.executeUpdate("update t1 set lvc1 = vc1 || lvc1");
            concateTests.verifyStringData(statement.executeQuery("select lvc1 from t1"), (String)object2);
            System.out.println("Test1i - VARCHAR and VARCHAR concatenations will give result type of VARCHAR when concatenated string < 4001");
            object2 = (String)object + (String)object;
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select vc1 || vc1 from t1)"), concatenatedSQLTypesNames[1]);
            concateTests.verifyStringData(statement.executeQuery("values(select vc1 || vc1 from t1)"), (String)object2);
            statement.executeUpdate("update t1 set lvc1 = vc1 || vc1");
            concateTests.verifyStringData(statement.executeQuery("select lvc1 from t1"), (String)object2);
            System.out.println("Test1j boundary test - VARCHAR and VARCHAR concatenations will give result type of LONG VARCHAR when concatenated string = 4001");
            object2 = string5 + string2;
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select vc2 || vc3 from t1)"), concatenatedSQLTypesNames[2]);
            concateTests.verifyStringData(statement.executeQuery("values(select vc2 || vc3 from t1)"), (String)object2);
            statement.executeUpdate("update t1 set lvc1 = vc2 || vc3");
            concateTests.verifyStringData(statement.executeQuery("select lvc1 from t1"), (String)object2);
            System.out.println("Test1j - VARCHAR and VARCHAR concatenations will give result type of LONG VARCHAR when concatenated string > 4000");
            object2 = (String)object + string5;
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select vc1 || vc2 from t1)"), concatenatedSQLTypesNames[2]);
            concateTests.verifyStringData(statement.executeQuery("values(select vc1 || vc2 from t1)"), (String)object2);
            statement.executeUpdate("update t1 set lvc1 = vc1 || vc2");
            concateTests.verifyStringData(statement.executeQuery("select lvc1 from t1"), (String)object2);
            System.out.println("Test1k - LONG VARCHAR and LONG VARCHAR concatenations will give result type of LONG VARCHAR");
            object2 = (String)object2 + (String)object2;
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select lvc1 || lvc1 from t1)"), concatenatedSQLTypesNames[2]);
            concateTests.verifyStringData(statement.executeQuery("values(select lvc1 || lvc1 from t1)"), (String)object2);
            statement.executeUpdate("update t1 set lvc1 = lvc1 || lvc1");
            concateTests.verifyStringData(statement.executeQuery("select lvc1 from t1"), (String)object2);
            System.out.println("Test1l - CHAR and LONGVARCHAR concatenation resulting in concatenated string > 32700 will give error");
            try {
                concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select c2 || lvc2 from t1)"), concatenatedSQLTypesNames[2]);
                System.out.println("FAIL - should have gotten overflow error for values");
            }
            catch (SQLException sQLException) {
                if (sQLException.getSQLState().equals("54006")) {
                    System.out.println("expected exception " + sQLException.getMessage());
                }
                concateTests.dumpSQLExceptions(sQLException);
            }
            try {
                statement.executeUpdate("update t1 set lvc2 = c2 || lvc2");
                System.out.println("FAIL - should have gotten overflow error for insert");
            }
            catch (SQLException sQLException) {
                if (sQLException.getSQLState().equals("54006")) {
                    System.out.println("expected exception " + sQLException.getMessage());
                }
                concateTests.dumpSQLExceptions(sQLException);
            }
            System.out.println("Test1m - VARCHAR and LONGVARCHAR concatenation resulting in concatenated string > 32700 will give error");
            try {
                concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select vc1 || lvc2 from t1)"), concatenatedSQLTypesNames[2]);
                System.out.println("FAIL - should have gotten overflow error for values");
            }
            catch (SQLException sQLException) {
                if (sQLException.getSQLState().equals("54006")) {
                    System.out.println("expected exception " + sQLException.getMessage());
                }
                concateTests.dumpSQLExceptions(sQLException);
            }
            try {
                statement.executeUpdate("update t1 set lvc2 = vc1 || lvc2");
                System.out.println("FAIL - should have gotten overflow error for insert");
            }
            catch (SQLException sQLException) {
                if (sQLException.getSQLState().equals("54006")) {
                    System.out.println("expected exception " + sQLException.getMessage());
                }
                concateTests.dumpSQLExceptions(sQLException);
            }
            System.out.println("Test1n - LONGVARCHAR and LONGVARCHAR concatenation resulting in concatenated string > 32700 will give error");
            try {
                concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select lvc1 || lvc2 from t1)"), concatenatedSQLTypesNames[2]);
                System.out.println("FAIL - should have gotten overflow error for values");
            }
            catch (SQLException sQLException) {
                if (sQLException.getSQLState().equals("54006")) {
                    System.out.println("expected exception " + sQLException.getMessage());
                }
                concateTests.dumpSQLExceptions(sQLException);
            }
            try {
                statement.executeUpdate("update t1 set lvc2 = lvc1 || lvc2");
                System.out.println("FAIL - should have gotten overflow error for insert");
            }
            catch (SQLException sQLException) {
                if (sQLException.getSQLState().equals("54006")) {
                    System.out.println("expected exception " + sQLException.getMessage());
                }
                concateTests.dumpSQLExceptions(sQLException);
            }
            try {
                statement.executeUpdate("drop table testCLOB_MAIN");
            }
            catch (Exception exception) {
                // empty catch block
            }
            statement.executeUpdate("create table testCLOB_MAIN (c1 char(10), vc1 varchar(100), lvc1 long varchar, clob1 CLOB(2G), clob2 CLOB(256), clob3 CLOB(1M))");
            preparedStatement = connection.prepareStatement("insert into testCLOB_MAIN values(?,?,?,?,?,?)");
            string4 = "1234567890";
            preparedStatement.setString(1, string4);
            object = "this is varchar";
            preparedStatement.setString(2, (String)object);
            object2 = "this is long varchar";
            preparedStatement.setString(3, (String)object2);
            Object object3 = "this is 2G clob";
            preparedStatement.setString(4, (String)object3);
            Object object4 = "this is 256 characters clob";
            preparedStatement.setString(5, (String)object4);
            String string6 = "this is 1M clob";
            preparedStatement.setString(6, string6);
            preparedStatement.executeUpdate();
            System.out.println("Test1o - CHAR(A) and CLOB(B) concatenations will give result type of CLOB(A+B) when A+B<2G");
            object4 = string4 + "this is 256 characters clob";
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select c1 || clob2 from testCLOB_MAIN)"), concatenatedSQLTypesNames[3]);
            concateTests.verifyStringData(statement.executeQuery("values(select c1 || clob2 from testCLOB_MAIN)"), (String)object4);
            statement.executeUpdate("update testCLOB_MAIN set clob2 = c1 || clob2");
            concateTests.verifyStringData(statement.executeQuery("select clob2 from testCLOB_MAIN"), (String)object4);
            System.out.println("Test1p - CLOB(A) and CHAR(B) concatenations will give result type of CLOB(A+B) when A+B<2G");
            object4 = (String)object4 + string4;
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select clob2 || c1 from testCLOB_MAIN)"), concatenatedSQLTypesNames[3]);
            concateTests.verifyStringData(statement.executeQuery("values(select clob2 || c1 from testCLOB_MAIN)"), (String)object4);
            statement.executeUpdate("update testCLOB_MAIN set clob2 = clob2 || c1");
            concateTests.verifyStringData(statement.executeQuery("select clob2 from testCLOB_MAIN"), (String)object4);
            System.out.println("Test1q - CHAR(A) and CLOB(B) concatenations will give result type of CLOB(2G) when A+B>2G");
            object3 = string4 + (String)object3;
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select c1 || clob1 from testCLOB_MAIN)"), concatenatedSQLTypesNames[3]);
            concateTests.verifyStringData(statement.executeQuery("values(select c1 || clob1 from testCLOB_MAIN)"), (String)object3);
            statement.executeUpdate("update testCLOB_MAIN set clob1 = c1 || clob1");
            concateTests.verifyStringData(statement.executeQuery("select clob1 from testCLOB_MAIN"), (String)object3);
            System.out.println("Test1r - CLOB(A) and CHAR(B) concatenations will give result type of CLOB(2G) when A+B>2G");
            object3 = (String)object3 + string4;
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select clob1 || c1 from testCLOB_MAIN)"), concatenatedSQLTypesNames[3]);
            concateTests.verifyStringData(statement.executeQuery("values(select clob1 || c1 from testCLOB_MAIN)"), (String)object3);
            statement.executeUpdate("update testCLOB_MAIN set clob1 = clob1 || c1");
            concateTests.verifyStringData(statement.executeQuery("select clob1 from testCLOB_MAIN"), (String)object3);
            System.out.println("Test1s - VARCHAR(A) and CLOB(B) concatenations will give result type of CLOB(A+B) when A+B<2G");
            object4 = (String)object + (String)object4;
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select vc1 || clob2 from testCLOB_MAIN)"), concatenatedSQLTypesNames[3]);
            concateTests.verifyStringData(statement.executeQuery("values(select vc1 || clob2 from testCLOB_MAIN)"), (String)object4);
            statement.executeUpdate("update testCLOB_MAIN set clob2 = vc1 || clob2");
            concateTests.verifyStringData(statement.executeQuery("select clob2 from testCLOB_MAIN"), (String)object4);
            System.out.println("Test1t - CLOB(A) and VARCHAR(B) concatenations will give result type of CLOB(A+B) when A+B<2G");
            object4 = (String)object4 + (String)object;
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select clob2 || vc1 from testCLOB_MAIN)"), concatenatedSQLTypesNames[3]);
            concateTests.verifyStringData(statement.executeQuery("values(select clob2 || vc1 from testCLOB_MAIN)"), (String)object4);
            statement.executeUpdate("update testCLOB_MAIN set clob2 = clob2 || vc1");
            concateTests.verifyStringData(statement.executeQuery("select clob2 from testCLOB_MAIN"), (String)object4);
            System.out.println("Test1u - VARCHAR(A) and CLOB(B) concatenations will give result type of CLOB(2G) when A+B>2G");
            object3 = (String)object + (String)object3;
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select vc1 || clob1 from testCLOB_MAIN)"), concatenatedSQLTypesNames[3]);
            concateTests.verifyStringData(statement.executeQuery("values(select vc1 || clob1 from testCLOB_MAIN)"), (String)object3);
            statement.executeUpdate("update testCLOB_MAIN set clob1 = vc1 || clob1");
            concateTests.verifyStringData(statement.executeQuery("select clob1 from testCLOB_MAIN"), (String)object3);
            System.out.println("Test1v - CLOB(A) and VARCHAR(B) concatenations will give result type of CLOB(2G) when A+B>2G");
            object3 = (String)object3 + (String)object;
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select clob1 || vc1 from testCLOB_MAIN)"), concatenatedSQLTypesNames[3]);
            concateTests.verifyStringData(statement.executeQuery("values(select clob1 || vc1 from testCLOB_MAIN)"), (String)object3);
            statement.executeUpdate("update testCLOB_MAIN set clob1 = clob1 || vc1");
            concateTests.verifyStringData(statement.executeQuery("select clob1 from testCLOB_MAIN"), (String)object3);
            System.out.println("Test1w - LONG VARCHAR and CLOB(A) concatenations will give result type of CLOB(A+32K) when A+32K<2G");
            object4 = (String)object2 + (String)object4;
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select lvc1 || clob2 from testCLOB_MAIN)"), concatenatedSQLTypesNames[3]);
            concateTests.verifyStringData(statement.executeQuery("values(select lvc1 || clob2 from testCLOB_MAIN)"), (String)object4);
            statement.executeUpdate("update testCLOB_MAIN set clob2 = lvc1 || clob2");
            concateTests.verifyStringData(statement.executeQuery("select clob2 from testCLOB_MAIN"), (String)object4);
            System.out.println("Test1x - CLOB(A) and LONG VARCHAR concatenations will give result type of CLOB(A+32K) when A+32K<2G");
            object4 = (String)object4 + (String)object2;
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select clob2 || lvc1 from testCLOB_MAIN)"), concatenatedSQLTypesNames[3]);
            concateTests.verifyStringData(statement.executeQuery("values(select clob2 || lvc1 from testCLOB_MAIN)"), (String)object4);
            statement.executeUpdate("update testCLOB_MAIN set clob2 = clob2 || lvc1");
            concateTests.verifyStringData(statement.executeQuery("select clob2 from testCLOB_MAIN"), (String)object4);
            System.out.println("Test1y - LONG VARCHAR and CLOB(B) concatenations will give result type of CLOB(2G) when A+32K>2G");
            object3 = (String)object2 + (String)object3;
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select lvc1 || clob1 from testCLOB_MAIN)"), concatenatedSQLTypesNames[3]);
            concateTests.verifyStringData(statement.executeQuery("values(select lvc1 || clob1 from testCLOB_MAIN)"), (String)object3);
            statement.executeUpdate("update testCLOB_MAIN set clob1 = lvc1 || clob1");
            concateTests.verifyStringData(statement.executeQuery("select clob1 from testCLOB_MAIN"), (String)object3);
            System.out.println("Test1z - CLOB(A) and LONG VARCHAR concatenations will give result type of CLOB(2G) when A+32K>2G");
            object3 = (String)object3 + (String)object2;
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select clob1 || lvc1 from testCLOB_MAIN)"), concatenatedSQLTypesNames[3]);
            concateTests.verifyStringData(statement.executeQuery("values(select clob1 || lvc1 from testCLOB_MAIN)"), (String)object3);
            statement.executeUpdate("update testCLOB_MAIN set clob1 = clob1 || lvc1");
            concateTests.verifyStringData(statement.executeQuery("select clob1 from testCLOB_MAIN"), (String)object3);
            System.out.println("Test11a - CLOB(A) and CLOB(B) concatenations will give result type of CLOB(A+B) when A+B<2G");
            object4 = (String)object4 + string6;
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select clob2 || clob3 from testCLOB_MAIN)"), concatenatedSQLTypesNames[3]);
            concateTests.verifyStringData(statement.executeQuery("values(select clob2 || clob3 from testCLOB_MAIN)"), (String)object4);
            statement.executeUpdate("update testCLOB_MAIN set clob2 = clob2 || clob3");
            concateTests.verifyStringData(statement.executeQuery("select clob2 from testCLOB_MAIN"), (String)object4);
            System.out.println("Test11b - CLOB(A) and CLOB(B) concatenations will give result type of CLOB(2G) when A+B>2G");
            object3 = (String)object4 + (String)object3;
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select clob2 || clob1 from testCLOB_MAIN)"), concatenatedSQLTypesNames[3]);
            concateTests.verifyStringData(statement.executeQuery("values(select clob2 || clob1 from testCLOB_MAIN)"), (String)object3);
            statement.executeUpdate("update testCLOB_MAIN set clob1 = clob2 || clob1");
            concateTests.verifyStringData(statement.executeQuery("select clob1 from testCLOB_MAIN"), (String)object3);
            System.out.println("Test12 - try 2 empty string concatenation and verify that length comes back as 0 for the result");
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values('' || '')"), concatenatedSQLTypesNames[0]);
            concateTests.verifyStringData(statement.executeQuery("values('' || '')"), "");
            System.out.println("Test13 - Prepared statement with CLOB(A) and ? concatenations will give result type of CLOB(A+length of ?)");
            System.out.println("  Prior to Derby-124 fix, ? parameter was getting bound to VARCHAR of length 32672 rather than CLOB.");
            try {
                statement.executeUpdate("drop table ct");
            }
            catch (Exception exception) {
                // empty catch block
            }
            statement.executeUpdate("create table ct (c CLOB(100K))");
            String string7 = Formatters.repeatChar("c", 32700);
            String string8 = "aa";
            String string9 = string8 + string7;
            System.out.println("  preapre statement with clob||?");
            preparedStatement = connection.prepareStatement("insert into ct values (cast ('aa' as CLOB) || ?)");
            preparedStatement.setString(1, string7);
            preparedStatement.execute();
            concateTests.verifyStringData(statement.executeQuery("select c from ct"), string9);
            statement.executeUpdate("delete from ct");
            System.out.println("  Test - preapre statement with clob||cast(? to cLOB)");
            preparedStatement = connection.prepareStatement("insert into ct values (cast ('aa' as CLOB) || cast(? as CLOB))");
            preparedStatement.setString(1, string7);
            preparedStatement.execute();
            concateTests.verifyStringData(statement.executeQuery("select c from ct"), string9);
            statement.executeUpdate("delete from ct");
            statement.executeUpdate("drop table testCLOB_MAIN");
            statement.executeUpdate("drop table t1");
            statement.executeUpdate("drop table ct");
            System.out.println("Test1 finished - CHAR, VARCHAR, LONGVARCHAR and CLOB concatenation tests");
        }
        catch (SQLException sQLException) {
            JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)sQLException);
            sQLException.printStackTrace(System.out);
        }
    }

    public static void testCharForBitDataConcatenation(Connection connection) throws Throwable {
        try {
            System.out.println("Test2 - CHAR FOR BIT DATA, VARCHAR FOR BIT DATA, LONGVARCHAR FOR BIT DATA and BLOB concatenation tests");
            Statement statement = connection.createStatement();
            byte[] byArray = new byte[]{97};
            byte[] byArray2 = new byte[40];
            Arrays.fill(byArray2, (byte)97);
            byte[] byArray3 = new byte[14];
            Arrays.fill(byArray3, (byte)97);
            byte[] byArray4 = new byte[]{97};
            byte[] byArray5 = new byte[32698];
            Arrays.fill(byArray5, (byte)97);
            try {
                statement.executeUpdate("drop table t2");
            }
            catch (Exception exception) {
                // empty catch block
            }
            statement.executeUpdate("create table t2 (cbd0 CHAR(1) FOR BIT DATA, cbd1 CHAR(254) FOR BIT DATA, cbd2 CHAR(40) FOR BIT DATA, cbd3 CHAR(14) FOR BIT DATA, vcbd1 VARCHAR(264) FOR BIT DATA, vcbd2 VARCHAR(4000) FOR BIT DATA, vcbd3 VARCHAR(1) FOR BIT DATA, lvcbd1 LONG VARCHAR FOR BIT DATA, lvcbd2 LONG VARCHAR FOR BIT DATA)");
            PreparedStatement preparedStatement = connection.prepareStatement("insert into t2(cbd0, cbd2, cbd3, vcbd3) values (?, ?,?,?)");
            preparedStatement.setBytes(1, byArray);
            preparedStatement.setBytes(2, byArray2);
            preparedStatement.setBytes(3, byArray3);
            preparedStatement.setBytes(4, byArray4);
            preparedStatement.executeUpdate();
            preparedStatement = connection.prepareStatement("update t2 set lvcbd2 = ?");
            preparedStatement.setBytes(1, byArray5);
            preparedStatement.executeUpdate();
            System.out.println("Test2a - CHAR FOR BIT DATA concatenations will give result type of CHAR FOR BIT DATA when concatenated string < 255");
            byte[] byArray6 = new byte[254];
            System.arraycopy(byArray2, 0, byArray6, 0, byArray2.length);
            System.arraycopy(byArray2, 0, byArray6, 40, byArray2.length);
            System.arraycopy(byArray2, 0, byArray6, 80, byArray2.length);
            System.arraycopy(byArray2, 0, byArray6, 120, byArray2.length);
            System.arraycopy(byArray2, 0, byArray6, 160, byArray2.length);
            System.arraycopy(byArray2, 0, byArray6, 200, byArray2.length);
            System.arraycopy(byArray3, 0, byArray6, 240, byArray3.length);
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select cbd2 || cbd2 || cbd2 || cbd2 || cbd2 || cbd2 || cbd3 from t2)"), concatenatedSQLTypesNames[4]);
            concateTests.verifyByteData(statement.executeQuery("values(select cbd2 || cbd2 || cbd2 || cbd2 || cbd2 || cbd2 || cbd3 from t2)"), byArray6);
            statement.executeUpdate("update t2 set cbd1 = cbd2 || cbd2 || cbd2 || cbd2 || cbd2 || cbd2 || cbd3");
            concateTests.verifyByteData(statement.executeQuery("select cbd1 from t2"), byArray6);
            System.out.println("Test2b boundary test - CHAR FOR BIT DATA concatenations will give result type of VARCHAR FOR BIT DATA when concatenated string = 255");
            byte[] byArray7 = new byte[255];
            System.arraycopy(byArray6, 0, byArray7, 0, byArray6.length);
            System.arraycopy(byArray, 0, byArray7, 254, byArray.length);
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select cbd1 || cbd0 from t2)"), concatenatedSQLTypesNames[5]);
            concateTests.verifyByteData(statement.executeQuery("values(select cbd1 || cbd0 from t2)"), byArray7);
            statement.executeUpdate("update t2 set vcbd1 = cbd1 || cbd0");
            concateTests.verifyByteData(statement.executeQuery("select vcbd1 from t2"), byArray7);
            System.out.println("Test2b - CHAR FOR BIT DATA concatenations will give result type of VARCHAR FOR BIT DATA when concatenated string > 254");
            byArray7 = new byte[264];
            System.arraycopy(byArray6, 0, byArray7, 0, byArray6.length);
            System.arraycopy(byArray, 0, byArray7, 254, byArray.length);
            System.arraycopy(byArray, 0, byArray7, 255, byArray.length);
            System.arraycopy(byArray, 0, byArray7, 256, byArray.length);
            System.arraycopy(byArray, 0, byArray7, 257, byArray.length);
            System.arraycopy(byArray, 0, byArray7, 258, byArray.length);
            System.arraycopy(byArray, 0, byArray7, 259, byArray.length);
            System.arraycopy(byArray, 0, byArray7, 260, byArray.length);
            System.arraycopy(byArray, 0, byArray7, 261, byArray.length);
            System.arraycopy(byArray, 0, byArray7, 262, byArray.length);
            System.arraycopy(byArray, 0, byArray7, 263, byArray.length);
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select cbd1 || cbd0 || cbd0 || cbd0 || cbd0 || cbd0 || cbd0 || cbd0 || cbd0 || cbd0 || cbd0 from t2)"), concatenatedSQLTypesNames[5]);
            concateTests.verifyByteData(statement.executeQuery("values(select cbd1 || cbd0 || cbd0 || cbd0 || cbd0 || cbd0 || cbd0 || cbd0 || cbd0 || cbd0 || cbd0  from t2)"), byArray7);
            statement.executeUpdate("update t2 set vcbd1 = cbd1 || cbd0 || cbd0 || cbd0 || cbd0 || cbd0 || cbd0 || cbd0 || cbd0 || cbd0 || cbd0");
            concateTests.verifyByteData(statement.executeQuery("select vcbd1 from t2"), byArray7);
            System.out.println("Test2c - CHAR FOR BIT DATA and VARCHAR FOR BIT DATA concatenations will give result type of VARCHAR FOR BIT DATA when concatenated string < 4001");
            byte[] byArray8 = new byte[4000];
            byte[] byArray9 = new byte[4000];
            System.arraycopy(byArray2, 0, byArray8, 0, byArray2.length);
            System.arraycopy(byArray7, 0, byArray8, 40, byArray7.length);
            System.arraycopy(byArray7, 0, byArray8, 304, byArray7.length);
            System.arraycopy(byArray7, 0, byArray8, 568, byArray7.length);
            System.arraycopy(byArray7, 0, byArray8, 832, byArray7.length);
            System.arraycopy(byArray7, 0, byArray8, 1096, byArray7.length);
            System.arraycopy(byArray7, 0, byArray8, 1360, byArray7.length);
            System.arraycopy(byArray7, 0, byArray8, 1624, byArray7.length);
            System.arraycopy(byArray7, 0, byArray8, 1888, byArray7.length);
            System.arraycopy(byArray7, 0, byArray8, 2152, byArray7.length);
            System.arraycopy(byArray7, 0, byArray8, 2416, byArray7.length);
            System.arraycopy(byArray7, 0, byArray8, 2680, byArray7.length);
            System.arraycopy(byArray7, 0, byArray8, 2944, byArray7.length);
            System.arraycopy(byArray7, 0, byArray8, 3208, byArray7.length);
            System.arraycopy(byArray7, 0, byArray8, 3472, byArray7.length);
            System.arraycopy(byArray7, 0, byArray8, 3736, byArray7.length);
            System.arraycopy(byArray8, 0, byArray9, 0, byArray8.length);
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select cbd2||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1 from t2)"), concatenatedSQLTypesNames[5]);
            concateTests.verifyByteData(statement.executeQuery("values(select cbd2||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1 from t2)"), byArray9);
            statement.executeUpdate("update t2 set vcbd2 = cbd2||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1");
            concateTests.verifyByteData(statement.executeQuery("select vcbd2 from t2"), byArray9);
            statement.executeUpdate("update t2 set lvcbd1 = cbd2||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1");
            concateTests.verifyByteData(statement.executeQuery("select lvcbd1 from t2"), byArray8);
            System.out.println("Test2d - VARCHAR FOR BIT DATA and CHAR FOR BIT DATA concatenations will give result type of VARCHAR FOR BIT DATA when concatenated string < 4001");
            byArray8 = new byte[4000];
            byArray9 = new byte[4000];
            System.arraycopy(byArray7, 0, byArray8, 0, byArray7.length);
            System.arraycopy(byArray7, 0, byArray8, 264, byArray7.length);
            System.arraycopy(byArray7, 0, byArray8, 528, byArray7.length);
            System.arraycopy(byArray7, 0, byArray8, 792, byArray7.length);
            System.arraycopy(byArray7, 0, byArray8, 1056, byArray7.length);
            System.arraycopy(byArray7, 0, byArray8, 1320, byArray7.length);
            System.arraycopy(byArray7, 0, byArray8, 1584, byArray7.length);
            System.arraycopy(byArray7, 0, byArray8, 1848, byArray7.length);
            System.arraycopy(byArray7, 0, byArray8, 2112, byArray7.length);
            System.arraycopy(byArray7, 0, byArray8, 2376, byArray7.length);
            System.arraycopy(byArray7, 0, byArray8, 2640, byArray7.length);
            System.arraycopy(byArray7, 0, byArray8, 2904, byArray7.length);
            System.arraycopy(byArray7, 0, byArray8, 3168, byArray7.length);
            System.arraycopy(byArray7, 0, byArray8, 3432, byArray7.length);
            System.arraycopy(byArray7, 0, byArray8, 3696, byArray7.length);
            System.arraycopy(byArray2, 0, byArray8, 3960, byArray2.length);
            System.arraycopy(byArray8, 0, byArray9, 0, byArray8.length);
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||cbd2 from t2)"), concatenatedSQLTypesNames[5]);
            concateTests.verifyByteData(statement.executeQuery("values(select vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||cbd2 from t2)"), byArray8);
            statement.executeUpdate("update t2 set vcbd2 = vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||cbd2");
            concateTests.verifyByteData(statement.executeQuery("select vcbd2 from t2"), byArray9);
            statement.executeUpdate("update t2 set lvcbd1 = vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||vcbd1||cbd2");
            concateTests.verifyByteData(statement.executeQuery("select lvcbd1 from t2"), byArray8);
            System.out.println("Test2e boundary test - CHAR FOR BIT DATA and VARCHAR FOR BIT DATA concatenations will give result type of LONG VARCHAR FOR BIT DATA when concatenated string > 4000");
            byArray8 = new byte[4001];
            System.arraycopy(byArray, 0, byArray8, 0, byArray.length);
            System.arraycopy(byArray9, 0, byArray8, 1, byArray9.length);
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select cbd0||vcbd2 from t2)"), concatenatedSQLTypesNames[6]);
            concateTests.verifyByteData(statement.executeQuery("values(select cbd0||vcbd2 from t2)"), byArray8);
            statement.executeUpdate("update t2 set lvcbd1 = cbd0||vcbd2 ");
            concateTests.verifyByteData(statement.executeQuery("select lvcbd1 from t2"), byArray8);
            System.out.println("Test2f boundary test - VARCHAR FOR BIT DATA and CHAR FOR BIT DATA concatenations will give result type of LONG VARCHAR FOR BIT DATA when concatenated string > 4000");
            byArray8 = new byte[4001];
            System.arraycopy(byArray9, 0, byArray8, 0, byArray9.length);
            System.arraycopy(byArray, 0, byArray8, 4000, byArray.length);
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select vcbd2 || cbd0 from t2)"), concatenatedSQLTypesNames[6]);
            concateTests.verifyByteData(statement.executeQuery("values(select vcbd2 || cbd0 from t2)"), byArray8);
            statement.executeUpdate("update t2 set lvcbd1 = vcbd2 || cbd0");
            concateTests.verifyByteData(statement.executeQuery("select lvcbd1 from t2"), byArray8);
            System.out.println("Test2g - CHAR FOR BIT DATA and LONG VARCHAR FOR BIT DATA concatenations will give result type of LONG VARCHAR FOR BIT DATA");
            byte[] byArray10 = new byte[4001];
            System.arraycopy(byArray8, 0, byArray10, 0, byArray8.length);
            byArray8 = new byte[4002];
            System.arraycopy(byArray, 0, byArray8, 0, byArray.length);
            System.arraycopy(byArray10, 0, byArray8, 1, byArray10.length);
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select cbd0 || lvcbd1 from t2)"), concatenatedSQLTypesNames[6]);
            concateTests.verifyByteData(statement.executeQuery("values(select cbd0 || lvcbd1 from t2)"), byArray8);
            statement.executeUpdate("update t2 set lvcbd1 = cbd0 || lvcbd1");
            concateTests.verifyByteData(statement.executeQuery("select lvcbd1 from t2"), byArray8);
            System.out.println("Test2h - VARCHAR FOR BIT DATA and LONG VARCHAR FOR BIT DATA concatenations will give result type of LONG VARCHAR FOR BIT DATA");
            byArray10 = new byte[4002];
            System.arraycopy(byArray8, 0, byArray10, 0, byArray8.length);
            byArray8 = new byte[4266];
            System.arraycopy(byArray7, 0, byArray8, 0, byArray7.length);
            System.arraycopy(byArray10, 0, byArray8, 264, byArray10.length);
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select vcbd1 || lvcbd1 from t2)"), concatenatedSQLTypesNames[6]);
            concateTests.verifyByteData(statement.executeQuery("values(select vcbd1 || lvcbd1 from t2)"), byArray8);
            statement.executeUpdate("update t2 set lvcbd1 = vcbd1 || lvcbd1");
            concateTests.verifyByteData(statement.executeQuery("select lvcbd1 from t2"), byArray8);
            System.out.println("Test2i - VARCHAR FOR BIT DATA and VARCHAR FOR BIT DATA concatenations will give result type of VARCHAR FOR BIT DATA when concatenated string < 4001");
            byArray8 = new byte[528];
            System.arraycopy(byArray7, 0, byArray8, 0, byArray7.length);
            System.arraycopy(byArray7, 0, byArray8, 264, byArray7.length);
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select vcbd1 || vcbd1 from t2)"), concatenatedSQLTypesNames[5]);
            concateTests.verifyByteData(statement.executeQuery("values(select vcbd1 || vcbd1 from t2)"), byArray8);
            statement.executeUpdate("update t2 set lvcbd1 = vcbd1 || vcbd1");
            concateTests.verifyByteData(statement.executeQuery("select lvcbd1 from t2"), byArray8);
            System.out.println("Test2j boundary test - VARCHAR FOR BIT DATA and VARCHAR FOR BIT DATA concatenations will give result type of LONG VARCHAR FOR BIT DATA when concatenated string = 4001");
            byArray8 = new byte[4001];
            System.arraycopy(byArray9, 0, byArray8, 0, byArray9.length);
            System.arraycopy(byArray4, 0, byArray8, 4000, byArray4.length);
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select vcbd2 || vcbd3 from t2)"), concatenatedSQLTypesNames[6]);
            concateTests.verifyByteData(statement.executeQuery("values(select vcbd2 || vcbd3 from t2)"), byArray8);
            statement.executeUpdate("update t2 set lvcbd1 = vcbd2 || vcbd3");
            concateTests.verifyByteData(statement.executeQuery("select lvcbd1 from t2"), byArray8);
            System.out.println("Test2j - VARCHAR FOR BIT DATA and VARCHAR FOR BIT DATA concatenations will give result type of LONG VARCHAR FOR BIT DATA when concatenated string > 4000");
            byArray8 = new byte[byArray7.length + byArray9.length];
            System.arraycopy(byArray7, 0, byArray8, 0, byArray7.length);
            System.arraycopy(byArray9, 0, byArray8, byArray7.length, byArray9.length);
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select vcbd1 || vcbd2 from t2)"), concatenatedSQLTypesNames[6]);
            concateTests.verifyByteData(statement.executeQuery("values(select vcbd1 || vcbd2 from t2)"), byArray8);
            statement.executeUpdate("update t2 set lvcbd1 = vcbd1 || vcbd2");
            concateTests.verifyByteData(statement.executeQuery("select lvcbd1 from t2"), byArray8);
            System.out.println("Test2k - LONG VARCHAR FOR BIT DATA and LONG VARCHAR FOR BIT DATA concatenations will give result type of LONG VARCHAR FOR BIT DATA");
            byArray10 = new byte[byArray8.length];
            System.arraycopy(byArray8, 0, byArray10, 0, byArray8.length);
            byArray8 = new byte[byArray10.length + byArray10.length];
            System.arraycopy(byArray10, 0, byArray8, 0, byArray10.length);
            System.arraycopy(byArray10, 0, byArray8, byArray10.length, byArray10.length);
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select lvcbd1 || lvcbd1 from t2)"), concatenatedSQLTypesNames[6]);
            concateTests.verifyByteData(statement.executeQuery("values(select lvcbd1 || lvcbd1 from t2)"), byArray8);
            statement.executeUpdate("update t2 set lvcbd1 = lvcbd1 || lvcbd1");
            concateTests.verifyByteData(statement.executeQuery("select lvcbd1 from t2"), byArray8);
            System.out.println("Test2l - CHAR FOR BIT DATA and LONGVARCHAR FOR BIT DATA concatenation resulting in concatenated string > 32700");
            byte[] byArray11 = new byte[byArray5.length];
            System.arraycopy(byArray5, 0, byArray11, 0, byArray5.length);
            byArray5 = new byte[byArray2.length + byArray11.length];
            System.arraycopy(byArray2, 0, byArray5, 0, byArray2.length);
            System.arraycopy(byArray11, 0, byArray5, byArray2.length, byArray11.length);
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select cbd2 || lvcbd2 from t2)"), concatenatedSQLTypesNames[6]);
            concateTests.verifyByteData(statement.executeQuery("values(select cbd2 || lvcbd2 from t2)"), byArray5);
            statement.executeUpdate("update t2 set lvcbd2 = cbd2 || lvcbd2");
            concateTests.verifyByteData(statement.executeQuery("select lvcbd2 from t2"), byArray5);
            System.out.println("Test2m - VARCHAR FOR BIT DATA and LONGVARCHAR FOR BIT DATA concatenation resulting in concatenated string > 32700");
            byArray11 = new byte[byArray5.length];
            System.arraycopy(byArray5, 0, byArray11, 0, byArray5.length);
            byArray5 = new byte[byArray7.length + byArray11.length];
            System.arraycopy(byArray7, 0, byArray5, 0, byArray7.length);
            System.arraycopy(byArray11, 0, byArray5, byArray7.length, byArray11.length);
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select vcbd1 || lvcbd2 from t2)"), concatenatedSQLTypesNames[6]);
            concateTests.verifyByteData(statement.executeQuery("values(select vcbd1 || lvcbd2 from t2)"), byArray5);
            statement.executeUpdate("update t2 set lvcbd2 = vcbd1 || lvcbd2");
            concateTests.verifyByteData(statement.executeQuery("select lvcbd2 from t2"), byArray5);
            System.out.println("Test2n - LONGVARCHAR FOR BIT DATA and LONGVARCHAR FOR BIT DATA concatenation resulting in concatenated string > 32700");
            byArray11 = new byte[byArray5.length];
            System.arraycopy(byArray5, 0, byArray11, 0, byArray5.length);
            byArray5 = new byte[byArray8.length + byArray11.length];
            System.arraycopy(byArray8, 0, byArray5, 0, byArray8.length);
            System.arraycopy(byArray11, 0, byArray5, byArray8.length, byArray11.length);
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select lvcbd1 || lvcbd2 from t2)"), concatenatedSQLTypesNames[6]);
            concateTests.verifyByteData(statement.executeQuery("values(select lvcbd1 || lvcbd2 from t2)"), byArray5);
            statement.executeUpdate("update t2 set lvcbd2 = lvcbd1 || lvcbd2");
            concateTests.verifyByteData(statement.executeQuery("select lvcbd2 from t2"), byArray5);
            try {
                statement.executeUpdate("drop table testBLOB_MAIN");
            }
            catch (Exception exception) {
                // empty catch block
            }
            statement.executeUpdate("create table testBLOB_MAIN (cbd1 CHAR(10) FOR BIT DATA, vcbd1 VARCHAR(100) FOR BIT DATA, lvcbd1 LONG VARCHAR FOR BIT DATA, blob1 BLOB(2G), blob2 BLOB(256), blob3 BLOB(1M))");
            preparedStatement = connection.prepareStatement("insert into testBLOB_MAIN values(?,?,?,?,?,?)");
            byArray6 = new byte[10];
            Arrays.fill(byArray6, (byte)97);
            preparedStatement.setBytes(1, byArray6);
            byArray7 = new byte[10];
            Arrays.fill(byArray7, (byte)98);
            preparedStatement.setBytes(2, byArray7);
            byArray8 = new byte[10];
            Arrays.fill(byArray8, (byte)99);
            preparedStatement.setBytes(3, byArray8);
            byte[] byArray12 = new byte[10];
            Arrays.fill(byArray12, (byte)100);
            preparedStatement.setBytes(4, byArray12);
            byte[] byArray13 = new byte[10];
            Arrays.fill(byArray13, (byte)101);
            preparedStatement.setBytes(5, byArray13);
            byte[] byArray14 = new byte[10];
            Arrays.fill(byArray14, (byte)102);
            preparedStatement.setBytes(6, byArray14);
            preparedStatement.executeUpdate();
            System.out.println("Test2o - CHAR(A) FOR BIT DATA and BLOB(B) concatenations will give result type of BLOB(A+B) when A+B<2G");
            byte[] byArray15 = new byte[byArray13.length];
            System.arraycopy(byArray13, 0, byArray15, 0, byArray13.length);
            byArray13 = new byte[byArray6.length + byArray15.length];
            System.arraycopy(byArray6, 0, byArray13, 0, byArray6.length);
            System.arraycopy(byArray15, 0, byArray13, byArray6.length, byArray15.length);
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select cbd1 || blob2 from testBLOB_MAIN)"), concatenatedSQLTypesNames[7]);
            concateTests.verifyByteData(statement.executeQuery("values(select cbd1 || blob2 from testBLOB_MAIN)"), byArray13);
            statement.executeUpdate("update testBLOB_MAIN set blob2 = cast((cbd1 || blob2) as blob(256))");
            concateTests.verifyByteData(statement.executeQuery("select blob2 from testBLOB_MAIN"), byArray13);
            System.out.println("Test2p - BLOB(A) and CHAR(B) FOR BIT DATA concatenations will give result type of BLOB(A+B) when A+B<2G");
            byArray15 = new byte[byArray13.length];
            System.arraycopy(byArray13, 0, byArray15, 0, byArray13.length);
            byArray13 = new byte[byArray15.length + byArray6.length];
            System.arraycopy(byArray15, 0, byArray13, 0, byArray15.length);
            System.arraycopy(byArray6, 0, byArray13, byArray15.length, byArray6.length);
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select blob2 || cbd1 from testBLOB_MAIN)"), concatenatedSQLTypesNames[7]);
            concateTests.verifyByteData(statement.executeQuery("values(select blob2 || cbd1 from testBLOB_MAIN)"), byArray13);
            statement.executeUpdate("update testBLOB_MAIN set blob2 =  cast((blob2 || cbd1) as blob(256))");
            concateTests.verifyByteData(statement.executeQuery("select blob2 from testBLOB_MAIN"), byArray13);
            System.out.println("Test2q - CHAR(A) FOR BIT DATA and BLOB(B) concatenations will give result type of BLOB(2G) when A+B>2G");
            byArray15 = new byte[byArray12.length];
            System.arraycopy(byArray12, 0, byArray15, 0, byArray12.length);
            byArray12 = new byte[byArray6.length + byArray15.length];
            System.arraycopy(byArray6, 0, byArray12, 0, byArray6.length);
            System.arraycopy(byArray15, 0, byArray12, byArray6.length, byArray15.length);
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select cbd1 || blob1 from testBLOB_MAIN)"), concatenatedSQLTypesNames[7]);
            concateTests.verifyByteData(statement.executeQuery("values(select cbd1 || blob1 from testBLOB_MAIN)"), byArray12);
            statement.executeUpdate("update testBLOB_MAIN set blob1 = cast((cbd1 || blob1) as blob(2G))");
            concateTests.verifyByteData(statement.executeQuery("select blob1 from testBLOB_MAIN"), byArray12);
            System.out.println("Test2r - BLOB(A) and CHAR(B) FOR BIT DATA concatenations will give result type of BLOB(2G) when A+B>2G");
            byArray15 = new byte[byArray12.length];
            System.arraycopy(byArray12, 0, byArray15, 0, byArray12.length);
            byArray12 = new byte[byArray15.length + byArray6.length];
            System.arraycopy(byArray15, 0, byArray12, 0, byArray15.length);
            System.arraycopy(byArray6, 0, byArray12, byArray15.length, byArray6.length);
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select blob1 || cbd1 from testBLOB_MAIN)"), concatenatedSQLTypesNames[7]);
            concateTests.verifyByteData(statement.executeQuery("values(select blob1 || cbd1 from testBLOB_MAIN)"), byArray12);
            statement.executeUpdate("update testBLOB_MAIN set blob1 = cast((blob1 || cbd1) as blob(2G))");
            concateTests.verifyByteData(statement.executeQuery("select blob1 from testBLOB_MAIN"), byArray12);
            System.out.println("Test2s - VARCHAR(A) FOR BIT DATA and BLOB(B) concatenations will give result type of BLOB(A+B) when A+B<2G");
            byArray15 = new byte[byArray13.length];
            System.arraycopy(byArray13, 0, byArray15, 0, byArray13.length);
            byArray13 = new byte[byArray7.length + byArray15.length];
            System.arraycopy(byArray7, 0, byArray13, 0, byArray7.length);
            System.arraycopy(byArray15, 0, byArray13, byArray7.length, byArray15.length);
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select vcbd1 || blob2 from testBLOB_MAIN)"), concatenatedSQLTypesNames[7]);
            concateTests.verifyByteData(statement.executeQuery("values(select vcbd1 || blob2 from testBLOB_MAIN)"), byArray13);
            statement.executeUpdate("update testBLOB_MAIN set blob2 = cast((vcbd1 || blob2) as blob(256))");
            concateTests.verifyByteData(statement.executeQuery("select blob2 from testBLOB_MAIN"), byArray13);
            System.out.println("Test2t - BLOB(A) and VARCHAR(B) FOR BIT DATA concatenations will give result type of BLOB(A+B) when A+B<2G");
            byArray15 = new byte[byArray13.length];
            System.arraycopy(byArray13, 0, byArray15, 0, byArray13.length);
            byArray13 = new byte[byArray15.length + byArray7.length];
            System.arraycopy(byArray15, 0, byArray13, 0, byArray15.length);
            System.arraycopy(byArray7, 0, byArray13, byArray15.length, byArray7.length);
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select blob2 || vcbd1 from testBLOB_MAIN)"), concatenatedSQLTypesNames[7]);
            concateTests.verifyByteData(statement.executeQuery("values(select blob2 || vcbd1 from testBLOB_MAIN)"), byArray13);
            statement.executeUpdate("update testBLOB_MAIN set blob2 = cast((blob2 || vcbd1) as blob(256))");
            concateTests.verifyByteData(statement.executeQuery("select blob2 from testBLOB_MAIN"), byArray13);
            System.out.println("Test2u - VARCHAR(A) FOR BIT DATA and BLOB(B) concatenations will give result type of BLOB(2G) when A+B>2G");
            byArray15 = new byte[byArray12.length];
            System.arraycopy(byArray12, 0, byArray15, 0, byArray12.length);
            byArray12 = new byte[byArray7.length + byArray15.length];
            System.arraycopy(byArray7, 0, byArray12, 0, byArray7.length);
            System.arraycopy(byArray15, 0, byArray12, byArray7.length, byArray15.length);
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select vcbd1 || blob1 from testBLOB_MAIN)"), concatenatedSQLTypesNames[7]);
            concateTests.verifyByteData(statement.executeQuery("values(select vcbd1 || blob1 from testBLOB_MAIN)"), byArray12);
            statement.executeUpdate("update testBLOB_MAIN set blob1 = cast((vcbd1 || blob1) as blob(2G))");
            concateTests.verifyByteData(statement.executeQuery("select blob1 from testBLOB_MAIN"), byArray12);
            System.out.println("Test2v - BLOB(A) and VARCHAR(B) FOR BIT DATA concatenations will give result type of BLOB(2G) when A+B>2G");
            byArray15 = new byte[byArray12.length];
            System.arraycopy(byArray12, 0, byArray15, 0, byArray12.length);
            byArray12 = new byte[byArray15.length + byArray7.length];
            System.arraycopy(byArray15, 0, byArray12, 0, byArray15.length);
            System.arraycopy(byArray7, 0, byArray12, byArray15.length, byArray7.length);
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select blob1 || vcbd1 from testBLOB_MAIN)"), concatenatedSQLTypesNames[7]);
            concateTests.verifyByteData(statement.executeQuery("values(select blob1 || vcbd1 from testBLOB_MAIN)"), byArray12);
            statement.executeUpdate("update testBLOB_MAIN set blob1 = cast((blob1 || vcbd1) as blob(2G))");
            concateTests.verifyByteData(statement.executeQuery("select blob1 from testBLOB_MAIN"), byArray12);
            System.out.println("Test2w - LONG VARCHAR FOR BIT DATA and BLOB(A) concatenations will give result type of BLOB(A+32K) when A+32K<2G");
            byArray15 = new byte[byArray13.length];
            System.arraycopy(byArray13, 0, byArray15, 0, byArray13.length);
            byArray13 = new byte[byArray8.length + byArray15.length];
            System.arraycopy(byArray8, 0, byArray13, 0, byArray8.length);
            System.arraycopy(byArray15, 0, byArray13, byArray8.length, byArray15.length);
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select lvcbd1 || blob2 from testBLOB_MAIN)"), concatenatedSQLTypesNames[7]);
            concateTests.verifyByteData(statement.executeQuery("values(select lvcbd1 || blob2 from testBLOB_MAIN)"), byArray13);
            statement.executeUpdate("update testBLOB_MAIN set blob2 = cast((lvcbd1 || blob2) as blob(256))");
            concateTests.verifyByteData(statement.executeQuery("select blob2 from testBLOB_MAIN"), byArray13);
            System.out.println("Test2x - BLOB(A) and LONG VARCHAR FOR BIT DATA concatenations will give result type of BLOB(A+32K) when A+32K<2G");
            byArray15 = new byte[byArray13.length];
            System.arraycopy(byArray13, 0, byArray15, 0, byArray13.length);
            byArray13 = new byte[byArray15.length + byArray8.length];
            System.arraycopy(byArray15, 0, byArray13, 0, byArray15.length);
            System.arraycopy(byArray8, 0, byArray13, byArray15.length, byArray8.length);
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select blob2 || lvcbd1 from testBLOB_MAIN)"), concatenatedSQLTypesNames[7]);
            concateTests.verifyByteData(statement.executeQuery("values(select blob2 || lvcbd1 from testBLOB_MAIN)"), byArray13);
            statement.executeUpdate("update testBLOB_MAIN set blob2 = cast((blob2 || lvcbd1) as blob(256))");
            concateTests.verifyByteData(statement.executeQuery("select blob2 from testBLOB_MAIN"), byArray13);
            System.out.println("Test2y - LONG VARCHAR FOR BIT DATA and BLOB(B) concatenations will give result type of BLOB(2G) when A+32K>2G");
            byArray15 = new byte[byArray12.length];
            System.arraycopy(byArray12, 0, byArray15, 0, byArray12.length);
            byArray12 = new byte[byArray8.length + byArray15.length];
            System.arraycopy(byArray8, 0, byArray12, 0, byArray8.length);
            System.arraycopy(byArray15, 0, byArray12, byArray8.length, byArray15.length);
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select lvcbd1 || blob1 from testBLOB_MAIN)"), concatenatedSQLTypesNames[7]);
            concateTests.verifyByteData(statement.executeQuery("values(select lvcbd1 || blob1 from testBLOB_MAIN)"), byArray12);
            statement.executeUpdate("update testBLOB_MAIN set blob1 = cast((lvcbd1 || blob1) as blob(2G))");
            concateTests.verifyByteData(statement.executeQuery("select blob1 from testBLOB_MAIN"), byArray12);
            System.out.println("Test2z - BLOB(A) and LONG VARCHAR FOR BIT DATA concatenations will give result type of BLOB(2G) when A+32K>2G");
            byArray15 = new byte[byArray12.length];
            System.arraycopy(byArray12, 0, byArray15, 0, byArray12.length);
            byArray12 = new byte[byArray15.length + byArray8.length];
            System.arraycopy(byArray15, 0, byArray12, 0, byArray15.length);
            System.arraycopy(byArray8, 0, byArray12, byArray15.length, byArray8.length);
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select blob1 || lvcbd1 from testBLOB_MAIN)"), concatenatedSQLTypesNames[7]);
            concateTests.verifyByteData(statement.executeQuery("values(select blob1 || lvcbd1 from testBLOB_MAIN)"), byArray12);
            statement.executeUpdate("update testBLOB_MAIN set blob1 = cast((blob1 || lvcbd1) as blob(2G))");
            concateTests.verifyByteData(statement.executeQuery("select blob1 from testBLOB_MAIN"), byArray12);
            System.out.println("Test21a - BLOB(A) and BLOB(B) concatenations will give result type of BLOB(A+B) when A+B<2G");
            byArray15 = new byte[byArray13.length];
            System.arraycopy(byArray13, 0, byArray15, 0, byArray13.length);
            byArray13 = new byte[byArray15.length + byArray14.length];
            System.arraycopy(byArray15, 0, byArray13, 0, byArray15.length);
            System.arraycopy(byArray14, 0, byArray13, byArray15.length, byArray14.length);
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select blob2 || blob3 from testBLOB_MAIN)"), concatenatedSQLTypesNames[7]);
            concateTests.verifyByteData(statement.executeQuery("values(select blob2 || blob3 from testBLOB_MAIN)"), byArray13);
            statement.executeUpdate("update testBLOB_MAIN set blob2 = blob2 || blob3");
            concateTests.verifyByteData(statement.executeQuery("select blob2 from testBLOB_MAIN"), byArray13);
            System.out.println("Test21b - BLOB(A) and BLOB(B) concatenations will give result type of BLOB(2G) when A+B>2G");
            byArray15 = new byte[byArray12.length];
            System.arraycopy(byArray12, 0, byArray15, 0, byArray12.length);
            byArray12 = new byte[byArray13.length + byArray15.length];
            System.arraycopy(byArray13, 0, byArray12, 0, byArray13.length);
            System.arraycopy(byArray15, 0, byArray12, byArray13.length, byArray15.length);
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(select blob2 || blob1 from testBLOB_MAIN)"), concatenatedSQLTypesNames[7]);
            concateTests.verifyByteData(statement.executeQuery("values(select blob2 || blob1 from testBLOB_MAIN)"), byArray12);
            statement.executeUpdate("update testBLOB_MAIN set blob1 = blob2 || blob1");
            concateTests.verifyByteData(statement.executeQuery("select blob1 from testBLOB_MAIN"), byArray12);
            System.out.println("Test22 - try 2 empty char for bit data concatenation and verify that length comes back as 0 for the result");
            concateTests.dumpSomeMetaDataInfo(statement.executeQuery("values(X'' || X'')"), concatenatedSQLTypesNames[4]);
            System.out.println("Test23 - Derby-124 try concatenation in a prepared statement with one operand casted to BLOB and other as ? parameter");
            System.out.println("  Prior to Derby-124 fix, ? parameter was getting bound to VARCHAR TO BIT DATA of length 32672 rather than BLOB.");
            System.out.println("  That caused truncation exception when ? parameter was set to > 32672 bytes");
            try {
                statement.executeUpdate("drop table bt");
            }
            catch (Exception exception) {
                // empty catch block
            }
            statement.executeUpdate("create table bt (b BLOB(100K))");
            byte[] byArray16 = new byte[32700];
            for (int i = 0; i < byArray16.length; ++i) {
                byArray16[i] = (byte)(i % 10);
            }
            byte[] byArray17 = new byte[]{16, 16};
            byte[] byArray18 = new byte[32702];
            System.arraycopy(byArray17, 0, byArray18, 0, byArray17.length);
            System.arraycopy(byArray16, 0, byArray18, byArray17.length, byArray16.length);
            System.out.println("  preapre statement with blob||?");
            preparedStatement = connection.prepareStatement("insert into bt values (cast (x'1010' as BLOB) || ?)");
            preparedStatement.setBytes(1, byArray16);
            preparedStatement.execute();
            concateTests.verifyByteData(statement.executeQuery("select b from bt"), byArray18);
            statement.executeUpdate("delete from bt");
            System.out.println("  Test - preapre statement with blob||cast(? to BLOB)");
            preparedStatement = connection.prepareStatement("insert into bt values (cast (x'1010' as BLOB) || cast(? as BLOB))");
            preparedStatement.setBytes(1, byArray16);
            preparedStatement.execute();
            concateTests.verifyByteData(statement.executeQuery("select b from bt"), byArray18);
            statement.executeUpdate("drop table testBLOB_MAIN");
            statement.executeUpdate("drop table t2");
            statement.executeUpdate("drop table bt");
            System.out.println("Test2 finished - CHAR FOR BIT DATA, VARCHAR FOR BIT DATA, LONGVARCHAR FOR BIT DATA and BLOB concatenation tests");
        }
        catch (SQLException sQLException) {
            JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)sQLException);
            sQLException.printStackTrace(System.out);
        }
    }

    private static void verifyStringData(ResultSet resultSet, String string) throws SQLException {
        if (resultSet == null) {
            System.out.println("<NULL>");
            return;
        }
        resultSet.next();
        if (!resultSet.getString(1).equals(string)) {
            System.out.println("ERROR: expected value does not match actual value");
            System.out.println("expected value is " + string);
            System.out.println("what we got here is " + resultSet.getString(1));
        } else {
            System.out.println("Successful " + resultSet.getMetaData().getColumnTypeName(1) + " read of " + string.length() + " characters");
        }
    }

    private static void verifyByteData(ResultSet resultSet, byte[] byArray) throws SQLException {
        if (resultSet == null) {
            System.out.println("<NULL>");
            return;
        }
        resultSet.next();
        if (!Arrays.equals(resultSet.getBytes(1), byArray)) {
            System.out.println("ERROR: expected value does not match actual value");
            System.out.println("expected value is " + byArray);
            System.out.println("what we got here is " + resultSet.getBytes(1));
        } else {
            System.out.println("Successful " + resultSet.getMetaData().getColumnTypeName(1) + " read of " + byArray.length + " bytes");
        }
    }

    private static void dumpSomeMetaDataInfo(ResultSet resultSet, String string) throws SQLException {
        if (resultSet == null) {
            System.out.println("<NULL>");
            return;
        }
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        StringBuffer stringBuffer = new StringBuffer("\t ");
        for (int i = 1; i <= n; ++i) {
            System.out.println("datatype of concatenated string is : " + resultSetMetaData.getColumnTypeName(i));
            if (!resultSetMetaData.getColumnTypeName(i).equals(string)) {
                System.out.println("FAIL : expected datatype of concatenated string is : " + string);
            }
            System.out.println("precision of concatenated string is : " + resultSetMetaData.getPrecision(i));
        }
    }

    private static void dumpSQLExceptions(SQLException sQLException) {
        System.out.println("FAIL -- unexpected exception: " + sQLException.toString());
        while (sQLException != null) {
            System.out.print("SQLSTATE(" + sQLException.getSQLState() + "):");
            sQLException = sQLException.getNextException();
        }
    }
}

