/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseJDBCTestSetup;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;

public class TimestampArithTest
extends BaseJDBCTestCase {
    private static final int FRAC_SECOND_INTERVAL = 0;
    private static final int SECOND_INTERVAL = 1;
    private static final int MINUTE_INTERVAL = 2;
    private static final int HOUR_INTERVAL = 3;
    private static final int DAY_INTERVAL = 4;
    private static final int WEEK_INTERVAL = 5;
    private static final int MONTH_INTERVAL = 6;
    private static final int QUARTER_INTERVAL = 7;
    private static final int YEAR_INTERVAL = 8;
    private static final OneDiffTest[] diffBetweenTsTests = new OneDiffTest[]{new OneDiffTest(0, TimestampArithTest.ts("2005-05-10 08:25:00"), TimestampArithTest.ts("2005-05-10 08:25:00.000001"), 1000, null, null), new OneDiffTest(1, TimestampArithTest.ts("2005-05-10 08:25:01"), TimestampArithTest.ts("2005-05-10 08:25:00"), -1, null, null), new OneDiffTest(1, TimestampArithTest.ts("2005-05-10 08:25:00.1"), TimestampArithTest.ts("2005-05-10 08:25:00"), 0, null, null), new OneDiffTest(1, TimestampArithTest.ts("2005-05-10 08:25:00"), TimestampArithTest.ts("2005-05-10 08:26:00"), 60, null, null), new OneDiffTest(2, TimestampArithTest.ts("2005-05-11 08:25:00"), TimestampArithTest.ts("2005-05-10 08:25:00"), -1440, null, null), new OneDiffTest(3, TimestampArithTest.ts("2005-05-10 08:25:00"), TimestampArithTest.ts("2005-05-11 08:25:00"), 24, null, null), new OneDiffTest(4, TimestampArithTest.ts("2005-05-10 08:25:00"), TimestampArithTest.ts("2005-05-11 08:25:00"), 1, null, null), new OneDiffTest(4, TimestampArithTest.ts("2005-05-10 08:25:01"), TimestampArithTest.ts("2005-05-11 08:25:00"), 0, null, null), new OneDiffTest(5, TimestampArithTest.ts("2005-02-23 08:25:00"), TimestampArithTest.ts("2005-03-01 08:25:00"), 0, null, null), new OneDiffTest(6, TimestampArithTest.ts("2005-02-23 08:25:00"), TimestampArithTest.ts("2005-03-23 08:25:00"), 1, null, null), new OneDiffTest(6, TimestampArithTest.ts("2005-02-23 08:25:01"), TimestampArithTest.ts("2005-03-23 08:25:00"), 0, null, null), new OneDiffTest(7, TimestampArithTest.ts("2005-02-23 08:25:00"), TimestampArithTest.ts("2005-05-23 08:25:00"), 1, null, null), new OneDiffTest(7, TimestampArithTest.ts("2005-02-23 08:25:01"), TimestampArithTest.ts("2005-05-23 08:25:00"), 0, null, null), new OneDiffTest(8, TimestampArithTest.ts("2005-02-23 08:25:00"), TimestampArithTest.ts("2005-05-23 08:25:00"), 0, null, null), new OneDiffTest(8, TimestampArithTest.ts("2005-02-23 08:25:00"), TimestampArithTest.ts("2006-02-23 08:25:00"), 1, null, null)};
    private static final OneDiffTest[] diffBetweenTsAndDateTests = new OneDiffTest[]{new OneDiffTest(0, TimestampArithTest.ts("2004-05-10 00:00:00.123456"), TimestampArithTest.dt("2004-05-10"), -123456000, null, null), new OneDiffTest(1, TimestampArithTest.ts("2004-05-10 08:25:01"), TimestampArithTest.dt("2004-05-10"), -30301, null, null), new OneDiffTest(2, TimestampArithTest.ts("2004-05-11 08:25:00"), TimestampArithTest.dt("2004-05-10"), -1945, null, null), new OneDiffTest(3, TimestampArithTest.ts("2004-02-28 08:25:00"), TimestampArithTest.dt("2004-03-01"), 39, null, null), new OneDiffTest(4, TimestampArithTest.ts("2004-05-10 08:25:00"), TimestampArithTest.dt("2004-05-11"), 0, null, null), new OneDiffTest(5, TimestampArithTest.ts("2004-02-23 00:00:00"), TimestampArithTest.dt("2004-03-01"), 1, null, null), new OneDiffTest(6, TimestampArithTest.ts("2004-02-23 08:25:00"), TimestampArithTest.dt("2004-03-24"), 1, null, null), new OneDiffTest(7, TimestampArithTest.ts("2004-02-23 08:25:00"), TimestampArithTest.dt("2004-05-24"), 1, null, null), new OneDiffTest(8, TimestampArithTest.ts("2004-02-23 08:25:00"), TimestampArithTest.dt("2004-05-23"), 0, null, null)};
    private static final OneDiffTest[] diffBetweenDateAndTsTests = new OneDiffTest[]{new OneDiffTest(0, TimestampArithTest.dt("2004-05-10"), TimestampArithTest.ts("2004-05-10 00:00:00.123456"), 123456000, null, null), new OneDiffTest(1, TimestampArithTest.dt("2004-05-10"), TimestampArithTest.ts("2004-05-09 23:59:00"), -60, null, null), new OneDiffTest(2, TimestampArithTest.dt("2004-05-10"), TimestampArithTest.ts("2004-05-11 08:25:00"), 1945, null, null), new OneDiffTest(3, TimestampArithTest.dt("2005-03-01"), TimestampArithTest.ts("2005-02-28 08:25:00"), -15, null, null), new OneDiffTest(4, TimestampArithTest.dt("2004-05-10"), TimestampArithTest.ts("2004-05-11 08:25:00"), 1, null, null), new OneDiffTest(5, TimestampArithTest.dt("2004-03-01"), TimestampArithTest.ts("2004-02-23 00:00:00"), -1, null, null), new OneDiffTest(6, TimestampArithTest.dt("2005-03-24"), TimestampArithTest.ts("2004-02-23 08:25:00"), -13, null, null), new OneDiffTest(7, TimestampArithTest.dt("2004-05-23"), TimestampArithTest.ts("2004-02-23 08:25:01"), 0, null, null), new OneDiffTest(8, TimestampArithTest.dt("2004-05-23"), TimestampArithTest.ts("2003-02-23 08:25:00"), -1, null, null)};
    private static final OneAddTest[] addBetweenTsTests = new OneAddTest[]{new OneAddTest(0, 1000, TimestampArithTest.ts("2005-05-11 15:55:00"), TimestampArithTest.ts("2005-05-11 15:55:00.000001"), null, null), new OneAddTest(1, 60, TimestampArithTest.ts("2005-05-11 15:55:00"), TimestampArithTest.ts("2005-05-11 15:56:00"), null, null), new OneAddTest(2, -1, TimestampArithTest.ts("2005-05-11 15:55:00"), TimestampArithTest.ts("2005-05-11 15:54:00"), null, null), new OneAddTest(3, 2, TimestampArithTest.ts("2005-05-11 15:55:00"), TimestampArithTest.ts("2005-05-11 17:55:00"), null, null), new OneAddTest(4, 1, TimestampArithTest.ts("2005-05-11 15:55:00"), TimestampArithTest.ts("2005-05-12 15:55:00"), null, null), new OneAddTest(5, 1, TimestampArithTest.ts("2005-05-11 15:55:00"), TimestampArithTest.ts("2005-05-18 15:55:00"), null, null), new OneAddTest(6, 1, TimestampArithTest.ts("2005-05-11 15:55:00"), TimestampArithTest.ts("2005-06-11 15:55:00"), null, null), new OneAddTest(7, 1, TimestampArithTest.ts("2005-10-11 15:55:00"), TimestampArithTest.ts("2006-01-11 15:55:00"), null, null), new OneAddTest(8, -10, TimestampArithTest.ts("2005-10-11 15:55:00"), TimestampArithTest.ts("1995-10-11 15:55:00"), null, null)};
    private static final OneAddTest[] addBetweenDateAndTsTests = new OneAddTest[]{new OneAddTest(0, -1000, TimestampArithTest.dt("2005-05-11"), TimestampArithTest.ts("2005-05-10 23:59:59.999999"), null, null), new OneAddTest(1, 60, TimestampArithTest.dt("2005-05-11"), TimestampArithTest.ts("2005-05-11 00:01:00"), null, null), new OneAddTest(2, 1, TimestampArithTest.dt("2005-05-11"), TimestampArithTest.ts("2005-05-11 00:01:00"), null, null), new OneAddTest(3, -2, TimestampArithTest.dt("2005-05-11"), TimestampArithTest.ts("2005-05-10 22:00:00"), null, null), new OneAddTest(4, 1, TimestampArithTest.dt("2005-05-11"), TimestampArithTest.ts("2005-05-12 00:00:00"), null, null), new OneAddTest(5, 1, TimestampArithTest.dt("2005-05-11"), TimestampArithTest.ts("2005-05-18 00:00:00"), null, null), new OneAddTest(6, -1, TimestampArithTest.dt("2005-03-29"), TimestampArithTest.ts("2005-02-28 00:00:00"), null, null), new OneAddTest(7, -2, TimestampArithTest.dt("2005-05-05"), TimestampArithTest.ts("2004-11-05 00:00:00"), null, null), new OneAddTest(8, 2, TimestampArithTest.dt("2005-05-05"), TimestampArithTest.ts("2007-05-05 00:00:00"), null, null)};
    private static final OneStringDiffTest[] diffBetweenStringTests = new OneStringDiffTest[]{new OneStringDiffTest(1, "2005-05-10 08:25:00", "2005-05-10 08:26:00", 60, null, null)};
    private static final OneStringAddTest[] addBetweenStringTests = new OneStringAddTest[]{new OneStringAddTest(4, 1, "2005-05-11 15:55:00", TimestampArithTest.ts("2005-05-12 15:55:00"), null, null)};
    private static final OneTest[] overflowTests = new OneTest[]{new OneDiffTest(0, TimestampArithTest.ts("2004-05-10 00:00:00.123456"), TimestampArithTest.ts("2004-05-10 00:00:10.123456"), 0, "22003", "The resulting value is outside the range for the data type INTEGER."), new OneDiffTest(0, TimestampArithTest.ts("2004-05-10 00:00:00.123456"), TimestampArithTest.ts("2005-05-10 00:00:00.123456"), 0, "22003", "The resulting value is outside the range for the data type INTEGER."), new OneDiffTest(1, TimestampArithTest.ts("1904-05-10 00:00:00"), TimestampArithTest.ts("2205-05-10 00:00:00"), 0, "22003", "The resulting value is outside the range for the data type INTEGER."), new OneAddTest(8, 99999, TimestampArithTest.ts("2004-05-10 00:00:00.123456"), null, "22003", "The resulting value is outside the range for the data type TIMESTAMP.")};
    private static final String[][] invalid = new String[][]{{"values( {fn TIMESTAMPDIFF( SECOND, CURRENT_TIMESTAMP, CURRENT_TIMESTAMP)})", "42X01", "Syntax error: Encountered \"SECOND\" at line 1, column 28."}, {"values( {fn TIMESTAMPDIFF( , CURRENT_TIMESTAMP, CURRENT_TIMESTAMP)})", "42X01", "Syntax error: Encountered \",\" at line 1, column 28."}, {"values( {fn TIMESTAMPDIFF( SQL_TSI_SECOND, CURRENT_TIMESTAMP, CURRENT_TIMESTAMP, 5)})", "42X01", "Syntax error: Encountered \",\" at line 1, column 80."}, {"values( {fn TIMESTAMPDIFF( SQL_TSI_SECOND, CURRENT_TIMESTAMP, 'x')})", "42X45", "CHAR is an invalid type for argument number 3 of TIMESTAMPDIFF."}, {"values( {fn TIMESTAMPDIFF( SQL_TSI_SECOND, 'x', CURRENT_TIMESTAMP)})", "42X45", "CHAR is an invalid type for argument number 2 of TIMESTAMPDIFF."}, {"values( {fn TIMESTAMPDIFF( SQL_TSI_SECOND, CURRENT_TIMESTAMP)})", "42X01", "Syntax error: Encountered \")\" at line 1, column 61."}, {"values( {fn TIMESTAMPDIFF( SQL_TSI_SECOND)})", "42X01", "Syntax error: Encountered \")\" at line 1, column 42."}, {"values( {fn TIMESTAMPADD( x, 1, CURRENT_TIMESTAMP)})", "42X01", "Syntax error: Encountered \"x\" at line 1, column 27."}, {"values( {fn TIMESTAMPADD( SQL_TSI_SECOND, CURRENT_DATE, CURRENT_TIMESTAMP)})", "42X45", "DATE is an invalid type for argument number 2 of TIMESTAMPADD."}, {"values( {fn TIMESTAMPADD( SQL_TSI_SECOND, 'XX', CURRENT_TIMESTAMP)})", "42X45", "CHAR is an invalid type for argument number 2 of TIMESTAMPADD."}, {"values( {fn TIMESTAMPADD( SQL_TSI_SECOND, 1.1, CURRENT_TIMESTAMP)})", "42X45", "DECIMAL is an invalid type for argument number 2 of TIMESTAMPADD."}, {"values( {fn TIMESTAMPADD( SQL_TSI_SECOND, 1, 2.1)})", "42X45", "DECIMAL is an invalid type for argument number 3 of TIMESTAMPADD."}, {"values( {fn TIMESTAMPADD( SQL_TSI_SECOND, 1, 'XX')})", "42X45", "CHAR is an invalid type for argument number 3 of TIMESTAMPADD."}, {"values( {fn TIMESTAMPADD( SQL_TSI_SECOND, 1)})", "42X01", "Syntax error: Encountered \")\" at line 1, column 44."}, {"values( {fn TIMESTAMPADD( SQL_TSI_SECOND)})", "42X01", "Syntax error: Encountered \")\" at line 1, column 41."}};
    private static final String[] intervalJdbcNames = new String[]{"SQL_TSI_FRAC_SECOND", "SQL_TSI_SECOND", "SQL_TSI_MINUTE", "SQL_TSI_HOUR", "SQL_TSI_DAY", "SQL_TSI_WEEK", "SQL_TSI_MONTH", "SQL_TSI_QUARTER", "SQL_TSI_YEAR"};
    private static Statement stmt;
    private static PreparedStatement[] tsAddPS;
    private static PreparedStatement[] tsDiffPS;

    public TimestampArithTest(String string) {
        super(string);
    }

    @Override
    protected void initializeConnection(Connection connection) throws SQLException {
        connection.setAutoCommit(false);
    }

    public static Test suite() {
        return new BaseJDBCTestSetup((Test)new BaseTestSuite(TimestampArithTest.class, "TimestampArithTest")){

            protected void setUp() throws Exception {
                super.setUp();
                for (int i = 0; i < intervalJdbcNames.length; ++i) {
                    TimestampArithTest.tsAddPS[i] = this.getConnection().prepareStatement(TimestampArithTest.composeSqlStr("ADD", i, "?", "?"));
                    TimestampArithTest.tsDiffPS[i] = this.getConnection().prepareStatement(TimestampArithTest.composeSqlStr("DIFF", i, "?", "?"));
                }
                stmt = this.getConnection().createStatement();
            }

            @Override
            protected void tearDown() throws Exception {
                TimestampArithTest.closeAll(tsAddPS);
                tsAddPS = null;
                TimestampArithTest.closeAll(tsDiffPS);
                tsDiffPS = null;
                stmt.close();
                stmt = null;
                super.tearDown();
            }
        };
    }

    private static void closeAll(Statement[] statementArray) throws SQLException {
        for (int i = 0; i < statementArray.length; ++i) {
            statementArray[i].close();
        }
    }

    public void testDiffBetweenTimestamp() throws SQLException {
        this.getConnection();
        for (int i = 0; i < diffBetweenTsTests.length; ++i) {
            diffBetweenTsTests[i].runTest();
        }
    }

    public void testDiffBetweenTimestampAndDate() throws SQLException {
        for (int i = 0; i < diffBetweenTsAndDateTests.length; ++i) {
            diffBetweenTsAndDateTests[i].runTest();
        }
    }

    public void testDiffBetweenDateAndTimestamp() throws SQLException {
        for (int i = 0; i < diffBetweenDateAndTsTests.length; ++i) {
            diffBetweenDateAndTsTests[i].runTest();
        }
    }

    public void testAddBetweenTimestamp() throws SQLException {
        for (int i = 0; i < addBetweenTsTests.length; ++i) {
            addBetweenTsTests[i].runTest();
        }
    }

    public void testAddBetweenDateAndTimestamps() throws SQLException {
        for (int i = 0; i < addBetweenDateAndTsTests.length; ++i) {
            addBetweenDateAndTsTests[i].runTest();
        }
    }

    public void testDiffBetweenString() throws SQLException {
        for (int i = 0; i < diffBetweenStringTests.length; ++i) {
            diffBetweenStringTests[i].runTest();
        }
    }

    public void testAddBetweenString() throws SQLException {
        for (int i = 0; i < addBetweenStringTests.length; ++i) {
            addBetweenStringTests[i].runTest();
        }
    }

    public void testOverflow() throws SQLException {
        for (int i = 0; i < overflowTests.length; ++i) {
            overflowTests[i].runTest();
        }
    }

    public void testNullInputs() throws SQLException {
        tsDiffPS[3].setTimestamp(1, TimestampArithTest.ts("2005-05-11 15:26:00"));
        tsDiffPS[3].setNull(2, 93);
        TimestampArithTest.expectNullResult(tsDiffPS[3]);
        tsDiffPS[3].setNull(2, 91);
        TimestampArithTest.expectNullResult(tsDiffPS[3]);
        tsDiffPS[3].setTimestamp(2, TimestampArithTest.ts("2005-05-11 15:26:00"));
        tsDiffPS[3].setNull(1, 93);
        TimestampArithTest.expectNullResult(tsDiffPS[3]);
        tsDiffPS[3].setNull(1, 91);
        TimestampArithTest.expectNullResult(tsDiffPS[3]);
        tsAddPS[2].setTimestamp(2, TimestampArithTest.ts("2005-05-11 15:26:00"));
        tsAddPS[2].setNull(1, 4);
        TimestampArithTest.expectNullResult(tsAddPS[2]);
        tsAddPS[2].setInt(1, 1);
        tsAddPS[2].setNull(2, 93);
        TimestampArithTest.expectNullResult(tsAddPS[2]);
        tsAddPS[2].setNull(2, 91);
        TimestampArithTest.expectNullResult(tsAddPS[2]);
    }

    public void testInvalidLengths() throws SQLException {
        for (int i = 0; i < invalid.length; ++i) {
            try {
                ResultSet resultSet = stmt.executeQuery(invalid[i][0]);
                resultSet.next();
                TimestampArithTest.fail((String)(invalid[i][0] + " did not throw an exception."));
                continue;
            }
            catch (SQLException sQLException) {
                TimestampArithTest.assertSQLState("Unexpected SQLState from " + invalid[i][0], invalid[i][1], sQLException);
            }
        }
    }

    public void testInvalidArgTypes() throws SQLException {
        TimestampArithTest.expectException(tsDiffPS[3], TimestampArithTest.ts("2005-05-21 15:26:00"), 2.0, "XCL12", "TIMESTAMPDIFF with double ts2");
        TimestampArithTest.expectException(tsDiffPS[3], 2.0, TimestampArithTest.ts("2005-05-11 15:26:00"), "XCL12", "TIMESTAMPDIFF with double ts1");
        TimestampArithTest.expectException(tsAddPS[2], 1, -1, "XCL12", "TIMESTAMPADD with int ts");
        TimestampArithTest.expectException(tsAddPS[2], TimestampArithTest.ts("2005-05-11 15:26:00"), TimestampArithTest.ts("2005-05-11 15:26:00"), "XCL12", "TIMESTAMPADD with timestamp count");
    }

    private static void expectException(PreparedStatement preparedStatement, Object object, Object object2, String string, String string2) {
        try {
            preparedStatement.setObject(1, object);
            preparedStatement.setObject(2, object2);
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            TimestampArithTest.fail((String)(string2 + " did not throw an exception."));
        }
        catch (SQLException sQLException) {
            TimestampArithTest.assertSQLState("Unexpected SQLState from " + string2, string, sQLException);
        }
    }

    private static void expectNullResult(PreparedStatement preparedStatement) throws SQLException {
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), null);
    }

    private static String dateTimeToLiteral(Object object) {
        if (object instanceof Timestamp) {
            return "{ts '" + ((Timestamp)object).toString() + "'}";
        }
        if (object instanceof Time) {
            return "{t '" + ((Time)object).toString() + "'}";
        }
        if (object instanceof Date) {
            return "{d '" + ((Date)object).toString() + "'}";
        }
        if (object instanceof String) {
            return "TIMESTAMP( '" + (String)object + "')";
        }
        return object.toString();
    }

    private static String composeSqlStr(String string, int n, String string2, String string3) {
        return "values( {fn TIMESTAMP" + string + "( " + intervalJdbcNames[n] + ", " + string2 + "," + string3 + ")})";
    }

    private static void setDateTime(PreparedStatement preparedStatement, int n, java.util.Date date) throws SQLException {
        if (date instanceof Timestamp) {
            preparedStatement.setTimestamp(n, (Timestamp)date);
        } else if (date instanceof Date) {
            preparedStatement.setDate(n, (Date)date);
        } else if (date instanceof Time) {
            preparedStatement.setTime(n, (Time)date);
        } else {
            preparedStatement.setTimestamp(n, (Timestamp)date);
        }
    }

    private static Timestamp ts(String string) {
        if (string.length() < 29) {
            StringBuffer stringBuffer = new StringBuffer(string);
            if (string.length() == 19) {
                stringBuffer.append('.');
            }
            while (stringBuffer.length() < 29) {
                stringBuffer.append('0');
            }
            string = stringBuffer.toString();
        }
        return Timestamp.valueOf(string);
    }

    private static Date dt(String string) {
        return Date.valueOf(string);
    }

    static {
        tsAddPS = new PreparedStatement[intervalJdbcNames.length];
        tsDiffPS = new PreparedStatement[intervalJdbcNames.length];
    }

    private static class OneDiffTest
    extends OneTest {
        private final java.util.Date ts1;
        private final java.util.Date ts2;
        private final int expectedDiff;
        protected boolean expectNull;

        OneDiffTest(int n, java.util.Date date, java.util.Date date2, int n2, String string, String string2) {
            super(n, string, string2);
            this.ts1 = date;
            this.ts2 = date2;
            this.expectedDiff = n2;
            this.expectNull = date == null || date2 == null;
        }

        @Override
        void checkResultRow(ResultSet resultSet, String string) throws SQLException {
            int n = resultSet.getInt(1);
            Assert.assertFalse((String)("Unexpected null result from '" + string + "'."), (resultSet.wasNull() && !this.expectNull ? 1 : 0) != 0);
            Assert.assertFalse((String)("Expected null result from '" + string + "'."), (!resultSet.wasNull() && this.expectNull ? 1 : 0) != 0);
            Assert.assertEquals((String)("Unexpected result from '" + string + "'."), (int)this.expectedDiff, (int)n);
        }

        @Override
        String composeSQL() {
            return TimestampArithTest.composeSqlStr("DIFF", this.interval, TimestampArithTest.dateTimeToLiteral(this.ts1), TimestampArithTest.dateTimeToLiteral(this.ts2));
        }

        @Override
        ResultSet executePS() throws SQLException {
            TimestampArithTest.setDateTime(tsDiffPS[this.interval], 1, this.ts1);
            TimestampArithTest.setDateTime(tsDiffPS[this.interval], 2, this.ts2);
            return tsDiffPS[this.interval].executeQuery();
        }
    }

    private static class OneAddTest
    extends OneTest {
        private final java.util.Date ts;
        final int count;
        final Timestamp expected;

        OneAddTest(int n, int n2, java.util.Date date, Timestamp timestamp, String string, String string2) {
            super(n, string, string2);
            this.count = n2;
            this.ts = date;
            this.expected = timestamp;
        }

        @Override
        String composeSQL() {
            return TimestampArithTest.composeSqlStr("ADD", this.interval, String.valueOf(this.count), TimestampArithTest.dateTimeToLiteral(this.ts));
        }

        @Override
        void checkResultRow(ResultSet resultSet, String string) throws SQLException {
            Timestamp timestamp = resultSet.getTimestamp(1);
            Assert.assertFalse((String)("Unexpected null result from '" + string + "'."), ((resultSet.wasNull() || timestamp == null) && this.expected != null ? 1 : 0) != 0);
            Assert.assertFalse((String)("Expected null result from '" + string + "'."), (!resultSet.wasNull() && timestamp != null && this.expected == null ? 1 : 0) != 0);
            Assert.assertEquals((String)("Unexpected result from '" + string + "'."), (Object)this.expected, (Object)timestamp);
        }

        @Override
        ResultSet executePS() throws SQLException {
            tsAddPS[this.interval].setInt(1, this.count);
            TimestampArithTest.setDateTime(tsAddPS[this.interval], 2, this.ts);
            return tsAddPS[this.interval].executeQuery();
        }
    }

    private static class OneStringDiffTest
    extends OneDiffTest {
        private final String ts1;
        private final String ts2;

        OneStringDiffTest(int n, String string, String string2, int n2, String string3, String string4) {
            super(n, null, null, n2, string3, string4);
            this.ts1 = string;
            this.ts2 = string2;
            this.expectNull = string == null || string2 == null;
        }

        @Override
        String composeSQL() {
            return TimestampArithTest.composeSqlStr("DIFF", this.interval, TimestampArithTest.dateTimeToLiteral(this.ts1), TimestampArithTest.dateTimeToLiteral(this.ts2));
        }

        @Override
        ResultSet executePS() throws SQLException {
            tsDiffPS[this.interval].setString(1, this.ts1);
            tsDiffPS[this.interval].setString(2, this.ts2);
            return tsDiffPS[this.interval].executeQuery();
        }
    }

    private static class OneStringAddTest
    extends OneAddTest {
        private final String ts;

        OneStringAddTest(int n, int n2, String string, Timestamp timestamp, String string2, String string3) {
            super(n, n2, null, timestamp, string2, string3);
            this.ts = string;
        }

        @Override
        String composeSQL() {
            return TimestampArithTest.composeSqlStr("ADD", this.interval, String.valueOf(this.count), TimestampArithTest.dateTimeToLiteral(this.ts));
        }

        @Override
        ResultSet executePS() throws SQLException {
            tsAddPS[this.interval].setInt(1, this.count);
            tsAddPS[this.interval].setString(2, this.ts);
            return tsAddPS[this.interval].executeQuery();
        }
    }

    private static abstract class OneTest {
        final int interval;
        final String expectedSQLState;
        final String expectedMsg;
        String sql;

        OneTest(int n, String string, String string2) {
            this.interval = n;
            this.expectedSQLState = string;
            this.expectedMsg = string2;
        }

        void runTest() throws SQLException {
            ResultSet resultSet = null;
            this.sql = this.composeSQL();
            try {
                resultSet = stmt.executeQuery(this.sql);
                this.checkResultSet(resultSet, this.sql);
                if (this.expectedSQLState != null) {
                    Assert.fail((String)("Statement '" + this.sql + "' did not generate an exception"));
                }
            }
            catch (SQLException sQLException) {
                if (this.expectedSQLState == null) {
                    BaseTestCase.fail("Unexpected exception from statement '" + this.sql + "'", sQLException);
                }
                BaseJDBCTestCase.assertSQLState("Incorrect SQLState from statement '" + this.sql + "'", this.expectedSQLState, sQLException);
            }
            if (resultSet != null) {
                resultSet.close();
                resultSet = null;
            }
            try {
                resultSet = this.executePS();
                this.checkResultSet(resultSet, this.sql);
                if (this.expectedSQLState != null) {
                    Assert.fail((String)("Prepared Statement '" + this.sql + "' did not generate an exception"));
                }
            }
            catch (SQLException sQLException) {
                if (this.expectedSQLState == null) {
                    BaseTestCase.fail("Unexpected exception from prepared statement '" + this.sql + "'", sQLException);
                }
                BaseJDBCTestCase.assertSQLState("Incorrect SQLState from prepared statement '" + this.sql + "'", this.expectedSQLState, sQLException);
            }
            if (resultSet != null) {
                resultSet.close();
                resultSet = null;
            }
        }

        private void checkResultSet(ResultSet resultSet, String string) throws SQLException {
            Assert.assertTrue((String)("'" + string + "' did not return any rows."), (boolean)resultSet.next());
            this.checkResultRow(resultSet, string);
            Assert.assertFalse((String)("'" + string + "' returned more than one row."), (boolean)resultSet.next());
        }

        abstract String composeSQL();

        abstract void checkResultRow(ResultSet var1, String var2) throws SQLException;

        abstract ResultSet executePS() throws SQLException;
    }
}

