/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.io.IOException;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.streams.CharAlphabet;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class StreamTruncationTest
extends BaseJDBCTestCase {
    public static final int CONV_BUFFER_SIZE = 32768;
    public static final int CLOB = 2;
    public static final int VARCHAR = 3;
    public static final int LONGVARCHAR = 4;
    public static final int CHAR = 5;
    public static final String TABLE_SMALL = "TRUNCATE_SMALL";
    public static final String TABLE_LARGE = "TRUNCATE_LARGE";
    public static final int SMALL_SIZE = 16384;
    public static final int LARGE_SIZE = 65536;
    public static final int LARGE_VARCHAR_SIZE = 32672;
    public static final int CHAR_SIZE = 138;
    private static AtomicInteger ID = new AtomicInteger(1);

    public StreamTruncationTest(String string) {
        super(string);
    }

    public void setUp() throws SQLException {
        this.setAutoCommit(false);
    }

    public void testCharWithLength() throws IOException, SQLException {
        this.charSmall(false);
    }

    public void testCharWithoutLength() throws IOException, SQLException {
        this.charSmall(true);
    }

    public void testSmallVarcharWithLength() throws IOException, SQLException {
        this.generalTypeSmall(3, false);
    }

    public void testSmallVarcharWithoutLength() throws IOException, SQLException {
        this.generalTypeSmall(3, true);
    }

    public void testLargeVarcharWithLength() throws IOException, SQLException {
        this.generalTypeLarge(3, false);
    }

    public void testLargeVarcharWithoutLength() throws IOException, SQLException {
        this.generalTypeLarge(3, true);
    }

    public void testLongVarcharWithLength() throws IOException, SQLException {
        this.generalTypeSmall(4, false);
    }

    public void testLongVarcharWithoutLength() throws IOException, SQLException {
        this.generalTypeSmall(4, true);
    }

    public void testSmallClobWithLength() throws IOException, SQLException {
        this.generalTypeSmall(2, false);
    }

    public void testSmallClobWithoutLength() throws IOException, SQLException {
        this.generalTypeSmall(2, true);
    }

    public void testLargeClobWithLength() throws IOException, SQLException {
        this.generalTypeLarge(2, false);
    }

    public void testLargeClobWithoutLength() throws IOException, SQLException {
        this.generalTypeLarge(2, true);
    }

    private void generalTypeLarge(int n, boolean bl) throws IOException, SQLException {
        this.insertLarge(n, bl, 65536, 0);
        this.insertLarge(n, bl, 65437, 15);
        this.insertLarge(n, bl, 65725, 189);
        this.insertLarge(n, bl, 65536, 250);
        this.insertLarge(n, bl, 65716, 0);
        this.insertLarge(n, bl, 65716, 17);
    }

    private void generalTypeSmall(int n, boolean bl) throws IOException, SQLException {
        this.insertSmall(n, bl, 16384, 0);
        this.insertSmall(n, bl, 16285, 15);
        this.insertSmall(n, bl, 16573, 189);
        this.insertSmall(n, bl, 16384, 250);
        this.insertSmall(n, bl, 16564, 0);
        this.insertSmall(n, bl, 16564, 17);
    }

    private void charSmall(boolean bl) throws IOException, SQLException {
        this.insertSmall(5, bl, 138, 0);
        this.insertSmall(5, bl, 128, 4);
        this.insertSmall(5, bl, 327, 189);
        this.insertSmall(5, bl, 138, 20);
        this.insertSmall(5, bl, 318, 0);
        this.insertSmall(5, bl, 318, 17);
    }

    private int insertSmall(int n, boolean bl, int n2, int n3) throws IOException, SQLException {
        int n4 = ID.getAndAdd(1);
        PreparedStatement preparedStatement = this.prepareStatement("insert into TRUNCATE_SMALL values (?,?,?,?,?)");
        preparedStatement.setInt(1, n4);
        preparedStatement.setNull(2, 2005);
        preparedStatement.setNull(3, 12);
        preparedStatement.setNull(4, -1);
        preparedStatement.setNull(5, 1);
        int n5 = 16384;
        if (n == 4) {
            n5 = 32700;
        }
        int n6 = Math.min(n2, n5);
        if (n == 5) {
            n6 = 138;
            n5 = 138;
        }
        StreamTruncationTest.println("totalLength=" + n2 + ", blanks=" + n3 + ", colWidth=" + n5 + ", expectedLength=" + n6);
        LoopingAlphabetReader loopingAlphabetReader = new LoopingAlphabetReader(n2, CharAlphabet.modernLatinLowercase(), n3);
        if (bl) {
            preparedStatement.setCharacterStream(n, loopingAlphabetReader);
        } else {
            preparedStatement.setCharacterStream(n, (Reader)loopingAlphabetReader, n2);
        }
        try {
            StreamTruncationTest.assertEquals((int)1, (int)preparedStatement.executeUpdate());
            if (n2 > n6) {
                StreamTruncationTest.assertTrue((n2 - n3 <= n6 ? 1 : 0) != 0);
            }
            StreamTruncationTest.assertEquals((int)n6, (int)this.getStreamLength(TABLE_SMALL, n, n4));
        }
        catch (SQLException sQLException) {
            if (n == 4) {
                StreamTruncationTest.assertTrue((n2 > n6 ? 1 : 0) != 0);
            } else {
                StreamTruncationTest.assertTrue((n2 - n3 > n6 ? 1 : 0) != 0);
            }
            String string = "XSDA4";
            if (n == 5 || n == 3) {
                string = bl ? "XJ001" : (!StreamTruncationTest.usingEmbedded() ? "XJ001" : "22001");
            }
            StreamTruncationTest.assertSQLState(string, sQLException);
        }
        return n4;
    }

    private int insertLarge(int n, boolean bl, int n2, int n3) throws IOException, SQLException {
        StreamTruncationTest.assertTrue((n != 5 && n != 4 ? 1 : 0) != 0);
        int n4 = ID.getAndAdd(1);
        PreparedStatement preparedStatement = this.prepareStatement("insert into TRUNCATE_LARGE values (?,?,?)");
        preparedStatement.setInt(1, n4);
        preparedStatement.setNull(2, 2005);
        preparedStatement.setNull(3, 12);
        int n5 = n == 3 ? 32672 : 65536;
        int n6 = Math.min(n2, n5);
        StreamTruncationTest.println("totalLength=" + n2 + ", blanks=" + n3 + ", colWidth=" + n5 + ", expectedLength=" + n6);
        LoopingAlphabetReader loopingAlphabetReader = new LoopingAlphabetReader(n2, CharAlphabet.modernLatinLowercase(), n3);
        if (bl) {
            preparedStatement.setCharacterStream(n, loopingAlphabetReader);
        } else {
            preparedStatement.setCharacterStream(n, (Reader)loopingAlphabetReader, n2);
        }
        try {
            StreamTruncationTest.assertEquals((int)1, (int)preparedStatement.executeUpdate());
            if (n2 > n6) {
                StreamTruncationTest.assertTrue((n2 - n3 <= n6 ? 1 : 0) != 0);
            }
            StreamTruncationTest.assertEquals((int)n6, (int)this.getStreamLength(TABLE_LARGE, n, n4));
        }
        catch (SQLException sQLException) {
            StreamTruncationTest.assertTrue((n2 - n3 > n6 ? 1 : 0) != 0);
            String string = "XSDA4";
            if (n == 3) {
                string = bl ? "XJ001" : (!StreamTruncationTest.usingEmbedded() ? "XJ001" : "22001");
            }
            StreamTruncationTest.assertSQLState(string, sQLException);
        }
        return n4;
    }

    private int getStreamLength(String string, int n, int n2) throws IOException, SQLException {
        int n3;
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from " + string + " where id = " + n2);
        StreamTruncationTest.assertTrue((boolean)resultSet.next());
        Reader reader = resultSet.getCharacterStream(n);
        int n4 = 0;
        char[] cArray = new char[1024];
        while ((n3 = reader.read(cArray)) != -1) {
            n4 += n3;
        }
        resultSet.close();
        return n4;
    }

    public static Test suite() {
        return new CleanDatabaseTestSetup(TestConfiguration.defaultSuite(StreamTruncationTest.class, false)){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.executeUpdate("create table TRUNCATE_SMALL (ID int primary key, CLOBDATA clob(16384),VCHARDATA varchar(16384),LVCHARDATA long varchar,CHARDATA char(138))");
                statement.executeUpdate("create table TRUNCATE_LARGE (ID int primary key, CLOBDATA clob(65536),VCHARDATA varchar(32672))");
                statement.close();
            }
        };
    }
}

