/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLType;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import junit.framework.Test;
import org.apache.derby.iapi.types.HarmonySerialBlob;
import org.apache.derby.iapi.types.HarmonySerialClob;
import org.apache.derbyTesting.functionTests.tests.lang.Price;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class PreparedStatementTest42
extends BaseJDBCTestCase {
    private static final String UNIMPLEMENTED_FEATURE = "0A000";
    private static final JDBCType[] ILLEGAL_JDBC_TYPES = new JDBCType[]{JDBCType.ARRAY, JDBCType.DATALINK, JDBCType.DISTINCT, JDBCType.LONGNVARCHAR, JDBCType.NCHAR, JDBCType.NCLOB, JDBCType.NULL, JDBCType.NVARCHAR, JDBCType.OTHER, JDBCType.REF, JDBCType.REF_CURSOR, JDBCType.ROWID, JDBCType.SQLXML, JDBCType.STRUCT};
    private static final int[] ILLEGAL_SQL_TYPES = new int[]{2003, 70, 2001, -16, -15, 2011, -9, 1111, 2006, 2012, -8, 2009, 2002};
    private static ColumnDesc[] _columnDescs = new ColumnDesc[]{new ColumnDesc(JDBCType.BIGINT, "bigint", 0L, 1L, null), new ColumnDesc(JDBCType.BLOB, "blob", PreparedStatementTest42.makeBlob("01234"), PreparedStatementTest42.makeBlob("56789"), null), new ColumnDesc(JDBCType.BOOLEAN, "boolean", Boolean.FALSE, Boolean.TRUE, null), new ColumnDesc(JDBCType.CHAR, "char( 5 )", "01234", "56789", null), new ColumnDesc(JDBCType.BINARY, "char( 5 ) for bit data", PreparedStatementTest42.makeBinary("01234"), PreparedStatementTest42.makeBinary("56789"), null), new ColumnDesc(JDBCType.CLOB, "clob", PreparedStatementTest42.makeClob("01234"), PreparedStatementTest42.makeClob("56789"), null), new ColumnDesc(JDBCType.DATE, "date", new Date(0L), new Date(1L), null), new ColumnDesc(JDBCType.DECIMAL, "decimal", new BigDecimal(0), new BigDecimal(1), null), new ColumnDesc(JDBCType.DOUBLE, "double", 0.0, 1.0, null), new ColumnDesc(JDBCType.FLOAT, "float", 0.0, 1.0, null), new ColumnDesc(JDBCType.INTEGER, "int", 0, 1, null), new ColumnDesc(JDBCType.LONGVARCHAR, "long varchar", "01234", "56789", null), new ColumnDesc(JDBCType.LONGVARBINARY, "long varchar for bit data", PreparedStatementTest42.makeBinary("01234"), PreparedStatementTest42.makeBinary("56789"), null), new ColumnDesc(JDBCType.NUMERIC, "numeric", new BigDecimal(0), new BigDecimal(1), null), new ColumnDesc(JDBCType.REAL, "real", Float.valueOf(0.0f), Float.valueOf(1.0f), null), new ColumnDesc(JDBCType.SMALLINT, "smallint", 0, 1, null), new ColumnDesc(JDBCType.TIME, "time", new Time(0L), new Time(1L), null), new ColumnDesc(JDBCType.TIMESTAMP, "timestamp", new Timestamp(0L), new Timestamp(1L), null), new ColumnDesc(JDBCType.JAVA_OBJECT, "Price", PreparedStatementTest42.makePrice(0L), PreparedStatementTest42.makePrice(1L), null), new ColumnDesc(JDBCType.VARCHAR, "varchar( 5 )", "01234", "56789", null), new ColumnDesc(JDBCType.VARBINARY, "varchar( 5 ) for bit data", PreparedStatementTest42.makeBinary("01234"), PreparedStatementTest42.makeBinary("56789"), null)};

    public PreparedStatementTest42(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("PreparedStatementTest42");
        suite.addTest(TestConfiguration.defaultSuite(PreparedStatementTest42.class));
        return suite;
    }

    public void test_01_setObject() throws Exception {
        Connection conn = this.getConnection();
        PreparedStatementTest42.setupPrice(conn);
        this.makeTable(conn);
        this.populateTable(conn);
        this.vetTableContents(conn);
        this.updateColumns(conn);
    }

    private void makeTable(Connection conn) throws Exception {
        StringBuilder buffer = new StringBuilder();
        buffer.append("create table allTypes\n(\n");
        buffer.append("\tcol0\tint generated always as identity");
        for (int i = 0; i < _columnDescs.length; ++i) {
            ColumnDesc cd = _columnDescs[i];
            String columnName = "col" + (i + 1);
            String columnType = cd.sqlType;
            buffer.append("\n\t, " + columnName + "\t" + columnType);
        }
        buffer.append("\n)");
        conn.prepareStatement(buffer.toString()).execute();
    }

    private void populateTable(Connection conn) throws Exception {
        int rowIdx;
        PreparedStatement insert = this.prepareInsert(conn);
        for (rowIdx = 0; rowIdx < 3; ++rowIdx) {
            this.insertRow(insert, rowIdx);
        }
        for (rowIdx = 0; rowIdx < 3; ++rowIdx) {
            for (int colIdx = 0; colIdx < _columnDescs.length; ++colIdx) {
                ColumnDesc cd = _columnDescs[colIdx];
                insert.setObject(colIdx + 1, cd.values[rowIdx], cd.jdbcType, 0);
            }
            insert.executeUpdate();
        }
        for (int i = 0; i < ILLEGAL_JDBC_TYPES.length; ++i) {
            try {
                insert.setObject(1, null, ILLEGAL_JDBC_TYPES[i]);
                PreparedStatementTest42.fail((String)"setObject() should have failed.");
                continue;
            }
            catch (SQLException se) {
                PreparedStatementTest42.assertUnimplemented(se);
            }
        }
        insert.close();
    }

    private static void assertUnimplemented(SQLException se) throws Exception {
        PreparedStatementTest42.assertSQLState(UNIMPLEMENTED_FEATURE, se);
        PreparedStatementTest42.assertTrue((boolean)(se instanceof SQLFeatureNotSupportedException));
    }

    private PreparedStatement prepareInsert(Connection conn) throws Exception {
        StringBuilder columnBuffer = new StringBuilder();
        StringBuilder valuesBuffer = new StringBuilder();
        columnBuffer.append("( ");
        valuesBuffer.append("( ");
        for (int i = 0; i < _columnDescs.length; ++i) {
            String columnName = "col" + (i + 1);
            if (i > 0) {
                columnBuffer.append(", ");
                valuesBuffer.append(", ");
            }
            columnBuffer.append(columnName);
            valuesBuffer.append("?");
        }
        columnBuffer.append(" )");
        valuesBuffer.append(" )");
        PreparedStatement insert = conn.prepareStatement("insert into allTypes " + columnBuffer.toString() + " values " + valuesBuffer.toString());
        return insert;
    }

    private void insertRow(PreparedStatement insert, int rowIdx) throws Exception {
        for (int colIdx = 0; colIdx < _columnDescs.length; ++colIdx) {
            ColumnDesc cd = _columnDescs[colIdx];
            insert.setObject(colIdx + 1, cd.values[rowIdx], cd.jdbcType);
        }
        insert.executeUpdate();
    }

    private void vetTableContents(Connection conn) throws Exception {
        PreparedStatement selectPS = conn.prepareStatement("select * from allTypes order by col0");
        ResultSet selectRS = selectPS.executeQuery();
        int rowCount = 0;
        while (selectRS.next()) {
            int rowIdx = rowCount % 3;
            for (int colIdx = 0; colIdx < _columnDescs.length; ++colIdx) {
                Object expected = PreparedStatementTest42._columnDescs[colIdx].values[rowIdx];
                PreparedStatementTest42.assertObjectEquals(expected, selectRS.getObject(colIdx + 2));
            }
            ++rowCount;
        }
        selectRS.close();
        selectPS.close();
    }

    private void updateColumns(Connection conn) throws Exception {
        ColumnDesc cd;
        int colIdx;
        PreparedStatement forUpdatePS = conn.prepareStatement("select * from allTypes for update", 1003, 1008);
        ResultSet updateRS = null;
        this.prepTable(conn, 0);
        updateRS = forUpdatePS.executeQuery();
        updateRS.next();
        for (colIdx = 0; colIdx < _columnDescs.length; ++colIdx) {
            cd = _columnDescs[colIdx];
            updateRS.updateObject(colIdx + 2, cd.values[1], (SQLType)cd.jdbcType);
        }
        updateRS.updateRow();
        updateRS.close();
        this.vetTable(conn, 1, 1);
        this.prepTable(conn, 0);
        updateRS = forUpdatePS.executeQuery();
        updateRS.next();
        for (colIdx = 0; colIdx < _columnDescs.length; ++colIdx) {
            cd = _columnDescs[colIdx];
            updateRS.updateObject(colIdx + 2, cd.values[1], (SQLType)cd.jdbcType, 0);
        }
        updateRS.updateRow();
        updateRS.close();
        this.vetTable(conn, 1, 1);
        this.prepTable(conn, 0);
        updateRS = forUpdatePS.executeQuery();
        updateRS.next();
        for (colIdx = 0; colIdx < _columnDescs.length; ++colIdx) {
            cd = _columnDescs[colIdx];
            updateRS.updateObject("col" + (colIdx + 1), cd.values[1], (SQLType)cd.jdbcType);
        }
        updateRS.updateRow();
        updateRS.close();
        this.vetTable(conn, 1, 1);
        this.prepTable(conn, 0);
        updateRS = forUpdatePS.executeQuery();
        updateRS.next();
        for (colIdx = 0; colIdx < _columnDescs.length; ++colIdx) {
            cd = _columnDescs[colIdx];
            updateRS.updateObject("col" + (colIdx + 1), cd.values[1], (SQLType)cd.jdbcType, 0);
        }
        updateRS.updateRow();
        updateRS.close();
        this.vetTable(conn, 1, 1);
        this.prepTable(conn, 0);
        updateRS = forUpdatePS.executeQuery();
        updateRS.next();
        PreparedStatementTest42.println("Testing ResultSet.updateObject() on illegal types.");
        for (int i = 0; i < ILLEGAL_JDBC_TYPES.length; ++i) {
            try {
                updateRS.updateObject(2, PreparedStatementTest42._columnDescs[0].values[1], (SQLType)ILLEGAL_JDBC_TYPES[i]);
                PreparedStatementTest42.fail((String)"updateObject() should have failed.");
            }
            catch (SQLException se) {
                PreparedStatementTest42.assertUnimplemented(se);
            }
            try {
                updateRS.updateObject(2, PreparedStatementTest42._columnDescs[0].values[1], (SQLType)ILLEGAL_JDBC_TYPES[i], 0);
                PreparedStatementTest42.fail((String)"updateObject() should have failed.");
            }
            catch (SQLException se) {
                PreparedStatementTest42.assertUnimplemented(se);
            }
            try {
                updateRS.updateObject("col2", PreparedStatementTest42._columnDescs[0].values[1], (SQLType)ILLEGAL_JDBC_TYPES[i]);
                PreparedStatementTest42.fail((String)"updateObject() should have failed.");
            }
            catch (SQLException se) {
                PreparedStatementTest42.assertUnimplemented(se);
            }
            try {
                updateRS.updateObject("col2", PreparedStatementTest42._columnDescs[0].values[1], (SQLType)ILLEGAL_JDBC_TYPES[i], 0);
                PreparedStatementTest42.fail((String)"updateObject() should have failed.");
                continue;
            }
            catch (SQLException se) {
                PreparedStatementTest42.assertUnimplemented(se);
            }
        }
        updateRS.close();
        this.vetTable(conn, 0, 1);
    }

    private void prepTable(Connection conn, int rowIdx) throws Exception {
        conn.prepareStatement("truncate table allTypes").execute();
        PreparedStatement insert = this.prepareInsert(conn);
        this.insertRow(insert, rowIdx);
        this.vetTable(conn, rowIdx, 1);
    }

    private void vetTable(Connection conn, int rowIdx, int expectedRowCount) throws Exception {
        PreparedStatement selectPS = conn.prepareStatement("select * from allTypes order by col0");
        ResultSet selectRS = selectPS.executeQuery();
        int actualRowCount = 0;
        while (selectRS.next()) {
            for (int colIdx = 0; colIdx < _columnDescs.length; ++colIdx) {
                Object expected = PreparedStatementTest42._columnDescs[colIdx].values[rowIdx];
                PreparedStatementTest42.assertObjectEquals(expected, selectRS.getObject(colIdx + 2));
            }
            ++actualRowCount;
        }
        PreparedStatementTest42.assertEquals((int)expectedRowCount, (int)actualRowCount);
        selectRS.close();
        selectPS.close();
    }

    public void test_02_registerObject() throws Exception {
        Connection conn = this.getConnection();
        PreparedStatementTest42.registerObjectTest(conn);
    }

    public static void registerObjectTest(Connection conn) throws Exception {
        PreparedStatementTest42.createSchemaObjects(conn);
        PreparedStatementTest42.vetProc(conn);
    }

    private static void createSchemaObjects(Connection conn) throws Exception {
        PreparedStatementTest42.setupPrice(conn);
        PreparedStatementTest42.createProc(conn);
    }

    private static void createProc(Connection conn) throws Exception {
        StringBuilder buffer = new StringBuilder();
        buffer.append("create procedure unpackAllTypes( in valueIdx int");
        for (int i = 0; i < _columnDescs.length; ++i) {
            ColumnDesc cd = _columnDescs[i];
            String parameterName = "param" + (i + 1);
            String parameterType = cd.sqlType;
            buffer.append(", out " + parameterName + " " + parameterType);
        }
        buffer.append(" ) language java parameter style java no sql\n");
        buffer.append("external name 'org.apache.derbyTesting.functionTests.tests.jdbc4.PreparedStatementTest42.unpackAllTypes'");
        String sqlText = buffer.toString();
        PreparedStatementTest42.println(sqlText);
        conn.prepareStatement(sqlText).execute();
    }

    private static void vetProc(Connection conn) throws Exception {
        int i;
        StringBuilder buffer = new StringBuilder();
        buffer.append("call unpackAllTypes( ?");
        for (int i2 = 0; i2 < _columnDescs.length; ++i2) {
            buffer.append(", ?");
        }
        buffer.append(" )");
        String sqlText = buffer.toString();
        PreparedStatementTest42.println(sqlText);
        CallableStatement cs = conn.prepareCall(sqlText);
        int valueIdx = 0;
        int param = 1;
        cs.setInt(param++, valueIdx);
        for (i = 0; i < _columnDescs.length; ++i) {
            cs.registerOutParameter(param++, (SQLType)PreparedStatementTest42._columnDescs[i].jdbcType);
        }
        cs.execute();
        PreparedStatementTest42.vetCS(cs, valueIdx);
        valueIdx = 1;
        param = 1;
        cs.setInt(param++, valueIdx);
        for (i = 0; i < _columnDescs.length; ++i) {
            cs.registerOutParameter(param++, (SQLType)PreparedStatementTest42._columnDescs[i].jdbcType, 0);
        }
        cs.execute();
        PreparedStatementTest42.vetCS(cs, valueIdx);
        valueIdx = 0;
        param = 1;
        cs.setInt(param++, valueIdx);
        for (i = 0; i < _columnDescs.length; ++i) {
            cs.registerOutParameter(param++, (SQLType)PreparedStatementTest42._columnDescs[i].jdbcType, "foo");
        }
        cs.execute();
        PreparedStatementTest42.vetCS(cs, valueIdx);
        valueIdx = 1;
        param = 1;
        cs.setInt(param++, valueIdx);
        for (i = 0; i < ILLEGAL_JDBC_TYPES.length; ++i) {
            try {
                cs.registerOutParameter(param++, (SQLType)ILLEGAL_JDBC_TYPES[i], 0);
                PreparedStatementTest42.fail();
                continue;
            }
            catch (SQLException se) {
                PreparedStatementTest42.assertUnimplemented(se);
            }
        }
        try {
            cs.registerOutParameter("param1", (SQLType)PreparedStatementTest42._columnDescs[0].jdbcType);
            PreparedStatementTest42.fail((String)"Expected unimplemented feature.");
        }
        catch (SQLException se) {
            PreparedStatementTest42.assertUnimplemented(se);
        }
        try {
            cs.registerOutParameter("param1", (SQLType)PreparedStatementTest42._columnDescs[0].jdbcType, 0);
            PreparedStatementTest42.fail((String)"Expected unimplemented feature.");
        }
        catch (SQLException se) {
            PreparedStatementTest42.assertUnimplemented(se);
        }
        try {
            cs.registerOutParameter("param1", (SQLType)PreparedStatementTest42._columnDescs[0].jdbcType, "foo");
            PreparedStatementTest42.fail((String)"Expected unimplemented feature.");
        }
        catch (SQLException se) {
            PreparedStatementTest42.assertUnimplemented(se);
        }
        valueIdx = 1;
        param = 1;
        cs.setInt(param++, valueIdx);
        for (int i3 = 0; i3 < ILLEGAL_SQL_TYPES.length; ++i3) {
            int type = ILLEGAL_SQL_TYPES[i3];
            try {
                cs.registerOutParameter(param++, type, 0);
                PreparedStatementTest42.fail((String)("Should not have been able to register parameter type " + type));
                continue;
            }
            catch (SQLException se) {
                PreparedStatementTest42.assertUnimplemented(se);
            }
        }
    }

    private static void vetCS(CallableStatement cs, int valueIdx) throws Exception {
        int idx = 0;
        int colIdx = 2;
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[idx++].values[valueIdx], cs.getObject(colIdx++));
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[idx++].values[valueIdx], cs.getObject(colIdx++));
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[idx++].values[valueIdx], cs.getObject(colIdx++));
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[idx++].values[valueIdx], cs.getObject(colIdx++));
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[idx++].values[valueIdx], cs.getObject(colIdx++));
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[idx++].values[valueIdx], cs.getObject(colIdx++));
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[idx++].values[valueIdx], cs.getObject(colIdx++));
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[idx++].values[valueIdx], cs.getObject(colIdx++));
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[idx++].values[valueIdx], cs.getObject(colIdx++));
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[idx++].values[valueIdx], cs.getObject(colIdx++));
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[idx++].values[valueIdx], cs.getObject(colIdx++));
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[idx++].values[valueIdx], cs.getObject(colIdx++));
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[idx++].values[valueIdx], cs.getObject(colIdx++));
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[idx++].values[valueIdx], cs.getObject(colIdx++));
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[idx++].values[valueIdx], cs.getObject(colIdx++));
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[idx++].values[valueIdx], cs.getObject(colIdx++));
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[idx++].values[valueIdx], cs.getObject(colIdx++));
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[idx++].values[valueIdx], cs.getObject(colIdx++));
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[idx++].values[valueIdx], cs.getObject(colIdx++));
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[idx++].values[valueIdx], cs.getObject(colIdx++));
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[idx++].values[valueIdx], cs.getObject(colIdx++));
    }

    public void test_03_setObject() throws Exception {
        Connection conn = this.getConnection();
        PreparedStatementTest42.callableStatementSetObjectTest(conn);
    }

    public static void callableStatementSetObjectTest(Connection conn) throws Exception {
        PreparedStatementTest42.createSetObjectSchemaObjects(conn);
        PreparedStatementTest42.vetSetObjectProc(conn);
    }

    private static void createSetObjectSchemaObjects(Connection conn) throws Exception {
        PreparedStatementTest42.setupPrice(conn);
        PreparedStatementTest42.createSetObjectProc(conn);
    }

    private static void createSetObjectProc(Connection conn) throws Exception {
        StringBuilder buffer = new StringBuilder();
        buffer.append("create procedure packAllTypes( in valueIdx int");
        for (int i = 0; i < _columnDescs.length; ++i) {
            ColumnDesc cd = _columnDescs[i];
            String parameterName = "param" + (i + 1);
            String parameterType = cd.sqlType;
            buffer.append(", in " + parameterName + " " + parameterType);
        }
        buffer.append(" ) language java parameter style java no sql\n");
        buffer.append("external name 'org.apache.derbyTesting.functionTests.tests.jdbc4.PreparedStatementTest42.packAllTypes'");
        String sqlText = buffer.toString();
        PreparedStatementTest42.println(sqlText);
        conn.prepareStatement(sqlText).execute();
    }

    private static void vetSetObjectProc(Connection conn) throws Exception {
        ColumnDesc cd;
        ColumnDesc cd2;
        int i;
        StringBuilder buffer = new StringBuilder();
        buffer.append("call packAllTypes( ?");
        for (int i2 = 0; i2 < _columnDescs.length; ++i2) {
            buffer.append(", ?");
        }
        buffer.append(" )");
        String sqlText = buffer.toString();
        PreparedStatementTest42.println(sqlText);
        CallableStatement cs = conn.prepareCall(sqlText);
        int valueIdx = 0;
        int param = 1;
        cs.setInt(param++, valueIdx);
        for (i = 0; i < _columnDescs.length; ++i) {
            cd2 = _columnDescs[i];
            cs.setObject(param++, cd2.values[valueIdx], (SQLType)cd2.jdbcType);
        }
        cs.execute();
        valueIdx = 1;
        param = 1;
        cs.setInt(param++, valueIdx);
        for (i = 0; i < _columnDescs.length; ++i) {
            cd2 = _columnDescs[i];
            cs.setObject(param++, cd2.values[valueIdx], (SQLType)cd2.jdbcType, 0);
        }
        cs.execute();
        try {
            cd = _columnDescs[0];
            cs.setObject("param1", cd.values[0], (SQLType)cd.jdbcType);
            PreparedStatementTest42.fail((String)"Expected unimplemented feature.");
        }
        catch (SQLException se) {
            PreparedStatementTest42.assertUnimplemented(se);
        }
        try {
            cd = _columnDescs[0];
            cs.setObject("param1", cd.values[0], (SQLType)cd.jdbcType, 0);
            PreparedStatementTest42.fail((String)"Expected unimplemented feature.");
        }
        catch (SQLException se) {
            PreparedStatementTest42.assertUnimplemented(se);
        }
    }

    public void test_04_targetTypeIsNull() throws Exception {
        this.setAutoCommit(false);
        PreparedStatement ps = this.prepareStatement("values cast(? as int)");
        try {
            ps.setObject(1, (Object)1, null);
            PreparedStatementTest42.fail((String)"setObject should fail when type is null");
        }
        catch (SQLException se) {
            PreparedStatementTest42.assertUnimplemented(se);
        }
        try {
            ps.setObject(1, (Object)1, null, 1);
            PreparedStatementTest42.fail((String)"setObject should fail when type is null");
        }
        catch (SQLException se) {
            PreparedStatementTest42.assertUnimplemented(se);
        }
        Statement s = this.createStatement(1003, 1008);
        s.execute("create table t(x int)");
        s.execute("insert into t values 1");
        ResultSet rs = s.executeQuery("select * from t");
        PreparedStatementTest42.assertTrue((boolean)rs.next());
        try {
            rs.updateObject("x", (Object)1, null);
            PreparedStatementTest42.fail((String)"updateObject should fail when type is null");
        }
        catch (SQLException se) {
            PreparedStatementTest42.assertUnimplemented(se);
        }
        try {
            rs.updateObject(1, (Object)1, null);
            PreparedStatementTest42.fail((String)"updateObject should fail when type is null");
        }
        catch (SQLException se) {
            PreparedStatementTest42.assertUnimplemented(se);
        }
        try {
            rs.updateObject("x", (Object)1, null, 1);
            PreparedStatementTest42.fail((String)"updateObject should fail when type is null");
        }
        catch (SQLException se) {
            PreparedStatementTest42.assertUnimplemented(se);
        }
        try {
            rs.updateObject(1, (Object)1, null, 1);
            PreparedStatementTest42.fail((String)"updateObject should fail when type is null");
        }
        catch (SQLException se) {
            PreparedStatementTest42.assertUnimplemented(se);
        }
        JDBC.assertEmpty(rs);
    }

    public static void unpackAllTypes(int valueIdx, Long[] bigintValue, Blob[] blobValue, Boolean[] booleanValue, String[] charValue, byte[][] binaryValue, Clob[] clobValue, Date[] dateValue, BigDecimal[] decimalValue, Double[] doubleValue, Double[] floatValue, Integer[] intValue, String[] longVarcharValue, byte[][] longVarbinaryValue, BigDecimal[] numericValue, Float[] realValue, Integer[] smallintValue, Time[] timeValue, Timestamp[] timestampValue, Price[] priceValue, String[] varcharValue, byte[][] varbinaryValue) {
        int colIdx = 0;
        bigintValue[0] = (Long)PreparedStatementTest42._columnDescs[colIdx++].values[valueIdx];
        blobValue[0] = (Blob)PreparedStatementTest42._columnDescs[colIdx++].values[valueIdx];
        booleanValue[0] = (Boolean)PreparedStatementTest42._columnDescs[colIdx++].values[valueIdx];
        charValue[0] = (String)PreparedStatementTest42._columnDescs[colIdx++].values[valueIdx];
        binaryValue[0] = (byte[])PreparedStatementTest42._columnDescs[colIdx++].values[valueIdx];
        clobValue[0] = (Clob)PreparedStatementTest42._columnDescs[colIdx++].values[valueIdx];
        dateValue[0] = (Date)PreparedStatementTest42._columnDescs[colIdx++].values[valueIdx];
        decimalValue[0] = (BigDecimal)PreparedStatementTest42._columnDescs[colIdx++].values[valueIdx];
        doubleValue[0] = (Double)PreparedStatementTest42._columnDescs[colIdx++].values[valueIdx];
        floatValue[0] = (Double)PreparedStatementTest42._columnDescs[colIdx++].values[valueIdx];
        intValue[0] = (Integer)PreparedStatementTest42._columnDescs[colIdx++].values[valueIdx];
        longVarcharValue[0] = (String)PreparedStatementTest42._columnDescs[colIdx++].values[valueIdx];
        longVarbinaryValue[0] = (byte[])PreparedStatementTest42._columnDescs[colIdx++].values[valueIdx];
        numericValue[0] = (BigDecimal)PreparedStatementTest42._columnDescs[colIdx++].values[valueIdx];
        realValue[0] = (Float)PreparedStatementTest42._columnDescs[colIdx++].values[valueIdx];
        smallintValue[0] = (Integer)PreparedStatementTest42._columnDescs[colIdx++].values[valueIdx];
        timeValue[0] = (Time)PreparedStatementTest42._columnDescs[colIdx++].values[valueIdx];
        timestampValue[0] = (Timestamp)PreparedStatementTest42._columnDescs[colIdx++].values[valueIdx];
        priceValue[0] = (Price)PreparedStatementTest42._columnDescs[colIdx++].values[valueIdx];
        varcharValue[0] = (String)PreparedStatementTest42._columnDescs[colIdx++].values[valueIdx];
        varbinaryValue[0] = (byte[])PreparedStatementTest42._columnDescs[colIdx++].values[valueIdx];
    }

    public static void packAllTypes(int valueIdx, Long bigintValue, Blob blobValue, Boolean booleanValue, String charValue, byte[] binaryValue, Clob clobValue, Date dateValue, BigDecimal decimalValue, Double doubleValue, Double floatValue, Integer intValue, String longVarcharValue, byte[] longVarbinaryValue, BigDecimal numericValue, Float realValue, Integer smallintValue, Time timeValue, Timestamp timestampValue, Price priceValue, String varcharValue, byte[] varbinaryValue) throws Exception {
        int colIdx = 0;
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[colIdx++].values[valueIdx], bigintValue);
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[colIdx++].values[valueIdx], blobValue);
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[colIdx++].values[valueIdx], booleanValue);
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[colIdx++].values[valueIdx], charValue);
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[colIdx++].values[valueIdx], binaryValue);
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[colIdx++].values[valueIdx], clobValue);
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[colIdx++].values[valueIdx], dateValue);
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[colIdx++].values[valueIdx], decimalValue);
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[colIdx++].values[valueIdx], doubleValue);
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[colIdx++].values[valueIdx], floatValue);
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[colIdx++].values[valueIdx], intValue);
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[colIdx++].values[valueIdx], longVarcharValue);
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[colIdx++].values[valueIdx], longVarbinaryValue);
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[colIdx++].values[valueIdx], numericValue);
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[colIdx++].values[valueIdx], realValue);
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[colIdx++].values[valueIdx], smallintValue);
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[colIdx++].values[valueIdx], timeValue);
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[colIdx++].values[valueIdx], timestampValue);
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[colIdx++].values[valueIdx], priceValue);
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[colIdx++].values[valueIdx], varcharValue);
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[colIdx++].values[valueIdx], varbinaryValue);
    }

    private static void setupPrice(Connection conn) throws Exception {
        if (!PreparedStatementTest42.aliasExists(conn, "PRICE")) {
            conn.prepareStatement("create type Price external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java").execute();
        }
    }

    private static boolean aliasExists(Connection conn, String aliasName) throws Exception {
        PreparedStatement ps = conn.prepareStatement("select count(*) from sys.sysaliases where alias = ?");
        ps.setString(1, aliasName);
        ResultSet rs = ps.executeQuery();
        rs.next();
        int retval = rs.getInt(1);
        rs.close();
        ps.close();
        return retval > 0;
    }

    private static Blob makeBlob(String contents) {
        return new HarmonySerialBlob(PreparedStatementTest42.makeBinary(contents));
    }

    private static Clob makeClob(String contents) {
        return new HarmonySerialClob(contents);
    }

    private static byte[] makeBinary(String contents) {
        try {
            return contents.getBytes("UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Price makePrice(long raw) {
        return Price.makePrice(new BigDecimal(raw));
    }

    public static void assertObjectEquals(Object expected, Object actual) throws Exception {
        if (expected == null) {
            PreparedStatementTest42.assertNull((Object)actual);
            return;
        }
        if (actual == null) {
            PreparedStatementTest42.assertNull((Object)expected);
            return;
        }
        if (expected instanceof Blob) {
            PreparedStatementTest42.assertEquals((Blob)expected, (Blob)actual);
        } else if (expected instanceof Clob) {
            PreparedStatementTest42.assertEquals((Clob)expected, (Clob)actual);
        } else if (expected instanceof byte[]) {
            PreparedStatementTest42.compareBytes((byte[])expected, (byte[])actual);
        } else {
            PreparedStatementTest42.assertEquals((String)expected.toString(), (String)actual.toString());
        }
    }

    private static void compareBytes(byte[] left, byte[] right) throws Exception {
        int count = left.length;
        if (count != right.length) {
            PreparedStatementTest42.fail((String)("left count = " + count + " but right count = " + right.length));
        }
        for (int i = 0; i < count; ++i) {
            if (left[i] == right[i]) continue;
            PreparedStatementTest42.fail((String)("left[ " + i + " ] = " + left[i] + " but right[ " + i + " ] = " + right[i]));
        }
    }

    public static final class ColumnDesc {
        public static final int VALUE_COUNT = 3;
        public final JDBCType jdbcType;
        public final String sqlType;
        public final Object[] values;

        public ColumnDesc(JDBCType jdbcType, String sqlType, Object ... values) {
            this.jdbcType = jdbcType;
            this.sqlType = sqlType;
            this.values = values;
            if (values.length != 3) {
                throw new IllegalArgumentException("Expected 3 values but saw " + values.length);
            }
        }
    }
}

