/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.derby.iapi.types.HarmonySerialBlob;
import org.apache.derby.iapi.types.HarmonySerialClob;
import org.apache.derbyTesting.functionTests.tests.lang.Price;
import org.apache.derbyTesting.functionTests.tests.lang.StringArrayVTI;

public class VarargsRoutines {
    public static Integer max(Integer ... values) {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return null;
        }
        int result = Integer.MIN_VALUE;
        for (Integer value : values) {
            if (value == null) {
                return null;
            }
            result = Math.max(result, value);
        }
        return result;
    }

    public static String formatMessage(String message, String ... args) {
        return MessageFormat.format(message, args);
    }

    public static String ambiguousTypes(int ... a) {
        return "primitive";
    }

    public static String ambiguousTypes(Integer ... a) {
        return "wrapper";
    }

    public static Integer maxInts(int ... values) {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return null;
        }
        int result = Integer.MIN_VALUE;
        for (int value : values) {
            result = Math.max(result, value);
        }
        return result;
    }

    public static String nonVarargsMethod(int a) {
        return "shouldn't be resolved";
    }

    public static String nonVarargsMethod(int[] a) {
        return "shouldn't be resolved";
    }

    public static Integer vnvr(int a) {
        return -a;
    }

    public static Integer vnvr(int ... a) {
        return VarargsRoutines.maxInts(a);
    }

    public static Integer lnv(int ... a) {
        return VarargsRoutines.maxInts(a);
    }

    public static Integer lnv(int first, int ... a) {
        return VarargsRoutines.maxInts(a);
    }

    public static Integer lnv(int first, int second, int ... a) {
        return VarargsRoutines.maxInts(a);
    }

    public static void inVarargs(String[] result, int ... values) {
        String retval;
        if (values == null) {
            retval = null;
        } else if (values.length == 0) {
            retval = null;
        } else {
            StringBuilder buffer = new StringBuilder();
            buffer.append("RESULT: ");
            for (int value : values) {
                buffer.append(" " + Integer.toString(value));
            }
            retval = buffer.toString();
        }
        result[0] = retval;
    }

    public static void outVarargs(int seed, int[] ... values) throws Exception {
        if (values == null) {
            return;
        }
        for (int i = 0; i < values.length; ++i) {
            values[i][0] = seed + i;
        }
    }

    public static void inoutVarargs(int seed, int[] ... values) throws Exception {
        if (values == null) {
            return;
        }
        for (int i = 0; i < values.length; ++i) {
            int[] nArray = values[i];
            nArray[0] = nArray[0] + seed;
        }
    }

    public static String add(String seed, int ... values) {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return null;
        }
        int result = 0;
        for (int value : values) {
            result += value;
        }
        return "int " + seed + " " + result;
    }

    public static String add(String seed, long ... values) {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return null;
        }
        long result = 0L;
        for (long value : values) {
            result += value;
        }
        return "long " + seed + " " + result;
    }

    public static String add(String seed, short ... values) {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return null;
        }
        short result = 0;
        for (short value : values) {
            result = (short)(result + value);
        }
        return "short " + seed + " " + result;
    }

    public static String add(String seed, Blob ... values) throws SQLException {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return null;
        }
        long result = 0L;
        for (Blob value : values) {
            result += (long)VarargsRoutines.addBytes(value.getBytes(1L, (int)value.length()));
        }
        return "blob " + seed + " " + result;
    }

    public static String add(String seed, boolean ... values) throws SQLException {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return null;
        }
        int result = 0;
        for (boolean value : values) {
            if (!value) continue;
            ++result;
        }
        return "boolean " + seed + " " + result;
    }

    public static String add(String seed, String ... values) throws SQLException {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return null;
        }
        String result = "";
        for (String value : values) {
            result = result + value;
        }
        return "String " + seed + " " + result;
    }

    public static String add(String seed, byte[] ... values) throws SQLException {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return null;
        }
        int result = 0;
        for (byte[] value : values) {
            result += VarargsRoutines.addBytes(value);
        }
        return "byte[] " + seed + " " + result;
    }

    public static String add(String seed, Clob ... values) throws SQLException {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return null;
        }
        String result = "";
        for (Clob value : values) {
            result = result + value.getSubString(1L, (int)value.length());
        }
        return "clob " + seed + " " + result;
    }

    public static String add(String seed, Date ... values) throws SQLException {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return null;
        }
        long result = 0L;
        for (Date value : values) {
            ++result;
        }
        return "date " + seed + " " + result;
    }

    public static String add(String seed, Time ... values) throws SQLException {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return null;
        }
        long result = 0L;
        for (Time value : values) {
            ++result;
        }
        return "time " + seed + " " + result;
    }

    public static String add(String seed, Timestamp ... values) throws SQLException {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return null;
        }
        long result = 0L;
        for (Timestamp value : values) {
            ++result;
        }
        return "timestamp " + seed + " " + result;
    }

    public static String add(String seed, BigDecimal ... values) {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return null;
        }
        long result = 0L;
        for (BigDecimal value : values) {
            result += value.longValue();
        }
        return "bigdecimal " + seed + " " + result;
    }

    public static String add(String seed, double ... values) {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return null;
        }
        double result = 0.0;
        for (double value : values) {
            result += value;
        }
        return "double " + seed + " " + result;
    }

    public static String add(String seed, float ... values) {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return null;
        }
        float result = 0.0f;
        for (float value : values) {
            result += value;
        }
        return "float " + seed + " " + result;
    }

    public static String add(String seed, Price ... values) throws SQLException {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return null;
        }
        long result = 0L;
        for (Price value : values) {
            ++result;
        }
        return "Price " + seed + " " + result;
    }

    private static int addChars(String value) {
        int result = 0;
        for (int i = 0; i < value.length(); ++i) {
            result += value.charAt(i);
        }
        return result;
    }

    public static Blob makeBlob(String contents) throws SQLException {
        return new HarmonySerialBlob(VarargsRoutines.makeBytes(contents));
    }

    public static byte[] makeBytes(String contents) throws SQLException {
        int count = contents.length();
        byte[] bytes = new byte[count];
        for (int i = 0; i < count; ++i) {
            bytes[i] = (byte)(contents.charAt(i) - 48);
        }
        return bytes;
    }

    public static Clob makeClob(String contents) throws SQLException {
        return new HarmonySerialClob(contents);
    }

    private static int addBytes(byte[] value) {
        int result = 0;
        for (byte b : value) {
            result += b;
        }
        return result;
    }

    public static ResultSet oneColumnRows(String ... values) {
        String[][] rows;
        String[] columnNames = new String[]{"COL1"};
        if (values == null || values.length == 0) {
            rows = new String[][]{};
        } else {
            int count = values.length;
            rows = new String[count][];
            for (int i = 0; i < count; ++i) {
                rows[i] = new String[]{values[i]};
            }
        }
        return new StringArrayVTI(columnNames, rows);
    }

    public static ResultSet stringArrayTable(String columnNames, String ... rows) {
        ArrayList<String> columnList = new ArrayList<String>();
        StringTokenizer colToks = new StringTokenizer(columnNames);
        while (colToks.hasMoreTokens()) {
            columnList.add(colToks.nextToken());
        }
        String[] colNameArg = new String[columnList.size()];
        columnList.toArray(colNameArg);
        ArrayList<String[]> rowList = new ArrayList<String[]>();
        for (String row : rows) {
            ArrayList<String> valueList = new ArrayList<String>();
            StringTokenizer valueToks = new StringTokenizer(row);
            while (valueToks.hasMoreTokens()) {
                valueList.add(valueToks.nextToken());
            }
            String[] valueRow = new String[valueList.size()];
            valueList.toArray(valueRow);
            rowList.add(valueRow);
        }
        String[][] rowsArg = new String[rowList.size()][];
        rowList.toArray((T[])rowsArg);
        return new StringArrayVTI(colNameArg, rowsArg);
    }
}

