/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.BackingStoreHashtable;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.DeferredConstraintsMemory;
import org.apache.derby.impl.sql.execute.RowUtil;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderImpl;
import org.apache.derby.shared.common.sanity.SanityManager;

class IndexChanger {
    private final IndexRowGenerator irg;
    private final long indexCID;
    private final DynamicCompiledOpenConglomInfo indexDCOCI;
    private final StaticCompiledOpenConglomInfo indexSCOCI;
    private final String indexName;
    private ConglomerateController baseCC;
    private final TransactionController tc;
    private final int lockMode;
    private final FormatableBitSet baseRowReadMap;
    private ConglomerateController indexCC = null;
    private ScanController indexSC = null;
    private ExecIndexRow ourIndexRow = null;
    private ExecIndexRow ourUpdatedIndexRow = null;
    private TemporaryRowHolderImpl rowHolder = null;
    private boolean rowHolderPassedIn;
    private int isolationLevel;
    private final Activation activation;
    private boolean ownIndexSC = true;
    private final boolean deferrable;
    private final LanguageConnectionContext lcc;
    private BackingStoreHashtable deferredDuplicates;
    private UUID uniqueConstraintId;

    IndexChanger(IndexRowGenerator irg, long indexCID, StaticCompiledOpenConglomInfo indexSCOCI, DynamicCompiledOpenConglomInfo indexDCOCI, String indexName, ConglomerateController baseCC, TransactionController tc, int lockMode, FormatableBitSet baseRowReadMap, int isolationLevel, Activation activation) throws StandardException {
        this.irg = irg;
        this.deferrable = irg.hasDeferrableChecking();
        this.indexCID = indexCID;
        this.indexSCOCI = indexSCOCI;
        this.indexDCOCI = indexDCOCI;
        this.baseCC = baseCC;
        this.tc = tc;
        this.lockMode = lockMode;
        this.baseRowReadMap = baseRowReadMap;
        this.rowHolderPassedIn = false;
        this.isolationLevel = isolationLevel;
        this.activation = activation;
        this.indexName = indexName;
        LanguageConnectionContext languageConnectionContext = this.lcc = activation != null ? activation.getLanguageConnectionContext() : null;
        if (activation != null && activation.getIndexConglomerateNumber() == indexCID) {
            this.ownIndexSC = false;
        }
        SanityManager.ASSERT(tc != null, "TransactionController argument to constructor is null");
    }

    void setRowHolder(TemporaryRowHolderImpl rowHolder) {
        this.rowHolder = rowHolder;
        this.rowHolderPassedIn = rowHolder != null;
    }

    void setBaseCC(ConglomerateController baseCC) {
        this.baseCC = baseCC;
    }

    private void setOurIndexRow(ExecRow baseRow, RowLocation baseRowLoc) throws StandardException {
        if (this.ourIndexRow == null) {
            this.ourIndexRow = this.irg.getIndexRowTemplate();
        }
        this.irg.getIndexRow(baseRow, baseRowLoc, this.ourIndexRow, this.baseRowReadMap);
    }

    private void setOurUpdatedIndexRow(ExecRow baseRow, RowLocation baseRowLoc) throws StandardException {
        if (this.ourUpdatedIndexRow == null) {
            this.ourUpdatedIndexRow = this.irg.getIndexRowTemplate();
        }
        this.irg.getIndexRow(baseRow, baseRowLoc, this.ourUpdatedIndexRow, this.baseRowReadMap);
    }

    private boolean indexRowChanged() throws StandardException {
        int numColumns = this.ourIndexRow.nColumns();
        for (int index = 1; index <= numColumns; ++index) {
            DataValueDescriptor newOrderable;
            DataValueDescriptor oldOrderable = this.ourIndexRow.getColumn(index);
            if (oldOrderable.compare(2, newOrderable = this.ourUpdatedIndexRow.getColumn(index), true, true)) continue;
            return true;
        }
        return false;
    }

    private void setScan() throws StandardException {
        if (!this.ownIndexSC) {
            this.indexSC = this.activation.getIndexScanController();
        } else if (this.indexSC == null) {
            RowLocation templateBaseRowLocation = this.baseCC.newRowLocationTemplate();
            this.indexSC = this.indexSCOCI == null ? this.tc.openScan(this.indexCID, false, 4, this.lockMode, this.isolationLevel, null, this.ourIndexRow.getRowArray(), 1, null, this.ourIndexRow.getRowArray(), -1) : this.tc.openCompiledScan(false, 4, this.lockMode, this.isolationLevel, null, this.ourIndexRow.getRowArray(), 1, null, this.ourIndexRow.getRowArray(), -1, this.indexSCOCI, this.indexDCOCI);
        } else {
            this.indexSC.reopenScan(this.ourIndexRow.getRowArray(), 1, null, this.ourIndexRow.getRowArray(), -1);
        }
    }

    private void closeIndexCC() throws StandardException {
        if (this.indexCC != null) {
            this.indexCC.close();
        }
        this.indexCC = null;
    }

    private void closeIndexSC() throws StandardException {
        if (this.ownIndexSC && this.indexSC != null) {
            this.indexSC.close();
            this.indexSC = null;
        }
    }

    private void doDelete() throws StandardException {
        if (this.ownIndexSC && !this.indexSC.next()) {
            SanityManager.THROWASSERT("Index row " + RowUtil.toString(this.ourIndexRow) + " not found in conglomerateid " + this.indexCID + "Current scan = " + this.indexSC);
            Object[] args = new Object[]{this.ourIndexRow.getRowArray()[this.ourIndexRow.getRowArray().length - 1], this.indexCID};
            Monitor.getStream().println(MessageService.getTextMessage("X0Y83.S", args));
            return;
        }
        this.indexSC.delete();
    }

    private void doInsert() throws StandardException {
        this.insertAndCheckDups(this.ourIndexRow);
    }

    private void doDeferredInsert() throws StandardException {
        if (this.rowHolder == null) {
            Properties properties = new Properties();
            this.openIndexCC().getInternalTablePropertySet(properties);
            this.rowHolder = new TemporaryRowHolderImpl(this.activation, properties, null);
        }
        if (!this.rowHolderPassedIn) {
            this.rowHolder.insert(this.ourIndexRow);
        }
    }

    private UUID getUniqueConstraintId() throws StandardException {
        if (this.uniqueConstraintId == null) {
            DataDictionary dd = this.lcc.getDataDictionary();
            ConglomerateDescriptor cd = dd.getConglomerateDescriptor(this.indexCID);
            this.uniqueConstraintId = dd.getConstraintDescriptor(dd.getTableDescriptor(cd.getTableID()), cd.getUUID()).getUUID();
        }
        return this.uniqueConstraintId;
    }

    private void insertAndCheckDups(ExecIndexRow row) throws StandardException {
        int insertStatus;
        this.openIndexCC();
        DataValueDescriptor[] rowArray = row.getRowArray();
        if (this.deferrable) {
            insertStatus = this.indexCC.insert(row.getRowArray());
            SanityManager.ASSERT(insertStatus != 1);
            DataValueDescriptor[] key = new DataValueDescriptor[rowArray.length - 1];
            System.arraycopy(rowArray, 0, key, 0, key.length);
            boolean deferred = this.lcc.isEffectivelyDeferred(this.lcc.getCurrentSQLSessionContext(this.activation), this.getUniqueConstraintId());
            ScanController idxScan = this.tc.openScan(this.indexCID, false, deferred ? 32768 : 0, 6, 3, null, key, 1, null, key, -1);
            boolean duplicate = false;
            try {
                boolean foundOne = idxScan.next();
                SanityManager.ASSERT(foundOne, "IndexChanger: inserted row gone?");
                duplicate = foundOne && idxScan.next();
            }
            catch (StandardException e) {
                if ((e.getSQLState().equals("40XL1") || e.getSQLState().equals("40001")) && deferred) {
                    duplicate = true;
                }
                throw e;
            }
            if (duplicate && this.irg.isUniqueWithDuplicateNulls()) {
                int keyParts = rowArray.length - 1;
                for (int i = 0; i < keyParts; ++i) {
                    if (!rowArray[i].isNull()) continue;
                    duplicate = false;
                    break;
                }
            }
            if (duplicate) {
                if (deferred) {
                    this.deferredDuplicates = DeferredConstraintsMemory.rememberDuplicate(this.lcc, this.deferredDuplicates, this.getUniqueConstraintId(), row.getRowArray());
                } else {
                    insertStatus = 1;
                }
            }
        } else {
            insertStatus = this.indexCC.insert(row.getRowArray());
        }
        if (insertStatus == 1) {
            String indexOrConstraintName = this.indexName;
            LanguageConnectionContext lcc = this.activation.getLanguageConnectionContext();
            DataDictionary dd = lcc.getDataDictionary();
            ConglomerateDescriptor cd = dd.getConglomerateDescriptor(this.indexCID);
            UUID tableID = cd.getTableID();
            TableDescriptor td = dd.getTableDescriptor(tableID);
            String tableName = td.getName();
            if (indexOrConstraintName == null) {
                ConstraintDescriptor conDesc = dd.getConstraintDescriptor(td, cd.getUUID());
                indexOrConstraintName = conDesc.getConstraintName();
            }
            StandardException se = StandardException.newException("23505", indexOrConstraintName, tableName);
            throw se;
        }
        if (insertStatus != 0) {
            SanityManager.THROWASSERT("Unknown insert status " + insertStatus);
        }
    }

    private ConglomerateController openIndexCC() throws StandardException {
        if (this.indexCC == null) {
            this.indexCC = this.indexSCOCI == null ? this.tc.openConglomerate(this.indexCID, false, 16388, this.lockMode, this.isolationLevel) : this.tc.openCompiledConglomerate(false, 16388, this.lockMode, this.isolationLevel, this.indexSCOCI, this.indexDCOCI);
        }
        return this.indexCC;
    }

    void open() throws StandardException {
    }

    void delete(ExecRow baseRow, RowLocation baseRowLocation) throws StandardException {
        this.setOurIndexRow(baseRow, baseRowLocation);
        this.setScan();
        this.doDelete();
    }

    void update(ExecRow oldBaseRow, ExecRow newBaseRow, RowLocation baseRowLocation) throws StandardException {
        this.setOurIndexRow(oldBaseRow, baseRowLocation);
        this.setOurUpdatedIndexRow(newBaseRow, baseRowLocation);
        if (this.indexRowChanged()) {
            this.setScan();
            this.doDelete();
            this.insertForUpdate(newBaseRow, baseRowLocation);
        }
    }

    void insert(ExecRow newRow, RowLocation baseRowLocation) throws StandardException {
        this.setOurIndexRow(newRow, baseRowLocation);
        this.doInsert();
    }

    void insertForUpdate(ExecRow newRow, RowLocation baseRowLocation) throws StandardException {
        this.setOurIndexRow(newRow, baseRowLocation);
        if (this.irg.isUnique() || this.irg.isUniqueWithDuplicateNulls() || this.irg.hasDeferrableChecking()) {
            this.doDeferredInsert();
        } else {
            this.doInsert();
        }
    }

    void finish() throws StandardException {
        if (this.rowHolder != null) {
            CursorResultSet rs = this.rowHolder.getResultSet();
            try {
                ExecRow deferredRow;
                rs.open();
                while ((deferredRow = rs.getNextRow()) != null) {
                    if (!(deferredRow instanceof ExecIndexRow)) {
                        SanityManager.THROWASSERT("deferredRow isn't an instance of ExecIndexRow as expected. It is an " + deferredRow.getClass().getName());
                    }
                    this.insertAndCheckDups((ExecIndexRow)deferredRow);
                }
            }
            finally {
                rs.close();
                if (!this.rowHolderPassedIn) {
                    this.rowHolder.close();
                }
            }
        }
    }

    void close() throws StandardException {
        this.closeIndexCC();
        this.closeIndexSC();
        if (this.rowHolder != null && !this.rowHolderPassedIn) {
            this.rowHolder.close();
        }
        this.baseCC = null;
    }
}

