/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.ConnectionContext;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.impl.sql.execute.NoRowsResultSetImpl;

class CallStatementResultSet
extends NoRowsResultSetImpl {
    private final GeneratedMethod methodCall;

    CallStatementResultSet(GeneratedMethod methodCall, Activation a) {
        super(a);
        this.methodCall = methodCall;
    }

    @Override
    public void open() throws StandardException {
        this.setup();
        this.methodCall.invoke(this.activation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws StandardException {
        this.close(false);
        ResultSet[][] dynamicResults = this.getActivation().getDynamicResults();
        if (dynamicResults != null) {
            StandardException errorOnClose = null;
            ConnectionContext jdbcContext = null;
            for (int i = 0; i < dynamicResults.length; ++i) {
                ResultSet[] param = dynamicResults[i];
                ResultSet drs = param[0];
                if (drs == null) continue;
                if (jdbcContext == null) {
                    jdbcContext = (ConnectionContext)((Object)this.lcc.getContextManager().getContext("JDBC_ConnectionContext"));
                }
                try {
                    if (!jdbcContext.processInaccessibleDynamicResult(drs)) continue;
                    drs.close();
                    continue;
                }
                catch (SQLException e) {
                    StandardException se;
                    if (errorOnClose != null) continue;
                    errorOnClose = se = StandardException.plainWrapException(e);
                    continue;
                }
                finally {
                    param[0] = null;
                }
            }
            if (errorOnClose != null) {
                throw errorOnClose;
            }
        }
    }

    @Override
    public void cleanUp() throws StandardException {
        this.close();
    }
}

