/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.HasNodeVisitor;
import org.apache.derby.impl.sql.compile.SubqueryNode;
import org.apache.derby.impl.sql.compile.ValueNode;

class VerifyAggregateExpressionsVisitor
implements Visitor {
    private GroupByList groupByList;

    VerifyAggregateExpressionsVisitor(GroupByList groupByList) {
        this.groupByList = groupByList;
    }

    @Override
    public Visitable visit(Visitable node) throws StandardException {
        if (node instanceof ColumnReference) {
            ColumnReference cr = (ColumnReference)node;
            if (this.groupByList == null) {
                throw StandardException.newException("42Y35", cr.getSQLColumnName());
            }
            if (this.groupByList.findGroupingColumn(cr) == null) {
                throw StandardException.newException("42Y36", cr.getSQLColumnName());
            }
        } else if (node instanceof SubqueryNode) {
            SubqueryNode subq = (SubqueryNode)node;
            if (subq.getSubqueryType() != 17 || subq.hasCorrelatedCRs()) {
                throw StandardException.newException(this.groupByList == null ? "42Y29" : "42Y30", new Object[0]);
            }
            HasNodeVisitor visitor = new HasNodeVisitor(AggregateNode.class);
            subq.accept(visitor);
            if (visitor.hasNode()) {
                throw StandardException.newException(this.groupByList == null ? "42Y29" : "42Y30", new Object[0]);
            }
        }
        return node;
    }

    @Override
    public boolean skipChildren(Visitable node) throws StandardException {
        return node instanceof AggregateNode || node instanceof SubqueryNode || node instanceof ValueNode && this.groupByList != null && this.groupByList.findGroupingColumn((ValueNode)node) != null;
    }

    @Override
    public boolean stopTraversal() {
        return false;
    }

    @Override
    public boolean visitChildrenFirst(Visitable node) {
        return false;
    }
}

