/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.SubqueryNode;

class RemapCRsVisitor
implements Visitor {
    private boolean remap;

    RemapCRsVisitor(boolean remap) {
        this.remap = remap;
    }

    @Override
    public Visitable visit(Visitable node) throws StandardException {
        if (node instanceof ColumnReference) {
            ColumnReference cr = (ColumnReference)node;
            if (this.remap) {
                cr.remapColumnReferences();
            } else {
                cr.unRemapColumnReferences();
            }
        }
        return node;
    }

    @Override
    public boolean skipChildren(Visitable node) {
        return node instanceof SubqueryNode;
    }

    @Override
    public boolean visitChildrenFirst(Visitable node) {
        return false;
    }

    @Override
    public boolean stopTraversal() {
        return false;
    }
}

