/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.types.BitDataValue;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;

class BitConstantNode
extends ConstantNode {
    BitConstantNode(TypeId t, ContextManager cm) throws StandardException {
        super(t, true, 0, cm);
    }

    BitConstantNode(String hexString, int bitLength, ContextManager cm) throws StandardException {
        super(TypeId.getBuiltInTypeId(-2), false, bitLength, cm);
        byte[] nv = StringUtil.fromHexString(hexString, 0, hexString.length());
        BitDataValue dvd = this.getDataValueFactory().getBitDataValue(nv);
        dvd.setWidth(bitLength, 0, false);
        this.setValue(dvd);
    }

    @Override
    Object getConstantValueAsObject() throws StandardException {
        return this.value.getBytes();
    }

    @Override
    void generateConstant(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        byte[] bytes = this.value.getBytes();
        String hexLiteral = StringUtil.toHexString(bytes, 0, bytes.length);
        mb.push(hexLiteral);
        mb.push(0);
        mb.push(hexLiteral.length());
        mb.callMethod((short)184, "org.apache.derby.iapi.util.StringUtil", "fromHexString", "byte[]", 3);
    }
}

