/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.impl.sql.catalog.DataDictionaryImpl;
import org.apache.derby.impl.sql.catalog.TDCacheable;
import org.apache.derby.shared.common.sanity.SanityManager;

class OIDTDCacheable
extends TDCacheable {
    private UUID identity;

    OIDTDCacheable(DataDictionaryImpl dd) {
        super(dd);
    }

    @Override
    public void clearIdentity() {
        this.identity = null;
        this.td = null;
    }

    @Override
    public Object getIdentity() {
        return this.identity;
    }

    @Override
    public Cacheable createIdentity(Object key, Object createParameter) {
        if (!(key instanceof UUID)) {
            SanityManager.THROWASSERT("Key for an OIDTDCacheElement is a " + key.getClass().getName() + " instead of an UUID");
        }
        if (!(createParameter instanceof TableDescriptor)) {
            SanityManager.THROWASSERT("Create parameter for an OIDTDCacheElement is a " + createParameter.getClass().getName() + "instead of a TableDescriptorImpl");
        }
        this.identity = ((UUID)key).cloneMe();
        this.td = (TableDescriptor)createParameter;
        if (this.td != null) {
            return this;
        }
        return null;
    }

    @Override
    public Cacheable setIdentity(Object key) throws StandardException {
        if (!(key instanceof UUID)) {
            SanityManager.THROWASSERT("Key for an OIDTDCacheElement is a " + key.getClass().getName() + " instead of an UUID");
        }
        this.identity = ((UUID)key).cloneMe();
        this.td = this.dd.getUncachedTableDescriptor(this.identity);
        if (this.td != null) {
            this.dd.addTableDescriptorToOtherCache(this.td, this);
            return this;
        }
        return null;
    }
}

