/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.junit;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.derby.iapi.services.io.InputStreamUtil;
import org.apache.derby.iapi.types.ClobStreamHeaderGenerator;
import org.apache.derby.iapi.types.ReaderToUTF8Stream;
import org.apache.derby.iapi.types.StreamHeaderGenerator;
import org.apache.derbyTesting.functionTests.util.streams.CharAlphabet;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;

public class ReaderToUTF8StreamTest
extends BaseTestCase {
    private static int DEFAULT_INTERNAL_BUFFER_SIZE = 32768;

    public ReaderToUTF8StreamTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new BaseTestSuite(ReaderToUTF8StreamTest.class);
    }

    public void testMarkResetSimplePosZero() throws IOException {
        InputStream is = this.getStream(100);
        is.mark(10);
        ReaderToUTF8StreamTest.assertEquals((int)10, (int)is.read(new byte[10]));
        is.reset();
        this.checkBeginningOfStream(is);
    }

    public void testMarkResetSimplePosNonZero() throws IOException {
        InputStream is = this.getStream(200);
        ReaderToUTF8StreamTest.assertEquals((int)127, (int)is.read(new byte[127]));
        is.mark(10);
        byte[] readBeforeReset = new byte[10];
        byte[] readAfterReset = new byte[10];
        ReaderToUTF8StreamTest.assertEquals((int)10, (int)is.read(readBeforeReset));
        is.reset();
        ReaderToUTF8StreamTest.assertEquals((int)10, (int)is.read(readAfterReset));
        ReaderToUTF8StreamTest.assertTrue((boolean)Arrays.equals(readBeforeReset, readAfterReset));
    }

    public void testMarkResetShiftBytesFew_Internal() throws IOException {
        InputStream is = this.getStream(131072);
        byte[] buf = new byte[DEFAULT_INTERNAL_BUFFER_SIZE - 2048];
        this.fillArray(is, buf);
        is.mark(4096);
        byte[] readBeforeReset = new byte[3072];
        byte[] readAfterReset = new byte[3072];
        this.fillArray(is, readBeforeReset);
        InputStream src = this.getStream(131072);
        InputStreamUtil.skipFully((InputStream)src, (long)(DEFAULT_INTERNAL_BUFFER_SIZE - 2048));
        byte[] comparisonRead = new byte[3072];
        this.fillArray(src, comparisonRead);
        ReaderToUTF8StreamTest.assertEquals(new ByteArrayInputStream(comparisonRead), new ByteArrayInputStream(readBeforeReset));
        is.reset();
        this.fillArray(is, readAfterReset);
        ReaderToUTF8StreamTest.assertEquals(new ByteArrayInputStream(readBeforeReset), new ByteArrayInputStream(readAfterReset));
    }

    public void testMarkResetShiftBytesMany_Internal() throws IOException {
        InputStream is = this.getStream(131072);
        is.read();
        is.read();
        is.mark(DEFAULT_INTERNAL_BUFFER_SIZE - 6);
        byte[] readBeforeReset = new byte[DEFAULT_INTERNAL_BUFFER_SIZE - 6];
        byte[] readAfterReset = new byte[DEFAULT_INTERNAL_BUFFER_SIZE - 6];
        this.fillArray(is, readBeforeReset);
        InputStream src = this.getStream(131072);
        src.read();
        src.read();
        byte[] comparisonRead = new byte[DEFAULT_INTERNAL_BUFFER_SIZE - 6];
        this.fillArray(src, comparisonRead);
        ReaderToUTF8StreamTest.assertEquals(new ByteArrayInputStream(comparisonRead), new ByteArrayInputStream(readBeforeReset));
        is.reset();
        this.fillArray(is, readAfterReset);
        ReaderToUTF8StreamTest.assertEquals(new ByteArrayInputStream(readBeforeReset), new ByteArrayInputStream(readAfterReset));
    }

    public void testMarkResetExceedReadAheadLimitOK_Internal() throws IOException {
        InputStream is = this.getStream(4113);
        is.mark(10);
        ReaderToUTF8StreamTest.assertEquals((int)20, (int)is.read(new byte[20]));
        is.reset();
    }

    public void testMarkResetExceedReadAheadLimitFail_Internal() throws IOException {
        InputStream is = this.getStream(65553);
        is.mark(10);
        int toRead = 38919;
        byte[] buf = new byte[toRead];
        for (int read = 0; read < toRead; read += is.read(buf, read, toRead - read)) {
        }
        try {
            is.reset();
            ReaderToUTF8StreamTest.fail((String)"reset-call was expected to throw IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testMarkResetOverflowInternalBufferKeepBytes() throws IOException {
        InputStream is = this.getStream(131072);
        is.mark(122880);
        byte[] buf = new byte[122879];
        this.fillArray(is, buf);
        is.reset();
        this.checkBeginningOfStream(is);
        is = this.getStream(36864);
        is.mark(4096);
        buf = new byte[36863];
        this.fillArray(is, buf);
        try {
            is.reset();
            ReaderToUTF8StreamTest.fail((String)"reset-call was expected to throw IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testMarkReadUntilEOF() throws IOException {
        int readNow;
        InputStream is = this.getStream(4096);
        is.mark(8192);
        byte[] buf = new byte[8192];
        int read = 0;
        while ((readNow = is.read(buf, read, buf.length - read)) != -1) {
            read += readNow;
        }
        try {
            is.reset();
            ReaderToUTF8StreamTest.fail((String)"reset-call was expected to throw IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        is = this.getStream(655360);
        is.mark(131072);
        buf = new byte[8192];
        while (is.read(buf, 0, buf.length) != -1) {
        }
        try {
            is.reset();
            ReaderToUTF8StreamTest.fail((String)"reset-call was expected to throw IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testMarkReadAlmostUntilEOF() throws IOException {
        int readNow;
        int limit = 4096;
        InputStream is = this.getStream(limit);
        is.mark(8192);
        byte[] buf = new byte[limit * 2];
        for (int read = 0; read < limit - 1 && (readNow = is.read(buf, read, limit - 1 - read)) != -1; read += readNow) {
        }
        is.reset();
        this.checkBeginningOfStream(is);
    }

    public void testHeaderPresentInStream_Internal() throws IOException {
        int valueLen = DEFAULT_INTERNAL_BUFFER_SIZE + 5120;
        InputStream is = this.getStream(valueLen);
        is.mark(valueLen - 1024);
        ClobStreamHeaderGenerator hdrGen = new ClobStreamHeaderGenerator(false);
        byte[] hdrTmp = new byte[100];
        int headerLen = hdrGen.generateInto(hdrTmp, 0, (long)valueLen);
        byte[] hdr1 = new byte[headerLen];
        System.arraycopy(hdrTmp, 0, hdr1, 0, headerLen);
        byte[] hdr2 = new byte[headerLen];
        ReaderToUTF8StreamTest.assertEquals((int)headerLen, (int)is.read(hdr2));
        ReaderToUTF8StreamTest.assertEquals(new ByteArrayInputStream(hdr1), new ByteArrayInputStream(hdr2));
    }

    private InputStream getStream(int length) {
        LoopingAlphabetReader src = new LoopingAlphabetReader((long)length, CharAlphabet.modernLatinLowercase());
        ReaderToUTF8Stream is = new ReaderToUTF8Stream((Reader)src, length, 0, "CLOB", (StreamHeaderGenerator)new ClobStreamHeaderGenerator(false));
        ReaderToUTF8StreamTest.assertTrue((String)"The stream doesn't support mark/reset", (boolean)is.markSupported());
        return is;
    }

    private void checkBeginningOfStream(InputStream is) throws IOException {
        ReaderToUTF8StreamTest.assertEquals((long)5L, (long)is.skip(5L));
        ReaderToUTF8StreamTest.assertEquals((int)97, (int)is.read());
        ReaderToUTF8StreamTest.assertEquals((int)98, (int)is.read());
    }

    private void fillArray(InputStream is, byte[] b) throws IOException {
        int readNow;
        int toRead = b.length;
        for (int read = 0; read < toRead; read += readNow) {
            readNow = is.read(b, read, toRead - read);
            ReaderToUTF8StreamTest.assertTrue((String)"reached EOF", (readNow != -1 ? 1 : 0) != 0);
        }
    }

    public void testRandomSequence() throws IOException {
        long seed = System.currentTimeMillis();
        try {
            this.testRandomSequence(seed);
        }
        catch (IOException ioe) {
            IOException wrapper = new IOException("seed=" + seed);
            wrapper.initCause(ioe);
            throw wrapper;
        }
    }

    private void testRandomSequence(long seed) throws IOException {
        ReaderToUTF8StreamTest.println("testRandomSequence seed: " + seed);
        int iterations = 100;
        Random rng = new Random(seed);
        for (int i = 0; i < 100; ++i) {
            int ops;
            int reads = 0;
            int skips = 0;
            int resets = 0;
            int marks = 0;
            int invalidations = 0;
            int length = 1024 * rng.nextInt(1024) + rng.nextInt(1024);
            boolean rs = rng.nextBoolean();
            ReaderToUTF8StreamTest.println(">>> iteration " + i + ", length=" + length);
            int currentPos = 0;
            int limit = 0;
            int mark = -1;
            InputStream is = this.getStream(length);
            for (ops = 0; ops < 200 && currentPos < length - 10; ++ops) {
                if (rng.nextBoolean()) {
                    int toRead = this.getRandomLength(currentPos, length, rng, rs);
                    if (rng.nextBoolean()) {
                        this.mytrace("\treading " + toRead + " bytes");
                        ++reads;
                        is.read(new byte[toRead]);
                    } else {
                        this.mytrace("\tskipping " + toRead + " bytes");
                        ++skips;
                        is.skip(toRead);
                    }
                    if (mark != -1 && (currentPos += toRead) - mark > limit) {
                        this.mytrace("\t\tmark invalidated");
                        ++invalidations;
                        mark = -1;
                        limit = 0;
                    }
                }
                if (!rng.nextBoolean() || !rng.nextBoolean()) continue;
                if (rng.nextInt(100) < 40 && mark != -1) {
                    this.mytrace("\tresetting to position " + mark);
                    ++resets;
                    is.reset();
                    currentPos = mark;
                    mark = -1;
                    continue;
                }
                limit = this.getRandomLength(currentPos, length, rng);
                this.mytrace("\tmarking position " + currentPos + " with limit " + limit);
                ++marks;
                mark = currentPos;
                is.mark(limit);
            }
            ReaderToUTF8StreamTest.println("ops=" + ops + ", reads=" + reads + ", skips=" + skips + ", marks=" + marks + ", resets=" + resets + ", invalidations=" + invalidations);
        }
    }

    private int getRandomLength(int currentPos, int length, Random rng) {
        return this.getRandomLength(currentPos, length, rng, false);
    }

    private int getRandomLength(int currentPos, int length, Random rng, boolean reducedSize) {
        int max = length - currentPos;
        if (reducedSize) {
            max /= 5;
        }
        return 1 + (int)((float)max * rng.nextFloat());
    }

    private void mytrace(String str) {
        if (this.getTestConfiguration().isVerbose()) {
            ReaderToUTF8StreamTest.traceit(str);
        }
    }

    public void testMarkReset1() throws IOException {
        InputStream is = this.getStream(65536);
        byte[] srcBuf = new byte[65541];
        this.fillArray(is, srcBuf);
        ByteArrayInputStream src = new ByteArrayInputStream(srcBuf);
        is = this.getStream(65536);
        StreamUtil su = new StreamUtil(is, src);
        su.mark(1024);
        su.skip(17L);
        su.reset();
        su.read(1);
        su.read(2133);
        su.mark(1024);
        su.reset();
        su.mark(1024);
        su.skip(18L);
        su.read(1024);
    }

    public void testMarkReset2_Internal() throws IOException {
        InputStream is = this.getStream(131072);
        byte[] srcBuf = new byte[131077];
        this.fillArray(is, srcBuf);
        ByteArrayInputStream src = new ByteArrayInputStream(srcBuf);
        is = this.getStream(131072);
        StreamUtil su = new StreamUtil(is, src);
        su.skip(DEFAULT_INTERNAL_BUFFER_SIZE);
        su.mark(DEFAULT_INTERNAL_BUFFER_SIZE + 2048);
        su.read(1024);
        su.reset();
        su.read(3072);
    }

    private class StreamUtil {
        private final InputStream is1;
        private final InputStream is2;

        StreamUtil(InputStream is1, InputStream is2) {
            Assert.assertNotNull((Object)is1);
            Assert.assertNotNull((Object)is2);
            this.is1 = is1;
            this.is2 = is2;
        }

        public void mark(int readAheadLimit) {
            this.is1.mark(readAheadLimit);
            this.is2.mark(readAheadLimit);
        }

        public void reset() throws IOException {
            this.is1.reset();
            this.is2.reset();
        }

        public long skip(long skip) throws IOException {
            long skip1;
            long skippedNow;
            long skip2 = 0L;
            for (skip1 = 0L; skip1 < skip; skip1 += skippedNow) {
                skippedNow = this.is1.skip(skip - skip1);
                if (skippedNow != -1L) continue;
                Assert.fail((String)("stream one reached EOF: " + this.is1.getClass()));
            }
            while (skip2 < skip) {
                skippedNow = this.is2.skip(skip - skip2);
                if (skippedNow == -1L) {
                    Assert.fail((String)("stream two reached EOF: " + this.is2.getClass()));
                }
                skip2 += skippedNow;
            }
            Assert.assertEquals((long)skip1, (long)skip2);
            return skip1;
        }

        public int read(int toRead) throws IOException {
            byte[] b1 = new byte[toRead];
            byte[] b2 = new byte[toRead];
            int read = this.read(b1, b2, false);
            BaseTestCase.assertEquals(new ByteArrayInputStream(b1), new ByteArrayInputStream(b2));
            return read;
        }

        public int read(byte[] b1, byte[] b2, boolean expectEOF) throws IOException {
            int read1;
            int readNow;
            Assert.assertEquals((String)"unequal sized arrays", (int)b1.length, (int)b2.length);
            int read2 = 0;
            int toRead = b1.length;
            for (read1 = 0; read1 < toRead; read1 += readNow) {
                readNow = this.is1.read(b1, read1, toRead - read1);
                if (readNow != -1) continue;
                if (expectEOF) break;
                Assert.fail((String)("stream one reached EOF: " + this.is1.getClass()));
            }
            while (read2 < toRead) {
                readNow = this.is2.read(b2, read2, toRead - read2);
                if (readNow == -1) {
                    if (expectEOF) break;
                    Assert.fail((String)("stream two reached EOF: " + this.is2.getClass()));
                }
                read2 += readNow;
            }
            Assert.assertEquals((int)read1, (int)read2);
            return read1;
        }
    }
}

