/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.nstest.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.derbyTesting.system.nstest.NsTest;

public class SequenceReader
extends Thread {
    private Connection conn;
    private int delay = 60000;
    public boolean stopNow = false;

    public SequenceReader(Connection connection, int num) {
        this.conn = connection;
        this.delay = num;
    }

    @Override
    public void run() {
        NsTest.logger.println("Starting the sequence reader thread with delay = " + this.delay);
        while (!this.stopNow) {
            try {
                this.readSequenceValue();
                SequenceReader.sleep(this.delay);
                if (NsTest.numActiveTestThreads() != 0 && NsTest.numActiveTestThreads() > 1) continue;
                NsTest.logger.println("no more test threads, finishing SequenceReader thread also");
                this.readSequenceValue();
                this.stopNow = true;
            }
            catch (InterruptedException ie) {
                NsTest.logger.println("SequenceReader: unexpected error in sleep");
            }
        }
    }

    private void readSequenceValue() {
        try {
            PreparedStatement ps = this.conn.prepareStatement("values syscs_util.syscs_peek_at_sequence( 'NSTEST', 'NSTESTTAB_SEQ' )");
            ResultSet rs = ps.executeQuery();
            rs.next();
            long nextSequenceValue = rs.getLong(1);
            NsTest.logger.println("Next sequence number = " + nextSequenceValue);
            NsTest.updateSequenceTracker(nextSequenceValue);
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            NsTest.printException(SequenceReader.class.getName(), e);
        }
    }
}

