/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.perf.basic.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.perf.basic.jdbc.BaseLoad100IdxTestSetup;
import org.apache.derbyTesting.perf.basic.jdbc.HeapScan;

public class CoveredIdxScan
extends HeapScan {
    public static Test suite() {
        BaseTestSuite scan = new BaseTestSuite("CoveredIdxScanTests");
        int iterations = 700;
        int repeats = 4;
        scan.addTest((Test)new CoveredIdxScan("ScanCoveredIdxInt", iterations, repeats));
        return new BaseLoad100IdxTestSetup((Test)scan, rowcount * 2, tableName);
    }

    public CoveredIdxScan(String name, int iterations, int repeats) {
        super(name, iterations, repeats);
    }

    @Override
    public void setUp() throws Exception {
        this.select = this.prepareStatement("SELECT i1 FROM " + tableName + " WHERE i1 > ? and i1 <= ?");
    }

    @Override
    public void initializeConnection(Connection conn) throws SQLException {
        conn.setAutoCommit(false);
    }

    public void ScanCoveredIdxInt() throws Exception {
        this.select.setInt(1, rowcount * 2 / 4);
        this.select.setInt(2, rowcount * 2 / 4 * 3);
        ResultSet rs = this.select.executeQuery();
        int actualCount = 0;
        int i = 0;
        while (rs.next()) {
            i = rs.getInt(1);
            ++actualCount;
        }
        CoveredIdxScan.assertEquals((int)rowcount, (int)actualCount);
        rs.close();
        this.commit();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }
}

