/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class TimeHandlingTest
extends BaseJDBCTestCase {
    private static final String[] CURRENT_TIME_FUNCTIONS = new String[]{"CURRENT TIME", "CURRENT_TIME"};
    private static final String[] CURRENT_TIMESTAMP_FUNCTIONS = new String[]{"CURRENT TIMESTAMP", "CURRENT_TIMESTAMP"};
    private static final long SLEEP_TIME = 2000L;
    private Calendar cal;

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite(TimeHandlingTest.class);
        suite.addTest(TestConfiguration.clientServerSuite(TimeHandlingTest.class));
        return new CleanDatabaseTestSetup((Test)suite){

            @Override
            protected void decorateSQL(Statement s) throws SQLException {
                int f;
                s.execute("CREATE FUNCTION SLEEP() RETURNS INTEGER LANGUAGE JAVA PARAMETER STYLE JAVA NO SQL  EXTERNAL NAME '" + TimeHandlingTest.class.getName().concat(".sleep'"));
                s.execute("CREATE TABLE TIME_ALL (ID INT, C_T TIME, C_D DATE, C_TS TIMESTAMP)");
                for (f = 0; f < CURRENT_TIME_FUNCTIONS.length; ++f) {
                    s.execute("ALTER TABLE TIME_ALL ADD COLUMN D_T" + f + " TIME WITH DEFAULT " + CURRENT_TIME_FUNCTIONS[f]);
                }
                for (f = 0; f < CURRENT_TIMESTAMP_FUNCTIONS.length; ++f) {
                    s.execute("ALTER TABLE TIME_ALL ADD COLUMN D_TS" + f + " TIMESTAMP WITH DEFAULT " + CURRENT_TIMESTAMP_FUNCTIONS[f]);
                }
            }
        };
    }

    public static int sleep() throws InterruptedException {
        Thread.sleep(2000L);
        return 0;
    }

    public TimeHandlingTest(String name) {
        super(name);
    }

    protected void setUp() throws SQLException {
        this.cal = Calendar.getInstance();
        Statement s = this.createStatement();
        s.executeUpdate("DELETE FROM TIME_ALL");
        s.close();
    }

    public void testInsertTime() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Random r = new Random();
        int itk = 71;
        PreparedStatement ps = this.prepareStatement("INSERT INTO TIME_ALL(ID, C_T) VALUES (?, ?)");
        for (int i = 0; i < 500; ++i) {
            int id = r.nextInt(1000000);
            ps.setInt(1, id);
            Time ct = this.getCodedTime(id);
            switch (id % 71 % 3) {
                case 0: {
                    ps.setTime(2, ct);
                    break;
                }
                case 1: {
                    ps.setString(2, ct.toString());
                    break;
                }
                case 2: {
                    ps.setString(2, ct.toString().replace(':', '.'));
                    break;
                }
                default: {
                    TimeHandlingTest.fail((String)"not reached");
                }
            }
            ps.executeUpdate();
        }
        ps.close();
        this.commit();
        Statement s = this.createStatement();
        ResultSet rs = s.executeQuery("SELECT ID, C_T FROM TIME_ALL");
        int rowCount = 0;
        while (rs.next()) {
            int id = rs.getInt(1);
            Time t = this.checkTimeValue(rs, 2);
            this.assertTimeEqual(this.getCodedTime(id), t);
            ++rowCount;
        }
        rs.close();
        s.close();
        this.commit();
        TimeHandlingTest.assertEquals((int)rowCount, (int)500);
    }

    private Time getCodedTime(int id) {
        int hk = 17;
        int mk = 41;
        int sk = 67;
        int hour = id % 17 % 24;
        int min = id % 41 % 60;
        int sec = id % 67 % 60;
        return this.getTime19700101(hour, min, sec);
    }

    public void testCurrentTime() throws SQLException, InterruptedException {
        this.currentFunctionTests(92, CURRENT_TIME_FUNCTIONS);
    }

    public void testCurrentTimestamp() throws SQLException, InterruptedException {
        this.currentFunctionTests(93, CURRENT_TIMESTAMP_FUNCTIONS);
    }

    private void currentFunctionTests(int jdbcType, String[] functions) throws SQLException, InterruptedException {
        Statement s = this.createStatement();
        for (int f = 0; f < functions.length; ++f) {
            this.checkCurrentQuery(jdbcType, s, "VALUES " + functions[f], new int[]{1}, 1);
        }
        StringBuffer rb = new StringBuffer("(");
        for (int f = 0; f < functions.length; ++f) {
            if (f != 0) {
                rb.append(", ");
            }
            rb.append(functions[f]);
        }
        rb.append(")");
        String row = rb.toString();
        int[] columns = new int[functions.length];
        for (int f = 0; f < columns.length; ++f) {
            columns[f] = f + 1;
        }
        String sql = "VALUES " + row;
        this.checkCurrentQuery(jdbcType, s, sql, columns, functions.length);
        sql = "VALUES " + row + "," + row + "," + row;
        this.checkCurrentQuery(jdbcType, s, sql, columns, 3 * functions.length);
        String sleepRow = row.substring(0, row.length() - 1) + ", SLEEP())";
        sql = "VALUES " + sleepRow + "," + sleepRow + "," + sleepRow;
        this.checkCurrentQuery(jdbcType, s, sql, columns, 3 * functions.length);
        String ccol = null;
        String dcol = null;
        switch (jdbcType) {
            case 92: {
                dcol = "D_T";
                ccol = "C_T";
                break;
            }
            case 93: {
                dcol = "D_TS";
                ccol = "C_TS";
                break;
            }
            case 91: {
                dcol = "D_D";
                ccol = "C_D";
                break;
            }
            default: {
                TimeHandlingTest.fail((String)("Unexpected JDBC Type " + jdbcType));
            }
        }
        StringBuffer rm = new StringBuffer();
        for (int f = 0; f < functions.length; ++f) {
            if (f != 0) {
                rm.append(", ");
            }
            rm.append(functions[f]);
        }
        String mrow = rm.toString();
        StringBuffer sb = new StringBuffer();
        sb.append(ccol);
        for (int f = 0; f < functions.length; ++f) {
            sb.append(", ");
            sb.append(dcol);
            sb.append(f);
        }
        String typeColumnList = sb.toString();
        String selectAllType = "SELECT " + typeColumnList + " FROM TIME_ALL";
        int[] tableColumns = new int[columns.length + 1];
        for (int i = 0; i < tableColumns.length; ++i) {
            tableColumns[i] = i + 1;
        }
        String insert = "INSERT INTO TIME_ALL(" + ccol + ") VALUES " + mrow;
        s.executeUpdate("DELETE FROM TIME_ALL");
        long start = System.currentTimeMillis();
        s.executeUpdate(insert);
        long end = System.currentTimeMillis();
        ResultSet rs = s.executeQuery(selectAllType);
        rs.next();
        this.checkCurrentMultiple(jdbcType, start, end, rs, tableColumns, functions.length * (functions.length + 1));
        rs.close();
        sb = new StringBuffer();
        for (int f = 0; f < functions.length; ++f) {
            if (f != 0) {
                sb.append(", ");
            }
            sb.append("(SLEEP(), ");
            sb.append(functions[f]);
            sb.append(")");
        }
        String mSleepRow = sb.toString();
        insert = "INSERT INTO TIME_ALL(ID, " + ccol + ")  SELECT * FROM TABLE (VALUES " + mSleepRow + ") AS T";
        s.executeUpdate("DELETE FROM TIME_ALL");
        start = System.currentTimeMillis();
        s.executeUpdate(insert);
        end = System.currentTimeMillis();
        rs = s.executeQuery(selectAllType);
        rs.next();
        this.checkCurrentMultiple(jdbcType, start, end, rs, tableColumns, functions.length * (functions.length + 1));
        rs.close();
        PreparedStatement psQ = this.prepareStatement(selectAllType + " WHERE ID = ?");
        Object last = null;
        for (int f = 0; f < functions.length; ++f) {
            PreparedStatement psI = this.prepareStatement("INSERT INTO TIME_ALL(ID, " + ccol + ") VALUES (?, " + functions[f] + ")");
            s.executeUpdate("DELETE FROM TIME_ALL");
            for (int i = 1; i <= 3; ++i) {
                psI.setInt(1, i);
                psQ.setInt(1, i);
                start = System.currentTimeMillis();
                psI.executeUpdate();
                end = System.currentTimeMillis();
                rs = psQ.executeQuery();
                rs.next();
                Object next = this.checkCurrentMultiple(jdbcType, start, end, rs, tableColumns, functions.length + 1);
                rs.close();
                if (last != null) {
                    TimeHandlingTest.assertFalse((String)"CURRENT value not changed over executions", (boolean)last.equals(next));
                }
                last = next;
                Thread.sleep(2000L);
            }
            psI.close();
        }
        psQ.close();
        s.close();
    }

    private void checkCurrentQuery(int sqlType, Statement s, String sql, int[] columns, int expectedCount) throws SQLException {
        long start = System.currentTimeMillis();
        ResultSet rs = s.executeQuery(sql);
        rs.next();
        long end = System.currentTimeMillis();
        this.checkCurrentMultiple(sqlType, start, end, rs, columns, expectedCount);
        rs.close();
    }

    private Object checkCurrentMultiple(int jdbcType, long start, long end, ResultSet rs, int[] columns, int expectedCount) throws SQLException {
        switch (jdbcType) {
            case 92: {
                return this.checkCurrentTimeMultiple(start, end, rs, columns, expectedCount);
            }
            case 93: {
                return this.checkCurrentTimestampMultiple(start, end, rs, columns, expectedCount);
            }
        }
        TimeHandlingTest.fail((String)("Unexpected type " + jdbcType));
        return null;
    }

    private Time checkCurrentTimeMultiple(long start, long end, ResultSet rs, int[] columns, int expectedCount) throws SQLException {
        Time t;
        int i;
        Time base = this.checkCurrentTimeValue(start, end, rs, columns[0]);
        TimeHandlingTest.assertNotNull((Object)base);
        int count = 1;
        for (i = 1; i < columns.length; ++i) {
            t = this.checkCurrentTimeValue(start, end, rs, columns[i]);
            TimeHandlingTest.assertEquals("CURENT TIME changed during execution", base, t);
            ++count;
        }
        while (rs.next()) {
            for (i = 0; i < columns.length; ++i) {
                t = this.checkCurrentTimeValue(start, end, rs, columns[i]);
                TimeHandlingTest.assertEquals("CURENT TIME changed during execution", base, t);
                ++count;
            }
        }
        TimeHandlingTest.assertEquals((int)expectedCount, (int)count);
        return base;
    }

    private Timestamp checkCurrentTimestampMultiple(long start, long end, ResultSet rs, int[] columns, int expectedCount) throws SQLException {
        Timestamp ts;
        int i;
        Timestamp base = this.checkCurrentTimestampValue(start, end, rs, columns[0]);
        TimeHandlingTest.assertNotNull((Object)base);
        int count = 1;
        for (i = 1; i < columns.length; ++i) {
            ts = this.checkCurrentTimestampValue(start, end, rs, columns[i]);
            TimeHandlingTest.assertEquals((String)"CURENT TIMESTAMP changed during execution", (Object)base, (Object)ts);
            ++count;
        }
        while (rs.next()) {
            for (i = 0; i < columns.length; ++i) {
                ts = this.checkCurrentTimestampValue(start, end, rs, columns[i]);
                TimeHandlingTest.assertEquals((String)"CURENT TIMESTAMP changed during execution", (Object)base, (Object)ts);
                ++count;
            }
        }
        TimeHandlingTest.assertEquals((int)expectedCount, (int)count);
        return base;
    }

    private Time checkTimeValue(ResultSet rs, int column) throws SQLException {
        TimeHandlingTest.assertEquals((int)92, (int)rs.getMetaData().getColumnType(column));
        try {
            rs.getDate(column);
            TimeHandlingTest.fail((String)"ResultSet.getDate() succeeded on TIME column");
        }
        catch (SQLException e) {
            TimeHandlingTest.assertSQLState("22005", e);
        }
        Time tv = rs.getTime(column);
        TimeHandlingTest.assertEquals((tv == null ? 1 : 0) != 0, (boolean)rs.wasNull());
        Object ov = rs.getObject(column);
        TimeHandlingTest.assertEquals((ov == null ? 1 : 0) != 0, (boolean)rs.wasNull());
        if (tv == null) {
            TimeHandlingTest.assertNull((Object)ov);
            return null;
        }
        TimeHandlingTest.assertTrue((boolean)(ov instanceof Time));
        TimeHandlingTest.assertEquals((Object)tv, (Object)ov);
        this.assertTime1970(tv);
        this.cal.clear();
        this.cal.setTime(tv);
        TimeHandlingTest.assertEquals((int)0, (int)this.cal.get(14));
        long now = System.currentTimeMillis();
        Timestamp tsv = rs.getTimestamp(column);
        long now2 = System.currentTimeMillis();
        TimeHandlingTest.assertNotNull((Object)tsv);
        TimeHandlingTest.assertFalse((boolean)rs.wasNull());
        if (this.isDateEqual(now, new Timestamp(now2))) {
            this.cal.clear();
            this.cal.setTimeInMillis(now);
            int thisYear = this.cal.get(1);
            int thisMonth = this.cal.get(2);
            int thisDate = this.cal.get(5);
            this.cal.clear();
            this.cal.setTime(tv);
            this.cal.set(thisYear, thisMonth, thisDate);
            Timestamp expectedValue = new Timestamp(this.cal.getTimeInMillis());
            this.assertTimeEqual(expectedValue, tsv);
        }
        if (!this.isDateEqual(now, tsv) && !this.isDateEqual(now2, tsv)) {
            TimeHandlingTest.fail((String)("TIME to java.sql.Timestamp does not contain current date " + tsv));
        }
        String sv = rs.getString(column);
        TimeHandlingTest.assertNotNull((Object)sv);
        TimeHandlingTest.assertFalse((boolean)rs.wasNull());
        TimeHandlingTest.assertEquals("ResultSet String converted to java.sql.Time mismatch", tv, this.getTime19700101(sv, this.cal));
        return tv;
    }

    private Timestamp checkTimestampValue(ResultSet rs, int column) throws SQLException {
        TimeHandlingTest.assertEquals((int)93, (int)rs.getMetaData().getColumnType(column));
        Timestamp tsv = rs.getTimestamp(column);
        TimeHandlingTest.assertEquals((tsv == null ? 1 : 0) != 0, (boolean)rs.wasNull());
        Object ov = rs.getObject(column);
        TimeHandlingTest.assertEquals((ov == null ? 1 : 0) != 0, (boolean)rs.wasNull());
        if (tsv == null) {
            TimeHandlingTest.assertNull((Object)ov);
            return null;
        }
        TimeHandlingTest.assertTrue((boolean)(ov instanceof Timestamp));
        TimeHandlingTest.assertEquals((Object)tsv, (Object)ov);
        Time tv = rs.getTime(column);
        TimeHandlingTest.assertNotNull((Object)tv);
        TimeHandlingTest.assertFalse((boolean)rs.wasNull());
        this.assertTime1970(tv);
        this.assertTimeEqual(tv, tsv);
        String sv = rs.getString(column);
        TimeHandlingTest.assertNotNull((Object)sv);
        TimeHandlingTest.assertFalse((boolean)rs.wasNull());
        TimeHandlingTest.assertEquals((String)"ResultSet String converted to java.sql.Timestamp mismatch", (Object)tsv, (Object)Timestamp.valueOf(sv));
        return tsv;
    }

    private Time checkCurrentTimeValue(long start, long end, ResultSet rs, int column) throws SQLException {
        Time et;
        Time tv = this.checkTimeValue(rs, column);
        Time st = this.getTime19700101(start, this.cal);
        if (st.after(et = this.getTime19700101(end, this.cal))) {
            TimeHandlingTest.assertTrue((String)"CURRENT TIME outside of range when test crossing midnight", (tv.equals(st) || tv.after(st) || tv.equals(et) || tv.before(et) ? 1 : 0) != 0);
        } else {
            TimeHandlingTest.assertFalse((String)"CURRENT TIME before start of statement", (boolean)tv.before(st));
            TimeHandlingTest.assertFalse((String)"CURRENT TIME after end of statement", (boolean)tv.after(et));
        }
        return tv;
    }

    private Timestamp checkCurrentTimestampValue(long start, long end, ResultSet rs, int column) throws SQLException {
        Timestamp tsv = this.checkTimestampValue(rs, column);
        Timestamp st = new Timestamp(start);
        Timestamp et = new Timestamp(end);
        if (st.after(et)) {
            TimeHandlingTest.assertTrue((String)"CURRENT TIME outside of range when test crossing midnight", (tsv.equals(st) || tsv.after(st) || tsv.equals(et) || tsv.before(et) ? 1 : 0) != 0);
        } else {
            TimeHandlingTest.assertFalse((String)"CURRENT TIME before start of statement", (boolean)tsv.before(st));
            TimeHandlingTest.assertFalse((String)"CURRENT TIME after end of statement", (boolean)tsv.after(et));
        }
        return tsv;
    }

    private Time getTime19700101(int hour, int min, int sec) {
        this.cal.clear();
        this.cal.set(1970, 0, 1, hour, min, sec);
        this.cal.set(14, 0);
        Time to = new Time(this.cal.getTimeInMillis());
        this.assertTime1970(to);
        return to;
    }

    private Time getTime19700101(long t, Calendar cal) {
        cal.clear();
        cal.setTimeInMillis(t);
        cal.set(1970, 0, 1);
        cal.set(14, 0);
        Time to = new Time(cal.getTimeInMillis());
        this.assertTime1970(to);
        return to;
    }

    private Time getTime19700101(String s, Calendar cal) {
        return this.getTime19700101(Time.valueOf(s).getTime(), cal);
    }

    private void assertTime1970(Time t) {
        this.cal.clear();
        this.cal.setTime(t);
        TimeHandlingTest.assertEquals((int)1970, (int)this.cal.get(1));
        TimeHandlingTest.assertEquals((int)0, (int)this.cal.get(2));
        TimeHandlingTest.assertEquals((int)1, (int)this.cal.get(5));
    }

    private void assertTimeEqual(Date tv1, Date tv2) {
        this.cal.clear();
        this.cal.setTime(tv1);
        int hour = this.cal.get(11);
        int min = this.cal.get(12);
        int sec = this.cal.get(13);
        int ms = this.cal.get(14);
        this.cal.clear();
        this.cal.setTime(tv2);
        TimeHandlingTest.assertEquals((int)hour, (int)this.cal.get(11));
        TimeHandlingTest.assertEquals((int)min, (int)this.cal.get(12));
        TimeHandlingTest.assertEquals((int)sec, (int)this.cal.get(13));
        TimeHandlingTest.assertEquals((int)ms, (int)this.cal.get(14));
    }

    private boolean isDateEqual(long d, Timestamp tsv) {
        this.cal.clear();
        this.cal.setTimeInMillis(d);
        int day = this.cal.get(5);
        int month = this.cal.get(2);
        int year = this.cal.get(1);
        this.cal.clear();
        this.cal.setTime(tsv);
        return day == this.cal.get(5) && month == this.cal.get(2) && year == this.cal.get(1);
    }
}

