/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import junit.framework.Test;
import org.apache.derby.catalog.SequencePreallocator;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.impl.sql.catalog.SequenceGenerator;
import org.apache.derby.impl.sql.catalog.SequenceRange;
import org.apache.derby.impl.sql.catalog.SequenceUpdater;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.functionTests.tests.lang.SGVetter;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SequenceGeneratorTest
extends GeneratedColumnsHelper {
    private static final long ALLOCATION_COUNT = 100L;
    private static final int TWEAKED_ALLOCATION_COUNT = 7;
    private static final String TEST_DBO = "TEST_DBO";
    private static final String RUTH = "RUTH";
    private static final String ALICE = "ALICE";
    private static final String[] LEGAL_USERS = new String[]{"TEST_DBO", "ALICE", "RUTH"};
    private static final String MISSING_ALLOCATOR = "X0Y85";
    private static final String DUPLICATE_SEQUENCE = "X0Y68";
    private static boolean _fullDebug = false;

    public SequenceGeneratorTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = (BaseTestSuite)TestConfiguration.embeddedSuite(SequenceGeneratorTest.class);
        CleanDatabaseTestSetup cleanTest = new CleanDatabaseTestSetup((Test)suite);
        Test timeoutTest = DatabasePropertyTestSetup.setLockTimeouts((Test)cleanTest, 5, 5);
        Test authenticatedTest = DatabasePropertyTestSetup.builtinAuthentication(timeoutTest, LEGAL_USERS, "sequenceGenerator");
        Test authorizedTest = TestConfiguration.sqlAuthorizationDecorator(authenticatedTest);
        return authorizedTest;
    }

    public void test_01_basic() throws Exception {
        Connection conn = this.openUserConnection(TEST_DBO);
        int initialValue = Integer.MIN_VALUE;
        this.goodStatement(conn, "create sequence seq_01\n");
        SequenceGeneratorTest.assertEquals((long)initialValue, (long)this.getCurrentValue(TEST_DBO, "SEQ_01"));
        int seq_01_value = initialValue;
        long seq_01_upperBound = (long)seq_01_value + 100L;
        int i = 0;
        while ((long)i < 100L) {
            this.vetBumping(conn, TEST_DBO, "SEQ_01", seq_01_value++, seq_01_upperBound);
            ++i;
        }
        this.vetBumping(conn, TEST_DBO, "SEQ_01", seq_01_value++, seq_01_upperBound += 100L);
        this.goodStatement(conn, "create sequence seq_01_a\n");
        int seq_01_a_value = initialValue;
        long seq_01_a_upperBound = (long)seq_01_a_value + 100L;
        for (int i2 = 0; i2 < 2; ++i2) {
            this.vetBumping(conn, TEST_DBO, "SEQ_01_A", seq_01_a_value++, seq_01_a_upperBound);
        }
        seq_01_upperBound = (long)seq_01_value + 100L;
        this.vetBumping(conn, TEST_DBO, "SEQ_01", seq_01_value++, seq_01_upperBound);
    }

    private void vetBumping(Connection conn, String schemaName, String sequenceName, int expectedValue, long expectedValueOnDisk) throws Exception {
        PreparedStatement ps = this.chattyPrepare(conn, "values( next value for " + schemaName + '.' + sequenceName + " )\n");
        SequenceGeneratorTest.assertEquals((int)expectedValue, (int)this.getScalarInteger(ps));
        SequenceGeneratorTest.assertEquals((long)expectedValueOnDisk, (long)this.getCurrentValue(schemaName, sequenceName));
    }

    public void test_02_boundary() throws Exception {
        T_SequenceUpdater updater = new T_SequenceUpdater((Long)Integer.MIN_VALUE, true, 1L, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        SequenceGeneratorTest.assertEquals((long)Integer.MIN_VALUE, (long)updater.getValueOnDisk());
        long initialValue = Integer.MIN_VALUE;
        long expectedValueOnDisk = initialValue + 100L;
        for (long i = 0L; i < 100L; ++i) {
            this.vetBumping(updater, initialValue + i, expectedValueOnDisk);
        }
        this.vetBumping(updater, initialValue + 100L, expectedValueOnDisk += 100L);
        this.vetBoundaries(32767L, -32768L);
        this.vetBoundaries(Integer.MAX_VALUE, Integer.MIN_VALUE);
        this.vetBoundaries(Long.MAX_VALUE, Long.MIN_VALUE);
        this.vetBoundaries(16383L, -16384L);
        this.vetBoundaries(0x3FFFFFFFL, -1073741824L);
        this.vetBoundaries(0x3FFFFFFFFFFFFFFFL, -4611686018427387904L);
    }

    private void vetBoundaries(long maxValue, long minValue) throws Exception {
        this.vetBoundaries(maxValue, minValue, 1L);
        this.vetBoundaries(maxValue, minValue, 100L);
        this.vetBoundaries(maxValue, minValue, 200L);
    }

    private void vetBoundaries(long maxValue, long minValue, long stepSize) throws Exception {
        this.vetUpperBoundary(maxValue, minValue, stepSize);
        this.vetLowerBoundary(maxValue, minValue, stepSize);
    }

    private void vetUpperBoundary(long maxValue, long minValue, long stepSize) throws Exception {
        long restartValue = minValue;
        long initValue = maxValue - 100L * stepSize;
        long finalValue = maxValue;
        long midpoint = (finalValue - initValue) / 2L;
        if (initValue > 0L) {
            this.vetBoundaries(maxValue, minValue, stepSize, initValue, restartValue);
        }
        if (midpoint > 0L) {
            this.vetBoundaries(maxValue, minValue, stepSize, midpoint, restartValue);
        }
        if (finalValue > 0L) {
            this.vetBoundaries(maxValue, minValue, stepSize, finalValue, restartValue);
        }
    }

    private void vetLowerBoundary(long maxValue, long minValue, long stepSize) throws Exception {
        long restartValue = maxValue;
        long initValue = minValue + 100L * stepSize;
        long finalValue = minValue;
        long midpoint = (finalValue - initValue) / 2L;
        if (initValue < 0L) {
            this.vetBoundaries(maxValue, minValue, -stepSize, initValue, restartValue);
        }
        if (midpoint < 0L) {
            this.vetBoundaries(maxValue, minValue, -stepSize, midpoint, restartValue);
        }
        if (finalValue < 0L) {
            this.vetBoundaries(maxValue, minValue, -stepSize, finalValue, restartValue);
        }
    }

    private void vetBoundaries(long maxValue, long minValue, long stepSize, long firstValue, long restartValue) throws Exception {
        long bumps = 201L;
        this.vetBumping(firstValue, true, stepSize, maxValue, minValue, restartValue, bumps);
        this.vetBumping(firstValue, false, stepSize, maxValue, minValue, restartValue, bumps);
    }

    private void vetBumping(long firstValue, boolean canCycle, long stepSize, long maxValue, long minValue, long restartValue, long bumps) throws Exception {
        if (_fullDebug) {
            SequenceGeneratorTest.println("stepSize = " + stepSize + " and firstValue = " + firstValue + " and canCycle = " + canCycle);
        }
        SGVetter vetter = new SGVetter(firstValue, canCycle, stepSize, maxValue, minValue, restartValue, 100L);
        T_SequenceUpdater updater = new T_SequenceUpdater(firstValue, canCycle, stepSize, maxValue, minValue, restartValue);
        if (_fullDebug) {
            SequenceGeneratorTest.println("");
        }
        for (long i = 0L; i < bumps; ++i) {
            this.vetBump(vetter, updater);
        }
    }

    private void vetBump(SGVetter vetter, T_SequenceUpdater updater) throws Exception {
        this.assertLongEquals(vetter.getUpperBound(), updater.getValueOnDisk());
        Long vetterValue = vetter.getNextValue();
        if (_fullDebug) {
            SequenceGeneratorTest.println("Expecting value = " + vetterValue + " and expecting ValueOnDisk = " + vetter.getUpperBound());
        }
        if (vetterValue != null) {
            long updaterValue = updater.getCurrentValueAndAdvance();
            SequenceGeneratorTest.assertEquals((long)vetterValue, (long)updaterValue);
        } else {
            try {
                updater.getCurrentValueAndAdvance();
                SequenceGeneratorTest.fail((String)"Expected to catch cycle exception.");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.assertLongEquals(vetter.getUpperBound(), updater.getValueOnDisk());
    }

    private void assertLongEquals(Long left, Long right) {
        if (left == null) {
            SequenceGeneratorTest.assertNull((Object)right);
        } else {
            SequenceGeneratorTest.assertNotNull((Object)right);
            SequenceGeneratorTest.assertEquals((long)left, (long)right);
        }
    }

    private void vetBumping(T_SequenceUpdater updater, long expectedValue, long expectedValueOnDisk) throws Exception {
        long actualValue = updater.getCurrentValueAndAdvance();
        long actualValueOnDisk = updater.getValueOnDisk();
        SequenceGeneratorTest.println("Expected value = " + expectedValue + " vs actual value = " + actualValue);
        SequenceGeneratorTest.println("    Expected value on disk = " + expectedValueOnDisk + " vs actual value on disk = " + actualValueOnDisk);
        SequenceGeneratorTest.assertEquals((long)expectedValue, (long)actualValue);
        SequenceGeneratorTest.assertEquals((long)expectedValueOnDisk, (long)actualValueOnDisk);
    }

    public void test_03_nonCycling() throws Exception {
        this.vetNonCycling(32767L, -32768L);
        this.vetNonCycling(Integer.MAX_VALUE, Integer.MIN_VALUE);
        this.vetNonCycling(Long.MAX_VALUE, Long.MIN_VALUE);
    }

    private void vetNonCycling(long maxValue, long minValue) throws Exception {
        this.vetNonCycling(maxValue, minValue, 1L);
        this.vetNonCycling(maxValue, minValue, -1L);
    }

    private void vetNonCycling(long maxValue, long minValue, long stepSize) throws Exception {
        long restartValue;
        long firstValue;
        long bumps = 3L;
        if (stepSize > 0L) {
            firstValue = maxValue - bumps;
            restartValue = minValue;
        } else {
            firstValue = minValue + bumps;
            restartValue = maxValue;
        }
        SGVetter vetter = new SGVetter(firstValue, false, stepSize, maxValue, minValue, restartValue, 100L);
        T_SequenceUpdater updater = new T_SequenceUpdater(firstValue, false, stepSize, maxValue, minValue, restartValue);
        long extraBumps = bumps + 2L;
        for (long i = 0L; i <= extraBumps; ++i) {
            this.vetBump(vetter, updater);
        }
    }

    public void test_04_reboot() throws Exception {
        Connection conn = this.openUserConnection(TEST_DBO);
        int initialValue = Integer.MIN_VALUE;
        this.goodStatement(conn, "create sequence seq_04\n");
        int seq_04_value = initialValue;
        long seq_04_upperBound = (long)seq_04_value + 100L;
        this.vetBumping(conn, TEST_DBO, "SEQ_04", seq_04_value++, seq_04_upperBound);
        this.vetBumping(conn, TEST_DBO, "SEQ_04", seq_04_value++, seq_04_upperBound);
        this.getTestConfiguration().shutdownDatabase();
        conn = this.openUserConnection(TEST_DBO);
        seq_04_upperBound = (long)seq_04_value + 100L;
        this.vetBumping(conn, TEST_DBO, "SEQ_04", seq_04_value++, seq_04_upperBound);
        this.getTestConfiguration().shutdownDatabase();
        conn = this.openUserConnection(TEST_DBO);
        seq_04_upperBound = (long)seq_04_value + 100L;
        this.vetBumping(conn, TEST_DBO, "SEQ_04", seq_04_value++, seq_04_upperBound);
    }

    public void test_05_concurrency() throws Exception {
        Connection conn = this.openUserConnection(TEST_DBO);
        int initialValue = Integer.MIN_VALUE;
        this.goodStatement(conn, "create sequence seq_05\n");
        this.goodStatement(conn, "grant usage on sequence seq_05 to public\n");
        int seq_05_value = initialValue;
        long seq_05_upperBound = seq_05_value;
        Connection ruthConnection = this.openUserConnection(RUTH);
        Connection aliceConnection = this.openUserConnection(ALICE);
        ruthConnection.setAutoCommit(false);
        aliceConnection.setAutoCommit(false);
        long loopCount = 200L;
        for (long i = 0L; i < loopCount; ++i) {
            Connection loopConn;
            Connection connection = loopConn = i % 2L == 0L ? ruthConnection : aliceConnection;
            if (i % 100L == 0L) {
                seq_05_upperBound += 100L;
            }
            this.vetBumping(loopConn, TEST_DBO, "SEQ_05", seq_05_value++, seq_05_upperBound);
        }
        ruthConnection.commit();
        aliceConnection.commit();
    }

    public void test_06_bigStepSize() throws Exception {
        long stepSize = 276701161105643274L;
        T_SequenceUpdater updater = new T_SequenceUpdater(Long.MIN_VALUE, true, stepSize, Long.MAX_VALUE, Long.MIN_VALUE, Long.MIN_VALUE);
        long nextValue = updater.getCurrentValueAndAdvance();
        long currentValueOnDisk = updater.getValueOnDisk();
        long rangeSize = currentValueOnDisk - nextValue;
        SequenceGeneratorTest.assertEquals((long)stepSize, (long)rangeSize);
        this.vetBigStep(32767L, -32768L);
        this.vetBigStep(Integer.MAX_VALUE, Integer.MIN_VALUE);
        this.vetBigStep(Long.MAX_VALUE, Long.MIN_VALUE);
        this.vetBigStep(100L, 0L);
    }

    private void vetBigStep(long maxValue, long minValue) throws Exception {
        Long firstValue = minValue;
        long restartValue = minValue;
        long stepSize = maxValue - 1L;
        boolean canCycle = true;
        long truncatedAllocationCount = 1L;
        SGVetter vetter = new SGVetter(firstValue, canCycle, stepSize, maxValue, minValue, restartValue, truncatedAllocationCount);
        T_SequenceUpdater updater = new T_SequenceUpdater(firstValue, canCycle, stepSize, maxValue, minValue, restartValue);
        for (long i = 0L; i < 100L; ++i) {
            this.vetBump(vetter, updater);
        }
    }

    public void test_07_dropSequence() throws Exception {
        int initialValue;
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create sequence seq_07\n");
        int seq_07_value = initialValue = Integer.MIN_VALUE;
        long seq_07_upperBound = (long)seq_07_value + 100L;
        int i = 0;
        while ((long)i < 100L) {
            this.vetBumping(conn, TEST_DBO, "SEQ_07", seq_07_value++, seq_07_upperBound);
            ++i;
        }
        this.goodStatement(conn, "values( next value for seq_07 )\n");
        this.goodStatement(conn, "drop sequence seq_07 restrict\n");
        this.expectCompilationError("42X94", "values ( next value for seq_07 )\n");
    }

    public void test_08_userWrittenAllocators() throws Exception {
        Connection conn = this.openUserConnection(TEST_DBO);
        this.goodStatement(conn, "create sequence seq_08\n");
        String className = ((Object)((Object)this)).getClass().getName() + "$UnknownClass";
        this.goodStatement(conn, "call syscs_util.syscs_set_database_property( 'derby.language.sequence.preallocator', '" + className + "')");
        this.expectExecutionError(conn, MISSING_ALLOCATOR, "values ( next value for seq_08 )");
        className = ((Object)((Object)this)).getClass().getName() + "$BadAllocator";
        this.goodStatement(conn, "call syscs_util.syscs_set_database_property( 'derby.language.sequence.preallocator', '" + className + "')");
        this.expectExecutionError(conn, MISSING_ALLOCATOR, "values ( next value for seq_08 )");
        className = ((Object)((Object)this)).getClass().getName() + "$LegalAllocator";
        this.goodStatement(conn, "call syscs_util.syscs_set_database_property( 'derby.language.sequence.preallocator', '" + className + "')");
        this.vetBumping(conn, TEST_DBO, "SEQ_08", Integer.MIN_VALUE, -2147483641L);
        this.goodStatement(conn, "call syscs_util.syscs_set_database_property( 'derby.language.sequence.preallocator', null )");
    }

    public void test_09_defaultRangeSize() throws Exception {
        Connection conn = this.openUserConnection(TEST_DBO);
        this.goodStatement(conn, "create sequence seq_09_01\n");
        long number = 30L;
        this.goodStatement(conn, "call syscs_util.syscs_set_database_property( 'derby.language.sequence.preallocator', '" + number + "')");
        this.vetBumping(conn, TEST_DBO, "SEQ_09_01", Integer.MIN_VALUE, Integer.MIN_VALUE + number);
        this.goodStatement(conn, "create sequence seq_09_02\n");
        number = 0L;
        this.goodStatement(conn, "call syscs_util.syscs_set_database_property( 'derby.language.sequence.preallocator', '" + number + "')");
        this.vetBumping(conn, TEST_DBO, "SEQ_09_02", Integer.MIN_VALUE, -2147483548L);
        this.goodStatement(conn, "create sequence seq_09_03\n");
        number = -1L;
        this.goodStatement(conn, "call syscs_util.syscs_set_database_property( 'derby.language.sequence.preallocator', '" + number + "')");
        this.expectExecutionError(conn, MISSING_ALLOCATOR, "values ( next value for seq_09_03 )");
        this.goodStatement(conn, "create sequence seq_09_04\n");
        number = 0x7FFFFFFFFFFFFFFEL;
        this.goodStatement(conn, "call syscs_util.syscs_set_database_property( 'derby.language.sequence.preallocator', '" + number + "')");
        this.expectExecutionError(conn, MISSING_ALLOCATOR, "values ( next value for seq_09_04 )");
        this.goodStatement(conn, "create sequence seq_09_05 as smallint\n");
        number = 98301L;
        this.goodStatement(conn, "call syscs_util.syscs_set_database_property( 'derby.language.sequence.preallocator', '" + number + "')");
        this.vetBumping(conn, TEST_DBO, "SEQ_09_05", Short.MIN_VALUE, -32767L);
        this.goodStatement(conn, "call syscs_util.syscs_set_database_property( 'derby.language.sequence.preallocator', null )");
    }

    public void test_10_5398() throws Exception {
        Connection conn = this.openUserConnection(TEST_DBO);
        this.goodStatement(conn, "create sequence seq_10\n");
        int seq_10_value = Integer.MIN_VALUE;
        long seq_10_upperBound = (long)seq_10_value + 100L;
        this.vetBumping(conn, TEST_DBO, "SEQ_10", seq_10_value++, seq_10_upperBound);
        this.getTestConfiguration().shutdownEngine();
        conn = this.openUserConnection(TEST_DBO);
        seq_10_upperBound = (long)seq_10_value + 100L;
        this.vetBumping(conn, TEST_DBO, "SEQ_10", seq_10_value++, seq_10_upperBound);
    }

    public void test_11_5493_correctness() throws Exception {
        Connection conn = this.openUserConnection(TEST_DBO);
        this.goodStatement(conn, "create table t_5493 (x int)\n");
        this.goodStatement(conn, "create sequence s_5493\n");
        boolean oldAutoCommit = conn.getAutoCommit();
        conn.setAutoCommit(false);
        PreparedStatement ps = this.chattyPrepare(conn, "select count(*) from sys.syssequences with rs\n");
        this.getScalarInteger(ps);
        ps.close();
        int expectedValue = Integer.MIN_VALUE;
        this.expectExecutionError(conn, "X0Y84", "values next value for s_5493");
        this.goodStatement(conn, "drop table t_5493\n");
        conn.rollback();
        ps = this.chattyPrepare(conn, "values next value for s_5493");
        SequenceGeneratorTest.assertEquals((int)expectedValue++, (int)this.getScalarInteger(ps));
        ps.close();
        this.goodStatement(conn, "drop sequence s_5493 restrict\n");
        conn.commit();
        conn.setAutoCommit(oldAutoCommit);
    }

    public void test_12_5493_function() throws Exception {
        Connection dboConn = this.openUserConnection(TEST_DBO);
        Connection ruthConn = this.openUserConnection(RUTH);
        this.goodStatement(dboConn, "create sequence s_5493\n");
        this.goodStatement(dboConn, "grant usage on sequence s_5493 to public\n");
        int expectedValue = Integer.MIN_VALUE;
        PreparedStatement ps = this.chattyPrepare(dboConn, "values next value for s_5493");
        SequenceGeneratorTest.assertEquals((int)expectedValue++, (int)this.getScalarInteger(ps));
        ps.close();
        ps = this.chattyPrepare(dboConn, "values syscs_util.syscs_peek_at_sequence( 'TEST_DBO', 'S_5493' )\n");
        SequenceGeneratorTest.assertEquals((int)expectedValue++, (int)this.getScalarInteger(ps));
        ps.close();
        this.expectExecutionError(dboConn, "X0X81", "values syscs_util.syscs_peek_at_sequence( 'TEST_DBO', 'S_5493_1' )\n");
        dboConn.setAutoCommit(false);
        this.goodStatement(dboConn, "drop sequence s_5493 restrict\n");
        this.expectExecutionError(dboConn, "X0X81", "values syscs_util.syscs_peek_at_sequence( 'TEST_DBO', 'S_5493' )\n");
        this.expectCompilationError(dboConn, "42X94", "values next value for s_5493");
        this.expectExecutionError(ruthConn, "40XL1", "values syscs_util.syscs_peek_at_sequence( 'TEST_DBO', 'S_5493' )\n");
        this.expectCompilationError(ruthConn, "40XL1", "values next value for TEST_DBO.s_5493");
        dboConn.commit();
        dboConn.setAutoCommit(true);
    }

    public void test_13_5494() throws Exception {
        String dbName = "DB_5494";
        SequenceGeneratorTest.assertLaunchedJUnitTestMethod(((Object)((Object)this)).getClass().getName() + ".preCrashActions", dbName);
        SequenceGeneratorTest.assertLaunchedJUnitTestMethod(((Object)((Object)this)).getClass().getName() + ".postCrashActions", dbName);
    }

    public void preCrashActions() throws Exception {
        Connection dboConn = this.openUserConnection(TEST_DBO);
        Connection ruthConn = this.openUserConnection(RUTH);
        int initialValue = Integer.MIN_VALUE;
        this.goodStatement(dboConn, "create sequence s_5494\n");
        this.assertNextValue(dboConn, TEST_DBO, "S_5494", initialValue);
        SequenceGeneratorTest.assertEquals((long)((long)initialValue + 100L), (long)this.getCurrentValue(ruthConn, TEST_DBO, "S_5494"));
    }

    public void postCrashActions() throws Exception {
        int initialValue = -2147483548;
        Connection dboConn = this.openUserConnection(TEST_DBO);
        SequenceGeneratorTest.assertEquals((long)initialValue, (long)this.getCurrentValue(dboConn, TEST_DBO, "S_5494"));
        this.assertNextValue(dboConn, TEST_DBO, "S_5494", initialValue);
        this.goodStatement(dboConn, "drop sequence s_5494 restrict\n");
    }

    private void assertNextValue(Connection conn, String schema, String sequenceName, int expectedValue) throws Exception {
        PreparedStatement ps = this.chattyPrepare(conn, "values( next value for " + schema + "." + sequenceName + " )\n");
        SequenceGeneratorTest.assertEquals((int)expectedValue, (int)this.getScalarInteger(ps));
    }

    public void test_14_6553() throws Exception {
        Connection dboConn = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConn, "create table t1_6553_1(x int, y int, z int)");
        this.goodStatement(dboConn, "create table t2_6553_1(x int, y int, z int)");
        this.goodStatement(dboConn, "create sequence seq_6553_1");
        this.goodStatement(dboConn, "values next value for seq_6553_1");
        this.goodStatement(dboConn, "create trigger tr1 after insert on t1_6553_1 insert into t2_6553_1(x) values (next value for seq_6553_1)");
        dboConn.setAutoCommit(false);
        this.goodStatement(dboConn, "create sequence seq_6553");
        dboConn.commit();
        this.goodStatement(dboConn, "values next value for seq_6553");
        this.expectExecutionError(dboConn, DUPLICATE_SEQUENCE, "create sequence seq_6553");
        dboConn.rollback();
        dboConn.setAutoCommit(true);
    }

    private long getCurrentValue(String schemaName, String sequenceName) throws Exception {
        return this.getCurrentValue(this.openUserConnection(TEST_DBO), schemaName, sequenceName);
    }

    private long getCurrentValue(Connection conn, String schemaName, String sequenceName) throws Exception {
        PreparedStatement ps = this.chattyPrepare(conn, "select currentvalue from sys.syssequences seq, sys.sysschemas s where s.schemaname = ? and seq.sequencename = ? and s.schemaid = seq.schemaid");
        ps.setString(1, schemaName);
        ps.setString(2, sequenceName);
        long retval = this.getScalarLong(ps);
        conn.commit();
        return retval;
    }

    private int getScalarInteger(PreparedStatement ps) throws Exception {
        ResultSet rs = ps.executeQuery();
        rs.next();
        int retval = rs.getInt(1);
        rs.close();
        ps.close();
        return retval;
    }

    private long getScalarLong(PreparedStatement ps) throws Exception {
        ResultSet rs = ps.executeQuery();
        rs.next();
        long retval = rs.getLong(1);
        rs.close();
        ps.close();
        return retval;
    }

    public static final class LegalAllocator
    implements SequencePreallocator {
        public int nextRangeSize(String s, String n) {
            return 7;
        }
    }

    public static final class BadAllocator {
    }

    public static final class T_SequenceUpdater
    extends SequenceUpdater {
        private Long _valueOnDisk;

        public T_SequenceUpdater(Long currentValue, boolean canCycle, long increment, long maxValue, long minValue, long restartValue) {
            this._valueOnDisk = currentValue;
            this._sequenceGenerator = new SequenceGenerator(currentValue, canCycle, increment, maxValue, minValue, restartValue, "DUMMY_SCHEMA", "DUMMY_SEQUENCE", (SequencePreallocator)new SequenceRange());
        }

        public Long getValueOnDisk() {
            return this._valueOnDisk;
        }

        public long getCurrentValueAndAdvance() throws Exception {
            SQLLongint nextValue = new SQLLongint();
            this.getCurrentValueAndAdvance((NumberDataValue)nextValue);
            return nextValue.getLong();
        }

        protected SequenceGenerator createSequenceGenerator(TransactionController readOnlyTC) {
            return this._sequenceGenerator;
        }

        protected boolean updateCurrentValueOnDisk(TransactionController tc, Long oldValue, Long newValue, boolean wait) {
            this._valueOnDisk = newValue;
            return true;
        }

        public boolean updateCurrentValueOnDisk(Long oldValue, Long newValue) {
            return this.updateCurrentValueOnDisk(null, oldValue, newValue, false);
        }
    }
}

