/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.server.ServerProducer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.impl.ServerProducerImpl;
import org.apache.activemq.artemis.core.server.impl.ServerProducers;
import org.apache.activemq.artemis.core.server.impl.ServerSessionImpl;
import org.apache.activemq.artemis.utils.collections.MaxSizeMap;

public class ServerLegacyProducersImpl
implements ServerProducers {
    private static final int MAX_PRODUCER_METRIC_SIZE = 100;
    protected final Map<String, ServerProducer> producers = Collections.synchronizedMap(new MaxSizeMap(100));
    private final String sessionName;
    private final String connectionID;

    public ServerLegacyProducersImpl(ServerSession session) {
        this.sessionName = session.getName();
        this.connectionID = session.getConnectionID() != null ? session.getConnectionID().toString() : null;
    }

    @Override
    public Map<String, ServerProducer> cloneProducers() {
        return new HashMap<String, ServerProducer>(this.producers);
    }

    @Override
    public Collection<ServerProducer> getServerProducers() {
        return new ArrayList<ServerProducer>(this.producers.values());
    }

    @Override
    public ServerProducer getServerProducer(String senderName, Message msg, ServerSessionImpl serverSession) {
        String address = msg.getAddress();
        String name = this.sessionName + ":" + address;
        ServerProducer producer = this.producers.get(name);
        if (producer == null) {
            producer = new ServerProducerImpl(name, "CORE", address);
            producer.setSessionID(this.sessionName);
            producer.setConnectionID(this.connectionID);
            this.producers.put(name, producer);
        }
        return producer;
    }

    @Override
    public void put(String id, ServerProducer producer) {
    }

    @Override
    public void remove(String id) {
    }

    @Override
    public void clear() {
        this.producers.clear();
    }
}

