/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.actors;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public interface ArtemisExecutor
extends Executor {
    public static ArtemisExecutor delegate(Executor executor) {
        return executor::execute;
    }

    default public int shutdownNow(Consumer<? super Runnable> onPendingTask, int timeout, TimeUnit unit) {
        return 0;
    }

    default public boolean flush(long timeout, TimeUnit unit) {
        CountDownLatch latch = new CountDownLatch(1);
        this.execute(latch::countDown);
        try {
            return latch.await(timeout, unit);
        }
        catch (Exception e) {
            return false;
        }
    }

    default public int shutdownNow() {
        return this.shutdownNow(t -> {}, 1, TimeUnit.SECONDS);
    }

    default public void shutdown() {
    }

    default public void yield() {
    }

    default public boolean isFair() {
        return false;
    }

    default public ArtemisExecutor setFair(boolean fair) {
        return this;
    }

    default public boolean isFlushed() {
        CountDownLatch latch = new CountDownLatch(1);
        this.execute(latch::countDown);
        try {
            return latch.await(100L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }
}

