/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.Comparator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Consumer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.impl.AbstractProtocolReference;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.transaction.Transaction;

public class MessageReferenceImpl
extends AbstractProtocolReference
implements MessageReference,
Runnable {
    private static final MessageReferenceComparatorSequence sequenceComparator = new MessageReferenceComparatorSequence();
    private static final AtomicIntegerFieldUpdater<MessageReferenceImpl> DELIVERY_COUNT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(MessageReferenceImpl.class, "deliveryCount");
    private volatile int deliveryCount = 0;
    private volatile int persistedCount;
    private volatile long scheduledDeliveryTime;
    private final Message message;
    private final Queue queue;
    private long consumerID;
    private boolean hasConsumerID = false;
    private boolean alreadyAcked;
    private boolean deliveredDirectly;
    private Consumer<? super MessageReference> onDelivery;
    private static final int memoryOffset = 72;

    public static Comparator<MessageReference> getSequenceComparator() {
        return sequenceComparator;
    }

    public MessageReferenceImpl() {
        this.queue = null;
        this.message = null;
    }

    public MessageReferenceImpl(MessageReferenceImpl other, Queue queue) {
        DELIVERY_COUNT_UPDATER.set(this, other.getDeliveryCount());
        this.scheduledDeliveryTime = other.scheduledDeliveryTime;
        this.message = other.message;
        this.queue = queue;
        this.sequence = other.sequence;
    }

    public MessageReferenceImpl(Message message, Queue queue) {
        this.message = message;
        this.queue = queue;
    }

    @Override
    public void onDelivery(Consumer<? super MessageReference> onDelivery) {
        this.onDelivery = onDelivery;
    }

    @Override
    public void run() {
        Consumer<? super MessageReference> onDelivery = this.onDelivery;
        if (onDelivery != null) {
            try {
                onDelivery.accept(this);
            }
            finally {
                this.onDelivery = null;
            }
        }
    }

    @Override
    public int getPersistedCount() {
        return this.persistedCount;
    }

    @Override
    public void setPersistedCount(int persistedCount) {
        this.persistedCount = persistedCount;
    }

    @Override
    public MessageReference copy(Queue queue) {
        return new MessageReferenceImpl(this, queue);
    }

    public static int getMemoryEstimate() {
        return 72;
    }

    @Override
    public int getDeliveryCount() {
        return DELIVERY_COUNT_UPDATER.get(this);
    }

    @Override
    public void setDeliveryCount(int deliveryCount) {
        DELIVERY_COUNT_UPDATER.set(this, deliveryCount);
        this.persistedCount = deliveryCount;
    }

    @Override
    public void incrementDeliveryCount() {
        DELIVERY_COUNT_UPDATER.incrementAndGet(this);
    }

    @Override
    public void decrementDeliveryCount() {
        DELIVERY_COUNT_UPDATER.decrementAndGet(this);
    }

    @Override
    public long getScheduledDeliveryTime() {
        return this.scheduledDeliveryTime;
    }

    @Override
    public void setScheduledDeliveryTime(long scheduledDeliveryTime) {
        this.scheduledDeliveryTime = scheduledDeliveryTime;
    }

    @Override
    public Message getMessage() {
        return this.message;
    }

    @Override
    public long getMessageID() {
        return this.getMessage().getMessageID();
    }

    @Override
    public Queue getQueue() {
        return this.queue;
    }

    @Override
    public boolean isDurable() {
        return this.getMessage().isDurable();
    }

    @Override
    public void handled() {
        this.queue.referenceHandled(this);
    }

    @Override
    public void setInDelivery(boolean inDelivery) {
        this.deliveredDirectly = inDelivery;
    }

    @Override
    public boolean isInDelivery() {
        return this.deliveredDirectly;
    }

    @Override
    public void setAlreadyAcked() {
        this.alreadyAcked = true;
    }

    @Override
    public boolean isAlreadyAcked() {
        return this.alreadyAcked;
    }

    @Override
    public boolean isPaged() {
        return false;
    }

    @Override
    public void acknowledge() throws Exception {
        this.acknowledge(null);
    }

    @Override
    public void acknowledge(Transaction tx) throws Exception {
        this.acknowledge(tx, null);
    }

    @Override
    public void acknowledge(Transaction tx, ServerConsumer consumer) throws Exception {
        this.acknowledge(tx, AckReason.NORMAL, consumer);
    }

    @Override
    public void acknowledge(Transaction tx, AckReason reason, ServerConsumer consumer) throws Exception {
        this.acknowledge(tx, reason, consumer, true);
    }

    @Override
    public void acknowledge(Transaction tx, AckReason reason, ServerConsumer consumer, boolean delivering) throws Exception {
        if (tx == null) {
            this.getQueue().acknowledge(this, reason, consumer);
        } else {
            this.getQueue().acknowledge(tx, this, reason, consumer, delivering);
        }
    }

    @Override
    public void emptyConsumerID() {
        this.hasConsumerID = false;
    }

    @Override
    public void setConsumerId(long consumerID) {
        this.hasConsumerID = true;
        this.consumerID = consumerID;
    }

    @Override
    public boolean hasConsumerId() {
        return this.hasConsumerID;
    }

    @Override
    public long getConsumerId() {
        if (!this.hasConsumerID) {
            throw new IllegalStateException("consumerID isn't specified: please check hasConsumerId first");
        }
        return this.consumerID;
    }

    @Override
    public SimpleString getLastValueProperty() {
        SimpleString lastValue = this.message.getSimpleStringProperty(this.queue.getLastValueKey());
        if (lastValue == null) {
            lastValue = this.message.getLastValueProperty();
        }
        return lastValue;
    }

    @Override
    public int getMessageMemoryEstimate() {
        return this.message.getMemoryEstimate();
    }

    public String toString() {
        Message message = this.getMessage();
        if (message != null) {
            return "Reference[" + message.getMessageID() + "]:" + (message.isDurable() ? "RELIABLE" : "NON-RELIABLE") + ":" + String.valueOf(message);
        }
        return "Reference[]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MessageReferenceImpl)) {
            return false;
        }
        MessageReferenceImpl other = (MessageReferenceImpl)obj;
        return Objects.equals(this.getMessage(), other.getMessage());
    }

    public int hashCode() {
        return this.getMessage().hashCode();
    }

    @Override
    public long getPersistentSize() throws ActiveMQException {
        return this.getMessage().getPersistentSize();
    }

    private static class MessageReferenceComparatorSequence
    implements Comparator<MessageReference> {
        private MessageReferenceComparatorSequence() {
        }

        @Override
        public int compare(MessageReference o1, MessageReference o2) {
            long value = o2.getSequence() - o1.getSequence();
            if (value > 0L) {
                return 1;
            }
            if (value < 0L) {
                return -1;
            }
            return 0;
        }
    }
}

