/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import javax.annotation.Priority;
import javax.security.auth.x500.X500Principal;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.rs.security.jose.common.JoseHeaders;
import org.apache.cxf.rs.security.jose.common.JoseUtils;
import org.apache.cxf.rs.security.jose.jaxrs.AbstractJwsReaderProvider;
import org.apache.cxf.rs.security.jose.jws.JwsCompactConsumer;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.PublicKeyJwsSignatureVerifier;
import org.apache.cxf.security.SecurityContext;

@PreMatching
@Priority(value=1002)
public class JwsContainerRequestFilter
extends AbstractJwsReaderProvider
implements ContainerRequestFilter {
    public void filter(ContainerRequestContext context) throws IOException {
        SecurityContext securityContext;
        Principal currentPrincipal;
        if (this.isMethodWithNoContent(context.getMethod()) || this.isCheckEmptyStream() && !context.hasEntity()) {
            return;
        }
        String content = IOUtils.readStringFromStream((InputStream)context.getEntityStream());
        if (StringUtils.isEmpty((String)content)) {
            return;
        }
        JwsCompactConsumer p = new JwsCompactConsumer(content);
        JwsSignatureVerifier theSigVerifier = this.getInitializedSigVerifier(p.getJwsHeaders());
        if (!p.verifySignatureWith(theSigVerifier)) {
            context.abortWith(JAXRSUtils.toResponse((int)400));
            return;
        }
        JoseUtils.validateRequestContextProperty((JoseHeaders)p.getJwsHeaders());
        byte[] bytes = p.getDecodedJwsPayloadBytes();
        context.setEntityStream((InputStream)new ByteArrayInputStream(bytes));
        context.getHeaders().putSingle((Object)"Content-Length", (Object)Integer.toString(bytes.length));
        String ct = JoseUtils.checkContentType((String)p.getJwsHeaders().getContentType(), (String)this.getDefaultMediaType());
        if (ct != null) {
            context.getHeaders().putSingle((Object)"Content-Type", (Object)ct);
        }
        if (super.isValidateHttpHeaders()) {
            super.validateHttpHeadersIfNeeded((MultivaluedMap<String, String>)context.getHeaders(), p.getJwsHeaders());
        }
        if (((currentPrincipal = context.getSecurityContext().getUserPrincipal()) == null || currentPrincipal.getName() == null) && (securityContext = this.configureSecurityContext(theSigVerifier)) != null) {
            JAXRSUtils.getCurrentMessage().put(SecurityContext.class, (Object)securityContext);
        }
    }

    protected SecurityContext configureSecurityContext(JwsSignatureVerifier sigVerifier) {
        if (sigVerifier instanceof PublicKeyJwsSignatureVerifier && ((PublicKeyJwsSignatureVerifier)sigVerifier).getX509Certificate() != null) {
            final X500Principal principal = ((PublicKeyJwsSignatureVerifier)sigVerifier).getX509Certificate().getSubjectX500Principal();
            return new SecurityContext(){

                public Principal getUserPrincipal() {
                    return principal;
                }

                public boolean isUserInRole(String arg0) {
                    return false;
                }
            };
        }
        return null;
    }

    protected boolean isMethodWithNoContent(String method) {
        return "DELETE".equals(method) || HttpUtils.isMethodWithNoRequestContent((String)method);
    }
}

