/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.rs.security.jose.common.JoseHeaders;
import org.apache.cxf.rs.security.jose.jaxrs.JoseJaxrsUtils;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionOutput;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweException;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.JweJsonConsumer;
import org.apache.cxf.rs.security.jose.jwe.JweJsonEncryptionEntry;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;

public class AbstractJweJsonDecryptingFilter {
    private Set<String> protectedHttpHeaders;
    private boolean validateHttpHeaders;
    private JweDecryptionProvider decryption;
    private String defaultMediaType;
    private Map<String, Object> recipientProperties;
    private boolean checkEmptyStream;

    protected JweDecryptionOutput decrypt(byte[] content) throws IOException {
        JweJsonConsumer c = new JweJsonConsumer(new String(content, StandardCharsets.UTF_8));
        JweDecryptionProvider theProvider = this.getInitializedDecryptionProvider(c.getProtectedHeader());
        JweJsonEncryptionEntry entry = c.getJweDecryptionEntry(theProvider, this.recipientProperties);
        if (entry == null) {
            throw new JweException(JweException.Error.INVALID_JSON_JWE);
        }
        JweDecryptionOutput out = c.decryptWith(theProvider, entry);
        JAXRSUtils.getCurrentMessage().put(JweJsonConsumer.class, (Object)c);
        JAXRSUtils.getCurrentMessage().put(JweJsonEncryptionEntry.class, (Object)entry);
        return out;
    }

    protected void validateHeaders(JweHeaders headers) {
    }

    public void setDecryptionProvider(JweDecryptionProvider decryptor) {
        this.decryption = decryptor;
    }

    protected JweDecryptionProvider getInitializedDecryptionProvider(JweHeaders headers) {
        if (this.decryption != null) {
            return this.decryption;
        }
        return JweUtils.loadDecryptionProvider((JweHeaders)headers, (boolean)true);
    }

    public String getDefaultMediaType() {
        return this.defaultMediaType;
    }

    public void setDefaultMediaType(String defaultMediaType) {
        this.defaultMediaType = defaultMediaType;
    }

    public void setRecipientProperties(Map<String, Object> recipientProperties) {
        this.recipientProperties = recipientProperties;
    }

    public void setValidateHttpHeaders(boolean validateHttpHeaders) {
        this.validateHttpHeaders = validateHttpHeaders;
    }

    public boolean isValidateHttpHeaders() {
        return this.validateHttpHeaders;
    }

    protected void validateHttpHeadersIfNeeded(MultivaluedMap<String, String> httpHeaders, JweHeaders jweHeaders) {
        JoseJaxrsUtils.validateHttpHeaders(httpHeaders, (JoseHeaders)jweHeaders, this.protectedHttpHeaders);
    }

    public void setProtectedHttpHeaders(Set<String> protectedHttpHeaders) {
        this.protectedHttpHeaders = protectedHttpHeaders;
    }

    public boolean isCheckEmptyStream() {
        return this.checkEmptyStream;
    }

    public void setCheckEmptyStream(boolean checkEmptyStream) {
        this.checkEmptyStream = checkEmptyStream;
    }
}

