/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.LifecycleMethodExecutionExceptionHandler;
import org.junit.jupiter.api.extension.TestInstanceFactory;
import org.junit.jupiter.api.extension.TestInstanceFactoryContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.junit.jupiter.api.extension.TestInstancePreConstructCallback;
import org.junit.jupiter.api.extension.TestInstancePreDestroyCallback;
import org.junit.jupiter.api.extension.TestInstances;
import org.junit.jupiter.api.extension.TestInstantiationException;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.ClassExtensionContext;
import org.junit.jupiter.engine.descriptor.DefaultTestInstanceFactoryContext;
import org.junit.jupiter.engine.descriptor.ExtensionUtils;
import org.junit.jupiter.engine.descriptor.JupiterTestDescriptor;
import org.junit.jupiter.engine.descriptor.LifecycleMethodUtils;
import org.junit.jupiter.engine.descriptor.TestInstanceLifecycleUtils;
import org.junit.jupiter.engine.execution.AfterEachMethodAdapter;
import org.junit.jupiter.engine.execution.BeforeEachMethodAdapter;
import org.junit.jupiter.engine.execution.DefaultExecutableInvoker;
import org.junit.jupiter.engine.execution.DefaultTestInstances;
import org.junit.jupiter.engine.execution.InterceptingExecutableInvoker;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.jupiter.engine.execution.TestInstancesProvider;
import org.junit.jupiter.engine.extension.ExtensionRegistrar;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.jupiter.engine.extension.MutableExtensionRegistry;
import org.junit.jupiter.engine.support.JupiterThrowableCollectorFactory;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.commons.util.UnrecoverableExceptions;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.hierarchical.ExclusiveResource;
import org.junit.platform.engine.support.hierarchical.Node;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;

@API(status=API.Status.INTERNAL, since="5.5")
public abstract class ClassBasedTestDescriptor
extends JupiterTestDescriptor {
    private static final InterceptingExecutableInvoker executableInvoker = new InterceptingExecutableInvoker();
    private final Class<?> testClass;
    protected final Set<TestTag> tags;
    protected final TestInstance.Lifecycle lifecycle;
    private Node.ExecutionMode defaultChildExecutionMode;
    private TestInstanceFactory testInstanceFactory;
    private List<Method> beforeAllMethods;
    private List<Method> afterAllMethods;

    ClassBasedTestDescriptor(UniqueId uniqueId, Class<?> testClass, Supplier<String> displayNameSupplier, JupiterConfiguration configuration) {
        super(uniqueId, testClass, displayNameSupplier, ClassSource.from(testClass), configuration);
        this.testClass = testClass;
        this.tags = ClassBasedTestDescriptor.getTags(testClass);
        this.lifecycle = TestInstanceLifecycleUtils.getTestInstanceLifecycle(testClass, configuration);
        this.defaultChildExecutionMode = this.lifecycle == TestInstance.Lifecycle.PER_CLASS ? Node.ExecutionMode.SAME_THREAD : null;
    }

    public final Class<?> getTestClass() {
        return this.testClass;
    }

    public abstract List<Class<?>> getEnclosingTestClasses();

    @Override
    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    @Override
    public String getLegacyReportingName() {
        return this.testClass.getName();
    }

    @Override
    protected Optional<Node.ExecutionMode> getExplicitExecutionMode() {
        return this.getExecutionModeFromAnnotation(this.getTestClass());
    }

    @Override
    protected Optional<Node.ExecutionMode> getDefaultChildExecutionMode() {
        return Optional.ofNullable(this.defaultChildExecutionMode);
    }

    public void setDefaultChildExecutionMode(Node.ExecutionMode defaultChildExecutionMode) {
        this.defaultChildExecutionMode = defaultChildExecutionMode;
    }

    @Override
    public Set<ExclusiveResource> getExclusiveResources() {
        return this.getExclusiveResourcesFromAnnotation(this.getTestClass());
    }

    @Override
    public JupiterEngineExecutionContext prepare(JupiterEngineExecutionContext context) {
        MutableExtensionRegistry registry = ExtensionUtils.populateNewExtensionRegistryFromExtendWithAnnotation(context.getExtensionRegistry(), this.testClass);
        ExtensionUtils.registerExtensionsFromStaticFields(registry, this.testClass);
        this.testInstanceFactory = this.resolveTestInstanceFactory(registry);
        if (this.testInstanceFactory == null) {
            ExtensionUtils.registerExtensionsFromConstructorParameters(registry, this.testClass);
        }
        this.beforeAllMethods = LifecycleMethodUtils.findBeforeAllMethods(this.testClass, this.lifecycle == TestInstance.Lifecycle.PER_METHOD);
        this.afterAllMethods = LifecycleMethodUtils.findAfterAllMethods(this.testClass, this.lifecycle == TestInstance.Lifecycle.PER_METHOD);
        this.beforeAllMethods.forEach(method -> ExtensionUtils.registerExtensionsFromExecutableParameters(registry, method));
        this.registerBeforeEachMethodAdapters(registry);
        this.registerAfterEachMethodAdapters(registry);
        this.afterAllMethods.forEach(method -> ExtensionUtils.registerExtensionsFromExecutableParameters(registry, method));
        ExtensionUtils.registerExtensionsFromInstanceFields(registry, this.testClass);
        ThrowableCollector throwableCollector = JupiterThrowableCollectorFactory.createThrowableCollector();
        ClassExtensionContext extensionContext = new ClassExtensionContext(context.getExtensionContext(), context.getExecutionListener(), this, this.lifecycle, context.getConfiguration(), throwableCollector, it -> new DefaultExecutableInvoker((ExtensionContext)it, registry));
        return context.extend().withTestInstancesProvider(this.testInstancesProvider(context, extensionContext)).withExtensionRegistry(registry).withExtensionContext(extensionContext).withThrowableCollector(throwableCollector).build();
    }

    @Override
    public JupiterEngineExecutionContext before(JupiterEngineExecutionContext context) {
        ThrowableCollector throwableCollector = context.getThrowableCollector();
        if (this.isPerClassLifecycle(context)) {
            ClassExtensionContext extensionContext = (ClassExtensionContext)context.getExtensionContext();
            throwableCollector.execute(() -> {
                TestInstances testInstances = context.getTestInstancesProvider().getTestInstances(context.getExtensionRegistry(), throwableCollector);
                extensionContext.setTestInstances(testInstances);
            });
        }
        if (throwableCollector.isEmpty()) {
            context.beforeAllCallbacksExecuted(true);
            this.invokeBeforeAllCallbacks(context);
            if (throwableCollector.isEmpty()) {
                context.beforeAllMethodsExecuted(true);
                this.invokeBeforeAllMethods(context);
            }
        }
        throwableCollector.assertEmpty();
        return context;
    }

    @Override
    public void after(JupiterEngineExecutionContext context) {
        ThrowableCollector throwableCollector = context.getThrowableCollector();
        Throwable previousThrowable = throwableCollector.getThrowable();
        if (context.beforeAllMethodsExecuted()) {
            this.invokeAfterAllMethods(context);
        }
        if (context.beforeAllCallbacksExecuted()) {
            this.invokeAfterAllCallbacks(context);
        }
        if (this.isPerClassLifecycle(context) && context.getExtensionContext().getTestInstance().isPresent()) {
            this.invokeTestInstancePreDestroyCallbacks(context);
        }
        if (previousThrowable != throwableCollector.getThrowable()) {
            throwableCollector.assertEmpty();
        }
    }

    private TestInstanceFactory resolveTestInstanceFactory(ExtensionRegistry registry) {
        List<TestInstanceFactory> factories = registry.getExtensions(TestInstanceFactory.class);
        if (factories.size() == 1) {
            return factories.get(0);
        }
        if (factories.size() > 1) {
            String factoryNames = factories.stream().map(factory -> factory.getClass().getName()).collect(Collectors.joining(", "));
            String errorMessage = String.format("The following TestInstanceFactory extensions were registered for test class [%s], but only one is permitted: %s", this.testClass.getName(), factoryNames);
            throw new ExtensionConfigurationException(errorMessage);
        }
        return null;
    }

    private TestInstancesProvider testInstancesProvider(JupiterEngineExecutionContext parentExecutionContext, ClassExtensionContext extensionContext) {
        return (registry, registrar, throwableCollector) -> extensionContext.getTestInstances().orElseGet(() -> this.instantiateAndPostProcessTestInstance(parentExecutionContext, extensionContext, registry, registrar, throwableCollector));
    }

    private TestInstances instantiateAndPostProcessTestInstance(JupiterEngineExecutionContext parentExecutionContext, ExtensionContext extensionContext, ExtensionRegistry registry, ExtensionRegistrar registrar, ThrowableCollector throwableCollector) {
        TestInstances instances = this.instantiateTestClass(parentExecutionContext, registry, registrar, extensionContext, throwableCollector);
        throwableCollector.execute(() -> {
            this.invokeTestInstancePostProcessors(instances.getInnermostInstance(), registry, extensionContext);
            registrar.initializeExtensions(this.testClass, instances.getInnermostInstance());
        });
        return instances;
    }

    protected abstract TestInstances instantiateTestClass(JupiterEngineExecutionContext var1, ExtensionRegistry var2, ExtensionRegistrar var3, ExtensionContext var4, ThrowableCollector var5);

    protected TestInstances instantiateTestClass(Optional<TestInstances> outerInstances, ExtensionRegistry registry, ExtensionContext extensionContext) {
        Optional<Object> outerInstance = outerInstances.map(TestInstances::getInnermostInstance);
        this.invokeTestInstancePreConstructCallbacks(new DefaultTestInstanceFactoryContext(this.testClass, outerInstance), registry, extensionContext);
        Object instance = this.testInstanceFactory != null ? this.invokeTestInstanceFactory(outerInstance, extensionContext) : this.invokeTestClassConstructor(outerInstance, registry, extensionContext);
        return outerInstances.map(instances -> DefaultTestInstances.of(instances, instance)).orElse(DefaultTestInstances.of(instance));
    }

    private Object invokeTestInstanceFactory(Optional<Object> outerInstance, ExtensionContext extensionContext) {
        Object instance;
        try {
            instance = this.testInstanceFactory.createTestInstance(new DefaultTestInstanceFactoryContext(this.testClass, outerInstance), extensionContext);
        }
        catch (Throwable throwable) {
            UnrecoverableExceptions.rethrowIfUnrecoverable(throwable);
            if (throwable instanceof TestInstantiationException) {
                throw (TestInstantiationException)throwable;
            }
            String message = String.format("TestInstanceFactory [%s] failed to instantiate test class [%s]", this.testInstanceFactory.getClass().getName(), this.testClass.getName());
            if (StringUtils.isNotBlank(throwable.getMessage())) {
                message = message + ": " + throwable.getMessage();
            }
            throw new TestInstantiationException(message, throwable);
        }
        if (!this.testClass.isInstance(instance)) {
            String instanceClassName;
            String testClassName = this.testClass.getName();
            Class<?> instanceClass = instance == null ? null : instance.getClass();
            String string = instanceClassName = instanceClass == null ? "null" : instanceClass.getName();
            if (testClassName.equals(instanceClassName)) {
                testClassName = testClassName + "@" + Integer.toHexString(System.identityHashCode(this.testClass));
                instanceClassName = instanceClassName + "@" + Integer.toHexString(System.identityHashCode(instanceClass));
            }
            String message = String.format("TestInstanceFactory [%s] failed to return an instance of [%s] and instead returned an instance of [%s].", this.testInstanceFactory.getClass().getName(), testClassName, instanceClassName);
            throw new TestInstantiationException(message);
        }
        return instance;
    }

    private Object invokeTestClassConstructor(Optional<Object> outerInstance, ExtensionRegistry registry, ExtensionContext extensionContext) {
        Constructor<?> constructor = ReflectionUtils.getDeclaredConstructor(this.testClass);
        return executableInvoker.invoke(constructor, outerInstance, extensionContext, registry, InvocationInterceptor::interceptTestClassConstructor);
    }

    private void invokeTestInstancePreConstructCallbacks(TestInstanceFactoryContext factoryContext, ExtensionRegistry registry, ExtensionContext context) {
        registry.stream(TestInstancePreConstructCallback.class).forEach(extension -> this.executeAndMaskThrowable(() -> extension.preConstructTestInstance(factoryContext, context)));
    }

    private void invokeTestInstancePostProcessors(Object instance, ExtensionRegistry registry, ExtensionContext context) {
        registry.stream(TestInstancePostProcessor.class).forEach(extension -> this.executeAndMaskThrowable(() -> extension.postProcessTestInstance(instance, context)));
    }

    private void executeAndMaskThrowable(Executable executable) {
        try {
            executable.execute();
        }
        catch (Throwable throwable) {
            throw ExceptionUtils.throwAsUncheckedException(throwable);
        }
    }

    private void invokeBeforeAllCallbacks(JupiterEngineExecutionContext context) {
        MutableExtensionRegistry registry = context.getExtensionRegistry();
        ExtensionContext extensionContext = context.getExtensionContext();
        ThrowableCollector throwableCollector = context.getThrowableCollector();
        for (BeforeAllCallback callback : registry.getExtensions(BeforeAllCallback.class)) {
            throwableCollector.execute(() -> callback.beforeAll(extensionContext));
            if (!throwableCollector.isNotEmpty()) continue;
            break;
        }
    }

    private void invokeBeforeAllMethods(JupiterEngineExecutionContext context) {
        MutableExtensionRegistry registry = context.getExtensionRegistry();
        ExtensionContext extensionContext = context.getExtensionContext();
        ThrowableCollector throwableCollector = context.getThrowableCollector();
        Object testInstance = extensionContext.getTestInstance().orElse(null);
        for (Method method : this.beforeAllMethods) {
            throwableCollector.execute(() -> {
                try {
                    executableInvoker.invoke(method, testInstance, extensionContext, registry, InterceptingExecutableInvoker.ReflectiveInterceptorCall.ofVoidMethod(InvocationInterceptor::interceptBeforeAllMethod));
                }
                catch (Throwable throwable) {
                    this.invokeBeforeAllMethodExecutionExceptionHandlers(registry, extensionContext, throwable);
                }
            });
            if (!throwableCollector.isNotEmpty()) continue;
            break;
        }
    }

    private void invokeBeforeAllMethodExecutionExceptionHandlers(ExtensionRegistry registry, ExtensionContext context, Throwable throwable) {
        this.invokeExecutionExceptionHandlers(LifecycleMethodExecutionExceptionHandler.class, registry, throwable, (handler, handledThrowable) -> handler.handleBeforeAllMethodExecutionException(context, handledThrowable));
    }

    private void invokeAfterAllMethods(JupiterEngineExecutionContext context) {
        MutableExtensionRegistry registry = context.getExtensionRegistry();
        ExtensionContext extensionContext = context.getExtensionContext();
        ThrowableCollector throwableCollector = context.getThrowableCollector();
        Object testInstance = extensionContext.getTestInstance().orElse(null);
        this.afterAllMethods.forEach(method -> throwableCollector.execute(() -> {
            try {
                executableInvoker.invoke((Method)method, (Object)testInstance, extensionContext, (ExtensionRegistry)registry, InterceptingExecutableInvoker.ReflectiveInterceptorCall.ofVoidMethod(InvocationInterceptor::interceptAfterAllMethod));
            }
            catch (Throwable throwable) {
                this.invokeAfterAllMethodExecutionExceptionHandlers(registry, extensionContext, throwable);
            }
        }));
    }

    private void invokeAfterAllMethodExecutionExceptionHandlers(ExtensionRegistry registry, ExtensionContext context, Throwable throwable) {
        this.invokeExecutionExceptionHandlers(LifecycleMethodExecutionExceptionHandler.class, registry, throwable, (handler, handledThrowable) -> handler.handleAfterAllMethodExecutionException(context, handledThrowable));
    }

    private void invokeAfterAllCallbacks(JupiterEngineExecutionContext context) {
        MutableExtensionRegistry registry = context.getExtensionRegistry();
        ExtensionContext extensionContext = context.getExtensionContext();
        ThrowableCollector throwableCollector = context.getThrowableCollector();
        CollectionUtils.forEachInReverseOrder(registry.getExtensions(AfterAllCallback.class), extension -> throwableCollector.execute(() -> extension.afterAll(extensionContext)));
    }

    private void invokeTestInstancePreDestroyCallbacks(JupiterEngineExecutionContext context) {
        ExtensionContext extensionContext = context.getExtensionContext();
        ThrowableCollector throwableCollector = context.getThrowableCollector();
        CollectionUtils.forEachInReverseOrder(context.getExtensionRegistry().getExtensions(TestInstancePreDestroyCallback.class), extension -> throwableCollector.execute(() -> extension.preDestroyTestInstance(extensionContext)));
    }

    private boolean isPerClassLifecycle(JupiterEngineExecutionContext context) {
        return context.getExtensionContext().getTestInstanceLifecycle().orElse(TestInstance.Lifecycle.PER_METHOD) == TestInstance.Lifecycle.PER_CLASS;
    }

    private void registerBeforeEachMethodAdapters(ExtensionRegistrar registrar) {
        List<Method> beforeEachMethods = LifecycleMethodUtils.findBeforeEachMethods(this.testClass);
        this.registerMethodsAsExtensions(beforeEachMethods, registrar, this::synthesizeBeforeEachMethodAdapter);
    }

    private void registerAfterEachMethodAdapters(ExtensionRegistrar registrar) {
        ArrayList<Method> afterEachMethods = new ArrayList<Method>(LifecycleMethodUtils.findAfterEachMethods(this.testClass));
        Collections.reverse(afterEachMethods);
        this.registerMethodsAsExtensions(afterEachMethods, registrar, this::synthesizeAfterEachMethodAdapter);
    }

    private void registerMethodsAsExtensions(List<Method> methods, ExtensionRegistrar registrar, Function<Method, Extension> extensionSynthesizer) {
        methods.forEach(method -> {
            ExtensionUtils.registerExtensionsFromExecutableParameters(registrar, method);
            registrar.registerSyntheticExtension((Extension)extensionSynthesizer.apply((Method)method), method);
        });
    }

    private BeforeEachMethodAdapter synthesizeBeforeEachMethodAdapter(Method method) {
        return (extensionContext, registry) -> this.invokeMethodInExtensionContext(method, extensionContext, registry, InvocationInterceptor::interceptBeforeEachMethod);
    }

    private AfterEachMethodAdapter synthesizeAfterEachMethodAdapter(Method method) {
        return (extensionContext, registry) -> this.invokeMethodInExtensionContext(method, extensionContext, registry, InvocationInterceptor::interceptAfterEachMethod);
    }

    private void invokeMethodInExtensionContext(Method method, ExtensionContext context, ExtensionRegistry registry, InterceptingExecutableInvoker.ReflectiveInterceptorCall.VoidMethodInterceptorCall interceptorCall) {
        TestInstances testInstances = context.getRequiredTestInstances();
        Object target = testInstances.findInstance(this.testClass).orElseThrow(() -> new JUnitException("Failed to find instance for method: " + method.toGenericString()));
        executableInvoker.invoke(method, target, context, registry, InterceptingExecutableInvoker.ReflectiveInterceptorCall.ofVoidMethod(interceptorCall));
    }
}

