/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;
import org.apache.commons.exec.TimeoutObserver;
import org.apache.commons.exec.Watchdog;
import org.apache.commons.exec.util.DebugUtils;

public class ExecuteWatchdog
implements TimeoutObserver {
    public static final long INFINITE_TIMEOUT = -1L;
    public static final Duration INFINITE_TIMEOUT_DURATION = Duration.ofMillis(-1L);
    private Exception caught;
    private final boolean hasWatchdog;
    private boolean killedProcess = false;
    private Process process;
    private volatile boolean processStarted;
    private final ThreadFactory threadFactory;
    private boolean watch = false;
    private final Watchdog watchdog;

    public static Builder builder() {
        return new Builder();
    }

    private ExecuteWatchdog(Builder builder) {
        this.hasWatchdog = !INFINITE_TIMEOUT_DURATION.equals(builder.timeout);
        this.processStarted = false;
        this.threadFactory = builder.threadFactory;
        if (this.hasWatchdog) {
            this.watchdog = Watchdog.builder().setThreadFactory(this.threadFactory).setTimeout(builder.timeout).get();
            this.watchdog.addTimeoutObserver(this);
        } else {
            this.watchdog = null;
        }
    }

    @Deprecated
    public ExecuteWatchdog(long timeoutMillis) {
        this(ExecuteWatchdog.builder().setTimeout(Duration.ofMillis(timeoutMillis)));
    }

    public synchronized void checkException() throws Exception {
        if (this.caught != null) {
            throw this.caught;
        }
    }

    protected synchronized void cleanUp() {
        this.watch = false;
        this.process = null;
    }

    public synchronized void destroyProcess() {
        this.ensureStarted();
        this.timeoutOccured(null);
        this.stop();
    }

    private void ensureStarted() {
        while (!this.processStarted && this.caught == null) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
    }

    public synchronized void failedToStart(Exception e) {
        this.processStarted = true;
        this.caught = e;
        this.notifyAll();
    }

    Watchdog getWatchdog() {
        return this.watchdog;
    }

    public synchronized boolean isWatching() {
        this.ensureStarted();
        return this.watch;
    }

    public synchronized boolean killedProcess() {
        return this.killedProcess;
    }

    void setProcessNotStarted() {
        this.processStarted = false;
    }

    public synchronized void start(Process processToMonitor) {
        Objects.requireNonNull(processToMonitor, "processToMonitor");
        if (this.process != null) {
            throw new IllegalStateException("Already running.");
        }
        this.caught = null;
        this.killedProcess = false;
        this.watch = true;
        this.process = processToMonitor;
        this.processStarted = true;
        this.notifyAll();
        if (this.hasWatchdog) {
            this.watchdog.start();
        }
    }

    public synchronized void stop() {
        if (this.hasWatchdog) {
            this.watchdog.stop();
        }
        this.watch = false;
        this.process = null;
    }

    @Override
    public synchronized void timeoutOccured(Watchdog w) {
        try {
            try {
                if (this.process != null) {
                    this.process.exitValue();
                }
            }
            catch (IllegalThreadStateException itse) {
                if (this.watch) {
                    this.killedProcess = true;
                    this.process.destroy();
                }
            }
        }
        catch (Exception e) {
            this.caught = e;
            DebugUtils.handleException("Getting the exit value of the process failed", e);
        }
        finally {
            this.cleanUp();
        }
    }

    public static final class Builder
    implements Supplier<ExecuteWatchdog> {
        private ThreadFactory threadFactory = Executors.defaultThreadFactory();
        private Duration timeout = INFINITE_TIMEOUT_DURATION;

        @Override
        public ExecuteWatchdog get() {
            return new ExecuteWatchdog(this);
        }

        public Builder setThreadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory != null ? threadFactory : Executors.defaultThreadFactory();
            return this;
        }

        public Builder setTimeout(Duration timeout) {
            this.timeout = timeout != null ? timeout : INFINITE_TIMEOUT_DURATION;
            return this;
        }
    }
}

