/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.web;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.web.MessageListenerServlet;

public class AjaxServlet
extends MessageListenerServlet {
    private static final long serialVersionUID = -3875280764356406114L;
    private Map<String, byte[]> jsCache = new HashMap<String, byte[]>();
    private long jsLastModified = 1000L * (System.currentTimeMillis() / 1000L);

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getPathInfo() != null && request.getPathInfo().endsWith(".js")) {
            this.doJavaScript(request, response);
        } else {
            super.doGet(request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doJavaScript(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String js = request.getServletPath() + request.getPathInfo();
        URL url = this.getServletContext().getResource(js);
        if (url != null) {
            this.getServletContext().getNamedDispatcher("default").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String resource = "org/apache/activemq/web" + request.getPathInfo();
        Map<String, byte[]> map = this.jsCache;
        synchronized (map) {
            byte[] data;
            block21: {
                data = this.jsCache.get(resource);
                if (data == null) {
                    try (InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);){
                        if (in == null) break block21;
                        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                            byte[] buf = new byte[4096];
                            int len = in.read(buf);
                            while (len >= 0) {
                                out.write(buf, 0, len);
                                len = in.read(buf);
                            }
                            data = out.toByteArray();
                            this.jsCache.put(resource, data);
                        }
                    }
                }
            }
            if (data != null) {
                long ifModified = request.getDateHeader("If-Modified-Since");
                if (ifModified == this.jsLastModified) {
                    response.sendError(304);
                } else {
                    response.setContentType("application/x-javascript");
                    response.setContentLength(data.length);
                    response.setDateHeader("Last-Modified", this.jsLastModified);
                    response.getOutputStream().write(data);
                }
            } else {
                response.sendError(404);
            }
        }
    }
}

