/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import org.apache.camel.AsyncProcessor;
import org.apache.camel.Channel;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.LoadBalanceDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.loadbalancer.FailoverLoadBalancerDefinition;
import org.apache.camel.processor.loadbalancer.LoadBalancer;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.reifier.loadbalancer.LoadBalancerReifier;

public class LoadBalanceReifier
extends ProcessorReifier<LoadBalanceDefinition> {
    public LoadBalanceReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (LoadBalanceDefinition)definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        LoadBalancer loadBalancer = LoadBalancerReifier.reifier(this.route, ((LoadBalanceDefinition)this.definition).getLoadBalancerType()).createLoadBalancer();
        int max = ((LoadBalanceDefinition)this.definition).getLoadBalancerType().getMaximumNumberOfOutputs();
        int size = ((LoadBalanceDefinition)this.definition).getOutputs().size();
        if (size > max) {
            throw new IllegalArgumentException("To many outputs configured on " + String.valueOf(((LoadBalanceDefinition)this.definition).getLoadBalancerType()) + ": " + size + " > " + max);
        }
        for (ProcessorDefinition processorType : ((LoadBalanceDefinition)this.definition).getOutputs()) {
            if (LoadBalanceDefinition.class.isInstance(processorType)) {
                throw new IllegalArgumentException("Loadbalancer already configured to: " + String.valueOf(((LoadBalanceDefinition)this.definition).getLoadBalancerType()) + ". Cannot set it to: " + String.valueOf(processorType));
            }
            Processor processor = this.createProcessor(processorType);
            Channel channel = this.wrapChannel(processor, processorType);
            loadBalancer.addProcessor((AsyncProcessor)channel);
        }
        Boolean inherit = ((LoadBalanceDefinition)this.definition).getInheritErrorHandler();
        if (((LoadBalanceDefinition)this.definition).getLoadBalancerType() instanceof FailoverLoadBalancerDefinition) {
            inherit = true;
        }
        return this.wrapChannel((Processor)loadBalancer, this.definition, inherit);
    }
}

