/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.diagnostic;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.ExceptionUtil;

public final class Attachment {
    private static final Logger LOG = Logger.getInstance(Attachment.class);
    public static final Attachment[] EMPTY_ARRAY = new Attachment[0];
    private final String myPath;
    private final String myDisplayText;
    private final byte @Nullable [] myBytes;
    @Nullable
    private final Path myTemporaryFile;
    private boolean myIncluded;

    public Attachment(@NotNull String name2, @NotNull Throwable throwable) {
        if (name2 == null) {
            Attachment.$$$reportNull$$$0(0);
        }
        if (throwable == null) {
            Attachment.$$$reportNull$$$0(1);
        }
        this(name2 + ".trace", ExceptionUtil.getThrowableText(throwable));
        this.myIncluded = true;
    }

    public Attachment(@NotNull String path, @NotNull String content) {
        if (path == null) {
            Attachment.$$$reportNull$$$0(2);
        }
        if (content == null) {
            Attachment.$$$reportNull$$$0(3);
        }
        this(path, content, null, null);
    }

    private Attachment(String path, String displayText, byte @Nullable [] bytes, @Nullable Path temporaryFile) {
        this.myPath = path;
        this.myDisplayText = displayText;
        this.myBytes = bytes;
        this.myTemporaryFile = temporaryFile;
    }

    @NotNull
    public String getDisplayText() {
        String string = this.myDisplayText;
        if (string == null) {
            Attachment.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            Attachment.$$$reportNull$$$0(14);
        }
        return string;
    }

    public byte @NotNull [] getBytes() {
        if (this.myBytes != null) {
            if (this.myBytes == null) {
                Attachment.$$$reportNull$$$0(17);
            }
            return this.myBytes;
        }
        if (this.myTemporaryFile != null) {
            byte[] byArray;
            try {
                byArray = Files.readAllBytes(this.myTemporaryFile);
            }
            catch (IOException e2) {
                LOG.error("Failed to read attachment content from temp. file " + this.myTemporaryFile, e2);
            }
            if (byArray == null) {
                Attachment.$$$reportNull$$$0(18);
            }
            return byArray;
        }
        if (this.myDisplayText != null) {
            byte[] byArray = this.myDisplayText.getBytes(StandardCharsets.UTF_8);
            if (byArray == null) {
                Attachment.$$$reportNull$$$0(19);
            }
            return byArray;
        }
        if (ArrayUtil.EMPTY_BYTE_ARRAY == null) {
            Attachment.$$$reportNull$$$0(20);
        }
        return ArrayUtil.EMPTY_BYTE_ARRAY;
    }

    public String toString() {
        return "Attachment[" + this.myPath + "][" + this.getBytes().length + " bytes]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwable";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 5: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayText";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "temporaryFile";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/diagnostic/Attachment";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/diagnostic/Attachment";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayText";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getEncodedBytes";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getBytes";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "openContentStream";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

