/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.map;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.ma.map.RecordType;
import net.sf.saxon.om.Genre;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.type.Affinity;
import net.sf.saxon.type.AnyFunctionType;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class RecordTest
extends AnyFunctionType
implements RecordType {
    private final Map<String, SequenceType> fieldTypes = new HashMap<String, SequenceType>();
    private final Set<String> optionalFields = new HashSet<String>();
    private boolean _extensible;
    public static RecordTest VALUE_RECORD = RecordTest.nonExtensible(new Field("value", SequenceType.ANY_SEQUENCE, false));
    public static RecordTest KEY_VALUE_RECORD = RecordTest.nonExtensible(new Field("key", SequenceType.ATOMIC_SEQUENCE, false), new Field("value", SequenceType.ANY_SEQUENCE, false));

    public RecordTest() {
    }

    public RecordTest(List<String> names, List<SequenceType> types, Collection<String> optionalFieldNames, boolean extensible) {
        this.setDetails(names, types, optionalFieldNames, extensible);
    }

    public static RecordTest extensible(Field ... fields) {
        return RecordTest.makeRecordTest(true, fields);
    }

    public static RecordTest nonExtensible(Field ... fields) {
        return RecordTest.makeRecordTest(false, fields);
    }

    private static RecordTest makeRecordTest(boolean extensible, Field ... fields) {
        ArrayList<String> fieldNames = new ArrayList<String>(fields.length);
        ArrayList<String> optionalFieldNames = new ArrayList<String>(fields.length);
        ArrayList<SequenceType> fieldTypes = new ArrayList<SequenceType>(fields.length);
        for (Field field : fields) {
            fieldNames.add(field.name);
            fieldTypes.add(field.type);
            if (!field.optional) continue;
            optionalFieldNames.add(field.name);
        }
        return new RecordTest(fieldNames, fieldTypes, optionalFieldNames, extensible);
    }

    public void setDetails(List<String> names, List<SequenceType> types, Collection<String> optionalFieldNames, boolean extensible) {
        for (int i = 0; i < names.size(); ++i) {
            this.fieldTypes.put(names.get(i), types.get(i));
        }
        this.optionalFields.addAll(optionalFieldNames);
        this._extensible = extensible;
    }

    @Override
    public Genre getGenre() {
        return Genre.MAP;
    }

    @Override
    public boolean isMapType() {
        return true;
    }

    @Override
    public boolean isArrayType() {
        return false;
    }

    @Override
    public Iterable<String> getFieldNames() {
        return this.fieldTypes.keySet();
    }

    @Override
    public SequenceType getFieldType(String field) {
        return this.fieldTypes.get(field);
    }

    @Override
    public boolean isOptionalField(String field) {
        return this.optionalFields.contains(field);
    }

    @Override
    public boolean isExtensible() {
        return this._extensible;
    }

    @Override
    public boolean matches(Item item, TypeHierarchy th) {
        if (!(item instanceof MapItem)) {
            return false;
        }
        MapItem map = (MapItem)item;
        for (Map.Entry<String, SequenceType> field : this.fieldTypes.entrySet()) {
            GroundedValue val = map.get(new StringValue(field.getKey()));
            if (!(val == null ? !this.isOptionalField(field.getKey()) : !field.getValue().matches(val, th))) continue;
            return false;
        }
        if (!this._extensible) {
            AtomicValue key;
            AtomicIterator keyIter = map.keys();
            while ((key = keyIter.next()) != null) {
                if (key instanceof StringValue && this.fieldTypes.containsKey(key.getStringValue())) continue;
                return false;
            }
        }
        return true;
    }

    public int getArity() {
        return 1;
    }

    @Override
    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_ATOMIC};
    }

    @Override
    public SequenceType getResultType() {
        if (this._extensible) {
            return SequenceType.ANY_SEQUENCE;
        }
        ItemType resultType = null;
        boolean allowsMany = false;
        for (Map.Entry<String, SequenceType> field : this.fieldTypes.entrySet()) {
            resultType = resultType == null ? field.getValue().getPrimaryType() : Type.getCommonSuperType(resultType, field.getValue().getPrimaryType());
            allowsMany = allowsMany || Cardinality.allowsMany(field.getValue().getCardinality());
        }
        return SequenceType.makeSequenceType(resultType, allowsMany ? 57344 : 24576);
    }

    @Override
    public double getDefaultPriority() {
        double prio = 1.0;
        for (SequenceType st : this.fieldTypes.values()) {
            prio *= st.getPrimaryType().getNormalizedDefaultPriority();
        }
        return this._extensible ? 0.5 + prio / 2.0 : prio;
    }

    @Override
    public String toString() {
        return this.makeString(SequenceType::toString);
    }

    @Override
    public String toExportString() {
        return this.makeString(SequenceType::toExportString);
    }

    @Override
    public String getBasicAlphaCode() {
        return "FM";
    }

    private String makeString(Function<SequenceType, String> show) {
        StringBuilder sb = new StringBuilder(100);
        sb.append("record(");
        boolean first = true;
        for (Map.Entry<String, SequenceType> field : this.fieldTypes.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            if (NameChecker.isValidNCName(field.getKey())) {
                sb.append(field.getKey());
            } else {
                sb.append('\"').append(field.getKey()).append('\"');
            }
            if (this.isOptionalField(field.getKey())) {
                sb.append('?');
            }
            sb.append(" as ");
            if (field.getValue().getPrimaryType() == this) {
                sb.append("..").append(Cardinality.getOccurrenceIndicator(field.getValue().getCardinality()));
                continue;
            }
            sb.append(show.apply(field.getValue()));
        }
        if (this.isExtensible()) {
            sb.append(", *");
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object other) {
        return this == other || other instanceof RecordTest && this._extensible == ((RecordTest)other)._extensible && this.fieldTypes.equals(((RecordTest)other).fieldTypes) && this.optionalFields.equals(((RecordTest)other).optionalFields);
    }

    public int hashCode() {
        int h = 667568159;
        for (Map.Entry<String, SequenceType> entry : this.fieldTypes.entrySet()) {
            h ^= entry.getKey().hashCode();
            if (entry.getValue().getPrimaryType() == this) {
                h ^= 0x5050505;
                continue;
            }
            h ^= entry.getValue().hashCode();
        }
        return h;
    }

    @Override
    public Affinity relationship(FunctionItemType other, TypeHierarchy th) {
        if (other == AnyFunctionType.getInstance()) {
            return Affinity.SUBSUMED_BY;
        }
        if (other instanceof RecordTest) {
            return this.recordTypeRelationship((RecordTest)other, th);
        }
        if (other == MapType.ANY_MAP_TYPE) {
            return Affinity.SUBSUMED_BY;
        }
        if (other.isArrayType()) {
            return Affinity.DISJOINT;
        }
        if (other instanceof MapType) {
            return this.recordToMapRelationship((MapType)other, th);
        }
        Affinity rel = new SpecificFunctionType(this.getArgumentTypes(), this.getResultType()).relationship(other, th);
        return rel;
    }

    private Affinity recordToMapRelationship(MapType other, TypeHierarchy th) {
        BuiltInAtomicType recordKeyType = this.isExtensible() ? BuiltInAtomicType.ANY_ATOMIC : BuiltInAtomicType.STRING;
        Affinity keyRel = th.relationship(recordKeyType, other.getKeyType());
        if (keyRel == Affinity.DISJOINT) {
            return Affinity.DISJOINT;
        }
        if (other.getValueType().getPrimaryType().equals(AnyItemType.getInstance()) && other.getValueType().getCardinality() == 57344) {
            if (keyRel == Affinity.SUBSUMED_BY || keyRel == Affinity.SAME_TYPE) {
                return Affinity.SUBSUMED_BY;
            }
            return Affinity.OVERLAPS;
        }
        if (this.isExtensible()) {
            return Affinity.OVERLAPS;
        }
        for (SequenceType entry : this.fieldTypes.values()) {
            Affinity rel = th.sequenceTypeRelationship(entry, other.getValueType());
            if (rel == Affinity.SUBSUMED_BY || rel == Affinity.SAME_TYPE) continue;
            return Affinity.OVERLAPS;
        }
        return Affinity.SUBSUMED_BY;
    }

    private Affinity recordTypeRelationship(RecordTest other, TypeHierarchy th) {
        HashSet<String> keys = new HashSet<String>(this.fieldTypes.keySet());
        keys.addAll(other.fieldTypes.keySet());
        boolean foundSubsuming = false;
        boolean foundSubsumed = false;
        boolean foundOverlap = false;
        if (this.isExtensible()) {
            if (!other.isExtensible()) {
                foundSubsuming = true;
            }
        } else if (other.isExtensible()) {
            foundSubsumed = true;
        }
        for (String key : keys) {
            SequenceType t1 = this.fieldTypes.get(key);
            SequenceType t2 = other.fieldTypes.get(key);
            if (t1 == null) {
                if (this.isExtensible()) {
                    foundSubsuming = true;
                    continue;
                }
                if (Cardinality.allowsZero(t2.getCardinality())) {
                    foundOverlap = true;
                    continue;
                }
                return Affinity.DISJOINT;
            }
            if (t2 == null) {
                if (other.isExtensible()) {
                    foundSubsumed = true;
                    continue;
                }
                if (Cardinality.allowsZero(t1.getCardinality())) {
                    foundOverlap = true;
                    continue;
                }
                return Affinity.DISJOINT;
            }
            Affinity a = th.sequenceTypeRelationship(t1, t2);
            switch (a) {
                case SAME_TYPE: {
                    break;
                }
                case SUBSUMED_BY: {
                    foundSubsumed = true;
                    break;
                }
                case SUBSUMES: {
                    foundSubsuming = true;
                    break;
                }
                case OVERLAPS: {
                    foundOverlap = true;
                    break;
                }
                case DISJOINT: {
                    return Affinity.DISJOINT;
                }
            }
        }
        if (foundOverlap || foundSubsumed && foundSubsuming) {
            return Affinity.OVERLAPS;
        }
        if (foundSubsuming) {
            return Affinity.SUBSUMES;
        }
        if (foundSubsumed) {
            return Affinity.SUBSUMED_BY;
        }
        return Affinity.SAME_TYPE;
    }

    @Override
    public Optional<String> explainMismatch(Item item, TypeHierarchy th) {
        if (item instanceof MapItem) {
            for (Map.Entry<String, SequenceType> entry : this.fieldTypes.entrySet()) {
                String key = entry.getKey();
                SequenceType required = entry.getValue();
                GroundedValue value = ((MapItem)item).get(new StringValue(key));
                if (value == null) {
                    if (Cardinality.allowsZero(required.getCardinality()) || this.isOptionalField(key)) continue;
                    return Optional.of("Field " + key + " is absent; it must have a value");
                }
                if (required.matches(value, th)) continue;
                String s = "Field " + key + " has value " + Err.depictSequence(value) + " which does not match the required type " + required.toString();
                Optional<String> more = required.explainMismatch(value, th);
                if (more.isPresent()) {
                    s = s + ". " + more.get();
                }
                return Optional.of(s);
            }
            if (!this._extensible) {
                AtomicValue key;
                AtomicIterator keyIter = ((MapItem)item).keys();
                while ((key = keyIter.next()) != null) {
                    if (!(key instanceof StringValue)) {
                        return Optional.of("Undeclared field " + key + " is present, but it is not a string, and the record type is not extensible");
                    }
                    if (this.fieldTypes.containsKey(key.getStringValue())) continue;
                    return Optional.of("Undeclared field " + key + " is present, but the record type is not extensible");
                }
            }
        }
        return Optional.empty();
    }

    @Override
    public Expression makeFunctionSequenceCoercer(Expression exp, Supplier<RoleDiagnostic> role, boolean allow40) throws XPathException {
        return new SpecificFunctionType(this.getArgumentTypes(), this.getResultType()).makeFunctionSequenceCoercer(exp, role, false);
    }

    public static class Field {
        String name;
        SequenceType type;
        boolean optional;

        public Field(String name, SequenceType type, boolean optional) {
            this.name = name;
            this.type = type;
            this.optional = optional;
        }
    }
}

