/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.lang;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.StringTokenizer;
import jlibs.core.io.IOPump;
import jlibs.core.io.IOUtil;
import jlibs.core.lang.OS;

public class RuntimeUtil {
    public static void redirectStreams(Process process, OutputStream output, OutputStream error) {
        if (output != null) {
            new Thread(new IOPump(process.getInputStream(), output, false, false).asRunnable()).start();
        }
        if (error != null) {
            new Thread(new IOPump(process.getErrorStream(), error, false, false).asRunnable()).start();
        }
    }

    public static String runCommand(String command, String[] envp, File workingDir) throws IOException {
        String[] cmd = OS.get().isUnix() ? new String[]{"sh", "-c", command} : new String[]{"cmd", "/C", command};
        Process p = Runtime.getRuntime().exec(cmd, envp, workingDir);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        RuntimeUtil.redirectStreams(p, output, System.err);
        try {
            p.waitFor();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("interrupted", ex);
        }
        if (p.exitValue() != 0) {
            throw new IOException("exitValue is " + p.exitValue());
        }
        return output.toString();
    }

    public static String runCommand(String command) throws IOException {
        return RuntimeUtil.runCommand(command, null, null);
    }

    public static String getPID() throws IOException {
        String pid = System.getProperty("pid");
        if (pid == null) {
            String command;
            if (OS.get().isUnix()) {
                command = "echo $$ $PPID";
            } else {
                File tempFile = File.createTempFile("getpids", "exe");
                IOUtil.pump(RuntimeUtil.class.getResourceAsStream("getpids.exe"), new FileOutputStream(tempFile), true, true);
                command = tempFile.getAbsolutePath();
                tempFile.deleteOnExit();
            }
            StringTokenizer stok = new StringTokenizer(RuntimeUtil.runCommand(command));
            stok.nextToken();
            pid = stok.nextToken();
            System.setProperty("pid", pid);
        }
        return pid;
    }

    public static void gc() {
        Object obj = new Object();
        WeakReference<Object> ref = new WeakReference<Object>(obj);
        obj = null;
        while (ref.get() != null) {
            System.gc();
        }
    }

    public static void gc(int count) {
        while (count != 0) {
            RuntimeUtil.gc();
            --count;
        }
    }

    public static void gcOnExit() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                RuntimeUtil.gc();
            }
        });
    }
}

