/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sequencing.Sequencing;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.sequencing.DefaultSequence;
import org.eclipse.persistence.sequencing.NativeSequence;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sequencing.TableSequence;
import org.eclipse.persistence.sequencing.UnaryTableSequence;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.tools.schemaframework.DatabaseObjectDefinition;
import org.eclipse.persistence.tools.schemaframework.DefaultTableGenerator;
import org.eclipse.persistence.tools.schemaframework.SequenceDefinition;
import org.eclipse.persistence.tools.schemaframework.SequenceObjectDefinition;
import org.eclipse.persistence.tools.schemaframework.StoredProcedureDefinition;
import org.eclipse.persistence.tools.schemaframework.StoredProcedureGenerator;
import org.eclipse.persistence.tools.schemaframework.TableCreator;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;
import org.eclipse.persistence.tools.schemaframework.TableSequenceDefinition;
import org.eclipse.persistence.tools.schemaframework.UnaryTableSequenceDefinition;

public class SchemaManager {
    protected DatabaseSessionImpl session;
    protected Writer createSchemaWriter;
    protected Writer dropSchemaWriter;
    protected boolean createSQLFiles = true;
    protected TableCreator defaultTableCreator;
    public static boolean FAST_TABLE_CREATOR = false;
    public static boolean FORCE_DROP = true;
    protected boolean createDatabaseSchemas = false;
    protected Set<String> createdDatabaseSchemas = new HashSet<String>();
    protected Set<String> createdDatabaseSchemasOnDatabase = new HashSet<String>();
    protected Map<String, DatabaseObjectDefinition> dropDatabaseSchemas = new HashMap<String, DatabaseObjectDefinition>();

    public SchemaManager(DatabaseSessionImpl session) {
        this.session = session;
    }

    public SchemaManager(DatabaseSession session) {
        this((DatabaseSessionImpl)session);
    }

    protected Writer getDropSchemaWriter() {
        return this.dropSchemaWriter == null ? this.createSchemaWriter : this.dropSchemaWriter;
    }

    public void appendToDDLWriter(String stringToWrite) {
        this.appendToDDLWriter(this.createSchemaWriter, stringToWrite);
    }

    public void appendToDDLWriter(Writer schemaWriter, String stringToWrite) {
        if (schemaWriter == null) {
            return;
        }
        try {
            schemaWriter.write(stringToWrite);
            schemaWriter.flush();
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    public void buildFieldTypes(TableDefinition tableDef) {
        tableDef.buildFieldTypes(this.getSession());
    }

    public void closeDDLWriter() {
        this.closeDDLWriter(this.createSchemaWriter);
        this.closeDDLWriter(this.dropSchemaWriter);
        this.createSchemaWriter = null;
        this.dropSchemaWriter = null;
    }

    public void closeDDLWriter(Writer schemaWriter) {
        if (schemaWriter == null) {
            return;
        }
        try {
            schemaWriter.flush();
            schemaWriter.close();
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    protected void collectDatabaseSchemasForDrop(DatabaseObjectDefinition databaseObjectDefinition) {
        if (this.createDatabaseSchemas && databaseObjectDefinition.hasDatabaseSchema() && !this.dropDatabaseSchemas.containsKey(databaseObjectDefinition.getDatabaseSchema())) {
            this.dropDatabaseSchemas.put(databaseObjectDefinition.getDatabaseSchema(), databaseObjectDefinition);
        }
    }

    public void createConstraints(TableDefinition tableDefinition) throws EclipseLinkException {
        boolean usesBatchWriting = false;
        if (this.getSession().getPlatform().usesBatchWriting()) {
            usesBatchWriting = true;
            this.getSession().getPlatform().setUsesBatchWriting(false);
        }
        try {
            if (this.shouldWriteToDatabase()) {
                tableDefinition.createConstraintsOnDatabase(this.getSession());
            } else {
                tableDefinition.setCreateSQLFiles(this.createSQLFiles);
                tableDefinition.createConstraints(this.getSession(), this.createSchemaWriter);
            }
        }
        finally {
            if (usesBatchWriting) {
                this.getSession().getPlatform().setUsesBatchWriting(true);
            }
        }
    }

    void createUniqueConstraints(TableDefinition tableDefinition) throws EclipseLinkException {
        if (this.shouldWriteToDatabase()) {
            tableDefinition.createUniqueConstraintsOnDatabase(this.getSession());
        } else {
            tableDefinition.setCreateSQLFiles(this.createSQLFiles);
            tableDefinition.createUniqueConstraints(this.getSession(), this.createSchemaWriter);
        }
    }

    void createForeignConstraints(TableDefinition tableDefinition) throws EclipseLinkException {
        if (this.shouldWriteToDatabase()) {
            tableDefinition.createForeignConstraintsOnDatabase(this.getSession());
        } else {
            tableDefinition.setCreateSQLFiles(this.createSQLFiles);
            tableDefinition.createForeignConstraints(this.getSession(), this.createSchemaWriter);
        }
    }

    public void createObject(DatabaseObjectDefinition databaseObjectDefinition) throws EclipseLinkException {
        boolean usesBatchWriting = false;
        if (this.getSession().getPlatform().usesBatchWriting()) {
            usesBatchWriting = true;
            this.getSession().getPlatform().setUsesBatchWriting(false);
        }
        try {
            if (this.shouldWriteToDatabase()) {
                if (this.shouldCreateDatabaseSchema(databaseObjectDefinition, this.createdDatabaseSchemasOnDatabase)) {
                    databaseObjectDefinition.createDatabaseSchemaOnDatabase(this.getSession(), this.createdDatabaseSchemasOnDatabase);
                }
                databaseObjectDefinition.createOnDatabase(this.getSession());
            } else {
                if (this.shouldCreateDatabaseSchema(databaseObjectDefinition, this.createdDatabaseSchemas)) {
                    databaseObjectDefinition.createDatabaseSchema(this.getSession(), this.createSchemaWriter, this.createdDatabaseSchemas);
                    this.appendToDDLWriter(this.createSchemaWriter, "\n");
                }
                databaseObjectDefinition.createObject(this.getSession(), this.createSchemaWriter);
                if (this.createSQLFiles) {
                    this.appendToDDLWriter(this.createSchemaWriter, this.getSession().getPlatform().getStoredProcedureTerminationToken());
                }
                this.appendToDDLWriter(this.createSchemaWriter, "\n");
            }
            databaseObjectDefinition.postCreateObject(this.getSession(), this.createSchemaWriter, this.createSQLFiles);
        }
        finally {
            if (usesBatchWriting) {
                this.getSession().getPlatform().setUsesBatchWriting(true);
            }
        }
    }

    public void createSequences() throws EclipseLinkException {
        this.createOrReplaceSequences(true);
    }

    public void setCreateDatabaseSchemas(boolean createDatabaseSchemas) {
        this.createDatabaseSchemas = createDatabaseSchemas;
    }

    public void setCreateSQLFiles(boolean genFlag) {
        this.createSQLFiles = genFlag;
    }

    public void replaceSequences() throws EclipseLinkException {
        this.createOrReplaceSequences(false);
    }

    protected void createOrReplaceSequences(boolean create) throws EclipseLinkException {
        this.createOrReplaceSequences(create, create);
    }

    protected void createOrReplaceSequences(boolean createSequenceTables, boolean createSequences) throws EclipseLinkException {
        boolean fast = FAST_TABLE_CREATOR;
        if (fast) {
            return;
        }
        this.processSequenceDefinitions(createSequenceTables, createSequences, true);
    }

    protected void dropSequences() {
        this.processSequenceDefinitions(false, false, false);
    }

    protected void processSequenceDefinition(SequenceDefinition definition, boolean createTables, boolean createSequences, boolean replace, Set<String> createdTableNames, Set<String> droppedTableNames) throws EclipseLinkException {
        block15: {
            try {
                TableDefinition tableDefinition;
                if (definition.isTableSequenceDefinition() && !createdTableNames.contains((tableDefinition = definition.buildTableDefinition()).getFullName())) {
                    createdTableNames.add(tableDefinition.getFullName());
                    boolean exists = this.checkTableExists(tableDefinition);
                    if (createTables) {
                        if (this.shouldWriteToDatabase() && !exists || !this.shouldWriteToDatabase()) {
                            this.createObject(tableDefinition);
                        }
                    } else if (replace) {
                        this.dropObject(tableDefinition);
                        this.createObject(tableDefinition);
                    }
                }
            }
            catch (DatabaseException tableDefinition) {
                // empty catch block
            }
            try {
                if (createSequences) {
                    this.createObject(definition);
                    break block15;
                }
                try {
                    if (definition.isTableSequenceDefinition() && ((TableSequenceDefinition)definition).shouldDropTableDefinition()) {
                        String tableDefinitionTableName = ((TableSequenceDefinition)definition).getSequenceTableName();
                        if (droppedTableNames.contains(tableDefinitionTableName)) {
                            return;
                        }
                        droppedTableNames.add(tableDefinitionTableName);
                    }
                    this.dropObject(definition);
                }
                catch (DatabaseException databaseException) {
                    // empty catch block
                }
                if (replace) {
                    this.createObject(definition);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void processSequenceDefinitions(boolean createSequenceTables, boolean createSequences, boolean replaceSequences) throws EclipseLinkException {
        Sequencing sequencing = this.getSession().getSequencing();
        if (sequencing != null && sequencing.whenShouldAcquireValueForAll() != 1) {
            Set<SequenceDefinition> sequenceDefinitions = this.buildSequenceDefinitions();
            boolean shouldLogExceptionStackTrace = this.session.getSessionLog().shouldLogExceptionStackTrace();
            this.session.getSessionLog().setShouldLogExceptionStackTrace(false);
            HashSet<String> createdSequenceTableNames = new HashSet<String>();
            HashSet<String> droppedSequenceTableNames = new HashSet<String>();
            for (SequenceDefinition sequenceDefinition : sequenceDefinitions) {
                this.processSequenceDefinition(sequenceDefinition, createSequenceTables, createSequences, replaceSequences, createdSequenceTableNames, droppedSequenceTableNames);
            }
            this.session.getSessionLog().setShouldLogExceptionStackTrace(shouldLogExceptionStackTrace);
        }
    }

    protected Set<SequenceDefinition> buildSequenceDefinitions() {
        HashSet<String> processedSequenceNames = new HashSet<String>();
        HashSet<SequenceDefinition> sequenceDefinitions = new HashSet<SequenceDefinition>();
        for (ClassDescriptor descriptor : this.getSession().getDescriptors().values()) {
            if (!descriptor.usesSequenceNumbers()) continue;
            String seqName = descriptor.getSequenceNumberName();
            if (seqName == null) {
                seqName = this.getSession().getDatasourcePlatform().getDefaultSequence().getName();
            }
            if (processedSequenceNames.contains(seqName)) continue;
            processedSequenceNames.add(seqName);
            Sequence sequence = this.getSession().getDatasourcePlatform().getSequence(seqName);
            SequenceDefinition sequenceDefinition = this.buildSequenceDefinition(sequence);
            if (sequenceDefinition == null) continue;
            sequenceDefinitions.add(sequenceDefinition);
        }
        return sequenceDefinitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkTableExists(TableDefinition table, boolean suppressLogging) {
        boolean loggingOff = this.session.isLoggingOff();
        try {
            boolean bl = this.session.getPlatform().checkTableExists(this.session, table, suppressLogging);
            return bl;
        }
        finally {
            this.session.setLoggingOff(loggingOff);
        }
    }

    public boolean checkTableExists(TableDefinition table) {
        return this.checkTableExists(table, true);
    }

    protected SequenceDefinition buildSequenceDefinition(Sequence sequence) {
        if (sequence.shouldAcquireValueAfterInsert()) {
            return null;
        }
        Sequence defaultSequence = this.getDefaultSequenceOrNull(sequence);
        if (sequence.isTable() || defaultSequence != null && defaultSequence.isTable()) {
            TableSequenceDefinition definition = this.initSequenceDefinition(new TableSequenceDefinition(sequence.getName(), this.createDatabaseSchemas), sequence);
            TableSequence ts = sequence.isTable() ? (TableSequence)sequence : (TableSequence)defaultSequence;
            definition.setSequenceTableName(ts.getTableName());
            definition.setSequenceTableQualifier(ts.getQualifier());
            definition.setSequenceNameFieldName(ts.getNameFieldName());
            definition.setSequenceCounterFieldName(ts.getCounterFieldName());
            definition.setSequenceTableIndexes(ts.getTableIndexes());
            return definition;
        }
        if (sequence.isUnaryTable() || defaultSequence != null && defaultSequence.isUnaryTable()) {
            UnaryTableSequenceDefinition definition = this.initSequenceDefinition(new UnaryTableSequenceDefinition(sequence.getName(), this.createDatabaseSchemas), sequence);
            UnaryTableSequence ut = sequence.isTable() ? (UnaryTableSequence)sequence : (UnaryTableSequence)defaultSequence;
            definition.setSequenceTableName(ut.getName());
            definition.setSequenceTableQualifier(ut.getQualifier());
            definition.setSequenceCounterFieldName(ut.getCounterFieldName());
            return definition;
        }
        if (sequence.isNative() || defaultSequence != null && defaultSequence.isNative()) {
            NativeSequence nativeSequence;
            NativeSequence nativeSequence2 = nativeSequence = sequence.isNative() ? (NativeSequence)sequence : (NativeSequence)defaultSequence;
            if (nativeSequence.hasDelegateSequence()) {
                return this.buildSequenceDefinition(((NativeSequence)sequence).getDelegateSequence());
            }
            return this.initSequenceDefinition(new SequenceObjectDefinition(sequence.getName()), sequence);
        }
        return null;
    }

    public void dropConstraints(TableDefinition tableDefinition) throws EclipseLinkException {
        boolean usesBatchWriting = false;
        if (this.getSession().getPlatform().usesBatchWriting()) {
            usesBatchWriting = true;
            this.getSession().getPlatform().setUsesBatchWriting(false);
        }
        try {
            if (this.shouldWriteToDatabase()) {
                tableDefinition.dropConstraintsOnDatabase(this.getSession());
            } else {
                tableDefinition.setCreateSQLFiles(this.createSQLFiles);
                tableDefinition.dropConstraints(this.getSession(), this.getDropSchemaWriter());
            }
        }
        finally {
            if (usesBatchWriting) {
                this.getSession().getPlatform().setUsesBatchWriting(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropObject(DatabaseObjectDefinition databaseObjectDefinition) throws EclipseLinkException {
        boolean usesBatchWriting = false;
        if (this.getSession().getPlatform().usesBatchWriting()) {
            usesBatchWriting = true;
            this.getSession().getPlatform().setUsesBatchWriting(false);
        }
        try {
            this.collectDatabaseSchemasForDrop(databaseObjectDefinition);
            databaseObjectDefinition.preDropObject(this.getSession(), this.getDropSchemaWriter(), this.createSQLFiles);
            if (this.shouldWriteToDatabase()) {
                databaseObjectDefinition.dropFromDatabase(this.getSession());
            } else {
                Writer dropSchemaWriter = this.getDropSchemaWriter();
                databaseObjectDefinition.dropObject(this.getSession(), dropSchemaWriter, this.createSQLFiles);
                if (this.createSQLFiles) {
                    this.appendToDDLWriter(dropSchemaWriter, this.getSession().getPlatform().getStoredProcedureTerminationToken());
                }
                this.appendToDDLWriter(dropSchemaWriter, "\n");
            }
        }
        finally {
            if (usesBatchWriting) {
                this.getSession().getPlatform().setUsesBatchWriting(true);
            }
        }
    }

    public void dropTable(String tableName) throws EclipseLinkException {
        TableDefinition tableDefinition = new TableDefinition();
        tableDefinition.setName(tableName);
        this.dropObject(tableDefinition);
    }

    public void finalize() {
        try {
            this.closeDDLWriter();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }

    public void generateStoredProcedures() throws EclipseLinkException {
        new StoredProcedureGenerator(this).generateStoredProcedures();
    }

    public void generateStoredProcedures(Writer writer) throws EclipseLinkException {
        new StoredProcedureGenerator(this).generateStoredProcedures(writer);
    }

    public void generateStoredProceduresAndAmendmentClass(Writer writer, String fullyQualifiedClassName) throws EclipseLinkException {
        String className = fullyQualifiedClassName.substring(fullyQualifiedClassName.lastIndexOf(46) + 1);
        String packageName = fullyQualifiedClassName.substring(0, fullyQualifiedClassName.lastIndexOf(46));
        StoredProcedureGenerator storedProcedureGenerator = new StoredProcedureGenerator(this);
        storedProcedureGenerator.generateStoredProcedures();
        storedProcedureGenerator.generateAmendmentClass(writer, packageName, className);
    }

    public void generateStoredProceduresAndAmendmentClass(String path, String fullyQualifiedClassName) throws EclipseLinkException {
        FileWriter fileWriter = null;
        try {
            StoredProcedureGenerator storedProcedureGenerator = new StoredProcedureGenerator(this);
            if (!((String)path).endsWith("\\") && !((String)path).endsWith("/")) {
                path = (String)path + "\\";
            }
            String className = fullyQualifiedClassName.substring(fullyQualifiedClassName.lastIndexOf(46) + 1);
            String packageName = fullyQualifiedClassName.substring(0, fullyQualifiedClassName.lastIndexOf(46));
            String fileName = (String)path + className + ".java";
            fileWriter = new FileWriter(fileName);
            storedProcedureGenerator.generateStoredProcedures();
            storedProcedureGenerator.generateAmendmentClass(fileWriter, packageName, className);
            fileWriter.close();
        }
        catch (IOException ioException) {
            try {
                throw ValidationException.fileError(ioException);
            }
            catch (Throwable throwable) {
                Helper.close(fileWriter);
                throw throwable;
            }
        }
        Helper.close(fileWriter);
    }

    protected DatabaseAccessor getAccessor() {
        return (DatabaseAccessor)this.getSession().getAccessor();
    }

    public List<AbstractRecord> getAllColumnNames(String tableName) throws DatabaseException {
        return this.getAccessor().getColumnInfo(null, null, tableName, null, this.getSession());
    }

    public List<AbstractRecord> getAllColumnNames(String creatorName, String tableName) throws DatabaseException {
        return this.getAccessor().getColumnInfo(null, creatorName, tableName, null, this.getSession());
    }

    public List<AbstractRecord> getAllTableNames() throws DatabaseException {
        return this.getAccessor().getTableInfo(null, null, null, null, this.getSession());
    }

    public List<AbstractRecord> getAllTableNames(String creatorName) throws DatabaseException {
        return this.getAccessor().getTableInfo(null, creatorName, null, null, this.getSession());
    }

    public List<AbstractRecord> getColumnInfo(String catalog, String schema, String tableName, String columnName) throws DatabaseException {
        return this.getAccessor().getColumnInfo(catalog, schema, tableName, columnName, this.getSession());
    }

    public List<AbstractRecord> getColumnInfo(String tableName, String columnName) throws DatabaseException {
        return this.getAccessor().getColumnInfo(tableName, columnName, this.getSession());
    }

    public AbstractSession getSession() {
        return this.session;
    }

    public List<AbstractRecord> getTableInfo(String catalog, String schema, String tableName, String[] types) throws DatabaseException {
        return this.getAccessor().getTableInfo(catalog, schema, tableName, types, this.getSession());
    }

    public void outputDDLToDatabase() {
        this.createSchemaWriter = null;
        this.dropSchemaWriter = null;
    }

    public void outputDDLToFile(String fileName) {
        this.createSchemaWriter = this.getWriter(fileName);
    }

    public void outputCreateDDLToFile(String fileName) {
        this.createSchemaWriter = this.getWriter(fileName);
    }

    public void outputDropDDLToFile(String fileName) {
        this.dropSchemaWriter = this.getWriter(fileName);
    }

    protected Writer getWriter(String fileName) {
        try {
            return new FileWriter(fileName);
        }
        catch (IOException ioException) {
            try {
                URL url = new URL(fileName);
                return new FileWriter(url.getFile());
            }
            catch (Exception e) {
                throw ValidationException.fileError(ioException);
            }
        }
    }

    public void outputDDLToWriter(Writer schemaWriter) {
        this.createSchemaWriter = schemaWriter;
    }

    public void outputCreateDDLToWriter(Writer createWriter) {
        this.createSchemaWriter = createWriter;
    }

    public void outputDropDDLToWriter(Writer dropWriter) {
        this.dropSchemaWriter = dropWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceObject(DatabaseObjectDefinition databaseDefinition) throws EclipseLinkException {
        boolean fast = FAST_TABLE_CREATOR;
        if (fast && databaseDefinition instanceof TableDefinition) {
            this.session.executeNonSelectingSQL("DELETE FROM " + databaseDefinition.getName());
        } else if (!fast || !(databaseDefinition instanceof StoredProcedureDefinition)) {
            boolean shouldLogExceptionStackTrace = this.getSession().getSessionLog().shouldLogExceptionStackTrace();
            if (shouldLogExceptionStackTrace) {
                this.getSession().getSessionLog().setShouldLogExceptionStackTrace(false);
            }
            try {
                this.dropObject(databaseDefinition);
            }
            catch (DatabaseException exception) {
                this.session.log(1, "ddl", "schema_drop_object_failed", exception.getLocalizedMessage());
            }
            finally {
                if (shouldLogExceptionStackTrace) {
                    this.getSession().getSessionLog().setShouldLogExceptionStackTrace(true);
                }
            }
            this.createObject(databaseDefinition);
        }
    }

    protected TableCreator getDefaultTableCreator(boolean generateFKConstraints) {
        if (this.defaultTableCreator == null) {
            this.defaultTableCreator = new DefaultTableGenerator(this.session.getProject(), generateFKConstraints).generateDefaultTableCreator();
            this.defaultTableCreator.setIgnoreDatabaseException(true);
        }
        return this.defaultTableCreator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDefaultTables(boolean generateFKConstraints) {
        boolean shouldLogExceptionStackTrace = this.getSession().getSessionLog().shouldLogExceptionStackTrace();
        this.getSession().getSessionLog().setShouldLogExceptionStackTrace(false);
        try {
            TableCreator tableCreator = this.getDefaultTableCreator(generateFKConstraints);
            tableCreator.createTables(this.session, this);
        }
        catch (DatabaseException exception) {
            this.session.log(1, "ddl", "schema_default_create_tables_failed", exception.getLocalizedMessage());
        }
        finally {
            this.getSession().getSessionLog().setShouldLogExceptionStackTrace(shouldLogExceptionStackTrace);
        }
        if (this.session.getDatabaseEventListener() != null) {
            this.session.getDatabaseEventListener().remove(this.session);
            this.session.getDatabaseEventListener().register(this.session);
        }
    }

    public void dropDatabaseSchemas() {
        for (DatabaseObjectDefinition dod : this.dropDatabaseSchemas.values()) {
            if (this.shouldWriteToDatabase()) {
                dod.dropDatabaseSchemaOnDatabase(this.getSession());
                continue;
            }
            dod.dropDatabaseSchema(this.getSession(), this.getDropSchemaWriter());
            this.appendToDDLWriter(this.getDropSchemaWriter(), "\n");
        }
    }

    public void dropDefaultTables() {
        boolean shouldLogExceptionStackTrace = this.getSession().getSessionLog().shouldLogExceptionStackTrace();
        this.getSession().getSessionLog().setShouldLogExceptionStackTrace(false);
        try {
            TableCreator tableCreator = this.getDefaultTableCreator(true);
            tableCreator.dropTables(this.session, this);
            this.dropSequences();
            this.dropDatabaseSchemas();
        }
        catch (DatabaseException exception) {
            this.session.log(1, "ddl", "schema_default_drop_tables_failed", exception.getLocalizedMessage());
        }
        finally {
            this.getSession().getSessionLog().setShouldLogExceptionStackTrace(shouldLogExceptionStackTrace);
        }
        if (this.session.getDatabaseEventListener() != null) {
            this.session.getDatabaseEventListener().remove(this.session);
            this.session.getDatabaseEventListener().register(this.session);
        }
    }

    public void replaceDefaultTables() throws EclipseLinkException {
        this.replaceDefaultTables(true, true, true);
    }

    public void replaceDefaultTables(boolean createSequenceTables, boolean generateFKConstraints) throws EclipseLinkException {
        this.replaceDefaultTables(createSequenceTables, false, generateFKConstraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceDefaultTables(boolean createSequenceTables, boolean createSequences, boolean generateFKConstraints) throws EclipseLinkException {
        boolean shouldLogExceptionStackTrace = this.getSession().getSessionLog().shouldLogExceptionStackTrace();
        this.session.getSessionLog().setShouldLogExceptionStackTrace(false);
        try {
            TableCreator tableCreator = this.getDefaultTableCreator(generateFKConstraints);
            tableCreator.replaceTables(this.session, this, createSequenceTables, createSequences);
            this.dropDatabaseSchemas();
        }
        catch (DatabaseException exception) {
            this.session.log(1, "ddl", "schema_default_replace_tables_failed", exception.getLocalizedMessage());
        }
        finally {
            this.session.getSessionLog().setShouldLogExceptionStackTrace(shouldLogExceptionStackTrace);
        }
        if (this.session.getDatabaseEventListener() != null) {
            this.session.getDatabaseEventListener().remove(this.session);
            this.session.getDatabaseEventListener().register(this.session);
        }
    }

    public void setSession(DatabaseSessionImpl session) {
        this.session = session;
    }

    protected boolean shouldCreateDatabaseSchema(DatabaseObjectDefinition databaseObjectDefinition, Set<String> createdDatabaseSchemas) {
        return this.createDatabaseSchemas && databaseObjectDefinition.shouldCreateDatabaseSchema(createdDatabaseSchemas);
    }

    public boolean shouldWriteToDatabase() {
        return this.createSchemaWriter == null && this.dropSchemaWriter == null;
    }

    public void alterSequence(SequenceDefinition sequenceDefinition) throws EclipseLinkException {
        if (!sequenceDefinition.isAlterSupported(this.getSession())) {
            return;
        }
        boolean usesBatchWriting = false;
        if (this.getSession().getPlatform().usesBatchWriting()) {
            usesBatchWriting = true;
            this.getSession().getPlatform().setUsesBatchWriting(false);
        }
        try {
            if (this.shouldWriteToDatabase()) {
                sequenceDefinition.alterOnDatabase(this.getSession());
            } else {
                sequenceDefinition.alter(this.getSession(), this.createSchemaWriter);
            }
        }
        finally {
            if (usesBatchWriting) {
                this.getSession().getPlatform().setUsesBatchWriting(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extendDefaultTables(boolean generateFKConstraints) throws EclipseLinkException {
        boolean shouldLogExceptionStackTrace = this.getSession().getSessionLog().shouldLogExceptionStackTrace();
        this.session.getSessionLog().setShouldLogExceptionStackTrace(false);
        try {
            TableCreator tableCreator = this.getDefaultTableCreator(generateFKConstraints);
            tableCreator.extendTables(this.session, this);
        }
        catch (DatabaseException exception) {
            this.session.log(1, "ddl", "schema_default_extend_tables_failed", exception.getLocalizedMessage());
        }
        finally {
            this.session.getSessionLog().setShouldLogExceptionStackTrace(shouldLogExceptionStackTrace);
        }
        if (this.session.getDatabaseEventListener() != null) {
            this.session.getDatabaseEventListener().remove(this.session);
            this.session.getDatabaseEventListener().register(this.session);
        }
    }

    private Sequence getDefaultSequenceOrNull(Sequence s) {
        return s instanceof DefaultSequence ? ((DefaultSequence)s).getDefaultSequence() : null;
    }

    private <T extends SequenceDefinition> T initSequenceDefinition(T sequenceDefinition, Sequence sequence) {
        sequenceDefinition.setQualifier(sequence.getQualifier());
        sequenceDefinition.setPreallocationSize(sequence.getPreallocationSize());
        sequenceDefinition.setInitialValue(sequence.getInitialValue());
        return sequenceDefinition;
    }
}

