/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.resources;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.InputStream;
import org.eclipse.persistence.jpa.rs.resources.common.AbstractEntityResource;

@Produces(value={"application/json", "application/xml"})
@Consumes(value={"application/json", "application/xml"})
@Path(value="/{version : v\\d\\.\\d|latest}/{context}/entity/")
public class EntityResource
extends AbstractEntityResource {
    @GET
    @Path(value="{type}/{id}/{attribute}")
    public Response findAttribute(@PathParam(value="version") String version, @PathParam(value="context") String persistenceUnit, @PathParam(value="type") String type, @PathParam(value="id") String id, @PathParam(value="attribute") String attribute, @Context HttpHeaders hh, @Context UriInfo ui) {
        this.setRequestUniqueId();
        return this.findAttributeInternal(version, persistenceUnit, type, id, attribute, hh, ui);
    }

    @GET
    @Path(value="{type}/{id}")
    public Response find(@PathParam(value="version") String version, @PathParam(value="context") String persistenceUnit, @PathParam(value="type") String type, @PathParam(value="id") String id, @Context HttpHeaders hh, @Context UriInfo ui) {
        this.setRequestUniqueId();
        return this.findInternal(version, persistenceUnit, type, id, hh, ui);
    }

    @PUT
    @Path(value="{type}")
    public Response create(@PathParam(value="version") String version, @PathParam(value="context") String persistenceUnit, @PathParam(value="type") String type, @Context HttpHeaders hh, @Context UriInfo uriInfo, InputStream in) throws Exception {
        this.setRequestUniqueId();
        return this.createInternal(version, persistenceUnit, type, hh, uriInfo, in);
    }

    @POST
    @Path(value="{type}")
    public Response update(@PathParam(value="version") String version, @PathParam(value="context") String persistenceUnit, @PathParam(value="type") String type, @Context HttpHeaders hh, @Context UriInfo uriInfo, InputStream in) {
        this.setRequestUniqueId();
        return this.updateInternal(version, persistenceUnit, type, hh, uriInfo, in);
    }

    @POST
    @Path(value="{type}/{id}/{attribute}")
    public Response setOrAddAttribute(@PathParam(value="version") String version, @PathParam(value="context") String persistenceUnit, @PathParam(value="type") String type, @PathParam(value="id") String id, @PathParam(value="attribute") String attribute, @Context HttpHeaders hh, @Context UriInfo ui, InputStream in) {
        this.setRequestUniqueId();
        return this.setOrAddAttributeInternal(version, persistenceUnit, type, id, attribute, hh, ui, in);
    }

    @DELETE
    @Path(value="{type}/{id}/{attribute}")
    public Response removeAttribute(@PathParam(value="version") String version, @PathParam(value="context") String persistenceUnit, @PathParam(value="type") String type, @PathParam(value="id") String id, @PathParam(value="attribute") String attribute, @Context HttpHeaders hh, @Context UriInfo ui) {
        this.setRequestUniqueId();
        return this.removeAttributeInternal(version, persistenceUnit, type, id, attribute, hh, ui);
    }

    @DELETE
    @Path(value="{type}/{id}")
    public Response delete(@PathParam(value="version") String version, @PathParam(value="context") String persistenceUnit, @PathParam(value="type") String type, @PathParam(value="id") String id, @Context HttpHeaders hh, @Context UriInfo ui) {
        this.setRequestUniqueId();
        return this.deleteInternal(version, persistenceUnit, type, id, hh, ui);
    }

    @OPTIONS
    @Path(value="{entityName}")
    public Response getEntityOptions(@PathParam(value="version") String version, @PathParam(value="context") String persistenceUnit, @PathParam(value="entityName") String entityName, @Context HttpHeaders httpHeaders, @Context UriInfo uriInfo) {
        this.setRequestUniqueId();
        return this.buildEntityOptionsResponse(version, persistenceUnit, entityName, httpHeaders, uriInfo);
    }
}

