/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.Stack;
import org.apache.openejb.util.CircularReferencesException;
import org.apache.openejb.util.Join;

public class References {
    public static <T> List<T> sort(List<T> objects, Visitor<T> visitor) {
        Node rootNode;
        if (objects.size() <= 1) {
            return objects;
        }
        LinkedHashMap<String, Node> nodes = new LinkedHashMap<String, Node>();
        for (T obj : objects) {
            String name = visitor.getName(obj);
            Node node = new Node(name, obj);
            nodes.put(name, node);
        }
        for (Object node : nodes.values()) {
            for (String name : visitor.getReferences(((Node)node).object)) {
                Node ref = (Node)nodes.get(name);
                if (ref == null) {
                    throw new IllegalArgumentException("No such object in list: " + name);
                }
                ((Node)node).references.add(ref);
                ((Node)node).initialReferences.add(ref);
            }
        }
        boolean circuitFounded = false;
        for (Object node : nodes.values()) {
            HashSet<Node> visitedNodes;
            if (!References.normalizeNodeReferences((Node)node, (Node)node, visitedNodes = new HashSet<Node>())) {
                circuitFounded = true;
                break;
            }
            ((Node)node).references.addAll(visitedNodes);
        }
        if (circuitFounded) {
            LinkedHashSet<Circuit> circuits = new LinkedHashSet<Circuit>();
            for (Node node : nodes.values()) {
                References.findCircuits(circuits, node, new Stack<Node>());
            }
            Iterator list = new ArrayList(circuits);
            Collections.sort(list);
            ArrayList<List> all = new ArrayList<List>();
            Iterator<Object> iterator = ((ArrayList)((Object)list)).iterator();
            while (iterator.hasNext()) {
                Circuit circuit = (Circuit)iterator.next();
                all.add(References.unwrap(circuit.nodes));
            }
            throw new CircularReferencesException(all);
        }
        rootNode.previous = rootNode = new Node(null, null);
        rootNode.next = (Node)nodes.values().iterator().next();
        for (Node node : nodes.values()) {
            node.previous = rootNode.previous;
            rootNode.previous.next = node;
            node.next = rootNode;
            rootNode.previous = node;
        }
        for (Node node : nodes.values()) {
            for (Node reference : node.references) {
                References.swap(node, reference, rootNode);
            }
        }
        ArrayList<Object> sortedList = new ArrayList<Object>(nodes.size());
        Node currentNode = rootNode.next;
        while (currentNode != rootNode) {
            sortedList.add(currentNode.object);
            currentNode = currentNode.next;
        }
        return sortedList;
    }

    private static boolean normalizeNodeReferences(Node rootNode, Node node, Set<Node> referenceNodes) {
        if (node.references.contains(rootNode)) {
            return false;
        }
        for (Node reference : node.references) {
            if (!referenceNodes.add(reference) || References.normalizeNodeReferences(rootNode, reference, referenceNodes)) continue;
            return false;
        }
        return true;
    }

    private static void swap(Node shouldAfterNode, Node shouldBeforeNode, Node rootNode) {
        Node currentNode = shouldBeforeNode;
        while (currentNode.next != rootNode) {
            if (currentNode.next == shouldAfterNode) {
                return;
            }
            currentNode = currentNode.next;
        }
        shouldAfterNode.previous.next = shouldAfterNode.next;
        shouldAfterNode.next.previous = shouldAfterNode.previous;
        shouldAfterNode.previous = shouldBeforeNode;
        shouldAfterNode.next = shouldBeforeNode.next;
        shouldBeforeNode.next = shouldAfterNode;
        shouldAfterNode.next.previous = shouldAfterNode;
    }

    private static <T> List<T> unwrap(List<Node> nodes) {
        ArrayList<Object> referees = new ArrayList<Object>(nodes.size());
        for (Node node : nodes) {
            referees.add(node.object);
        }
        return referees;
    }

    private static void findCircuits(Set<Circuit> circuits, Node node, Stack<Node> stack) {
        if (stack.contains(node)) {
            int fromIndex = stack.indexOf(node);
            int toIndex = stack.size();
            ArrayList<Node> circularity = new ArrayList<Node>(stack.subList(fromIndex, toIndex));
            circularity.add(node);
            Circuit circuit = new Circuit(circularity);
            circuits.add(circuit);
            return;
        }
        stack.push(node);
        for (Node reference : node.initialReferences) {
            References.findCircuits(circuits, reference, stack);
        }
        stack.pop();
    }

    public static interface Visitor<T> {
        public String getName(T var1);

        public Set<String> getReferences(T var1);
    }

    private static class Node
    implements Comparable<Node> {
        private final String name;
        private final Object object;
        private final List<Node> initialReferences = new ArrayList<Node>();
        private final Set<Node> references = new HashSet<Node>();
        private Node next;
        private Node previous;

        public Node(String name, Object object) {
            this.name = name;
            this.object = object;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            return this.name.equals(node.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        @Override
        public int compareTo(Node o) {
            return this.name.compareTo(o.name);
        }

        public String toString() {
            return this.name;
        }
    }

    private static class Circuit
    implements Comparable<Circuit> {
        private final List<Node> nodes;
        private final List<Node> atomic;

        public Circuit(List<Node> nodes) {
            this.nodes = nodes;
            this.atomic = new ArrayList<Node>(nodes);
            this.atomic.remove(this.atomic.size() - 1);
            Collections.sort(this.atomic);
        }

        public List<Node> getNodes() {
            return this.nodes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Circuit circuit = (Circuit)o;
            return this.atomic.equals(circuit.atomic);
        }

        public int hashCode() {
            return this.atomic.hashCode();
        }

        @Override
        public int compareTo(Circuit o) {
            int i = this.atomic.size() - o.atomic.size();
            if (i != 0) {
                return i;
            }
            ListIterator<Node> iterA = this.atomic.listIterator();
            ListIterator<Node> iterB = o.atomic.listIterator();
            while (iterA.hasNext() && iterB.hasNext()) {
                Node b;
                Node a = (Node)iterA.next();
                i = a.compareTo(b = (Node)iterB.next());
                if (i == 0) continue;
                return i;
            }
            return 0;
        }

        public String toString() {
            return "Circuit(" + Join.join(",", References.unwrap(this.nodes)) + ")";
        }
    }
}

