/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester3;

import java.util.Stack;
import org.apache.commons.digester3.Rule;
import org.xml.sax.Attributes;

public class CallParamRule
extends Rule {
    protected String attributeName = null;
    protected int paramIndex = 0;
    protected boolean fromStack = false;
    protected int stackIndex = 0;
    protected Stack<String> bodyTextStack;

    public CallParamRule(int paramIndex) {
        this(paramIndex, null);
    }

    public CallParamRule(int paramIndex, String attributeName) {
        this.paramIndex = paramIndex;
        this.attributeName = attributeName;
    }

    public CallParamRule(int paramIndex, boolean fromStack) {
        this.paramIndex = paramIndex;
        this.fromStack = fromStack;
    }

    public CallParamRule(int paramIndex, int stackIndex) {
        this.paramIndex = paramIndex;
        this.fromStack = true;
        this.stackIndex = stackIndex;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        String param = null;
        if (this.attributeName != null) {
            param = attributes.getValue(this.attributeName);
        } else if (this.fromStack) {
            param = this.getDigester().peek(this.stackIndex);
            if (this.getDigester().getLogger().isDebugEnabled()) {
                this.getDigester().getLogger().debug((Object)String.format("[CallParamRule]{%s} Save from stack; from stack?%s; object=%s", this.getDigester().getMatch(), this.fromStack, param));
            }
        }
        if (param != null) {
            Object[] parameters = this.getDigester().peekParams();
            parameters[this.paramIndex] = param;
        }
    }

    public void body(String namespace, String name, String text) throws Exception {
        if (this.attributeName == null && !this.fromStack) {
            if (this.bodyTextStack == null) {
                this.bodyTextStack = new Stack();
            }
            this.bodyTextStack.push(text.trim());
        }
    }

    public void end(String namespace, String name) {
        if (this.bodyTextStack != null && !this.bodyTextStack.empty()) {
            Object[] parameters = this.getDigester().peekParams();
            parameters[this.paramIndex] = this.bodyTextStack.pop();
        }
    }

    public String toString() {
        return String.format("CallParamRule[paramIndex=%s, attributeName=%s, from stack=%s]", this.paramIndex, this.attributeName, this.fromStack);
    }
}

