/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.io.netty.channel.uring;

import java.io.IOException;
import java.net.SocketAddress;
import org.apache.storm.shade.io.netty.channel.Channel;
import org.apache.storm.shade.io.netty.channel.ChannelFuture;
import org.apache.storm.shade.io.netty.channel.ChannelFutureListener;
import org.apache.storm.shade.io.netty.channel.ChannelOutboundBuffer;
import org.apache.storm.shade.io.netty.channel.ChannelPipeline;
import org.apache.storm.shade.io.netty.channel.ChannelPromise;
import org.apache.storm.shade.io.netty.channel.IoRegistration;
import org.apache.storm.shade.io.netty.channel.unix.DomainSocketAddress;
import org.apache.storm.shade.io.netty.channel.unix.DomainSocketChannel;
import org.apache.storm.shade.io.netty.channel.unix.DomainSocketChannelConfig;
import org.apache.storm.shade.io.netty.channel.unix.DomainSocketReadMode;
import org.apache.storm.shade.io.netty.channel.unix.Errors;
import org.apache.storm.shade.io.netty.channel.unix.FileDescriptor;
import org.apache.storm.shade.io.netty.channel.unix.PeerCredentials;
import org.apache.storm.shade.io.netty.channel.uring.AbstractIoUringChannel;
import org.apache.storm.shade.io.netty.channel.uring.AbstractIoUringStreamChannel;
import org.apache.storm.shade.io.netty.channel.uring.IoUringDomainSocketChannelConfig;
import org.apache.storm.shade.io.netty.channel.uring.IoUringIoOps;
import org.apache.storm.shade.io.netty.channel.uring.IoUringRecvByteAllocatorHandle;
import org.apache.storm.shade.io.netty.channel.uring.LinuxSocket;
import org.apache.storm.shade.io.netty.channel.uring.MsgHdrMemory;
import org.apache.storm.shade.io.netty.channel.uring.Native;
import org.apache.storm.shade.io.netty.util.concurrent.GenericFutureListener;

public final class IoUringDomainSocketChannel
extends AbstractIoUringStreamChannel
implements DomainSocketChannel {
    private final IoUringDomainSocketChannelConfig config;
    private volatile DomainSocketAddress local;
    private volatile DomainSocketAddress remote;

    public IoUringDomainSocketChannel() {
        super(null, LinuxSocket.newSocketDomain(), false);
        this.config = new IoUringDomainSocketChannelConfig(this);
    }

    IoUringDomainSocketChannel(Channel parent, FileDescriptor fd) {
        this(parent, new LinuxSocket(fd.intValue()));
    }

    IoUringDomainSocketChannel(Channel parent, LinuxSocket fd) {
        super(parent, fd, true);
        this.local = fd.localDomainSocketAddress();
        this.remote = fd.remoteDomainSocketAddress();
        this.config = new IoUringDomainSocketChannelConfig(this);
    }

    @Override
    public DomainSocketChannelConfig config() {
        return this.config;
    }

    @Override
    public DomainSocketAddress localAddress() {
        return this.local;
    }

    @Override
    public DomainSocketAddress remoteAddress() {
        return this.remote;
    }

    public PeerCredentials peerCredentials() throws IOException {
        return this.socket.getPeerCredentials();
    }

    @Override
    protected Object filterOutboundMessage(Object msg) {
        if (msg instanceof FileDescriptor) {
            return msg;
        }
        return super.filterOutboundMessage(msg);
    }

    @Override
    protected AbstractIoUringChannel.AbstractUringUnsafe newUnsafe() {
        return new IoUringDomainSocketUnsafe();
    }

    @Override
    protected boolean allowMultiShotPollIn() {
        return false;
    }

    @Override
    boolean isPollInFirst() {
        DomainSocketReadMode readMode = this.config.getReadMode();
        switch (readMode) {
            case BYTES: {
                return super.isPollInFirst();
            }
            case FILE_DESCRIPTORS: {
                return false;
            }
        }
        throw new Error("Unexpected read mode: " + String.valueOf((Object)readMode));
    }

    private final class IoUringDomainSocketUnsafe
    extends AbstractIoUringStreamChannel.IoUringStreamUnsafe {
        private MsgHdrMemory writeMsgHdrMemory;
        private MsgHdrMemory readMsgHdrMemory;

        private IoUringDomainSocketUnsafe() {
            super(IoUringDomainSocketChannel.this);
        }

        @Override
        protected int scheduleWriteSingle(Object msg) {
            if (msg instanceof FileDescriptor) {
                if (this.writeMsgHdrMemory == null) {
                    this.writeMsgHdrMemory = new MsgHdrMemory();
                }
                IoRegistration registration = IoUringDomainSocketChannel.this.registration();
                IoUringIoOps ioUringIoOps = this.prepSendFdIoOps((FileDescriptor)msg, this.writeMsgHdrMemory);
                IoUringDomainSocketChannel.this.writeId = registration.submit(ioUringIoOps);
                IoUringDomainSocketChannel.this.writeOpCode = (byte)9;
                if (IoUringDomainSocketChannel.this.writeId == 0L) {
                    MsgHdrMemory memory = this.writeMsgHdrMemory;
                    this.writeMsgHdrMemory = null;
                    memory.release();
                    return 0;
                }
                return 1;
            }
            return super.scheduleWriteSingle(msg);
        }

        @Override
        boolean writeComplete0(byte op, int res, int flags, short data, int outstanding) {
            if (op == 9) {
                IoUringDomainSocketChannel.this.writeId = 0L;
                IoUringDomainSocketChannel.this.writeOpCode = 0;
                if (res == Native.ERRNO_ECANCELED_NEGATIVE) {
                    return true;
                }
                try {
                    int nativeCallResult;
                    int n = nativeCallResult = res >= 0 ? res : Errors.ioResult("io_uring sendmsg", res);
                    if (nativeCallResult >= 0) {
                        ChannelOutboundBuffer channelOutboundBuffer = IoUringDomainSocketChannel.this.unsafe().outboundBuffer();
                        channelOutboundBuffer.remove();
                    }
                }
                catch (Throwable throwable) {
                    this.handleWriteError(throwable);
                }
                return true;
            }
            return super.writeComplete0(op, res, flags, data, outstanding);
        }

        private IoUringIoOps prepSendFdIoOps(FileDescriptor fileDescriptor, MsgHdrMemory msgHdrMemory) {
            msgHdrMemory.setScmRightsFd(fileDescriptor.intValue());
            return IoUringIoOps.newSendmsg(IoUringDomainSocketChannel.this.fd().intValue(), (byte)0, 0, msgHdrMemory.address(), msgHdrMemory.idx());
        }

        @Override
        protected int scheduleRead0(boolean first, boolean socketIsEmpty) {
            DomainSocketReadMode readMode = IoUringDomainSocketChannel.this.config.getReadMode();
            switch (readMode) {
                case FILE_DESCRIPTORS: {
                    return this.scheduleRecvReadFd();
                }
                case BYTES: {
                    return super.scheduleRead0(first, socketIsEmpty);
                }
            }
            throw new Error("Unexpected read mode: " + String.valueOf((Object)readMode));
        }

        private int scheduleRecvReadFd() {
            if (this.readMsgHdrMemory == null) {
                this.readMsgHdrMemory = new MsgHdrMemory();
            }
            this.readMsgHdrMemory.prepRecvReadFd();
            IoRegistration registration = IoUringDomainSocketChannel.this.registration();
            IoUringIoOps ioUringIoOps = IoUringIoOps.newRecvmsg(IoUringDomainSocketChannel.this.fd().intValue(), (byte)0, 0, this.readMsgHdrMemory.address(), this.readMsgHdrMemory.idx());
            IoUringDomainSocketChannel.this.readId = registration.submit(ioUringIoOps);
            IoUringDomainSocketChannel.this.readOpCode = (byte)10;
            if (IoUringDomainSocketChannel.this.readId == 0L) {
                MsgHdrMemory memory = this.readMsgHdrMemory;
                this.readMsgHdrMemory = null;
                memory.release();
                return 0;
            }
            return 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void readComplete0(byte op, int res, int flags, short data, int outstanding) {
            if (op == 10) {
                IoUringDomainSocketChannel.this.readId = 0L;
                if (res == Native.ERRNO_ECANCELED_NEGATIVE) {
                    return;
                }
                IoUringRecvByteAllocatorHandle allocHandle = this.recvBufAllocHandle();
                ChannelPipeline pipeline = IoUringDomainSocketChannel.this.pipeline();
                try {
                    int nativeCallResult = res >= 0 ? res : Errors.ioResult("io_uring recvmsg", res);
                    int nativeFd = this.readMsgHdrMemory.getScmRightsFd();
                    allocHandle.lastBytesRead(nativeFd);
                    allocHandle.incMessagesRead(1);
                    pipeline.fireChannelRead(new FileDescriptor(nativeFd));
                }
                catch (Throwable throwable) {
                    this.handleReadException(pipeline, null, throwable, false, allocHandle);
                }
                finally {
                    allocHandle.readComplete();
                    pipeline.fireChannelReadComplete();
                }
                return;
            }
            super.readComplete0(op, res, flags, data, outstanding);
        }

        @Override
        public void connect(final SocketAddress remoteAddress, final SocketAddress localAddress, final ChannelPromise promise) {
            ChannelFuture channelPromise = IoUringDomainSocketChannel.this.newPromise().addListener((GenericFutureListener)new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        IoUringDomainSocketChannel.this.local = localAddress != null ? (DomainSocketAddress)localAddress : IoUringDomainSocketChannel.this.socket.localDomainSocketAddress();
                        IoUringDomainSocketChannel.this.remote = (DomainSocketAddress)remoteAddress;
                        promise.setSuccess();
                    } else {
                        promise.setFailure(future.cause());
                    }
                }
            });
            super.connect(remoteAddress, localAddress, (ChannelPromise)channelPromise);
        }

        @Override
        public void unregistered() {
            super.unregistered();
            if (this.readMsgHdrMemory != null) {
                this.readMsgHdrMemory.release();
                this.readMsgHdrMemory = null;
            }
            if (this.writeMsgHdrMemory != null) {
                this.writeMsgHdrMemory.release();
                this.writeMsgHdrMemory = null;
            }
        }
    }
}

