/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.tuple;

import java.util.HashMap;
import java.util.Map;
import org.apache.storm.shade.org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.storm.tuple.Fields;

public class ValuePointer {
    public int delegateIndex;
    protected int index;
    protected String field;

    public ValuePointer(int delegateIndex, int index, String field) {
        this.delegateIndex = delegateIndex;
        this.index = index;
        this.field = field;
    }

    public static Map<String, ValuePointer> buildFieldIndex(ValuePointer[] pointers) {
        HashMap<String, ValuePointer> ret = new HashMap<String, ValuePointer>();
        for (ValuePointer ptr : pointers) {
            ret.put(ptr.field, ptr);
        }
        return ret;
    }

    public static ValuePointer[] buildIndex(Fields fieldsOrder, Map<String, ValuePointer> pointers) {
        if (fieldsOrder.size() != pointers.size()) {
            throw new IllegalArgumentException("Fields order must be same length as pointers map");
        }
        ValuePointer[] ret = new ValuePointer[pointers.size()];
        for (int i = 0; i < fieldsOrder.size(); ++i) {
            ret[i] = pointers.get(fieldsOrder.get(i));
        }
        return ret;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

