/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.operation.builtin;

import org.apache.storm.trident.operation.BaseAggregator;
import org.apache.storm.trident.operation.TridentCollector;
import org.apache.storm.trident.tuple.TridentTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ComparisonAggregator<T>
extends BaseAggregator<State> {
    private static final Logger log = LoggerFactory.getLogger(ComparisonAggregator.class);
    private final String inputFieldName;
    private Object batchId;

    public ComparisonAggregator(String inputFieldName) {
        this.inputFieldName = inputFieldName;
    }

    protected abstract T compare(T var1, T var2);

    @Override
    public State init(Object batchId, TridentCollector collector) {
        this.batchId = batchId;
        log.debug("Started comparison aggregation for batch: [{}] in operation [{}]", batchId, (Object)this);
        return new State();
    }

    @Override
    public void aggregate(State state, TridentTuple tuple, TridentCollector collector) {
        T value1 = this.valueFromTuple(state.previousTuple);
        T value2 = this.valueFromTuple(tuple);
        log.debug("Aggregated tuple value in state [{}], and received tuple value [{}] in operation [{}]", new Object[]{value1, value2, this});
        if (value2 == null) {
            return;
        }
        if (value1 == null || this.compare(value1, value2) == value2) {
            state.previousTuple = tuple;
        }
    }

    protected T valueFromTuple(TridentTuple tuple) {
        Object value = null;
        value = this.inputFieldName != null && tuple != null ? tuple.getValueByField(this.inputFieldName) : tuple;
        log.debug("value from tuple is [{}] with input field [{}] and tuple [{}]", new Object[]{value, this.inputFieldName, tuple});
        return (T)value;
    }

    @Override
    public void complete(State state, TridentCollector collector) {
        log.debug("Completed comparison aggregation for batch [{}] with resultant tuple: [{}] in operation [{}]", new Object[]{this.batchId, state.previousTuple, this});
        collector.emit(state.previousTuple != null ? state.previousTuple.getValues() : null);
    }

    public static class State {
        TridentTuple previousTuple;
    }
}

