/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.provider;

import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.provider.AbstractProvider;
import org.apache.sis.referencing.operation.provider.Geographic3Dto2D;
import org.apache.sis.referencing.operation.transform.MathTransformProvider;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.util.FactoryException;

@XmlTransient
public final class Geographic2Dto3D
extends AbstractProvider {
    private static final long serialVersionUID = -1198461394243672064L;
    public static final String NAME = "Geographic2D to 3D conversion";
    private static final ParameterDescriptor<Double> HEIGHT;
    public static final double DEFAULT_HEIGHT = 0.0;
    public static final ParameterDescriptorGroup PARAMETERS;
    private static final Geographic2Dto3D INSTANCE;

    public static Geographic2Dto3D provider() {
        return INSTANCE;
    }

    public Geographic2Dto3D() {
        super(Conversion.class, PARAMETERS, CoordinateSystem.class, false, CoordinateSystem.class, false, (byte)2);
    }

    @Override
    public AbstractProvider inverse() {
        return Geographic3Dto2D.provider();
    }

    @Override
    public AbstractProvider variantFor(MathTransform transform) {
        return transform.getSourceDimensions() > transform.getTargetDimensions() ? Geographic3Dto2D.provider() : this;
    }

    @Override
    public MathTransform createMathTransform(MathTransformProvider.Context context) throws FactoryException {
        Parameters pg = Parameters.castOrWrap(context.getCompletedParameters());
        return Geographic3Dto2D.createMathTransform(context, context.getSourceDimensions().orElse(2), context.getTargetDimensions().orElse(3), pg.doubleValue(HEIGHT));
    }

    static {
        ParameterBuilder builder = (ParameterBuilder)Geographic2Dto3D.builder().setCodeSpace(Citations.SIS, "SIS");
        HEIGHT = ((ParameterBuilder)builder.addName("height")).create(0.0, Units.METRE);
        PARAMETERS = ((ParameterBuilder)builder.addName(NAME)).createGroup(new GeneralParameterDescriptor[]{HEIGHT});
        INSTANCE = new Geographic2Dto3D();
    }
}

