/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.measure.Unit;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.iso.citation.DefaultCitation;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.crs.DefaultGeographicCRS;
import org.apache.sis.referencing.crs.DefaultProjectedCRS;
import org.apache.sis.referencing.crs.DefaultVerticalCRS;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.cs.DefaultCartesianCS;
import org.apache.sis.referencing.cs.DefaultCoordinateSystemAxis;
import org.apache.sis.referencing.cs.DefaultEllipsoidalCS;
import org.apache.sis.referencing.cs.DefaultSphericalCS;
import org.apache.sis.referencing.cs.DefaultVerticalCS;
import org.apache.sis.referencing.datum.DefaultDatumEnsemble;
import org.apache.sis.referencing.datum.DefaultEllipsoid;
import org.apache.sis.referencing.datum.DefaultGeodeticDatum;
import org.apache.sis.referencing.datum.DefaultPrimeMeridian;
import org.apache.sis.referencing.datum.DefaultVerticalDatum;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.operation.DefaultConversion;
import org.apache.sis.referencing.operation.provider.PolarStereographicA;
import org.apache.sis.referencing.operation.provider.TransverseMercator;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.util.SimpleInternationalString;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.PresentationForm;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.RangeMeaning;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.InternationalString;
import org.opengis.util.NoSuchIdentifierException;

final class StandardDefinitions {
    private static final String VERSION = "9.9.1";
    static final String GREENWICH = "8901";
    private static final InternationalString NOTICE = Resources.formatInternational((short)42);
    static final Citation AUTHORITY;
    static final short ELLIPSOIDAL_2D = 6422;
    static final short ELLIPSOIDAL_3D = 6423;
    static final short SPHERICAL = 6404;
    static final short EARTH_CENTRED = 6500;
    static final short CARTESIAN_2D = 4400;
    static final short UPS_NORTH = 1026;
    static final short UPS_SOUTH = 1027;
    private static CartesianCS DEFAULT_CS;

    private StandardDefinitions() {
    }

    private static Map<String, Object> properties(int code, String name, String alias, boolean world) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        if (code != 0) {
            map.put("identifiers", new NamedIdentifier(AUTHORITY, "EPSG", (CharSequence)String.valueOf(code), VERSION, null));
        }
        map.put("name", new NamedIdentifier(AUTHORITY, null, (CharSequence)name, null, null));
        if (alias != null) {
            map.put("alias", alias);
        }
        if (world) {
            map.put("domainOfValidity", Extents.WORLD);
        }
        map.put("remarks", NOTICE);
        return map;
    }

    private static void addWMS(Map<String, Object> properties, String code) {
        properties.put("identifiers", new NamedIdentifier[]{(NamedIdentifier)properties.get("identifiers"), new NamedIdentifier((Citation)Citations.WMS, "OGC", (CharSequence)code, null, null)});
    }

    static ProjectedCRS createMercator(int code, GeographicCRS baseCRS, boolean pseudo) {
        return StandardDefinitions.createProjectedCRS(code, baseCRS, StandardDefinitions.defaultCartesianCS(), pseudo ? "Popular Visualisation Pseudo Mercator" : "Mercator (variant A)", parameters -> pseudo ? "Pseudo-Mercator" : "World Mercator");
    }

    static ProjectedCRS createUniversal(int code, GeographicCRS baseCRS, boolean isUTM, double latitude, double longitude, CartesianCS derivedCS) {
        return StandardDefinitions.createProjectedCRS(code, baseCRS, derivedCS, isUTM ? "Transverse Mercator" : "Polar Stereographic (variant A)", parameters -> isUTM ? TransverseMercator.Zoner.UTM.setParameters((ParameterValueGroup)parameters, latitude, longitude) : PolarStereographicA.setParameters(parameters, latitude >= 0.0));
    }

    private static ProjectedCRS createProjectedCRS(int code, GeographicCRS baseCRS, CartesianCS derivedCS, String methodName, Function<ParameterValueGroup, String> setup) {
        OperationMethod method;
        try {
            method = DefaultMathTransformFactory.provider().getOperationMethod(methodName);
        }
        catch (NoSuchIdentifierException e) {
            throw new IllegalStateException(e);
        }
        ParameterValueGroup parameters = method.getParameters().createValue();
        Object name = setup.apply(parameters);
        DefaultConversion conversion = new DefaultConversion(StandardDefinitions.properties(0, (String)name, null, false), method, null, parameters);
        name = baseCRS.getName().getCode() + " / " + (String)name;
        return new DefaultProjectedCRS(StandardDefinitions.properties(code, (String)name, null, false), baseCRS, (Conversion)conversion, derivedCS);
    }

    static GeographicCRS createGeographicCRS(short code, GeodeticDatum datum, DefaultDatumEnsemble<GeodeticDatum> ensemble, EllipsoidalCS cs) {
        String name;
        boolean world = false;
        switch (code) {
            case 4326: {
                name = "WGS 84";
                world = true;
                break;
            }
            case 4322: {
                name = "WGS 72";
                world = true;
                break;
            }
            case 4258: {
                name = "ETRS89";
                break;
            }
            case 4269: {
                name = "NAD83";
                break;
            }
            case 4267: {
                name = "NAD27";
                break;
            }
            case 4230: {
                name = "ED50";
                break;
            }
            case 4019: {
                name = "Unknown datum based upon the GRS 1980 ellipsoid";
                world = true;
                break;
            }
            case 4047: {
                name = "Unspecified datum based upon the GRS 1980 Authalic Sphere";
                world = true;
                break;
            }
            default: {
                throw new AssertionError(code);
            }
        }
        Map<String, Object> properties = StandardDefinitions.properties(code, name, null, world);
        return new DefaultGeographicCRS(properties, datum, ensemble, cs);
    }

    static GeodeticDatum createGeodeticDatum(short code, Ellipsoid ellipsoid, PrimeMeridian meridian) {
        String alias;
        String name;
        boolean world = false;
        switch (code) {
            case 6326: {
                name = "World Geodetic System 1984";
                alias = "WGS 84";
                world = true;
                break;
            }
            case 6322: {
                name = "World Geodetic System 1972";
                alias = "WGS 72";
                world = true;
                break;
            }
            case 6258: {
                name = "European Terrestrial Reference System 1989";
                alias = "ETRS89";
                break;
            }
            case 6269: {
                name = "North American Datum 1983";
                alias = "NAD83";
                break;
            }
            case 6267: {
                name = "North American Datum 1927";
                alias = "NAD27";
                break;
            }
            case 6230: {
                name = "European Datum 1950";
                alias = "ED50";
                break;
            }
            case 6019: {
                name = "Not specified (based on GRS 1980 ellipsoid)";
                alias = null;
                world = true;
                break;
            }
            case 6047: {
                name = "Not specified (based on GRS 1980 Authalic Sphere)";
                alias = null;
                world = true;
                break;
            }
            default: {
                throw new AssertionError(code);
            }
        }
        return new DefaultGeodeticDatum(StandardDefinitions.properties(code, name, alias, world), ellipsoid, meridian);
    }

    static Ellipsoid createEllipsoid(short code) {
        double other;
        double semiMajorAxis;
        String name;
        String alias = null;
        boolean ivfDefinitive = true;
        Unit unit = Units.METRE;
        switch (code) {
            case 7030: {
                name = "WGS 1984";
                semiMajorAxis = 6378137.0;
                other = 298.257223563;
                break;
            }
            case 7043: {
                name = "WGS 1972";
                semiMajorAxis = 6378135.0;
                other = 298.26;
                break;
            }
            case 7019: {
                name = "GRS 1980";
                semiMajorAxis = 6378137.0;
                other = 298.257222101;
                break;
            }
            case 7022: {
                name = "International 1924";
                semiMajorAxis = 6378388.0;
                other = 297.0;
                break;
            }
            case 7008: {
                name = "Clarke 1866";
                semiMajorAxis = 6378206.4;
                other = 6356583.8;
                ivfDefinitive = false;
                break;
            }
            case 7048: {
                name = "GRS 1980 Authalic Sphere";
                other = 6371007.0;
                semiMajorAxis = 6371007.0;
                ivfDefinitive = false;
                break;
            }
            default: {
                throw new AssertionError(code);
            }
        }
        Map<String, Object> map = StandardDefinitions.properties(code, name, alias, false);
        if (ivfDefinitive) {
            return DefaultEllipsoid.createFlattenedSphere(map, semiMajorAxis, other, (Unit<Length>)unit);
        }
        return DefaultEllipsoid.createEllipsoid(map, semiMajorAxis, other, (Unit<Length>)unit);
    }

    static PrimeMeridian primeMeridian() {
        HashMap<String, NamedIdentifier> properties = new HashMap<String, NamedIdentifier>(4);
        properties.put("name", new NamedIdentifier(AUTHORITY, "Greenwich"));
        properties.put("identifiers", new NamedIdentifier(AUTHORITY, "EPSG", (CharSequence)GREENWICH, VERSION, null));
        return new DefaultPrimeMeridian(properties, 0.0, (Unit<Angle>)Units.DEGREE);
    }

    static VerticalCRS createVerticalCRS(short code, VerticalDatum datum) {
        String alias;
        String name;
        String csName = "Vertical CS. Axis: height (H).";
        int csCode = 6499;
        short axis = 114;
        String wms = null;
        switch (code) {
            case 5703: {
                wms = "88";
                name = "NAVD88 height";
                alias = "North American Vertical Datum 1988 height";
                break;
            }
            case 5714: {
                name = "MSL height";
                alias = "Mean Sea Level height";
                break;
            }
            case 5715: {
                name = "MSL depth";
                alias = "Mean Sea Level depth";
                csName = "Vertical CS. Axis: depth (D).";
                csCode = 6498;
                axis = 113;
                break;
            }
            default: {
                throw new AssertionError(code);
            }
        }
        Map<String, Object> properties = StandardDefinitions.properties(csCode, csName, null, false);
        DefaultVerticalCS cs = new DefaultVerticalCS((Map<String, ?>)properties, StandardDefinitions.createAxis(axis, true));
        properties = StandardDefinitions.properties(code, name, alias, true);
        if (wms != null) {
            StandardDefinitions.addWMS(properties, wms);
        }
        return new DefaultVerticalCRS(properties, datum, null, cs);
    }

    static VerticalDatum createVerticalDatum(short code) {
        VerticalDatumType method;
        String alias;
        String name;
        switch (code) {
            case 5100: {
                name = "Mean Sea Level";
                alias = "MSL";
                method = VerticalDatumType.DEPTH;
                break;
            }
            case 5103: {
                name = "North American Vertical Datum 1988";
                alias = "NAVD88";
                method = VerticalDatumType.GEOIDAL;
                break;
            }
            default: {
                throw new AssertionError(code);
            }
        }
        return new DefaultVerticalDatum(StandardDefinitions.properties(code, name, alias, true), method);
    }

    static synchronized CartesianCS defaultCartesianCS() {
        if (DEFAULT_CS == null) {
            DEFAULT_CS = (CartesianCS)StandardDefinitions.createCoordinateSystem((short)4400, true);
        }
        return DEFAULT_CS;
    }

    static CoordinateSystem createCoordinateSystem(short code, boolean mandatory) {
        short axisCode;
        String name;
        int type = 0;
        int dim = 2;
        switch (code) {
            case 6422: {
                name = "Ellipsoidal 2D";
                type = 2;
                axisCode = 108;
                break;
            }
            case 6423: {
                name = "Ellipsoidal 3D";
                type = 2;
                dim = 3;
                axisCode = 111;
                break;
            }
            case 6404: {
                name = "Spherical";
                type = 1;
                dim = 3;
                axisCode = 63;
                break;
            }
            case 6500: {
                name = "Cartesian 3D (geocentric)";
                dim = 3;
                axisCode = 118;
                break;
            }
            case 4400: {
                name = "Cartesian 2D";
                axisCode = 3;
                break;
            }
            case 1026: {
                name = "Cartesian 2D for UPS north";
                axisCode = 1067;
                break;
            }
            case 1027: {
                name = "Cartesian 2D for UPS south";
                axisCode = 1059;
                break;
            }
            default: {
                if (!mandatory) {
                    return null;
                }
                throw new AssertionError(code);
            }
        }
        Map<String, Object> properties = StandardDefinitions.properties(code, name, null, false);
        CoordinateSystemAxis xAxis = null;
        CoordinateSystemAxis yAxis = null;
        CoordinateSystemAxis zAxis = null;
        switch (dim) {
            default: {
                throw new AssertionError(dim);
            }
            case 3: {
                axisCode = (short)(axisCode - 1);
                zAxis = StandardDefinitions.createAxis(axisCode, true);
            }
            case 2: {
                axisCode = (short)(axisCode - 1);
                yAxis = StandardDefinitions.createAxis(axisCode, true);
            }
            case 1: {
                axisCode = (short)(axisCode - 1);
                xAxis = StandardDefinitions.createAxis(axisCode, true);
            }
            case 0: 
        }
        switch (type) {
            default: {
                throw new AssertionError(type);
            }
            case 0: {
                return zAxis != null ? new DefaultCartesianCS((Map<String, ?>)properties, xAxis, yAxis, zAxis) : new DefaultCartesianCS((Map<String, ?>)properties, xAxis, yAxis);
            }
            case 1: {
                return new DefaultSphericalCS((Map<String, ?>)properties, xAxis, yAxis, zAxis);
            }
            case 2: 
        }
        return zAxis != null ? new DefaultEllipsoidalCS((Map<String, ?>)properties, xAxis, yAxis, zAxis) : new DefaultEllipsoidalCS((Map<String, ?>)properties, xAxis, yAxis);
    }

    static CoordinateSystemAxis createAxis(short code, boolean mandatory) {
        AxisDirection dir;
        String abrv;
        String name;
        Unit unit = Units.METRE;
        double min = Double.NEGATIVE_INFINITY;
        double max = Double.POSITIVE_INFINITY;
        RangeMeaning rm = null;
        switch (code) {
            case 1: {
                name = "Easting";
                abrv = "E";
                dir = AxisDirection.EAST;
                break;
            }
            case 2: {
                name = "Northing";
                abrv = "N";
                dir = AxisDirection.NORTH;
                break;
            }
            case 60: {
                name = "Spherical latitude";
                abrv = "\u03a9";
                unit = Units.DEGREE;
                dir = AxisDirection.NORTH;
                min = -90.0;
                max = 90.0;
                rm = RangeMeaning.EXACT;
                break;
            }
            case 61: {
                name = "Spherical longitude";
                abrv = "\u03b8";
                unit = Units.DEGREE;
                dir = AxisDirection.EAST;
                min = -180.0;
                max = 180.0;
                rm = RangeMeaning.WRAPAROUND;
                break;
            }
            case 62: {
                name = "Geocentric radius";
                abrv = "r";
                dir = AxisDirection.UP;
                rm = RangeMeaning.EXACT;
                min = 0.0;
                break;
            }
            case 106: 
            case 108: {
                name = "Geodetic latitude";
                abrv = "\u03c6";
                unit = Units.DEGREE;
                dir = AxisDirection.NORTH;
                min = -90.0;
                max = 90.0;
                rm = RangeMeaning.EXACT;
                break;
            }
            case 107: 
            case 109: {
                name = "Geodetic longitude";
                abrv = "\u03bb";
                unit = Units.DEGREE;
                dir = AxisDirection.EAST;
                min = -180.0;
                max = 180.0;
                rm = RangeMeaning.WRAPAROUND;
                break;
            }
            case 110: {
                name = "Ellipsoidal height";
                abrv = "h";
                dir = AxisDirection.UP;
                break;
            }
            case 114: {
                name = "Gravity-related height";
                abrv = "H";
                dir = AxisDirection.UP;
                break;
            }
            case 113: {
                name = "Depth";
                abrv = "D";
                dir = AxisDirection.DOWN;
                break;
            }
            case 115: {
                name = "Geocentric X";
                abrv = "X";
                dir = AxisDirection.GEOCENTRIC_X;
                break;
            }
            case 116: {
                name = "Geocentric Y";
                abrv = "Y";
                dir = AxisDirection.GEOCENTRIC_Y;
                break;
            }
            case 117: {
                name = "Geocentric Z";
                abrv = "Z";
                dir = AxisDirection.GEOCENTRIC_Z;
                break;
            }
            case 1056: 
            case 1057: {
                name = "Easting";
                abrv = "E";
                dir = CoordinateSystems.directionAlongMeridian(AxisDirection.NORTH, 90.0);
                break;
            }
            case 1058: {
                name = "Northing";
                abrv = "N";
                dir = CoordinateSystems.directionAlongMeridian(AxisDirection.NORTH, 0.0);
                break;
            }
            case 1065: {
                name = "Easting";
                abrv = "E";
                dir = CoordinateSystems.directionAlongMeridian(AxisDirection.SOUTH, 90.0);
                break;
            }
            case 1066: {
                name = "Northing";
                abrv = "N";
                dir = CoordinateSystems.directionAlongMeridian(AxisDirection.SOUTH, 180.0);
                break;
            }
            default: {
                if (!mandatory) {
                    return null;
                }
                throw new AssertionError(code);
            }
        }
        Map<String, Object> properties = StandardDefinitions.properties(code, name, null, false);
        properties.put("minimumValue", min);
        properties.put("maximumValue", max);
        properties.put("rangeMeaning", rm);
        return new DefaultCoordinateSystemAxis(properties, abrv, dir, unit);
    }

    static {
        DefaultCitation c = new DefaultCitation();
        c.setTitle(Vocabulary.formatInternational((short)188, (Object)"EPSG"));
        c.setEdition((InternationalString)new SimpleInternationalString(VERSION));
        c.getPresentationForms().add(PresentationForm.DOCUMENT_DIGITAL);
        c.setOtherCitationDetails(NOTICE);
        c.transitionTo(ModifiableMetadata.State.FINAL);
        AUTHORITY = c;
    }
}

