/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.stream;

import java.io.DataOutput;
import java.io.Flushable;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.Channel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.sis.io.stream.ChannelData;
import org.apache.sis.io.stream.ChannelDataInput;
import org.apache.sis.storage.internal.Resources;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.internal.shared.Numerics;

public class ChannelDataOutput
extends ChannelData
implements DataOutput,
Flushable {
    public final WritableByteChannel channel;

    public ChannelDataOutput(String filename, WritableByteChannel channel, ByteBuffer buffer) throws IOException {
        super(filename, channel, buffer);
        this.channel = channel;
        buffer.limit(0);
    }

    public ChannelDataOutput(ChannelDataInput input) {
        super(input, input.buffer, false);
        this.channel = (WritableByteChannel)((Object)input.channel);
    }

    @Override
    public final Channel channel() {
        return this.channel;
    }

    public final void ensureBufferAccepts(int n) throws IOException {
        assert (n >= 0 && n <= this.buffer.capacity()) : n;
        int after = this.buffer.position() + n;
        if (after > this.buffer.limit()) {
            if (after > this.buffer.capacity()) {
                int c;
                this.buffer.flip();
                do {
                    if ((c = this.channel.write(this.buffer)) != 0) continue;
                    this.onEmptyTransfer();
                } while ((after -= c) > this.buffer.capacity());
                this.moveBufferForward(this.buffer.position());
                this.buffer.compact();
                assert (after >= this.buffer.position()) : after;
            }
            this.buffer.limit(after);
        }
    }

    @Override
    public final long getStreamPosition() {
        long position = this.position();
        if (this.getBitOffset() != 0) {
            --position;
        }
        return position;
    }

    @Override
    public final void skipRemainingBits() {
        this.bitPosition = 0L;
    }

    public final void writeBit(int bit) throws IOException {
        this.writeBits(bit, 1);
    }

    public final void writeBits(long bits, int numBits) throws IOException {
        ArgumentChecks.ensureBetween((String)"numBits", (int)0, (int)64, (int)numBits);
        if (numBits != 0) {
            int bitOffset = this.getBitOffset();
            if (bitOffset != 0) {
                long mask;
                bits &= Numerics.bitmask((int)numBits) - 1L;
                int r = numBits - (8 - bitOffset);
                if (r >= 0) {
                    mask = bits >>> r;
                    bitOffset = 0;
                } else {
                    mask = bits << -r;
                    bitOffset += numBits;
                }
                numBits = r;
                assert ((mask & 0xFFFFFFFFFFFFFF00L) == 0L) : mask;
                int p = this.buffer.position() - 1;
                this.buffer.put(p, (byte)((long)this.buffer.get(p) | mask));
            }
            while (numBits > 0) {
                long part;
                if ((numBits -= 8) >= 0) {
                    part = bits >>> numBits;
                } else {
                    part = bits << -numBits;
                    bitOffset = 8 + numBits;
                }
                this.writeByte((int)part);
            }
            this.setBitOffset(bitOffset);
        }
    }

    @Override
    public final void writeBoolean(boolean v) throws IOException {
        this.writeByte(v ? 1 : 0);
    }

    @Override
    @Deprecated
    public final void write(int v) throws IOException {
        this.writeByte(v);
    }

    @Override
    public final void writeByte(int value) throws IOException {
        this.ensureBufferAccepts(1);
        this.buffer.put((byte)value);
    }

    @Override
    public final void writeShort(int value) throws IOException {
        this.ensureBufferAccepts(2);
        this.buffer.putShort((short)value);
    }

    @Override
    public final void writeChar(int value) throws IOException {
        this.ensureBufferAccepts(2);
        this.buffer.putChar((char)value);
    }

    @Override
    public final void writeInt(int value) throws IOException {
        this.ensureBufferAccepts(4);
        this.buffer.putInt(value);
    }

    @Override
    public final void writeLong(long value) throws IOException {
        this.ensureBufferAccepts(8);
        this.buffer.putLong(value);
    }

    @Override
    public final void writeFloat(float value) throws IOException {
        this.ensureBufferAccepts(4);
        this.buffer.putFloat(value);
    }

    @Override
    public final void writeDouble(double value) throws IOException {
        this.ensureBufferAccepts(8);
        this.buffer.putDouble(value);
    }

    @Override
    public final void write(byte[] src) throws IOException {
        this.write(src, 0, src.length);
    }

    public final void writeShorts(short[] src) throws IOException {
        this.writeShorts(src, 0, src.length);
    }

    public final void writeChars(char[] src) throws IOException {
        this.writeChars(src, 0, src.length);
    }

    public final void writeInts(int[] src) throws IOException {
        this.writeInts(src, 0, src.length);
    }

    public final void writeLongs(long[] src) throws IOException {
        this.writeLongs(src, 0, src.length);
    }

    public final void writeFloats(float[] src) throws IOException {
        this.writeFloats(src, 0, src.length);
    }

    public final void writeDoubles(double[] src) throws IOException {
        this.writeDoubles(src, 0, src.length);
    }

    @Override
    public final void write(byte[] src, int offset, int length) throws IOException {
        this.skipRemainingBits();
        if (length != 0) {
            int n;
            do {
                n = Math.min(this.buffer.capacity(), length);
                this.ensureBufferAccepts(n);
                this.buffer.put(src, offset, n);
                offset += n;
            } while ((length -= n) != 0);
        }
    }

    public final void writeChars(final char[] src, int offset, int length) throws IOException {
        new ArrayWriter(this){
            private CharBuffer view;
            final /* synthetic */ ChannelDataOutput this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            Buffer createView() {
                this.view = this.this$0.buffer.asCharBuffer();
                return this.view;
            }

            @Override
            void transfer(int start, int n) {
                this.view.put(src, start, n);
            }
        }.writeFully(2, offset, length);
    }

    public final void writeShorts(final short[] src, int offset, int length) throws IOException {
        new ArrayWriter(this){
            private ShortBuffer view;
            final /* synthetic */ ChannelDataOutput this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            Buffer createView() {
                this.view = this.this$0.buffer.asShortBuffer();
                return this.view;
            }

            @Override
            void transfer(int start, int n) {
                this.view.put(src, start, n);
            }
        }.writeFully(2, offset, length);
    }

    public final void writeInts(final int[] src, int offset, int length) throws IOException {
        new ArrayWriter(this){
            private IntBuffer view;
            final /* synthetic */ ChannelDataOutput this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            Buffer createView() {
                this.view = this.this$0.buffer.asIntBuffer();
                return this.view;
            }

            @Override
            void transfer(int start, int n) {
                this.view.put(src, start, n);
            }
        }.writeFully(4, offset, length);
    }

    public final void writeLongs(final long[] src, int offset, int length) throws IOException {
        new ArrayWriter(this){
            private LongBuffer view;
            final /* synthetic */ ChannelDataOutput this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            Buffer createView() {
                this.view = this.this$0.buffer.asLongBuffer();
                return this.view;
            }

            @Override
            void transfer(int start, int n) {
                this.view.put(src, start, n);
            }
        }.writeFully(8, offset, length);
    }

    public final void writeFloats(final float[] src, int offset, int length) throws IOException {
        new ArrayWriter(this){
            private FloatBuffer view;
            final /* synthetic */ ChannelDataOutput this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            Buffer createView() {
                this.view = this.this$0.buffer.asFloatBuffer();
                return this.view;
            }

            @Override
            void transfer(int start, int n) {
                this.view.put(src, start, n);
            }
        }.writeFully(4, offset, length);
    }

    public final void writeDoubles(final double[] src, int offset, int length) throws IOException {
        new ArrayWriter(this){
            private DoubleBuffer view;
            final /* synthetic */ ChannelDataOutput this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            Buffer createView() {
                this.view = this.this$0.buffer.asDoubleBuffer();
                return this.view;
            }

            @Override
            void transfer(int start, int n) {
                this.view.put(src, start, n);
            }
        }.writeFully(8, offset, length);
    }

    @Override
    public void writeBytes(String ascii) throws IOException {
        byte[] data = new byte[ascii.length()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)ascii.charAt(i);
        }
        this.write(data);
    }

    @Override
    public final void writeChars(String text) throws IOException {
        this.writeChars(text.toCharArray());
    }

    @Override
    public void writeUTF(String s) throws IOException {
        byte[] data = s.getBytes(StandardCharsets.UTF_8);
        int length = data.length;
        if (length > Short.MAX_VALUE) {
            throw new IllegalArgumentException(Resources.format((short)6, this.filename, (short)Short.MAX_VALUE, length));
        }
        this.ensureBufferAccepts(2);
        this.buffer.put((byte)(length >>> 8));
        this.buffer.put((byte)length);
        this.write(data);
    }

    public final void repeat(long count, byte value) throws IOException {
        this.skipRemainingBits();
        if (count > 0L) {
            long n = Math.min(count, (long)this.buffer.capacity());
            this.ensureBufferAccepts((int)n);
            if (this.buffer.hasArray()) {
                int offset = this.buffer.arrayOffset();
                int lower = this.buffer.position();
                int upper = lower + (int)n;
                Arrays.fill(this.buffer.array(), offset + lower, offset + upper, value);
                this.buffer.position(upper);
            } else {
                int i = (int)n;
                while (--i >= 0) {
                    this.buffer.put(value);
                }
            }
            if ((count -= n) > 0L) {
                int c;
                assert (this.buffer.position() == this.buffer.capacity());
                do {
                    c = this.channel.write(this.buffer.rewind());
                    this.moveBufferForward(c);
                    if (c == 0) {
                        this.onEmptyTransfer();
                    }
                    c = this.buffer.remaining();
                } while ((count -= (n = Math.min(count, (long)(this.buffer.capacity() - c)))) > 0L);
                this.buffer.limit(c + (int)n);
            }
        }
    }

    public final void truncate(long size) throws IOException {
        long p;
        if (this.channel instanceof SeekableByteChannel) {
            ((SeekableByteChannel)this.channel).truncate(this.toSeekableByteChannelPosition(size));
            if (size <= this.bufferOffset) {
                this.bufferOffset = size;
                this.bitPosition = 0L;
                this.buffer.limit(0);
                return;
            }
        }
        if ((p = Math.subtractExact(size, this.bufferOffset)) < 0L || p > (long)this.buffer.limit()) {
            throw new IOException(Resources.format((short)13, this.filename));
        }
        this.buffer.limit((int)p);
        this.bitPosition = 0L;
    }

    @Override
    public final void seek(long position) throws IOException {
        long p = Math.subtractExact(position, this.bufferOffset);
        if (p >= 0L && p <= (long)this.buffer.limit()) {
            this.buffer.position((int)p);
            this.bitPosition = 0L;
        } else if (this.channel instanceof SeekableByteChannel) {
            this.flush();
            ((SeekableByteChannel)this.channel).position(this.toSeekableByteChannelPosition(position));
            this.bufferOffset = position;
        } else if ((p -= (long)this.buffer.position()) >= 0L) {
            this.repeat(p, (byte)0);
        } else {
            throw new IOException(Resources.format((short)13, this.filename));
        }
        assert (this.position() == position) : position;
    }

    @Override
    public final void flush() throws IOException {
        this.skipRemainingBits();
        this.writeFully();
        this.bufferOffset = this.position();
        this.buffer.limit(0);
    }

    @Override
    final void flushNBytes(int count) throws IOException {
        int position = this.buffer.position();
        int validity = this.buffer.limit();
        this.buffer.limit(count);
        this.writeFully();
        this.bufferOffset = this.position();
        this.buffer.limit(validity).compact().limit(this.buffer.position()).position(position - count);
    }

    private void writeFully() throws IOException {
        this.buffer.rewind();
        while (this.buffer.hasRemaining()) {
            if (this.channel.write(this.buffer) != 0) continue;
            this.onEmptyTransfer();
        }
    }

    public final void yield(ChannelDataInput takeOver) throws IOException {
        int position = this.buffer.position();
        this.writeFully();
        if (this.getBitOffset() != 0) {
            --position;
            this.bitPosition -= 8L;
        }
        this.buffer.position(position);
        this.copyTo(takeOver);
        assert (takeOver.buffer == this.buffer);
    }

    public final void clear() {
        this.buffer.clear().limit(0);
        this.bufferOffset = 0L;
        this.bitPosition = 0L;
    }

    private abstract class ArrayWriter {
        ArrayWriter() {
        }

        abstract Buffer createView();

        abstract void transfer(int var1, int var2);

        private void skipInBuffer(int nByte) {
            ChannelDataOutput.this.buffer.position(ChannelDataOutput.this.buffer.position() + nByte);
        }

        final void writeFully(int dataSize, int offset, int length) throws IOException {
            ChannelDataOutput.this.skipRemainingBits();
            ChannelDataOutput.this.ensureBufferAccepts(Math.min(length * dataSize, ChannelDataOutput.this.buffer.capacity()));
            Buffer view = this.createView();
            int n = Math.min(view.remaining(), length);
            this.transfer(offset, n);
            this.skipInBuffer(n * dataSize);
            while ((length -= n) != 0) {
                ChannelDataOutput.this.ensureBufferAccepts(Math.min(length, view.capacity()) * dataSize);
                view.rewind().limit(ChannelDataOutput.this.buffer.remaining() / dataSize);
                n = view.remaining();
                this.transfer(offset += n, n);
                this.skipInBuffer(n * dataSize);
            }
        }
    }
}

