/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.temporal;

import java.time.DateTimeException;
import java.time.temporal.TemporalAmount;
import java.util.Map;
import org.apache.sis.pending.geoapi.temporal.Instant;
import org.apache.sis.pending.geoapi.temporal.Period;
import org.apache.sis.pending.geoapi.temporal.TemporalOperatorName;
import org.apache.sis.temporal.DefaultInstant;
import org.apache.sis.temporal.GeneralDuration;
import org.apache.sis.temporal.TemporalObject;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.temporal.TemporalPrimitive;

final class DefaultPeriod
extends TemporalObject
implements Period {
    private static final long serialVersionUID = 3870895998810224339L;
    private final Instant beginning;
    private final Instant ending;
    private static final Map<TemporalOperatorName, Map<TemporalOperatorName, TemporalOperatorName>> POSITIONS = Map.of(TemporalOperatorName.BEFORE, Map.of(TemporalOperatorName.BEFORE, TemporalOperatorName.BEFORE, TemporalOperatorName.BEGINS, TemporalOperatorName.MEETS, TemporalOperatorName.DURING, TemporalOperatorName.OVERLAPS, TemporalOperatorName.ENDS, TemporalOperatorName.ENDED_BY, TemporalOperatorName.AFTER, TemporalOperatorName.CONTAINS), TemporalOperatorName.BEGINS, Map.of(TemporalOperatorName.BEGINS, TemporalOperatorName.MEETS, TemporalOperatorName.DURING, TemporalOperatorName.BEGINS, TemporalOperatorName.ENDS, TemporalOperatorName.EQUALS, TemporalOperatorName.AFTER, TemporalOperatorName.BEGUN_BY), TemporalOperatorName.DURING, Map.of(TemporalOperatorName.DURING, TemporalOperatorName.DURING, TemporalOperatorName.ENDS, TemporalOperatorName.ENDS, TemporalOperatorName.AFTER, TemporalOperatorName.OVERLAPPED_BY), TemporalOperatorName.ENDS, Map.of(TemporalOperatorName.ENDS, TemporalOperatorName.MET_BY, TemporalOperatorName.AFTER, TemporalOperatorName.MET_BY), TemporalOperatorName.AFTER, Map.of(TemporalOperatorName.AFTER, TemporalOperatorName.AFTER));

    DefaultPeriod(Instant beginning, Instant ending) {
        this.beginning = beginning;
        this.ending = ending;
    }

    @Override
    public Instant getBeginning() {
        return this.beginning;
    }

    @Override
    public Instant getEnding() {
        return this.ending;
    }

    @Override
    public TemporalAmount length() {
        return GeneralDuration.distance(this.beginning, this.ending, false, false);
    }

    @Override
    public TemporalOperatorName findRelativePosition(TemporalPrimitive other) {
        ArgumentChecks.ensureNonNull((String)"other", (Object)other);
        if (other instanceof Instant) {
            return DefaultInstant.castOrCopy((Instant)other).relativeToPeriod(this).reversed().orElseThrow();
        }
        if (other instanceof Period) {
            String erroneous;
            Period period = (Period)other;
            TemporalOperatorName relation = DefaultInstant.castOrCopy(this.beginning).relativeToPeriod(period);
            Map<TemporalOperatorName, TemporalOperatorName> map = POSITIONS.get((Object)relation);
            if (map != null) {
                relation = DefaultInstant.castOrCopy(this.ending).relativeToPeriod(period);
                TemporalOperatorName result = map.get((Object)relation);
                if (result != null) {
                    return result;
                }
                erroneous = "ending";
            } else {
                erroneous = "beginning";
            }
            throw new DateTimeException(Errors.format((short)70, (Object)erroneous, (Object)((Object)relation)));
        }
        throw new DateTimeException(Errors.format((short)200, (Object)other.getClass()));
    }

    public String toString() {
        return String.valueOf(this.beginning) + "/" + String.valueOf(this.ending);
    }

    public int hashCode() {
        return this.beginning.hashCode() + 37 * this.ending.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DefaultPeriod) {
            DefaultPeriod other = (DefaultPeriod)obj;
            return this.beginning.equals(other.beginning) && this.ending.equals(other.ending) && this.equalIdentifiers(other);
        }
        return false;
    }

    public boolean equals(Object object, ComparisonMode mode) {
        if (mode.equals((Object)ComparisonMode.STRICT)) {
            return this.equals(object);
        }
        if (object instanceof Period) {
            Period other = (Period)object;
            return Utilities.deepEquals((Object)this.beginning, (Object)other.getBeginning(), (ComparisonMode)mode) && Utilities.deepEquals((Object)this.ending, (Object)other.getEnding(), (ComparisonMode)mode);
        }
        return false;
    }
}

