/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Collection;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.TitleProperty;
import org.apache.sis.metadata.internal.Dependencies;
import org.apache.sis.metadata.internal.shared.ImplementationHelper;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.legacy.LegacyPropertyAdapter;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.iso.Types;
import org.apache.sis.xml.NilReason;
import org.apache.sis.xml.bind.Context;
import org.apache.sis.xml.bind.FilterByVersion;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.Datatype;
import org.opengis.metadata.ExtendedElementInformation;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.util.InternationalString;

@TitleProperty(name="name")
@XmlType(name="MD_ExtendedElementInformation_Type", namespace="http://standards.iso.org/iso/19115/-3/mex/1.0", propOrder={"name", "shortName", "domainCode", "definition", "obligation", "condition", "dataType", "maxOccurs", "domainValue", "parentEntity", "rule", "rationale", "sources"})
@XmlRootElement(name="MD_ExtendedElementInformation", namespace="http://standards.iso.org/iso/19115/-3/mex/1.0")
public class DefaultExtendedElementInformation
extends ISOMetadata
implements ExtendedElementInformation {
    private static final long serialVersionUID = 5892811836634834434L;
    private String name;
    @Deprecated(since="1.0")
    private String shortName;
    @Deprecated(since="1.0")
    private Integer domainCode;
    private InternationalString definition;
    private org.opengis.metadata.Obligation obligation;
    private InternationalString condition;
    private Datatype dataType;
    private Integer maximumOccurrence;
    private InternationalString domainValue;
    private Collection<String> parentEntity;
    private InternationalString rule;
    private Collection<InternationalString> rationales;
    private Collection<ResponsibleParty> sources;

    public DefaultExtendedElementInformation() {
    }

    public DefaultExtendedElementInformation(String name, CharSequence definition, CharSequence condition, Datatype dataType, String parentEntity, CharSequence rule, ResponsibleParty source) {
        this.name = name;
        this.definition = Types.toInternationalString(definition);
        this.condition = Types.toInternationalString(condition);
        this.dataType = dataType;
        this.parentEntity = DefaultExtendedElementInformation.singleton(parentEntity, String.class);
        this.rule = Types.toInternationalString(rule);
        this.sources = DefaultExtendedElementInformation.singleton(source, ResponsibleParty.class);
    }

    public DefaultExtendedElementInformation(ExtendedElementInformation object) {
        super(object);
        if (object != null) {
            this.name = object.getName();
            this.shortName = object.getShortName();
            this.domainCode = object.getDomainCode();
            this.definition = object.getDefinition();
            this.obligation = object.getObligation();
            this.condition = object.getCondition();
            this.dataType = object.getDataType();
            this.maximumOccurrence = object.getMaximumOccurrence();
            this.domainValue = object.getDomainValue();
            this.parentEntity = DefaultExtendedElementInformation.copyCollection(object.getParentEntity(), String.class);
            this.rule = object.getRule();
            this.rationales = DefaultExtendedElementInformation.copyCollection(object.getRationales(), InternationalString.class);
            this.sources = DefaultExtendedElementInformation.copyCollection(object.getSources(), ResponsibleParty.class);
        }
    }

    public static DefaultExtendedElementInformation castOrCopy(ExtendedElementInformation object) {
        if (object == null || object instanceof DefaultExtendedElementInformation) {
            return (DefaultExtendedElementInformation)object;
        }
        return new DefaultExtendedElementInformation(object);
    }

    @XmlElement(name="name", required=true)
    public String getName() {
        return this.name;
    }

    public void setName(String newValue) {
        this.checkWritePermission(this.name);
        this.name = newValue;
    }

    @Deprecated(since="1.0")
    @XmlElement(name="shortName", namespace="http://www.isotc211.org/2005/gmd")
    public String getShortName() {
        return FilterByVersion.LEGACY_METADATA.accept() ? this.shortName : null;
    }

    @Deprecated(since="1.0")
    public void setShortName(String newValue) {
        this.checkWritePermission(this.shortName);
        this.shortName = newValue;
    }

    @Deprecated(since="1.0")
    @XmlElement(name="domainCode", namespace="http://www.isotc211.org/2005/gmd")
    public Integer getDomainCode() {
        return FilterByVersion.LEGACY_METADATA.accept() ? this.domainCode : null;
    }

    @Deprecated(since="1.0")
    public void setDomainCode(Integer newValue) {
        this.checkWritePermission(this.domainCode);
        this.domainCode = newValue;
    }

    @XmlElement(name="definition", required=true)
    public InternationalString getDefinition() {
        return this.definition;
    }

    public void setDefinition(InternationalString newValue) {
        this.checkWritePermission(this.definition);
        this.definition = newValue;
    }

    @XmlElement(name="obligation")
    public org.opengis.metadata.Obligation getObligation() {
        return this.obligation;
    }

    public void setObligation(org.opengis.metadata.Obligation newValue) {
        this.checkWritePermission(this.obligation);
        this.obligation = newValue;
    }

    @XmlElement(name="condition")
    public InternationalString getCondition() {
        return this.condition;
    }

    public void setCondition(InternationalString newValue) {
        this.checkWritePermission(this.condition);
        this.condition = newValue;
    }

    @XmlElement(name="dataType", required=true)
    public Datatype getDataType() {
        return this.dataType;
    }

    public void setDataType(Datatype newValue) {
        this.checkWritePermission(this.dataType);
        this.dataType = newValue;
    }

    @ValueRange(minimum=0.0)
    public Integer getMaximumOccurrence() {
        return this.maximumOccurrence;
    }

    public void setMaximumOccurrence(Integer newValue) {
        this.checkWritePermission(this.maximumOccurrence);
        if (ImplementationHelper.ensurePositive(DefaultExtendedElementInformation.class, "maximumOccurrence", false, newValue)) {
            this.maximumOccurrence = newValue;
        }
    }

    @XmlElement(name="domainValue")
    public InternationalString getDomainValue() {
        return this.domainValue;
    }

    public void setDomainValue(InternationalString newValue) {
        this.checkWritePermission(this.domainValue);
        this.domainValue = newValue;
    }

    @XmlElement(name="parentEntity", required=true)
    public Collection<String> getParentEntity() {
        this.parentEntity = this.nonNullCollection(this.parentEntity, String.class);
        return this.parentEntity;
    }

    public void setParentEntity(Collection<? extends String> newValues) {
        this.parentEntity = this.writeCollection(newValues, this.parentEntity, String.class);
    }

    @XmlElement(name="rule", required=true)
    public InternationalString getRule() {
        return this.rule;
    }

    public void setRule(InternationalString newValue) {
        this.checkWritePermission(this.rule);
        this.rule = newValue;
    }

    @XmlElement(name="rationale")
    @UML(identifier="rationale", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public InternationalString getRationale() {
        return LegacyPropertyAdapter.getSingleton(this.rationales, InternationalString.class, null, DefaultExtendedElementInformation.class, "getRationale");
    }

    public void setRationale(InternationalString newValue) {
        this.rationales = this.writeCollection(Containers.singletonOrEmpty((Object)newValue), this.rationales, InternationalString.class);
    }

    @Deprecated(since="1.0")
    @Dependencies(value={"getRationale"})
    public Collection<InternationalString> getRationales() {
        this.rationales = this.nonNullCollection(this.rationales, InternationalString.class);
        return this.rationales;
    }

    @Deprecated(since="1.0")
    public void setRationales(Collection<? extends InternationalString> newValues) {
        this.rationales = this.writeCollection(newValues, this.rationales, InternationalString.class);
    }

    @XmlElement(name="source", required=true)
    public Collection<ResponsibleParty> getSources() {
        this.sources = this.nonNullCollection(this.sources, ResponsibleParty.class);
        return this.sources;
    }

    public void setSources(Collection<? extends ResponsibleParty> newValues) {
        this.sources = this.writeCollection(newValues, this.sources, ResponsibleParty.class);
    }

    @XmlElement(name="maximumOccurrence")
    private String getMaxOccurs() {
        Integer value = this.getMaximumOccurrence();
        if (value == null) {
            return null;
        }
        NilReason nil = NilReason.forObject(value);
        if (nil != null) {
            return nil.createNilObject(String.class);
        }
        return value.toString();
    }

    private void setMaxOccurs(String value) {
        if (value != null) {
            Integer n;
            NilReason nil = NilReason.forObject(value);
            if (nil != null) {
                n = nil.createNilObject(Integer.class);
            } else {
                try {
                    n = Integer.valueOf(value);
                }
                catch (NumberFormatException e) {
                    Context.warningOccured(Context.current(), DefaultExtendedElementInformation.class, "setMaximumOccurrence", e, true);
                    return;
                }
            }
            this.setMaximumOccurrence(n);
        }
    }
}

