/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import org.apache.sis.metadata.AbstractMetadata;
import org.apache.sis.metadata.MetadataStandard;
import org.apache.sis.metadata.MetadataVisitor;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.PropertyAccessor;
import org.apache.sis.metadata.internal.Resources;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.collection.CodeListSet;
import org.apache.sis.util.resources.Errors;

public class MetadataCopier
extends MetadataVisitor<Object> {
    private final MetadataStandard standard;
    private Object target;

    public MetadataCopier(MetadataStandard standard) {
        this.standard = standard;
    }

    private MetadataStandard getStandard(Object metadata) {
        MetadataStandard std;
        if (metadata instanceof AbstractMetadata && (std = ((AbstractMetadata)metadata).getStandard()) != null) {
            return std;
        }
        return this.standard;
    }

    public static MetadataCopier forModifiable(MetadataStandard standard) {
        return new MetadataCopier(standard){

            @Override
            protected Object copyRecursively(Class<?> type, Object metadata) {
                ModifiableMetadata.State state;
                if (metadata instanceof ModifiableMetadata && (state = ((ModifiableMetadata)metadata).state()) != null && state.isUnmodifiable()) {
                    return metadata;
                }
                return super.copyRecursively(type, metadata);
            }
        };
    }

    public Object copy(Object metadata) {
        return this.copyRecursively(null, metadata);
    }

    public <T> T copy(Class<T> type, T metadata) {
        Class<?> interfaceType;
        ArgumentChecks.ensureNonNull((String)"type", type);
        if (metadata instanceof AbstractMetadata && !type.isAssignableFrom(interfaceType = ((AbstractMetadata)metadata).getInterface())) {
            throw new IllegalArgumentException(Resources.format((short)5, interfaceType, type));
        }
        return type.cast(this.copyRecursively(type, metadata));
    }

    protected Object copyRecursively(Class<?> type, Object metadata) {
        Object result;
        MetadataStandard std;
        if (metadata != null && (std = this.getStandard(metadata)) != null && (result = this.walk(std, type, metadata, false)) != null) {
            return result;
        }
        return metadata;
    }

    @Override
    final MetadataVisitor.Filter preVisit(PropertyAccessor accessor) {
        if (accessor.isWritable()) {
            try {
                this.target = accessor.implementation.getConstructor(new Class[0]).newInstance(new Object[0]);
                return MetadataVisitor.Filter.WRITABLE_RESULT;
            }
            catch (ReflectiveOperationException e) {
                throw new UnsupportedOperationException(Errors.format((short)13, accessor.type), Exceptions.unwrap((Exception)e));
            }
        }
        this.target = null;
        return MetadataVisitor.Filter.NONE;
    }

    @Override
    final Object result() {
        return this.target;
    }

    @Override
    final Object visit(Class<?> type, Object metadata) {
        if (!type.isInstance(metadata)) {
            if (metadata instanceof Collection) {
                SequencedCollection<Object> c = (List<Object>)metadata;
                if (c.isEmpty()) {
                    return null;
                }
                if (!(c instanceof EnumSet) && !(c instanceof CodeListSet)) {
                    Object[] array = c.toArray();
                    for (int i = 0; i < array.length; ++i) {
                        array[i] = this.copyRecursively(type, array[i]);
                    }
                    c = Arrays.asList(array);
                    if (metadata instanceof Set) {
                        c = new LinkedHashSet<Object>(c);
                    }
                }
                return c;
            }
            if (metadata instanceof Map) {
                return metadata;
            }
        }
        return this.copyRecursively(type, metadata);
    }

    @Override
    protected List<String> getCurrentPropertyPath() {
        return super.getCurrentPropertyPath();
    }
}

